//---------------------------------------------------------------------------
/** }l[W
 * HMJRE.DLL p
 */
/*
 * Copyright (c) 2004, 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "regexp.h"

#define FILEPATH_HMJRE "\\regexp\\hmJre.dll"
//---------------------------------------------------------------------------
/** RXgN^
 */
ARegExp::ARegExp()
{
    AnsiString path = g_global.getExeDir() + FILEPATH_HMJRE ;
    m_hdll = LoadLibrary( path.c_str() ) ;
    if ( m_hdll ) getFuncAdress( m_hdll ) ;
}
//---------------------------------------------------------------------------
/** fXgN^
 */
ARegExp::~ARegExp()
{
    if ( m_hdll ) FreeLibrary( m_hdll ) ;
}
//---------------------------------------------------------------------------
/** DLLAPI𓾂
 * @param hdll DLL̃nh
 * @return true
 */
#define GET_FUNC(hdll, api) ( ## api = (F ## api)GetProcAddress(hdll, #api) )
bool ARegExp::getFuncAdress(const HANDLE hdll)
{
    GET_FUNC( hdll, JreGetVersion ) ;
    GET_FUNC( hdll, Fuzzy_Open ) ;
    GET_FUNC( hdll, Fuzzy_Close ) ;
    GET_FUNC( hdll, Fuzzy_ConvertTarget ) ;
    GET_FUNC( hdll, Fuzzy_ConvertFindString ) ;
    GET_FUNC( hdll, Fuzzy_OptionDialog ) ;
    GET_FUNC( hdll, Jre2Open ) ;
    GET_FUNC( hdll, Jre2Compile ) ;
    GET_FUNC( hdll, Jre2GetMatchInfo ) ;
    GET_FUNC( hdll, Jre2Close ) ;

    return true ;
}
//---------------------------------------------------------------------------
/** HmJre.dll̃o[W𓾂
 * @return o[W񕶎
 */
AnsiString ARegExp::getVerString(void)
{
    AnsiString result ;
    if ( JreGetVersion == NULL )
    {
        result = "iEREjAF[@hmJre.dllȂxn" ;
    }
    else
    {
        int v = JreGetVersion() ;
        result.printf( "%s%d.%d%d%s", "HMJRE.DLL ", v >> 8, (v & 0xf0) >> 4, v & 0xf, " (C) LЃTCg[" ) ;
    }
    return result ;
};
//---------------------------------------------------------------------------
/** ݒ
 * @param keyStr 
 * @param nocase 啶ʂȂ
 * @return G[ true
 */
bool ARegExp::open(const char *keyStr, bool nocase)
{
    if ( Fuzzy_Open == NULL ) return false ;
    if ( Jre2Open == NULL ) return false ;
    if ( Fuzzy_ConvertFindString == NULL ) return false ;
    if ( Jre2Compile == NULL ) return false ;
    if ( Fuzzy_ConvertTarget == NULL ) return false ;
    if ( Jre2GetMatchInfo == NULL ) return false ;

	m_fuz.dwSize = sizeof(JREFUZZYDATA) ;
    BOOL ret1 = Fuzzy_Open( &m_fuz, FALSE ) ;
    if ( nocase )
    {
        m_fuz.flags |= FUZZYOPTION_NOCASE ;
    }
	m_jre2.dwSize = sizeof(JRE2) ;
    BOOL ret2 = Jre2Open( &m_jre2 ) ;
    if ( (ret1 == FALSE) || (ret2 == FALSE) )
    {
        ShowMessage( "iEREjAF[@DLLłȂxn" ) ;
        return false ;
    }
    ret1 = Fuzzy_ConvertFindString( &m_fuz, keyStr, 2 ) ;
	ret2 = Jre2Compile( &m_jre2, m_fuz.pszFindConved ) ;
    if ( (ret1 == FALSE) || (ret2 == FALSE) )
    {
        ShowMessage( "iEREjAF[@[hxn" ) ;
        Fuzzy_Close( &m_fuz ) ;
        return false ;
    }

    m_keyStr = keyStr ;
    return true ;
}
//---------------------------------------------------------------------------
/** ݒ肵Ń}b`O
 * @param srcStr Ώە
 * @return }b` true
 */
bool ARegExp::match(const char *srcStr)
{
    BOOL isMatch = Fuzzy_ConvertTarget( &m_fuz, srcStr ) ;
    if ( isMatch == FALSE ) return false ;

	if ( Jre2GetMatchInfo( &m_jre2, m_fuz.pszTargetConved ) )
    {
		if ( m_jre2.nLength )
        {
			return true ;
		}
	}
    return false ;
}
//---------------------------------------------------------------------------

