//---------------------------------------------------------------------------
/** GȂ
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef mymisc_h
#define mymisc_h

#include <vcl.h>
#include <Clipbrd.hpp>

class AGlobal
{
public:
	AGlobal()
    {
        // st@ĈfBNgƂ
        m_exeDir = ExtractFileDir( Application->ExeName ) ;
        CreateDir( m_exeDir + "\\ini" ) ;
        m_logDir = m_exeDir + "\\log" ;
        CreateDir( m_logDir ) ;
	}
	~AGlobal()
    {
	}
    const AnsiString &getExeDir()
    {
        return m_exeDir ;
    }
    const AnsiString &getLogDir()
    {
        return m_logDir ;
    }
private:
    AnsiString m_exeDir ;
    AnsiString m_logDir ;
} ;

/* O[o */
extern AGlobal g_global ;


extern void __fastcall showLastError(void) ;
extern HANDLE __fastcall createTempFileHandle(const AnsiString &tempPath, const char *lpPrefixString = "tmp") ;

extern void __fastcall showHTML(const AnsiString &htmlStr, const AnsiString &caption) ;
extern void __fastcall bbsMenuUpdate(bool silent = false, bool showTaskbar = false) ;

extern AnsiString __fastcall url2local(const AnsiString &Url) ;
extern void __fastcall readcgi2LocalPath(const char *URL, AnsiString &local, AnsiString &opt) ;
extern void __fastcall parseUrl(const char *URL, AnsiString &Host, AnsiString &Path) ;
extern void __fastcall parseLocalUrl(const AnsiString &local, AnsiString &Host, AnsiString &Path) ;


/** NeBJZNV
 * ЂƂ̃XbhʂƂŐł邱
 */
class ACriticalSection
{
public:
    ACriticalSection()
    {
        InitializeCriticalSection( &m_cs ) ;
        Enter() ;
    }
    ~ACriticalSection()
    {
        Leave() ;
        DeleteCriticalSection( &m_cs ) ;
    }
private:
    void Enter(void)
    {
        EnterCriticalSection( &m_cs ) ;
    }
    void Leave(void)
    {
        LeaveCriticalSection( &m_cs ) ;
    }
    CRITICAL_SECTION m_cs ;
} ;


/** ꎞIɃJ[\vɕύX
 */
class ATemporarilyCursor
{
public:
    ATemporarilyCursor()
    {
        Screen->Cursor = crHourGlass ;
        Application->ProcessMessages() ;
    }
    ~ATemporarilyCursor()
    {
        Screen->Cursor = crDefault ;
    }
} ;


/** TClipboard̂Ƀbv
 * Nbv{[hLĂ܂̂
 * ł悤ȃ[JϐŎg
 */
class AClipboard
{
public:
    AClipboard()
    {
        m_cb = Clipboard() ;
        m_cb->Open() ;
    }
    ~AClipboard()
    {
        m_cb->Close() ;
    }
    void __fastcall SetTextBuf(char * Buffer)
    {
        m_cb->SetTextBuf( Buffer ) ;
    }
private:
    TClipboard *m_cb ;
} ;

#endif /* misc.h */
