//---------------------------------------------------------------------------
/** GȂ
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <windows.h>
#include <wininet.h>
#include <vcl.h>
#include <Clipbrd.hpp>
#pragma hdrstop
#pragma link "w32inet.lib"

#include "misc.h"
#include "MainUnit.h"
#include "UpdateUnit.h"

/* O[o */
AGlobal g_global ;
//---------------------------------------------------------------------------
/**
 * GetLastError() ɑΉG[bZ[W\
 */
void __fastcall showLastError(void)
{
    LPTSTR lpMassageBuffer ;

    FormatMessage(
        FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
        NULL,
        GetLastError(),
        LANG_USER_DEFAULT,
        (LPTSTR)&lpMassageBuffer,
        0,
        NULL ) ;
    MessageBox( Application->Handle, lpMassageBuffer, Application->Title.c_str(), MB_ICONHAND | MB_OK ) ;

    LocalFree( lpMassageBuffer ) ;
}
//---------------------------------------------------------------------------
/** ꎞt@CJ
 * @param tempPath e|tH_pX
 * @param lpPrefixString ꎞt@C̓ɎgBŏ3܂łgȂB->Win32::GetTempFileName()
 * @return t@CnhԂBG[ INVALID_HANDLE_VALUE ԂB->Win32::CreateFile()
 */
HANDLE __fastcall createTempFileHandle(const AnsiString &tempPath, const char *lpPrefixString)
{
    char temp[MAX_PATH] ;

    if ( GetTempFileName( tempPath.c_str(), (lpPrefixString)? lpPrefixString : "tmp", 0, temp ) == 0 )
    {
        return INVALID_HANDLE_VALUE ;
    }

    return CreateFile( temp, GENERIC_WRITE, FILE_SHARE_READ, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_TEMPORARY | FILE_FLAG_DELETE_ON_CLOSE, NULL ) ;
}
//---------------------------------------------------------------------------
/** {[hꗗXV
 * @param silent XV
 * @param showTaskbar NULL ̏ꍇ͂ɍXVmF
 */
void __fastcall bbsMenuUpdate(bool silent, bool showTaskbar)
{
    TUpdateMenuForm *updateForm = new TUpdateMenuForm( MainForm ) ;

    if ( showTaskbar )
    {
        // eEBhEύX
        // ^XNo[ɕ\邽
        ::SetParent( updateForm->Handle, NULL ) ;
    }

    if ( silent )
    {
        updateForm->update( true ) ;
    }
    else
    {
        updateForm->ShowModal() ;
    }

    delete updateForm ;
}
//---------------------------------------------------------------------------
void __fastcall showHTML(const AnsiString &htmlStr, const AnsiString &caption)
{
    MainForm->SubjectExpand( false ) ;
    g_tabMan.writeHTML( htmlStr, caption, true ) ;
}
//---------------------------------------------------------------------------
/* URL烍[JLbVtH_΃pX擾
 * G[""Ԃ
 */
AnsiString __fastcall url2local(const AnsiString &url)
{
    AnsiString host, path ;
    parseUrl( url.c_str(), host, path ) ;
    path = StringReplace( path, "/", "\\", TReplaceFlags() << rfReplaceAll ) ;
    return AnsiString("\\") + host + path ;
}
//---------------------------------------------------------------------------
/* read.cgiURL[J`ɕϊ
 * url:"http://pc.2ch.net/test/read.cgi/hp/1009190196/50l"
 * local:"\\pc.2ch.net\\hp\\1009190196.dat"
 * opt:"50l"
 */
void __fastcall readcgi2LocalPath(const char *URL, AnsiString &local, AnsiString &opt)
{
    AnsiString path ;
    opt = "" ;
    parseUrl( URL, local, path ) ;
    path.Delete( 1, 15 ) ; // "hp/1009190196/l50"
    local = "\\" + local + "\\" ; // "\\pc.2ch.net\\"

    int index = path.AnsiPos( "/" ) ;
    if ( index != 0 )
    {
        local += path.SubString( 1, index -1 ) ;
        path.Delete( 1, index ) ; // "1009190196/l50"
        local += "\\"; // "\\pc.2ch.net\\hp\\"
        index = path.AnsiPos( "/" ) ;
        if ( index != 0 )
        {
          local += path.SubString( 1, index -1 ) ;
          path.Delete( 1, index ) ; // "l50"
          local += ".dat" ; // "\\pc.2ch.net\\hp\\1009190196.dat"
          opt = path ;
        }
        else
        {
          local += path ;
          local += ".dat" ; // "\\pc.2ch.net\\hp\\1009190196.dat"
        }
    }
}
//---------------------------------------------------------------------------
/** URL𕪉
 */
void __fastcall parseUrl(const char *URL, AnsiString &Host, AnsiString &Path)
{
// http://www.geocities.co.jp/SiliconValley-PaloAlto/1512/
// Schme: "http"
// HostName: "www.geocities.co.jp"
// URLPath: "/SiliconValley-PaloAlto/1512/"
// Port: "80"
    char szScheme[512] ;
    char szHostName[512] ;
    char szUserName[512] ;
    char szPassword[512] ;
    char szURLPath[512] ;
    char szExtraInfo[512] ;
    DWORD dwURLLength ;
    URL_COMPONENTSA UrlComponents ;

    dwURLLength = strlen( URL ) ;

    UrlComponents.dwStructSize = sizeof(URL_COMPONENTSA) ; //R|[lg̃TCYm

    UrlComponents.nScheme   = INTERNET_SCHEME_DEFAULT ;
    UrlComponents.lpszScheme    = szScheme; // Schemë̗̊m
    UrlComponents.dwSchemeLength    = 512 ;

    UrlComponents.lpszHostName  = szHostName ;  // HostNamë̗̊m
    UrlComponents.dwHostNameLength  = 512 ;

    UrlComponents.lpszUserName  = szUserName;   // UserNamë̗̊m
    UrlComponents.dwUserNameLength  = 512;

    UrlComponents.lpszPassword  = szPassword ;  // Password̗̈̊m
    UrlComponents.dwPasswordLength  = 512 ;

    UrlComponents.lpszUrlPath   = szURLPath ;   // UrlPatḧ̗̊m
    UrlComponents.dwUrlPathLength   = 512 ;

    UrlComponents.lpszExtraInfo = szExtraInfo ; // ExtraInfö̗̊m
    UrlComponents.dwExtraInfoLength = 512 ;

    if ( InternetCrackUrl( URL, dwURLLength, ICU_DECODE, &UrlComponents ) )
    {
        Host = UrlComponents.lpszHostName ;
        Path = UrlComponents.lpszUrlPath ;
    }
}
//---------------------------------------------------------------------------
/** [JURL𕪉
 * local: logdir + "\book3.2ch.net\sf\"
 * host: "book3.2ch.net"
 * path: "/sf/"
 */
void __fastcall parseLocalUrl(const AnsiString &local, AnsiString &host, AnsiString &path)
{
    AnsiString tmp =  ExtractFileDir( local ) ;
    path = "/" + ExtractFileName( tmp )  + "/" ;
    host = ExtractFileName( ExtractFileDir( tmp ) ) ;
}
//---------------------------------------------------------------------------

