//---------------------------------------------------------------------------
/** O
 */
/*
 * Copyright (c) 2002, 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <shellapi.h> // for SHFILEOPSTRUCT
#include <inifiles.hpp>
#pragma hdrstop

#include "logsweep.h"
#include "bbsmenu.h"
#include "misc.h"
#include "subject.h"

//--------------------------------------------------------------
/** t@CS~֓
 * @param filePath t@C̃pX
 * @param htmlStr O
 */
void __fastcall putRecycleBox(const AnsiString &filePath, AnsiString &htmlStr)
{
    char fpath[MAX_PATH] ;
    strcpy( fpath, filePath.c_str() ) ;
    fpath[ strlen( fpath ) +1 ] = '\0' ; // double NULL
    
	htmlStr += filePath ;
	htmlStr += "<br>" ;

	SHFILEOPSTRUCT fop ;
	fop.hwnd   = NULL ;
	fop.wFunc  = FO_DELETE ; // S~s
	fop.pFrom  = fpath ;
	fop.pTo    = NULL ;
    fop.fFlags =   FOF_NOERRORUI
                 | FOF_NOCONFIRMATION
                 | FOF_SILENT
                 | FOF_ALLOWUNDO // S~sȂ炱
                 ;
    fop.fAnyOperationsAborted = false ;

	SHFileOperation( &fop ) ;
}
//---------------------------------------------------------------------------
/** fBNg`FbN
 * "."()  ".."(efBNg) fBNgƂ݂Ȃ
 * @param fd WIN32_FIND_DATA
 * @return fBNgȂtrue
 */
inline bool __fastcall isDirAttribute(WIN32_FIND_DATA &fd)
{
    return ( fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY ) ;
}
//---------------------------------------------------------------------------
/** ʂ̃fBNg`FbN
 * ̏ꍇ̓ "."()  ".."(efBNg)
 * @param fd WIN32_FIND_DATA
 * @return ʂ̃fBNgȂtrue
 */
inline bool __fastcall isNotDotDir(WIN32_FIND_DATA &fd)
{
    bool result = true ;

    // "."(),".."(efBNg)͂
    if (   strcmp( fd.cFileName, "." ) == 0
        || strcmp( fd.cFileName, ".." ) == 0
       )
    {
        result = false ;
    }

    return result ;
}
//---------------------------------------------------------------------------
/** wfBNgɑ݂fBNg̃Xg𓾂
 * @param list Xg
 * @param path Xg𓾂fBNg
 */
void __fastcall getDirList(TStringList *list, const AnsiString &path)
{
    WIN32_FIND_DATA fd ;
    HANDLE hf = FindFirstFile( (path + "*.*").c_str(), &fd ) ;
    if ( hf == INVALID_HANDLE_VALUE ) return ;

	do
    {
        if ( isDirAttribute( fd ) )
        {
            if ( isNotDotDir( fd ) )
            {
                list->Add( path + fd.cFileName + "\\" ) ;
            }
        }
	} while ( FindNextFile( hf, &fd ) ) ;

	FindClose( hf ) ;
}
//---------------------------------------------------------------------------
/** wtH_ɑ݂tH_̒̃tH_̃Xg𓾂
 * @param list Xg
 * @param path Xg𓾂tH_w
 * ex.
 * path:d:\w2ch\log\
 * list:
 *  d:\w2ch\log\pc.2ch.net\prog
 *  d:\w2ch\log\pc.2ch.net\software
 *  d:\w2ch\log\pc.2ch.net\tech
 *  d:\w2ch\log\pc.2ch.net\win
 */
void __fastcall getDirDirList(TStringList *list, const AnsiString &path)
{
    // wfBNg̃t@C}XNœ
    WIN32_FIND_DATA fd ;
    HANDLE hf = FindFirstFile( (path + "*.*").c_str(), &fd ) ;
    if ( hf == INVALID_HANDLE_VALUE ) return ;

    do
    {
        if ( isDirAttribute( fd ) )
        {
            if ( isNotDotDir( fd ) )
            {
                getDirList( list, path + fd.cFileName + "\\" ) ;
            }
        }
    } while ( FindNextFile( hf, &fd ) ) ;

    FindClose( hf ) ;
}
//---------------------------------------------------------------------------
/** wtH_ɑ݂t@C̃Xg𓾂
 * @param list Xg
 * @param path Xg𓾂tH_w
 * ex.
 * path:d:\w2ch\log\pc.2ch.net\tech\
 * list:
 *  d:\w2ch\log\pc.2ch.net\tech\\111111111.abn
 *  d:\w2ch\log\pc.2ch.net\tech\\111111111.dat
 *  d:\w2ch\log\pc.2ch.net\tech\\222222222.abn
 *  d:\w2ch\log\pc.2ch.net\tech\\222222222.dat
 *  d:\w2ch\log\pc.2ch.net\tech\\222222222.log
 *  d:\w2ch\log\pc.2ch.net\tech\\333333333.dat
 */
void __fastcall getFileList(TStringList *list, const AnsiString &path)
{
    // wfBNg̃t@C}XNœ
    WIN32_FIND_DATA fd;
    HANDLE hf = FindFirstFile( (path + "*.*").c_str(), &fd ) ;
    if ( hf == INVALID_HANDLE_VALUE ) return ;

    do
    {
        if ( isDirAttribute( fd ) )
        {
            ; // fBNg
        }
        else
        {
            list->Add( path + fd.cFileName ) ;
        }
    } while ( FindNextFile( hf, &fd ) ) ;

    FindClose( hf ) ;
}
//---------------------------------------------------------------------------
/** w̃tH_Ƀt@C邩`FbN
 * @param path tH_w
 * @return t@CȂtrue
 */
bool __fastcall isEmptyDir(const AnsiString &path)
{
    WIN32_FIND_DATA fd ;
    HANDLE hf = FindFirstFile( (path + "*.*").c_str(), &fd ) ;
    if ( hf == INVALID_HANDLE_VALUE ) return false ;

    bool ret = true ;
    do
    {
        if ( isDirAttribute( fd ) )
        {
            if ( isNotDotDir( fd ) )
            {
                ret = false ;
                break ;
            }
        }
        else
        {
            ret = false ;
            break ;
        }
    } while ( FindNextFile( hf, &fd ) ) ;

    FindClose( hf ) ;
    return ret ;
}
//---------------------------------------------------------------------------
/** wtH_ȉ̃t@C̓ĂȂtH_폜
 * tH_̓t@CɊ܂߂Ȃ
 * @param tH_w
 * @param htmlStr O
 */
void __fastcall sweepEmptyDir(const AnsiString &path, AnsiString &htmlStr)
{
    WIN32_FIND_DATA fd ;
    HANDLE hf = FindFirstFile( (path + "*.*").c_str(), &fd ) ;
    if ( hf == INVALID_HANDLE_VALUE ) return ;

    AnsiString dirname ;
    do
    {
        if ( isDirAttribute( fd ) )
        {
            if ( isNotDotDir( fd ) )
            {
                dirname = path + fd.cFileName ;
                if ( isEmptyDir( dirname + "\\" ) )
                {
                    putRecycleBox( dirname, htmlStr ) ;
                }
            }
        }
    }
    while ( FindNextFile( hf, &fd ) ) ;

    FindClose( hf ) ;
}
//---------------------------------------------------------------------------
/** subject.ini ɋLqDATt@C폜
 * @param iniPath subject.inĩpXw
 * @param htmlStr O
 */
void __fastcall sweepLog(const AnsiString &iniPath, AnsiString &htmlStr)
{
    TMemIniFile *ini = new TMemIniFile( iniPath ) ;
    TStringList *filelist = new TStringList() ;

    getFileList( filelist, ExtractFilePath( iniPath ) ) ;
    int c = filelist->Count ;
    AnsiString fpath, filename ;
    for (int i=0; i < c; i++)
    {
        fpath = filelist->Strings[i] ;
        filename = ExtractFileName( fpath ).LowerCase() ;
        if ( ! ini->SectionExists( filename ) )
        {
            if (    (filename != FILENAME_BBS_INI)
                 && (filename != FILENAME_SUBJECT_INI)
                 && (filename != FILENAME_SUBJECT_TXT)
               )
            {
                putRecycleBox( fpath, htmlStr ) ;
            }
        }
    }

    delete filelist ;
    delete ini ;
}
//---------------------------------------------------------------------------
/** Cɓ̃OfBNg̃Xg𓾂
 * @param list 
 */
void __fastcall getSubscribeLogDirList(TStringList *list)
{
    // CɓURLXg
    TStringList *urlList = new TStringList() ;
    g_subscribeBoard.getUrlList(urlList) ;

    int c = urlList->Count;
    for (int i=0; i < c; i++)
    {
        list->Add( g_global.getLogDir() + url2local( urlList->Strings[i] ) ) ;
    }

    delete urlList ;
}
//---------------------------------------------------------------------------
/** O̐
 */
void __fastcall logSweeper(void)
{
    AnsiString htmlStr = g_htmlHeader ;

    // Cɓ̃OfBNgXg
    TStringList *subList = new TStringList();
    // OtH_̃OfBNgXg
    TStringList *localList = new TStringList();

    getSubscribeLogDirList( subList ) ;
    getDirDirList( localList, g_global.getLogDir() + "\\" ) ;


    htmlStr += "<h2>݂Cɓɖ̃O폜</h2>" ;
    AnsiString dir ;
    int lc = localList->Count ;
    for (int i=0; i < lc; i++)
    {
        dir = localList->Strings[i] ;
        if ( subList->IndexOf( dir ) == -1 )
        {
            putRecycleBox( ExtractFileDir( dir ), htmlStr ) ;
        }
    }

    htmlStr += "<hr><h2>̃tH_폜</h2>" ;
    sweepEmptyDir( g_global.getLogDir() + "\\", htmlStr ) ;


    htmlStr += "<hr><h2>֘A̖t@C폜</h2>" ;
    AnsiString path ;
    int sc = subList->Count ;
    for (int i=0; i < sc; i++)
    {
        path = subList->Strings[i] + FILENAME_SUBJECT_INI ;
        sweepLog( path, htmlStr ) ;
    }

    delete localList ;
    delete subList ;
    htmlStr += "<hr></body></html>" ;
    showHTML( htmlStr, "O" ) ;
}
//---------------------------------------------------------------------------
