//---------------------------------------------------------------------------
/** Xbh̃O
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef mylogdat_h
#define mylogdat_h

#include <vcl.h>
#include "skin.h"

/** \郌X̐ */
typedef enum
{
    showAllRes = 0,
    showLatest50Res = 50,
} ShowResMode ;

/** O
 */
class ALogDat
{
public:
    /** RXgN^
     */
	ALogDat()
    {
        m_log = new TStringList() ;
	}
    /** fXgN^ */
	~ALogDat()
    {
        delete m_log ;
	}
	void __fastcall dat2log(const AnsiString &datpath) ;
	AnsiString __fastcall log2html(const AnsiString &title, int midoku, ShowResMode flag) ;
	AnsiString __fastcall popupLog(char *nostr, int maxrow) ;
	AnsiString __fastcall popupOtherLog(const AnsiString &datpath, char *nostr, int maxrow) ;
	AnsiString __fastcall selectPopup(char *str, int maxrow) ;
private:
	void __fastcall parseDatLine(char *line, AnsiString &name, AnsiString &mail, AnsiString &date, AnsiString &res) ;
	void __fastcall parseDatLinePop(char *line, AnsiString &name, AnsiString &mail, AnsiString &date, AnsiString &res) ;
    /** ^Cgo
     */
    char *__fastcall parseDatTitle(char *line)
    {
        return ::strrchr( line, '>' ) +1 ;
    }
	AnsiString __fastcall replaceLink(AnsiString &str) ;
	AnsiString __fastcall addResLink(AnsiString &str) ;
	AnsiString __fastcall putHeader(char *line) ;
	AnsiString __fastcall putRes(const AnsiString &tempre, const AnsiString &name, const AnsiString &mail, const AnsiString &date, const AnsiString &res, const int no) ;
	AnsiString __fastcall putBookmark(void) ;
    /** tb^[o
     */
	AnsiString __fastcall putFooter(void)
    {
        return g_skin.getFooter() ;
    }
	AnsiString __fastcall deleteTag(AnsiString &str) ;
	AnsiString __fastcall deleteLink(AnsiString &str) ;
	void __fastcall countPop(char *nostr, bool *pop) ;
    TStringList *m_log ;
} ;

#endif /* logdat.h */

