//---------------------------------------------------------------------------
/** Xbh̃O
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "logdat.h"

const char *g_brokenMessage = "[Ă܂H]" ;
//---------------------------------------------------------------------------
/** "name<>mail<>date<>res<>titleLF"؂蕪
 * line ̓e *j* 
 */
void __fastcall ALogDat::parseDatLine(char *line, AnsiString &name, AnsiString &mail, AnsiString &date, AnsiString &res)
{
    int skip = 2 ;
    char *deli = "<>" ;

    char *pname, *pmail, *pdate, *pres ;
    pname = line ;
    char *p = strstr( line, deli ) ;
    if ( p == NULL ) goto DATLINE_NAME ;
    *p = 0 ;
    name = pname ;

    // ^O
    //name = AntiTag( name ) ;
    p += skip ;
    pmail = p ;
    p = strstr( p, deli ) ;
    if ( p == NULL ) goto DATLINE_MAIL ;
    *p = 0 ;
    mail = pmail ;

    // ^O
    //mail = AntiTag( mail ) ;
    p += skip ;
    pdate = p ;
    p = strstr( p, deli ) ;
    if ( p == NULL ) goto DATLINE_DATE ;
    *p = 0 ;
    date = pdate ;
    
    p += skip ;
    pres = p ;
    p = strstr( p, deli ) ;
    if ( p == NULL ) goto DATLINE_RES ;
    *p = 0 ;
    res  = pres ;

    //"&ampnbsp;"->"&nbsp;"
    res = StringReplace( res, "&ampnbsp;", "&nbsp;", TReplaceFlags() << rfReplaceAll ) ;

    return ;

DATLINE_NAME:
    name = g_brokenMessage ;
DATLINE_MAIL:
    mail = g_brokenMessage ;
DATLINE_DATE:
    date = g_brokenMessage ;
DATLINE_RES:
    res  = g_brokenMessage ;
}
//---------------------------------------------------------------------------
/** "name<>mail<>date<>res<>titleLF"؂蕪
 * line ̓e *j* 
 * URL|bvAbvp
 */
void __fastcall ALogDat::parseDatLinePop(char *line, AnsiString &name, AnsiString &mail, AnsiString &date, AnsiString &res)
{
    int skip = 2 ;
    char *deli = "<>" ;

    char *pname, *pmail, *pdate, *pres ;
    pname = line ;
    char *p = strstr( line, deli ) ;
    if ( p == NULL ) goto DATLINE_NAME ;
    *p = 0 ;
    name = pname ;
    p += skip ;
    pmail = p ;
    p = strstr( p, deli ) ;
    if ( p == NULL ) goto DATLINE_MAIL ;
    *p = 0 ;
    mail = pmail ;
    p += skip ;
    pdate = p ;
    p = strstr( p, deli ) ;
    if ( p == NULL ) goto DATLINE_DATE ;
    *p = 0 ;
    date = pdate ;
    p += skip ;
    pres = p ;
    p = strstr( p, deli ) ;
    if ( p == NULL ) goto DATLINE_RES ;
    *p = 0 ;
    res  = pres ;

    //"&ampnbsp;"->"&nbsp;"->" "
    //res = StringReplace( res, "&ampnbsp;", " ", TReplaceFlags() << rfReplaceAll ) ;

    return ;

DATLINE_NAME:
    name = g_brokenMessage ;
DATLINE_MAIL:
    mail = g_brokenMessage ;
DATLINE_DATE:
    date = g_brokenMessage ;
DATLINE_RES:
    res  = g_brokenMessage ;
}
//---------------------------------------------------------------------------
/** ">1",""̂悤Ȃ̂Nɕϊ
 * <a href="#a1">&gt;&gt;1</a>
 * AJ[^O͑OďĂ
 */
#define MIN(x,y) ( (x<=y)? x: y )
AnsiString __fastcall ALogDat::addResLink(AnsiString &str)
{
	const static AnsiString RESNUM_STR = "1234567890-,. =PQRSTUVWXO|`]CAE" ;
	const static char RESNUM_CHAR[]   = ",1234567890-,,,,=11223344556677889900------,,,,,,,,==" ;
	int wkIdx[4] ;
	AnsiString href, url, gt, no ;
	AnsiString ret = "" ;

	for (;;)
    {
		wkIdx[0] = str.AnsiPos( "&gt;" ) ;
		wkIdx[1] = str.AnsiPos( "" ) ;
		wkIdx[2] = str.AnsiPos( "" ) ;
		wkIdx[3] = str.AnsiPos( "t" ) ;

		int idx = MaxInt ;
		for (int i=0; i < 4; i++)
        {
			if ( wkIdx[i] != 0 ) idx = MIN( wkIdx[i], idx ) ;
        }

		if ( idx == MaxInt )
        {
			// 
			ret = ret + str ;
			break ;
		}

        // O܂łRs[A폜
		ret = ret + str.SubString( 1, idx -1 ) ;
        str.Delete( 1, idx -1 ) ;

        // "&gt;","","","t"
        gt = "" ;
        for (;;)
        {
            if ( str.AnsiPos( "" ) == 1 )
            {
                gt += "" ;
                str.Delete( 1, 2 ) ;
            }
            else if ( str.AnsiPos( "&gt;" ) == 1 )
            {
                gt += "&gt;" ;
                str.Delete( 1, 4 ) ;
            }
            else if ( str.AnsiPos( "" ) == 1 )
            {
                gt += "" ;
                str.Delete( 1, 2 ) ;
            }
            else if ( str.AnsiPos( "t" ) == 1 )
            {
                gt += "t" ;
                str.Delete( 1, 2) ;
            }
            else
            {
                break ;
            }
        }

        href = "" ;
        url = "" ;
        for (;;)
        {
            bool mb = str.IsLeadByte( 1 ) ;
            if ( mb )
            {
                no = str.SubString( 1, 2 ) ;
            }
            else
            {
                no = str.SubString( 1, 1 ) ;
            }

            int index = RESNUM_STR.AnsiPos( no ) ;
            if ( index > 0 )
            {
                url += no ;
                if ( mb )
                {
                    str.Delete( 1, 2 ) ;
                }
                else
                {
                    str.Delete( 1, 1 ) ;
                }
                href += RESNUM_CHAR[index] ;
            }
            else
            {
                if ( str.AnsiPos( "&" ) == 1 )
                {
                    if ( str.AnsiPos( "&amp;" ) == 1 )
                    {
                        url += "&amp;" ;
                        str.Delete( 1, 5 ) ;
                        href += "," ;
                    }
                    else if ( str.AnsiPos( "&gt;" ) == 1 )
                    {
                        break ;
                    }
                    else if ( str.AnsiPos( "&lt;" ) == 1 )
                    {
                        break ;
                    }
                    else if ( str.AnsiPos( "&nbsp;" ) == 1 )
                    {
                        break ;
                    }
                    else
                    {
                        url += "&" ;
                        str.Delete( 1, 1 ) ;
                        href += "," ;
                    }
                }
                else
                {
                    break ;
                }
            }
        } // for (;;)

        if ( ! url.IsEmpty() )
        {
            int ino = atoi( href.c_str() ) ;
            if ( ino == 0 ) ino = atoi( href.c_str() +1 ) ;
            if ( ino != 0 )
            {
                ret = ret + "<a href=\"#a" + href + "\">" + gt + url + "</a>" ;
            }
            else
            {
                ret = ret + gt + url ;
            }
        }
        else
        {
            ret = ret + gt ;
        }
	} // for (;;)

    return ret ;
}
//---------------------------------------------------------------------------
/** ^O폜
 */
AnsiString __fastcall ALogDat::deleteTag(AnsiString &str)
{
	AnsiString ret = "" ;

    int idx ;
	for (;;)
    {
		idx = str.AnsiPos( "<" ) ;
		if ( idx == 0 )
        {
			// 
			ret = ret + str ;
			break ;
		}

        // O܂łRs[A^O폜
		ret = ret + str.SubString( 1, idx -1 ) ;
        str.Delete( 1, idx -1 ) ;
		idx = str.AnsiPos( ">" ) ;
        if ( idx == 0 ) break ;
        str.Delete( 1, idx ) ;
	}

    return ret ;
}
//---------------------------------------------------------------------------
/** AJ[^O폜
 */
AnsiString __fastcall ALogDat::deleteLink(AnsiString &str)
{
	AnsiString ret = "" ;

    int idx ;
	for (;;)
    {
		idx = str.AnsiPos( "<a" ) ;
		if ( idx == 0 )
        {
			// 
			ret = ret + str ;
			break ;
		}

        // O܂łRs[A^O폜
		ret = ret + str.SubString( 1, idx -1 ) ;
        str.Delete( 1, idx -1 ) ;
		idx = str.AnsiPos( ">" ) ;
        if ( idx == 0 ) break ;
        str.Delete( 1, idx ) ;

		idx = str.AnsiPos( "</a>" ) ;
		if ( idx == 0 )
        {
			// 
			ret = ret + str ;
			break ;
		}
        // O܂łRs[A^O폜
		ret = ret + str.SubString( 1, idx -1 ) ;
        str.Delete( 1, idx -1 +4 ) ;
	}

    return ret ;
}
//---------------------------------------------------------------------------
// URLۂ̂Nɕϊ
// MRirTGikoSys.AddAnchorTagpNpN
AnsiString __fastcall ALogDat::replaceLink(AnsiString &str)
{
	const static char URL_CHAR[] = "0123456789"
                            "abcdefghijklmnopqrstuvwxyz"
							"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
							"#$%&*+,-./:;=?@[]^_`{|}~!'";
							//"#$%&()*+,-./:;=?@[]^_`{|}~!'" ;
	int wkIdx[3] ;
	AnsiString url, href ;
	AnsiString ret = "" ;

    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
	for (;;)
    {
		wkIdx[0] = str.AnsiPos( "http://" ) ;
		wkIdx[1] = str.AnsiPos( "ttp://" ) ;
		wkIdx[2] = str.AnsiPos( "ftp://" ) ;
		//wkIdx[3] = str.AnsiPos( "tp://" ) ;
		//wkIdx[4] = str.AnsiPos( "p://" ) ;
		//wkIdx[5] = str.AnsiPos( "www." ) ;

		int idx = MaxInt ;
		for (int i=0; i < 3; i++)
        {
			if ( wkIdx[i] != 0 ) idx = MIN( wkIdx[i], idx ) ;
        }

		if ( idx == MaxInt )
        {
			// N
			ret = ret + str ;
			break ;
		}

        // URLO܂łRs[A폜
		ret = ret + str.SubString( 1, idx -1 ) ;
        str.Delete( 1, idx -1 ) ;

        // URL炵̂̒
        size_t urllen = strspn( str.c_str(), URL_CHAR ) ;
		size_t amp = str.AnsiPos( "&gt;" ) ; // "&gt;"URL̈ꕔɂȂĂ܂̂h
        if ( (amp != 0) && (urllen > amp) ) urllen = amp -1 ;
        url = str.SubString( 1, urllen ) ;

        if ( str.AnsiPos( "t" ) == 1 )  // "ttp://"
        {
            href = "h" + url ;
        //} else if ( str.AnsiPos("tp://" ) == 1 ) {
        //    href = "ht" + url ;
        //} else if ( str.AnsiPos("p://" ) == 1 ) {
        //    href = "htt" + url ;
        //} else if ( str.AnsiPos("www.") == 1 ) {
        //    href = "http://" + url ;
        }
        else
        {
            href = url ;
        }
        while ( href.AnsiPos( "http://ime.nu/" ) == 1 )
        {
            href = StringReplace( href, "http://ime.nu/", "http://", f ) ;
        }
        while ( href.AnsiPos( "http://pinktower.com/" ) == 1 )
        {
            href = StringReplace( href, "http://pinktower.com/", "http://", f ) ;
        }
        ret = ret + "<a href=\"" + href + "\">" + url + "</a>" ;
        // URL폜
		str.Delete( 1, urllen ) ;

	}
    
    return ret ;
}
//---------------------------------------------------------------------------
/** Headero
 */
AnsiString __fastcall ALogDat::putHeader(char *line)
{
    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
    AnsiString ret = g_skin.getHeader() ;
    ret = StringReplace( ret, "<TITLE/>", parseDatTitle( line ), f ) ;
    return ret ;
}
//---------------------------------------------------------------------------
/** Reso
 */
AnsiString __fastcall ALogDat::putRes(const AnsiString &tempre, const AnsiString &name, const AnsiString &mail, const AnsiString &date, const AnsiString &res, const int no)
{
    AnsiString mailname, num ;
    if ( (mail != " ") && (mail.IsEmpty() != true) )
    {
        mailname += "<a href=\"mailto:" ;
        mailname += mail ;
        mailname += "\"><b>" ;
        mailname += name ;
        mailname += "</b></a>" ;
    }
    else
    {
        mailname += "<b>" ;
        mailname += name ;
        mailname += "</b>" ;
    }
    num = "<a href=\"menu:" ;
    num += no ;
    num += "\">" ;
    num += no ;
    num += "</a>" ;

    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
    AnsiString ret = "<a name=\"a" ;
    ret += no ;
    ret += "\"></a>" ;
    ret += tempre ;
    // NUMBER
    ret = StringReplace( ret, "<NUMBER/>", num, f ) ;
    // PLAINNUMBER
    ret = StringReplace( ret, "<PLAINNUMBER/>", AnsiString(no), f ) ;
    // MAILNAME
    ret = StringReplace( ret, "<MAILNAME/>", mailname, f ) ;
    // NAME
    ret = StringReplace( ret, "<NAME/>", name, f ) ;
    // MAIL
    ret = StringReplace( ret, "<MAIL/>", mail, f ) ;
    // DATE
    ret = StringReplace( ret, "<DATE/>", date, f ) ;
    // MESSAGE
    ret = StringReplace( ret, "<MESSAGE/>", res, f ) ;

    // THREADNAME
    // THREADURL
    // SKINPATH
    // GETRESCOUNT
    // NEWRESCOUNT
    // ALLRESCOUNT

    return ret ;
}
//---------------------------------------------------------------------------
/** o
 */
AnsiString __fastcall ALogDat::putBookmark(void)
{
    return AnsiString("<a name=\"midoku\"></a>") + g_skin.getBookmark() ;
}
//---------------------------------------------------------------------------
/** datlogɕϊ
 * ^CgԂ
 * datpath  dat ̃t@CpX
 */
void __fastcall ALogDat::dat2log(const AnsiString &datpath)
{
    m_log->Clear() ;

    TStringList *dat = new TStringList() ;
    try
    {
        dat->LoadFromFile( datpath ) ;
    } catch (...) {
        delete dat ;
        return ;
    }
    int cdat = dat->Count ;
    if ( cdat == 0 ) return ;

    AnsiString name, mail, date, res ;
    for (int i=0; i < cdat; i++)
    {
        parseDatLine( dat->Strings[i].c_str(), name, mail, date, res ) ;
        res = deleteLink( res ) ;
        res = addResLink( res ) ;
        res = replaceLink( res ) ;
        m_log->Add( name ) ;
        m_log->Add( mail ) ;
        m_log->Add( date ) ;
        m_log->Add( res ) ;
    }

    delete dat ;
}
//---------------------------------------------------------------------------
/** ϊloghtmlɕϊĕԂ
 * midoku͖ǈʒu
 * flag:ALL or ŐV50
 */
AnsiString __fastcall ALogDat::log2html(const AnsiString &title, int midoku, ShowResMode flag)
{
    AnsiString ret = "" ;
    if ( m_log == NULL ) return ret ;

    int c = m_log->Count / 4 ;
    if ( c==0 ) return ret ;

    if ( c +1 < midoku ) midoku = c +1 ;
    midoku -- ;
    if ( midoku < 0 ) midoku = 0 ;

    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
    ret = StringReplace( g_skin.getHeader(), "<&TITLE>", title, f ) ;

    AnsiString name, mail, date, res ;
    int i = 0 ;
    if ( flag > showAllRes )
    {
        if ( midoku > flag )
        {
            i = midoku - flag ;
        }
        if ( i > 0 )
        {
            // 1o
            name = m_log->Strings[0] ;
            mail = m_log->Strings[1] ;
            date = m_log->Strings[2] ;
            res  = m_log->Strings[3] ;
            ret += putRes( g_skin.getRes(), name, mail, date, res, 1 ) ;
        }
    }
    for ( ; i < midoku; i++)
    {
        name = m_log->Strings[ i*4 +0 ] ;
        mail = m_log->Strings[ i*4 +1 ] ;
        date = m_log->Strings[ i*4 +2 ] ;
        res  = m_log->Strings[ i*4 +3 ] ;
        ret += putRes( g_skin.getRes(), name, mail, date, res, i +1 ) ;
    }
    ret += putBookmark() ;
    for ( ; i < c; i++)
    {
        name = m_log->Strings[ i*4 +0 ] ;
        mail = m_log->Strings[ i*4 +1 ] ;
        date = m_log->Strings[ i*4 +2 ] ;
        res  = m_log->Strings[ i*4 +3 ] ;
        ret += putRes( g_skin.getNewRes(), name, mail, date, res, i +1 ) ;
    }
    ret += putFooter() ;

    return ret ;
}
//---------------------------------------------------------------------------
/** |bvAbvɎgp镶Ԃ
 * G[""
 * nostr"1","2-3"Ȃǂ̕
 * "="","
 */
AnsiString __fastcall ALogDat::popupLog(char *nostr, int maxrow)
{
    if ( m_log == NULL ) return AnsiString( "" ) ;
    bool pop[1001] ; // ܂ł
    countPop( nostr, pop ) ;

    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
    TStringList *strlist = new TStringList() ;
    AnsiString res ;
    int logc = m_log->Count / 4 ;
    bool *pb = pop +1 ;
    if ( logc > 1000 ) logc = 1000 ;
    for (int i=0; i < logc; i++)
    {
        if ( *pb )
        {
            res  = AnsiString(i +1) ;
            res += " OF" ;
            res += m_log->Strings[ i*4 +0 ] ;
            res += " [F" ;
            res += m_log->Strings[ i*4 +1 ] ;
            res += " eF" ;
            res += m_log->Strings[ i*4 +2 ] ;
            strlist->Add( res ) ;

            res = m_log->Strings[ i*4 +3 ] ;
            res = StringReplace( res, "<br>", "\n", f ) ;
            res += "\n" ;

            strlist->Add( res ) ;
            strlist->SetText( strlist->Text.c_str() ) ;
            if ( maxrow <= strlist->Count )
            {
                while ( maxrow < strlist->Count )
                {
                    strlist->Delete( strlist->Count -1 ) ;
                }
                break ;
            }
        }
        pb ++ ;
    }
    AnsiString ret = strlist->Text ;
    ret = ret.TrimRight() ;
    ret = StringReplace( ret, "<b>", "", f ) ;
    ret = StringReplace( ret, "</b>", "", f ) ;
    ret = deleteTag( ret ) ;
    ret = StringReplace( ret, "&lt;", "<", f ) ;
    ret = StringReplace( ret, "&gt;", ">", f ) ;
    ret = StringReplace( ret, "&quot;", "\"", f ) ;
    ret = StringReplace( ret, "&nbsp;", " ", f ) ;
    delete strlist ;

    return ret ;
}
//---------------------------------------------------------------------------
/** nostr"1","2-3"Ȃǂ̕
 * "="","
 * |bvAbvԍ𐔂
 */
void __fastcall ALogDat::countPop(char *nostr, bool *pop)
{
    memset( pop +1, 0, 1000 ) ;

    char *p = nostr ;
    int now = 0 ;
    int startno, endno ;
    bool hyphen = false ;
    for (;;)
    {
        if ( (*p >= '0') && (*p <= '9') )
        {
            now = now * 10 + (*p -'0') ;
        }
        else if ( *p == '-' )
        {
            if ( hyphen )
            {
                if ( now == 0 )
                {
                    endno = 1000 ;
                }
                else
                {
                    endno = now ;
                }
                if ( (startno > 0) && (endno <= 1000) )
                {
                    int i = startno ;
                    do
                    {
                        pop[i] = true ;
                        i ++ ;
                    } while ( i <= endno ) ;
                }
                startno = now ;
            }
            else
            {
                if ( now == 0 )
                {
                    startno = 1 ;
                }
                else
                {
                    startno = now ;
                }
            }
            hyphen = true ;
            now = 0 ;
        }
        else if ( (*p == ',') || (*p == '=') || (*p == '\0') )
        {
            if ( hyphen )
            {
                if ( now == 0 )
                {
                    endno = 1000 ;
                }
                else
                {
                    endno = now ;
                }
                if ( (startno > 0) && (endno <= 1000) )
                {
                    int i = startno ;
                    do
                    {
                        pop[i] = true ;
                        i ++ ;
                    } while ( i <= endno ) ;
                }
            }
            else
            {
                if ( (now > 0) && (now <= 1000) )
                {
                    pop[now] = true ;
                }
            }
            hyphen = false ;
            now = 0 ;
        }
        else if ( *p == 'l' )
        {
            memset( pop +1, 0, 1000 ) ;
            pop[1] = true ;
            return ;
        }
        if ( *p == '\0' ) break ;
        p ++ ;
    }
}
//---------------------------------------------------------------------------
/** |bvAbvɎgp镶Ԃ
 * O琶
 * G[""
 * nostr"1","2-3"Ȃǂ̕
 * datpathdatt@CpX
 */
AnsiString __fastcall ALogDat::popupOtherLog(const AnsiString &datpath, char *nostr, int maxrow)
{
    TStringList *nlog = new TStringList() ;
    try
    {
        nlog->LoadFromFile( datpath ) ;
    }
    catch (...)
    {
        delete nlog ;
        return "" ;
    }

    bool pop[1001] ; // ܂ł
    if ( (*nostr == '\0') || strcmp(nostr, "midoku") == 0 )
    {
        memset( pop +1, 0, 1000 ) ;
        pop[1] = true ;
    }
    else
    {
        countPop( nostr, pop ) ;
    }

    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĂ̕
    TStringList *strlist = new TStringList() ;
    AnsiString res ;
    int logc = nlog->Count ;
    bool *pb = pop +1 ;
    if ( logc > 1000 ) logc = 1000 ;
    if ( logc > 0 )
    {
        strlist->Add( parseDatTitle( nlog->Strings[0].c_str() ) ) ;
        strlist->Add( "" ) ;
    }
    AnsiString name, mail, date, logres ;
    for (int i=0; i < logc; i++)
    {
        if ( *pb )
        {
            parseDatLinePop( nlog->Strings[i].c_str(), name, mail, date, logres ) ;
            res  = AnsiString( i +1 ) ;
            res += " OF" ;
            res += name ;
            res += " [F" ;
            res += mail ;
            res += " eF" ;
            res += date ;
            strlist->Add( res ) ;

            res = logres ;
            res = StringReplace( res, "<br>", "\n", f ) ;
            res += "\n" ;

            strlist->Add( res ) ;
            strlist->SetText( strlist->Text.c_str() ) ;
            if ( maxrow <= strlist->Count )
            {
                while ( maxrow < strlist->Count )
                {
                    strlist->Delete( strlist->Count -1 ) ;
                }
                break ;
            }
        }
        pb ++ ;
    }
    AnsiString ret = strlist->Text ;
    ret = ret.TrimRight() ;
    ret = StringReplace( ret, "<b>", "", f ) ; //ÕgbvƂ
    ret = StringReplace( ret, "</b>", "", f ) ;
    ret = deleteTag( ret ) ;
    ret = StringReplace( ret, "&lt;", "<", f ) ;
    ret = StringReplace( ret, "&gt;", ">", f ) ;
    ret = StringReplace( ret, "&quot;", "\"", f ) ;
    ret = StringReplace( ret, "&ampnbsp;", " ", f ) ;
    delete strlist ;

    delete nlog ;
    return ret ;
}
//---------------------------------------------------------------------------
/** IĂ镶񂪐Ȃ|bvAbvɎgp镶Ԃ
 * G[""
 */
AnsiString __fastcall ALogDat::selectPopup(char *cstr, int maxrow)
{
                                              //͔p&OK
	const static AnsiString RESNUM_STR = "1234567890-,.& =PQRSTUVWXO|`CAE" ;
	const static char RESNUM_CHAR[]   = ",1234567890-,,,,,=11223344556677889900----,,,,,,,,==" ;
	AnsiString nostr = "" ;

    if ( strspn( cstr, RESNUM_STR.c_str() ) != strlen( cstr ) )
        return nostr ;
    AnsiString str = cstr ;
    AnsiString no ;
    for (;;)
    {
        bool mb = str.IsLeadByte( 1 ) ;
        if ( mb )
        {
            no = str.SubString( 1, 2 ) ;
        }
        else
        {
            no = str.SubString( 1, 1 ) ;
        }
        int index = RESNUM_STR.AnsiPos( no ) ;
        if ( index > 0 )
        {
            if ( mb )
            {
                str.Delete( 1, 2 ) ;
            } else {
                str.Delete( 1, 1 ) ;
            }
            nostr += RESNUM_CHAR[index] ;
        }
        else
        {
            break ;
        }
    }
    return popupLog( nostr.c_str(), maxrow ) ;
}
//---------------------------------------------------------------------------

