//---------------------------------------------------------------------------
/** HTTPNX
 * pCu:WinSock2
 * 2chT[o
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef myhttpsock_h
#define myhttpsock_h

#include "misc.h"
#include "config.h"

#include <time.h>
#include <vcl.h>
#include <ComCtrls.hpp>
#include <winsock.h>
#include <wininet.h>

typedef int (CALLBACK *PROGRESS_CALLBACK)(const char *str, long lData, int nNum, int nDenom) ;

/** R[obNf[^ */
typedef struct CALL_PACK
{
    bool abort ;
    THandleStream *fs ;
    time_t id ;
    CALL_PACK()
    {
        id = time( NULL ) ;
        abort = false ;
        fs = NULL ;

        if ( g_outputDebugLog )
        {
            HANDLE hf = ::createTempFileHandle( g_global.getLogDir() ) ;
            if ( hf != INVALID_HANDLE_VALUE )
            {
                fs = new THandleStream( (int)hf ) ;
            }
        }
    }
    ~CALL_PACK()
    {
        if ( fs != NULL )
        {
            ::CloseHandle( (HANDLE)fs->Handle ) ;
            delete fs ;
        }
    }
} CALL_PACK ;

/** \Pbg̏ */
typedef enum
{
    socketStateNone,
    socketStateConnected,
    socketStateClosed,
    socketStateClosing,
} SocketState ;

/** HTTP\PbgNX
 */
class AHttpSock
{
public:
    /** RXgN^
     */
	AHttpSock()
    {
		WORD wVersionRequested = MAKEWORD(2, 0) ; /* WinSock2v */
		::WSAStartup( wVersionRequested, &m_wsaData ) ;

        m_state = socketStateNone ;
        m_released = false ;
        m_CallbackFunc = NULL ;
	}
    /** fXgN^ */
	~AHttpSock()
    {
        if ( m_state == socketStateConnected ) close() ;
		release() ;
	}
	void __fastcall setCallback(long lData, PROGRESS_CALLBACK lpCallBack) ;
	int __fastcall download(const AnsiString &URL, TMemoryStream *ms, AnsiString &dattime, bool bgzip = false, bool bclose = true) ;
	int __fastcall rangeDownload(const AnsiString &url, TMemoryStream *ms, AnsiString &dattime, bool lastmod = false) ;
    /** \[X
     */
	void __fastcall release(void)
    {
		if ( ! m_released )
        {
            ::WSACleanup() ;
            m_released = true ;
        }
    }
private:
    void __fastcall checkConnection(char *Response) ;
    bool __fastcall enabled(void) ;
	bool __fastcall connect(const AnsiString &host) ;
	bool __fastcall send(const AnsiString &head) ;
    int __fastcall recv(char *buf, int len, int flags) ;
    int __fastcall waitForRecv(void) ;
	int __fastcall waitForSend(void) ;
	void __fastcall close(void) ;
	DWORD __fastcall getStatusCode(char *Response) ;
	DWORD __fastcall getContentLength(char *Response) ;
	AnsiString __fastcall getLastModified(char *Response) ;
	bool __fastcall isGzipEncode(char *Response) ;
	int __fastcall callMessage(const char *message) ;
	void __fastcall logging(const char *data, DWORD length = 0) ;
    PROGRESS_CALLBACK m_CallbackFunc ;
    CALL_PACK *m_CallData ;
	WSADATA m_wsaData ;
	SOCKET m_soc ;
    AnsiString m_host ;
    SocketState m_state ;
    bool m_released ;
} ;

#endif /* httpsock.h */

