//---------------------------------------------------------------------------
/** HTTPNX
 * WinSock2
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <time.h>
#include <vcl.h>
#include <ComCtrls.hpp>
#include <winsock.h>
#include <wininet.h>
#pragma hdrstop

#pragma link "ws2_32.lib"
#pragma link "w32inet.lib"

#include "httpsock.h"
#include "gzip.h"

#define FILENAME_GZIPDUMP "\\gzip.dmp"
#define HTTPBUFF_SIZE 1024
//---------------------------------------------------------------------------
/** R[obN̐ݒ
 */
void __fastcall AHttpSock::setCallback(long lData, PROGRESS_CALLBACK lpCallBack)
{
    m_CallbackFunc = lpCallBack ;
    m_CallData = (CALL_PACK*)lData ;
}
//---------------------------------------------------------------------------
/** Xe[^XR[ho
 * Xe[^XR[hԂ
 * 0̓G[낤
 */
DWORD __fastcall AHttpSock::getStatusCode(char *StatusLine)
{
    DWORD result = 0 ;
    char *p = ::strchr(StatusLine, ' ') ;
    if ( p != NULL )
    {
        result = atoi( p ) ;
    }
    return result ;
}
//---------------------------------------------------------------------------
/** Content-Lengtho
 * Content-LengthԂ
 * 0̓G[낤
 */
DWORD __fastcall AHttpSock::getContentLength(char *Response)
{
    DWORD result = 0 ;
    char *p = ::strstr( Response, "Content-Length:" ) ;
    if ( p != NULL )
    {
        result = atoi( p +15 ) ;
    }
    return result ;
}
//---------------------------------------------------------------------------
/** Last-Modified o
 * Last-Modified Ԃ
 */
AnsiString __fastcall AHttpSock::getLastModified(char *Response)
{
    AnsiString result = "" ;
    char *p = ::strstr( Response, "Last-Modified:" ) ;
    if ( p != NULL )
    {
        char *pp = ::strstr( p, "\r\n" ) ;
        if ( pp != NULL )
        {
            *pp = '\0' ;
            result = AnsiString( (p +14) ) ;
            *pp = '\r' ;
        }
    }
    return result ;
}
//---------------------------------------------------------------------------
/** Content-Encodinggzip
 * gzipȂtrueԂ
 */
bool __fastcall AHttpSock::isGzipEncode(char *Response)
{
    bool result = false ;
    char *p = ::strstr( Response, "Content-Encoding: gzip" ) ;
    if ( p != NULL )
    {
        result = true ;
    }
    return result ;
}
//---------------------------------------------------------------------------
/** Connection: close ǂ
 */
void __fastcall AHttpSock::checkConnection(char *Response)
{
    char *p = ::strstr( Response, "Connection: close" ) ;
    if ( p != NULL )
    {
        m_state = socketStateClosing ;
    }
}
//---------------------------------------------------------------------------
/** gp\
 */
bool __fastcall AHttpSock::enabled(void)
{
	fd_set errfds ;
    FD_ZERO( &errfds ) ;
    FD_SET( m_soc, &errfds ) ;

	timeval Timeout ;
	Timeout.tv_sec = 0 ;
    Timeout.tv_usec = 0 ;

	return ( ::select( 1, NULL, NULL, &errfds, &Timeout ) == 0 ) ;
}
//---------------------------------------------------------------------------
/** O
 * @param data f[^
 * @param length f[^TCYB0w肷strlen(data)g
 */
void __fastcall AHttpSock::logging(const char *data, DWORD length)
{
    if ( ! g_outputDebugLog ) return ;
    if ( data == NULL ) return ;
    if ( m_CallData->fs == NULL ) return ;

    AnsiString id = "id:" ;
    id += AnsiString( m_CallData->id ) ;
    id += "\r\n" ;
    m_CallData->fs->Write( id.c_str(), id.Length() ) ; // id}

    if ( length == 0 ) length = ::strlen( data ) ;
    m_CallData->fs->Write( data, length ) ;

    m_CallData->fs->Write( "\r\n", 2 ) ; // Ks
}
//---------------------------------------------------------------------------
/** R[obNŃbZ[W𑗐M
 */
int __fastcall AHttpSock::callMessage(const char *message)
{
    logging( message ) ;
    return m_CallbackFunc( message, (long)m_CallData, 0, 0 ) ;
}
//---------------------------------------------------------------------------
/** T[oɐڑ
 */
bool __fastcall AHttpSock::connect(const AnsiString &host)
{
#if 1
    if ( ::InternetAttemptConnect(0) != ERROR_SUCCESS )
#else
    DWORD flags = INTERNET_CONNECTION_MODEM | INTERNET_CONNECTION_LAN | INTERNET_CONNECTION_PROXY ;
    if ( ::InternetGetConnectedState( &flags, 0 ) != TRUE )
#endif
    {
        callMessage( "G[:lbg[NɐڑoĂ܂" ) ;
        return false ;
    }

    AnsiString hostname = host ;
    int port = 80 ;
    if ( m_state == socketStateConnected )
    {
        if ( m_host == host )
        {
            //if (Sendable()) {
                return true; // zXgŐڑĂ
                /* ⑫Fǂ Connection: close ԂĂ̂łӖȂ */
            //}
        }
        close() ;
    }
    else if ( m_state == socketStateClosing )
    {
        close() ;
    }

	// svNameɃhbgŋ؂10iIPAhXĂꍇAserveraddr32bitIPAhXԂ
	unsigned long serveraddr ; // T[oIPAhX
	serveraddr = inet_addr( hostname.c_str() ) ;
	if ( serveraddr == INADDR_NONE )
    {
		// T[o(svName)T[ȍ擾
    	hostent *serverhostent ;	// T[ȍw|C^
		serverhostent = gethostbyname( hostname.c_str() ) ;
		if ( serverhostent == NULL )
        {
			callMessage( "G[:zXgAhX擾s" ) ;
			return false ;
		}
        else
        {
			// T[ȍ񂩂IPAhXserveraddrɃRs[
			serveraddr = *((unsigned long *)((serverhostent->h_addr_list)[0])) ;
		}
	}

	// T[õAhX̍\̂ɃT[oIPAhXƃ|[gԍݒ
	sockaddr_in serversockaddr ; // T[õAhX
	serversockaddr.sin_family       = AF_INET ;	  // C^[lbg̏ꍇ
	serversockaddr.sin_addr.s_addr  = serveraddr ; // T[oIPAhX
	serversockaddr.sin_port         = htons( (unsigned short)port ) ; // |[gԍ
	::memset( serversockaddr.sin_zero, (int)0, sizeof(serversockaddr.sin_zero)  ) ;

	// \Pbg쐬
	m_soc = ::socket( PF_INET, SOCK_STREAM, 0 ) ;
	if ( m_soc == INVALID_SOCKET )
    {
		callMessage( "G[:Socket쐬s" ) ;
		return false ;
	}

	// T[o֐ڑ
    int errConnect ;
    if ( callMessage( AnsiString(hostname + "ɐڑ...").c_str() ) != 0 )
    {
		::closesocket( m_soc ) ;
		return false ;
    }

	errConnect = ::connect( m_soc, (sockaddr *)&serversockaddr, sizeof(serversockaddr) ) ;

	if ( errConnect == SOCKET_ERROR )
    {
		callMessage( "G[:T[oւ̐ڑs" ) ;
		::closesocket( m_soc ) ;
		return false ;
	}

    callMessage( "ڑ܂." ) ;
    m_state = socketStateConnected ;
    m_host = host ;
    return true ;
}
//---------------------------------------------------------------------------
/** M\҂
 * 0Ԃ΃^CAEg
 */
int __fastcall AHttpSock::waitForSend(void)
{
	fd_set sendfds ;
    FD_ZERO( &sendfds ) ;
    FD_SET( m_soc, &sendfds ) ;

	timeval Timeout ;
	Timeout.tv_sec = 10 ;
    Timeout.tv_usec = 0 ;

	return ::select( 1, NULL, &sendfds, NULL, &Timeout ) ;
}
//---------------------------------------------------------------------------
/** T[oɃNGXg
 */
bool __fastcall AHttpSock::send(const AnsiString &head)
{
    callMessage( "NGXgM." ) ;

    logging( head.c_str() ) ;

    bool ret = true ;
    int total = 0 ;
    int len = head.Length() ;

    int tocount = 3 ;
    while ( len > total )
    {
        if ( waitForSend() == 0 )
        {
			if ( callMessage( "x:^CAEg" ) != 0 )
            {
                ret = false ;
                break ;
            }
            tocount -- ;
            if ( tocount <= 0 )
            {
                break ;
            }
            continue ;
		}
		int sent = ::send( m_soc, head.c_str() + total, len - total, 0 ) ;
		if ( sent == SOCKET_ERROR )
        {
            ret = false ;
            callMessage( "G[:T[oւ̑Ms" ) ;
            close();
        }
        total += sent ;
	}

    return ret ;
}
//---------------------------------------------------------------------------
/** M҂
 * 0Ԃ΃^CAEg
 */
int __fastcall AHttpSock::waitForRecv(void)
{
	fd_set readfds ;
    FD_ZERO( &readfds ) ;
    FD_SET( m_soc, &readfds ) ;

	timeval Timeout ;
	Timeout.tv_sec = 10 ;
    Timeout.tv_usec = 0 ;

	return ::select( 1, &readfds, NULL, NULL, &Timeout ) ;
}
//---------------------------------------------------------------------------
/** \Pbg
 */
void __fastcall AHttpSock::close(void)
{
    //callMessage( "\PbgN[Y." ) ; // łɃR[obNpłꍇ̂ŃRgAEg
    ::shutdown( m_soc, 2 ) ;
    ::closesocket( m_soc ) ;
    m_state = socketStateClosed ;
}
//---------------------------------------------------------------------------
/** M
 */
int __fastcall AHttpSock::recv(char *buf, int len, int flags)
{
    int result ;
    result = ::recv( m_soc, buf, len, flags ) ;
    logging( buf, result ) ;
    return result ;
}
//---------------------------------------------------------------------------
/** URL̃t@C擾
 * Ƃ肠0Ԃ
 */
int __fastcall AHttpSock::download(const AnsiString &url, TMemoryStream *ms, AnsiString &dattime, bool bgzip, bool bclose)
{
	// URL𕪉
	AnsiString host, path ;
	parseUrl( url.c_str(), host, path ) ;

    if ( ! connect( host ) )
    {
		return -1 ;
    }

    callMessage( url.c_str() ) ;
	// T[o GET NGXg𑗐M
	AnsiString sendstr = "GET ";
    sendstr += path;
    sendstr += " HTTP/1.1\r\nHost: ";
    sendstr += host;
    sendstr += "\r\nUser-Agent: " ;
    sendstr += g_useragent ;
    //sendstr += "\r\nAccept: */*" ;
    if ( bclose )
    {
    	sendstr += "Connection: close" ;
    }
    // If-Modified-Since
    if ( ! dattime.IsEmpty() )
    {
        sendstr += "\r\nIf-Modified-Since:" ;
        sendstr += dattime ;
    }
    // gzip
    if ( bgzip )
    {
        sendstr += "\r\nAccept-Encoding: gzip" ;
    }
    sendstr += "\r\n\r\n" ;

	if ( ! send( sendstr ) )
    {
		return -2 ;
	}
	// X|Xwb_M
	unsigned char recvbuf[HTTPBUFF_SIZE] ;
    TMemoryStream *respms = new TMemoryStream() ;
    int respsize ;
    int buf_len ;
    int ret = 0 ;
    int tocount = 3 ;
for (;;)
{
	for (;;)
    {
        respms->Write( "", 1 ) ;
        respms->Position = respms->Position -1 ;
        char *p = (char*)respms->Memory ;
        char *pp = strstr( p, "\r\n\r\n" ) ;
        if ( pp != NULL )
        {
            respsize = pp - p +4 ;
            break ;
        }
        if ( waitForRecv() == 0 )
        {
			if ( callMessage( "x:^CAEg" ) != 0 )
            {
    		    close() ;
                delete respms ;
			    return -5 ;
            }
            tocount -- ;
            if ( tocount <= 0 )
            {
    		    close() ;
                delete respms ;
			    return -6 ;
            }
            continue ;
		}
        tocount = 3 ;
        buf_len = recv( recvbuf, HTTPBUFF_SIZE, 0 ) ;
		if ( buf_len == SOCKET_ERROR || buf_len == 0 )
        {
			callMessage( "G[:T[o̎Ms" ) ;
    		close() ;
            delete respms ;
			return -5 ;
		}
        respms->Write( recvbuf, buf_len ) ;
        if ( m_CallbackFunc( NULL, (long)m_CallData, 0, respms->Position ) != 0 )
        {
            callMessage( "f܂." ) ;
    		close() ;
            delete respms ;
			return -5 ;
        }
	}

    TMemoryStream *tmpms = new TMemoryStream() ;
    if ( respms->Position > respsize )
    {
        char *p = (char*)respms->Memory ;
        tmpms->Write( p +respsize, respms->Position - respsize ) ;
    }
    respms->Position = respsize -4 ;
    respms->Write( "", 1 ) ;
    char *pres = (char*)respms->Memory ;

    // X|Xwb_

    // Status-Code
    DWORD scode = getStatusCode( pres ) ;
    if ( scode == 100 )
    {
        respms->LoadFromStream( tmpms ) ;
        respms->Position = respms->Size ;
        delete tmpms ;
        continue ;
    }
    else if ( scode != 200 )
    {
        //close() ;
        delete tmpms ;
        if ( scode == 302 )
        {
            callMessage( "ړ]Ă܂." ) ;
            return 2 ;
        }
        if ( scode == 304 )
        {
            callMessage( "XVĂ܂." ) ;
            return 1 ;
        }
        callMessage( "code:" + scode ) ;
        return -6 ;
    }

    // Last-Modified
    dattime = getLastModified( pres ) ;

    // Content-Length
    DWORD urisize = getContentLength( pres ) ;
    if ( urisize == 0 )
    {
		urisize = ~0 ;
	}
	else
    {
        tmpms->SetSize( (int)urisize ) ;
    }

    // Content-Encoding
    bool isgzip = isGzipEncode( pres ) ;

    // Connection: close
    checkConnection( pres ) ;

    delete respms ;
	// f[^M
    DWORD pos = tmpms->Position ;
    DWORD datsize = pos ;
	for ( ; pos < urisize; )
    {
        if ( waitForRecv() == 0 )
        {
			if ( callMessage( "x:^CAEg" ) != 0 )
            {
    		    close() ;
                delete tmpms ;
			    return -5 ;
            }
            tocount -- ;
            if ( tocount <= 0 )
            {
                callMessage( "^CAEg." ) ;
    		    close() ;
                delete respms ;
			    return -6 ;
            }
            continue ;
		}
        tocount = 3 ;
		buf_len = recv( recvbuf, HTTPBUFF_SIZE, 0 ) ;
		if ( buf_len == SOCKET_ERROR )
        {
        	callMessage( "G[:T[o̎Ms" ) ;
    		close() ;
            delete tmpms ;
			return -5 ;
        }
#if 1
        if ( buf_len == 0 )
        {
            // MI?
            break ;
		}
#endif
        tmpms->Write( recvbuf, buf_len ) ;
        pos += buf_len ;
        datsize += buf_len ;
        if ( m_CallbackFunc( NULL, (long)m_CallData, pos, urisize ) != 0 )
        {
            callMessage( "f܂." ) ;
    		close() ;
            delete tmpms ;
			return -5 ;
        }
	}

    tmpms->SetSize( (int)datsize ) ;
    if ( isgzip )
    {
        // gzipGR[fBO
        // gzipŎ擾̂subject.txt̂
        // datgzipŎȂ悤ɂȂH
        callMessage( "gzipfR[h..." ) ;
        bool g = decodeGzip( tmpms, ms ) ; // gzipWJ
        if ( g )
        {
            callMessage( "ok." ) ;
            logging( (char*)ms->Memory, ms->Position ) ;
            ms->SetSize( (int)ms->Position ) ;
        }
        else
        {
            callMessage( "gzipfR[hɎs." ) ;
            ret = -7 ;
            tmpms->SaveToFile( g_global.getLogDir() + FILENAME_GZIPDUMP ) ;
            dattime = "" ;
        }
    }
    else
    {
        // gzipGR[fBOłȂΉGR[fBOĂȂf[^Ɖ
        // NULL'*'ɕϊ
        ms->SetSize( (int)datsize ) ;
        ms->Position = 0 ;
        char *pm = (char*)tmpms->Memory ;
        char *p = pm ;
        for (DWORD i=0; i < datsize; i++)
        {
            if ( *p == 0 ) *p = '*' ;
            p ++ ;
        }
        ms->Write( pm, datsize ) ;
        callMessage( "ok." ) ;
    }

    delete tmpms ;
    break ;
}
    //close() ;

    return ret ;
}
//---------------------------------------------------------------------------
/** 擾
 * msɎ擾ǂݍł.
 * dattimeIf-Modified-SinceLast-Modified̎󂯓nɎg
 * lastmod  true  dattime łȂIf-Modified-SinceŃNGXg
 * 󂯎f[^Last-ModifieddattimeŕԂ
 * Ƃ肠0Ԃ.
 */
int __fastcall AHttpSock::rangeDownload(const AnsiString &url, TMemoryStream *ms, AnsiString &dattime, bool lastmod)
{
	// URL𕪉
	AnsiString host, path;
	parseUrl( url.c_str(), host, path ) ;

    if ( ! connect( host ) )
    {
		return -1 ;
    }

    callMessage( url.c_str() ) ;
    int rangepos = ms->Size -1 ;
	// T[o GET NGXg𑗐M
	AnsiString sendstr = "GET " ;
    sendstr += path ;
    sendstr += " HTTP/1.1\r\nHost: " ;
    sendstr += host ;
    sendstr += "\r\nUser-Agent: " ;
    sendstr += g_useragent ;
    //sendstr += "\r\nAccept: */*" ;
    //sendstr += "Connection: close" ;
    // If-Modified-Since
    if ( lastmod && ! dattime.IsEmpty() )
    {
        sendstr += "\r\nIf-Modified-Since:" ;
        sendstr += dattime ;
    }
    sendstr += "\r\nRange: bytes=" ;
    sendstr += rangepos ;
    sendstr += "-" ;
    sendstr += "\r\n\r\n" ;

	if ( ! send( sendstr ) )
    {
		return -2 ;
	}

	// X|Xwb_M
	unsigned char recvbuf[HTTPBUFF_SIZE] ;
    TMemoryStream *respms = new TMemoryStream() ;
    int respsize ;
    int buf_len ;
    int tocount = 3 ;
for (;;)
{
	for (;;)
    {
        respms->Write( "", 1 ) ;
        respms->Position = respms->Position -1 ;
        char *p = (char*)respms->Memory ;
        char *pp = strstr( p, "\r\n\r\n" ) ;
        if ( pp != NULL )
        {
            respsize = pp - p +4 ;
            break ;
        }
        if ( waitForRecv() == 0 )
        {
			if ( callMessage( "x:^CAEg" ) != 0 )
            {
    		    close() ;
                delete respms ;
			    return -5 ;
            }
            tocount -- ;
            if ( tocount <= 0 )
            {
                callMessage( "^CAEg." ) ;
    		    close() ;
                delete respms ;
			    return -6 ;
            }
            continue ;
		}
        tocount = 3 ;
		buf_len = recv( recvbuf, HTTPBUFF_SIZE, 0 ) ;
		if ( (buf_len == SOCKET_ERROR) || (buf_len == 0) )
        {
        	callMessage( "G[:T[o̎Ms" ) ;
    		close() ;
            delete respms ;
			return -5 ;
		}
        // NULL'*'ɕϊ
        for (int i=0; i < buf_len; i++)
        {
            if ( recvbuf[i] == 0 ) recvbuf[i] = '*' ;
        }
        respms->Write( recvbuf, buf_len ) ;
        if ( m_CallbackFunc( NULL, (long)m_CallData, 0, respms->Position ) != 0 )
        {
            callMessage( "f܂." ) ;
    		close() ;
            delete respms ;
			return -5 ;
        }
	}

    TMemoryStream *tmpms = new TMemoryStream() ;
    if ( respms->Position > respsize )
    {
        char *p = (char*)respms->Memory ;
        tmpms->Write( p + respsize, respms->Position - respsize ) ;
    }
    respms->Position = respsize -4 ;
    respms->Write( "", 1 ) ;
    char *pres = (char*)respms->Memory ;


    // X|Xwb_

    // Status-Code
    DWORD scode = getStatusCode( pres ) ;
    if ( scode == 100 )
    {
        respms->LoadFromStream( tmpms ) ;
        respms->Position = respms->Size ;
        delete tmpms ;
        continue ;
    }
    // Last-Modified
    dattime = getLastModified( pres ) ;

    // Content-Length
    DWORD urisize = getContentLength( pres ) ;

    // Connection: close
    checkConnection( pres ) ;

    delete respms ;
    DWORD pos = 1 ;
    if ( scode == 206 )
    {
        // Range
        ms->Position = ms->Size ;
        unsigned char b ;
        if ( tmpms->Position > 0 )
        {
            pos = tmpms->Size ;
            b = *(unsigned char*)(tmpms->Memory) ;
            ms->Write( (char*)tmpms->Memory +1, tmpms->Size -1 ) ;
        }
        else
        {
            buf_len = recv( recvbuf, 1, 0 ) ;
            if ( buf_len == SOCKET_ERROR )
            {
			    callMessage( "G[:T[o̎Ms" ) ;
        		close() ;
                delete tmpms ;
			    return -5 ;
            }
            b = recvbuf[0] ;
        }
        if ( b != 0x0a )
        {
#if 1
            // ځ[񓙂
            callMessage( "Ol܂̂ߍĎ擾܂." ) ;
    		close() ;
            delete tmpms ;
            dattime = "" ;
            return download( url, ms, dattime ) ;
#else
            callMessage( "Ol܂ł΂[." ) ;
            ms->Position = 0 ;
#endif
        }
    }
    else if ( scode == 302 )
    {
        // Found
        //close() ;
        delete tmpms ;
        return 2 ;
    }
    else if ( scode == 304 )
    {
        callMessage( "ύXĂ܂." ) ;
        //close() ;
        delete tmpms ;
        return 1 ;
    }
    else if ( scode == 416 )
    {
        // range
        callMessage( "Ol܂̂ߍĎ擾܂." ) ;
        close() ;
        delete tmpms ;
        dattime = "" ;
        return download( url, ms, dattime ) ;
    }
    else if ( scode == 200 )
    {
        // Range ͖ꂽ
        // Ă͂ځ`ŃTCYȂA烌XtĂ邩Ȃ
        ms->LoadFromStream( tmpms ) ;
        ms->Position = ms->Size ;
        callMessage( "x:擾ł܂" ) ;
        pos = 0 ;
    }
    else
    {
        close() ;
        delete tmpms ;
        return -6 ;
    }
    delete tmpms ;

	// f[^M
	for ( ; pos < urisize; )
    {
        if ( waitForRecv() == 0 )
        {
			if ( callMessage( "x:^CAEg" ) != 0 )
            {
    		    close() ;
			    return -5 ;
            }
            tocount -- ;
            if ( tocount <= 0 )
            {
                callMessage( "^CAEg." ) ;
    		    close() ;
                delete respms ;
			    return -6 ;
            }
            continue ;
		}
        tocount = 3 ;
		buf_len = recv( recvbuf, HTTPBUFF_SIZE, 0 ) ;
		if ( buf_len == SOCKET_ERROR )
        {
        	callMessage( "G[:T[o̎Ms" ) ;
    		close() ;
            return -5 ;
        }
#if 1
        if ( buf_len == 0 )
        {
            // MI?
            break ;
		}
#endif
        // NULL'*'ɕϊ
        for (int i=0; i < buf_len; i++)
        {
            if ( recvbuf[i] == 0 ) recvbuf[i] = '*' ;
        }
        ms->Write( recvbuf, buf_len ) ;
        pos += buf_len ;
        if ( m_CallbackFunc( NULL, (long)m_CallData, pos, urisize ) != 0 )
        {
            callMessage( "f܂." ) ;
    		close() ;
			return -3 ;
        }
	}
    ms->SetSize( (int)ms->Position ) ;
    break ;
}
    //close() ;
    callMessage( "ok." ) ;

    return 0 ;
}
//---------------------------------------------------------------------------


