/** gzip L
 * ͂ɂ`, kageQl
 */

#include <vcl.h>
namespace ZLIB /* RpCG[΍ */
{
    #include "zlib/zlib.h"
}
#pragma hdrstop
#pragma comment (lib, "zlib\zlib.lib")

#include "gzip.h"

/* gzip flag byte */
#define ASCII_FLAG   0x01 /* bit 0 set: file probably ascii text */
#define HEAD_CRC     0x02 /* bit 1 set: header CRC present */
#define EXTRA_FIELD  0x04 /* bit 2 set: extra field present */
#define ORIG_NAME    0x08 /* bit 3 set: original file name present */
#define COMMENT      0x10 /* bit 4 set: file comment present */
#define RESERVED     0xE0 /* bits 5..7: reserved */

//---------------------------------------------------------------------------
/** gzipwb_̃TCY𓾂
 * @param buf gzipf[^
 * @param len f[^TCY
 * @return gzipwb_TCYBG[ -1
 */
int __fastcall getGzipHeaderSize(const char *buf, int len)
{
	const char gz_magic[2] = { '\x1f', '\x8b' } ;

	if ( len < 0x20 )
    {
		return -1 ;
	}

	int i = 0 ;
#if 0
    // 擪̃S~(?)16oCg炢͋e
    for ( ; i < 0xf ; i++)
#else
    for ( ; i < 1; i++)
#endif
    {
        if ( buf[i] == gz_magic[0] && buf[i+1] == gz_magic[1] )
        {
            goto HEADNEXT ;
        }
    }
    return -1 ;
    
HEADNEXT:
	i += 2 ;
	int method = buf[i++] ;
	int flags  = buf[i++] ;
	if ( (method != Z_DEFLATED) || ((flags & RESERVED) != 0) )
    {
		return -1 ;
	}
	i += 6 ;

	if ( flags & EXTRA_FIELD )
    {
        /* skip the extra field */
		int len = buf[i++] ;
		len += (buf[i++] << 8) ;
		/* len is garbage if EOF but the loop below will quit anyway */
		i += len ;
	}
	if ( flags & ORIG_NAME )
    {
        /* skip the original file name */
		while ( buf[i++] != 0 ) ;
	}
	if ( flags & COMMENT )
    {
        /* skip the .gz file comment */
		while ( buf[i++] != 0 ) ;
	}
	if ( flags & HEAD_CRC )
    {
        /* skip the header crc */
		i += 2 ;
	}

	return i ;
}
//---------------------------------------------------------------------------
/** gzip烁ɓWJ
 * ӁF0x00'*'ɕϊ
 * @param src
 * @param dest
 * @return 
 */
bool __fastcall decodeGzip(TMemoryStream *src, TMemoryStream *dest)
{
	// gzipwb_XLbv
	char *p = (char*)src->Memory ;
	int s = src->Size ;
	int hsize =  getGzipHeaderSize( p, s ) ;
	if ( hsize < 0 ) return false ;

	ZLIB::z_stream z ;
    /* ׂẴǗCuɔC */
    z.zalloc = Z_NULL ;
    z.zfree = Z_NULL ;
    z.opaque = Z_NULL ;

    /*  */
    z.next_in = Z_NULL ;
    z.avail_in = 0 ;

    if ( ZLIB::inflateInit2_(&z, -MAX_WBITS, ZLIB_VERSION, sizeof(ZLIB::z_stream)) != Z_OK )
    {
       return false ;
    }

    bool ret = true ;
	src->Position = hsize ;
	dest->Position = 0 ;
#define GZIPBUFSIZE 4096
	char buf[GZIPBUFSIZE] ;
	z.avail_out = GZIPBUFSIZE ;
	z.next_out  = buf ;

	z.next_in  = (unsigned char*)(p + hsize) ;
	z.avail_in = s - hsize ;

	int status = Z_OK ;
	while ( status != Z_STREAM_END )
    {
		if ( z.avail_in == 0 ) break ; // ͎cʂ[

		status = inflate( &z, Z_NO_FLUSH ) ;
		if ( status == Z_STREAM_END )
        {
			int used = GZIPBUFSIZE - z.avail_out ;
            // NULL
            for (int n=0; n < used; n++)
            {
                if ( buf[n] == 0 ) buf[n] = '*' ;
            }
			dest->Write( buf, used ) ;
			dest->SetSize( (int)dest->Position ) ;
			break ;
		}
		if ( status != Z_OK )
        {
        	// G[
			ret = false ;
            break ;
		}
		if ( z.avail_out == 0 )
        {
            // NULL
            for (int n=0; n < GZIPBUFSIZE; n++)
            {
                if ( buf[n] == 0 ) buf[n] = '*' ;
            }

			dest->Write( buf,  GZIPBUFSIZE ) ;
			z.avail_out = GZIPBUFSIZE ;
			z.next_out  = (unsigned char*)buf ;
		}
	}

    inflateEnd( &z ) ;
	return ret ;
}
//---------------------------------------------------------------------------


