//---------------------------------------------------------------------------
/** ݒ̊Ǘ
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef myconfig_h
#define myconfig_h

#include <vcl.h>
#include <inifiles.hpp>

#define FILEPATH_CONFIG_INI "\\ini\\config.ini"

extern THintWindow *g_popHint ;
extern int g_hintMaxRow ;
extern AnsiString g_useragent ;
extern bool g_subjectGzip ;
extern bool g_outputDebugLog ;
extern bool g_openNewTab ;
extern AnsiString g_wwwBrowserPath ;

extern TColor g_colorSubscribeBBS ;
extern TColor g_colorNewThread ;
extern TColor g_colorUnreadThread ;
extern TColor g_colorLogExistThread ;
extern TColor g_colorNologThread ;
extern TColor g_color1000OverThread ;
extern TColor g_colorPastThread ;

extern bool g_CacheServerEnable ;
extern AnsiString g_CacheServerMatch ;
extern AnsiString g_CacheServerHost ;

typedef enum
{
    styleStandard = 0, // TCho[3yCA܂̓TCho[Ȃ2yC
    styleSidebarAndBrowser = 1, // TCho[ɃXbhꗗ
} ViewStyle ;

#define MAINFORM_INI "MainForm"
#define MAINFORM_INI_TOP "top"
#define MAINFORM_INI_LEFT "left"
#define MAINFORM_INI_WIDTH "width"
#define MAINFORM_INI_HEIGHT "height"
#define MAINFORM_INI_SIDEBAR_VISIBLE "SidebarVisible"
#define MAINFORM_INI_VIEW_STYLE "ViewStyle"
#define MAINFORM_INI_SIDEBAR_WIDTH "SidebarWidth"
#define MAINFORM_INI_SUBJECT_HEIGHT "SubjectHeight"
#define MAINFORM_INI_SUBJECT_COLUMN "SubjectColumn"
typedef struct FORM_INI
{
    int top ;
    int left ;
    int width ;
    int height ;
    bool sidebarVisible ;
    ViewStyle viewStyle ;
    int sidebarWidth ;
    int subjectHeight ;
} FORM_INI;

#define BBSMENU_URL_INI "BBSMenuURL"
#define BBSMENU_URL_INI_HISTORY1    "History1"
#define BBSMENU_URL_INI_HISTORY2    "History2"
#define BBSMENU_URL_INI_HISTORY3    "History3"
#define BBSMENU_URL_INI_HISTORY4    "History4"
#define BBSMENU_URL_INI_HISTORY5    "History5"
#define BBSMENU_URL_INI_TIMESTAMP   "Timestamp"

#define KODAWARI_INI    "Kodawari"
#define KODAWARI_INI_SUBJECT_GZIP   "SubjectGzip"
#define KODAWARI_INI_DEBUG_LOG  "DebugLog"
#define KODAWARI_INI_NEWTAB_OPEN    "NewTabOpen"
#define KODAWARI_INI_TAB_MULTILINE  "TabMultiLine"
#define KODAWARI_INI_TAB_STYLE  "TabStyle"
#define KODAWARI_INI_WWW_BROWSER    "BrowserApp"

#define LOOKFEEL_INI    "LookFeel"
#define LOOKFEEL_INI_BOARD_FONTSIZE "BoardFontSize"
#define LOOKFEEL_INI_SUBJECT_FONTSIZE   "ThreadFontSize"
#define LOOKFEEL_INI_SUBJECT_SUBSCRIBE_COLOR    "SubjectSubscribeColor"
#define LOOKFEEL_INI_NEWTHREAD_COLOR    "NewThreadColor"
#define LOOKFEEL_INI_UNREAD_THREAD_COLOR    "UnreadThreadColor"
#define LOOKFEEL_INI_LOG_EXIST_THREAD_COLOR "LogExistThreadColor"
#define LOOKFEEL_INI_NOLOG_THREAD_COLOR "NologThreadColor"
#define LOOKFEEL_INI_1000OVER_THREAD_COLOR  "Over1000ThreadColor"
#define LOOKFEEL_INI_PAST_THREAD_COLOR  "PastThreadColor"

#define CACHESERVER_INI "CacheServer"
#define CACHESERVER_INI_ENABLE  "Enable"
#define CACHESERVER_INI_MATCH   "Match"
#define CACHESERVER_INI_HOST    "Host"

class AConfig
{
public:
	AConfig()
    {
        m_ini = NULL ;
	}
	~AConfig()
    {
		if ( m_ini ) delete m_ini ;
	}
	void __fastcall nop(void) ;
	void __fastcall init(const AnsiString &iniFilePath) ;
	void __fastcall loadFormInfo(FORM_INI *form) ;
	void __fastcall saveFormInfo(FORM_INI *form, bool flush = true) ;
	void __fastcall loadListViewColumn(void) ;
	void __fastcall saveListViewColumn(bool flush = true) ;
	void __fastcall loadGlobal(void) ;
	void __fastcall exportToDialog(long form) ;
	void __fastcall importFromDialog(long form, bool flush = true) ;
	void __fastcall readBBSMenuURL(TStringList *list) ;
	void __fastcall writeBBSMenuURL(TStringList *list, bool flush = true) ;
	AnsiString __fastcall getMenuTimestamp(void) ;
	void __fastcall setMenuTimestamp(const AnsiString &time, bool flush = true) ;
    /** init@Cɐݒۑ
     */
	void __fastcall flushIni(void)
    {
        if ( ! m_ini ) return ;
        m_ini->UpdateFile() ;
    }
private:
	TMemIniFile *m_ini ;
} ;

extern AConfig *gp_config ; /* O[o */

#endif /* config.h */

