//---------------------------------------------------------------------------
/** ݒ̊Ǘ
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <inifiles.hpp>
#pragma hdrstop

#include "config.h"
#include "httpsock.h"
#include "MainUnit.h"
#include "OptionUnit.h"

/* O[o */
THintWindow *g_popHint ; // X|bvAbvp
int g_hintMaxRow ; // |bvAbv̏s
AnsiString g_useragent ;
bool g_subjectGzip ;
bool g_outputDebugLog ;
bool g_openNewTab ;
AnsiString g_wwwBrowserPath ;

TColor g_colorSubscribeBBS ;
TColor g_colorNewThread ;
TColor g_colorUnreadThread ;
TColor g_colorLogExistThread ;
TColor g_colorNologThread ;
TColor g_color1000OverThread ;
TColor g_colorPastThread ;

bool g_CacheServerEnable ;
AnsiString g_CacheServerMatch ;
AnsiString g_CacheServerHost ;

AConfig *gp_config ;
//---------------------------------------------------------------------------
/** 
 * @param iniFilePath {[hinit@CpX
 */
void __fastcall AConfig::init(const AnsiString &iniFilePath)
{
    if ( m_ini ) return ;
    m_ini = new TMemIniFile( iniFilePath ) ;
}
//---------------------------------------------------------------------------
/** Form֌W̐ݒۑ
 * @param form FORM_INI
 * @param flush trueinit@Cɐݒo
 */
void __fastcall AConfig::saveFormInfo(FORM_INI *form, bool flush)
{
    if ( ! m_ini ) return ;

    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_TOP, form->top ) ;
    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_LEFT, form->left ) ;
    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_WIDTH, form->width ) ;
    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_HEIGHT, form->height ) ;
    m_ini->WriteBool( MAINFORM_INI, MAINFORM_INI_SIDEBAR_VISIBLE, form->sidebarVisible ) ;
    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_VIEW_STYLE, form->viewStyle ) ;
    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_SIDEBAR_WIDTH, form->sidebarWidth ) ;
    m_ini->WriteInteger( MAINFORM_INI, MAINFORM_INI_SUBJECT_HEIGHT, form->subjectHeight ) ;

    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** Form֌W̐ݒǂݏo
 * @param form FORM_INI
 */
void __fastcall AConfig::loadFormInfo(FORM_INI *form)
{
    if ( ! m_ini ) return ;

    form->top    = m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_TOP, 0 ) ;
    form->left   = m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_LEFT, 0 ) ;
    form->width  = m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_WIDTH, 640 ) ;
    form->height = m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_HEIGHT, 480 ) ;
    form->sidebarVisible = m_ini->ReadBool( MAINFORM_INI, MAINFORM_INI_SIDEBAR_VISIBLE, true ) ;
    form->viewStyle  = (ViewStyle)m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_VIEW_STYLE, 180 ) ;
    form->sidebarWidth  = m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_SIDEBAR_WIDTH, 180 ) ;
    form->subjectHeight = m_ini->ReadInteger( MAINFORM_INI, MAINFORM_INI_SUBJECT_HEIGHT, 130 ) ;
}
//---------------------------------------------------------------------------
/** XbhꗗListView̐ݒ擾
 */
void __fastcall AConfig::loadListViewColumn(void)
{
    if ( ! m_ini ) return ;

    TStringList *sl = new TStringList() ;
    sl->CommaText = m_ini->ReadString( MAINFORM_INI, MAINFORM_INI_SUBJECT_COLUMN, "0,38,38,325,40,40,40,180,100,120" ) ;
    int c = MainForm->SubjectListView->Columns->Count ;
    for (int i=0; i < c; i++)
    {
        MainForm->SubjectListView->Column[i]->Width = sl->Strings[i].ToIntDef( 40 ) ;
    }
    delete sl ;
}
//---------------------------------------------------------------------------
/** XbhꗗListView̐ݒۑ
 * @param flush trueinit@Cɐݒo
 */
void __fastcall AConfig::saveListViewColumn(bool flush)
{
    if ( ! m_ini) return ;

    TStringList *sl = new TStringList() ;
    int c = MainForm->SubjectListView->Columns->Count ;
    AnsiString w ;
    for (int i=0; i < c; i++)
    {
        w = AnsiString( MainForm->SubjectListView->Column[i]->Width ) ;
        sl->Add( w ) ;
    }
    m_ini->WriteString( MAINFORM_INI, MAINFORM_INI_SUBJECT_COLUMN, sl->CommaText ) ;
    delete sl ;

    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** ݒ𔽉f
 */
void __fastcall AConfig::loadGlobal(void)
{
    if ( ! m_ini ) return ;

    g_subjectGzip = m_ini->ReadBool( KODAWARI_INI, KODAWARI_INI_SUBJECT_GZIP, true ) ;
    g_outputDebugLog = m_ini->ReadBool( KODAWARI_INI, KODAWARI_INI_DEBUG_LOG, false ) ;
    g_openNewTab = m_ini->ReadBool( KODAWARI_INI, KODAWARI_INI_NEWTAB_OPEN, false ) ;
    g_wwwBrowserPath = m_ini->ReadString( KODAWARI_INI, KODAWARI_INI_WWW_BROWSER, "" ) ;

    int fsize = m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_BOARD_FONTSIZE, 10 ) ;
    MainForm->BBSTreeView->Font->Size = fsize ;
    MainForm->subscribeTreeView->Font->Size = fsize ;
    MainForm->SubjectListView->Font->Size = m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_SUBJECT_FONTSIZE, 10 ) ;
    
    g_colorSubscribeBBS     = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_SUBJECT_SUBSCRIBE_COLOR, clYellow ) ;
    g_colorNewThread        = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_NEWTHREAD_COLOR, 16445154 ) ;
    g_colorUnreadThread     = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_UNREAD_THREAD_COLOR, 41727 ) ;
    g_colorLogExistThread   = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_LOG_EXIST_THREAD_COLOR, clWhite ) ;
    g_colorNologThread      = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_NOLOG_THREAD_COLOR, clWhite ) ;
    g_color1000OverThread   = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_1000OVER_THREAD_COLOR, clWhite ) ;
    g_colorPastThread       = (TColor)m_ini->ReadInteger( LOOKFEEL_INI, LOOKFEEL_INI_PAST_THREAD_COLOR, clYellow ) ;

    if ( g_openNewTab )
    {
        MainForm->SubjectListView->OnClick = MainForm->OnOpenThreadInNewTab ;
        MainForm->threadNewTabMI->Caption = "ANeBuȃ^uŊJ" ;
        MainForm->threadNewTabMI->OnClick = MainForm->OnOpenThreadInActiveTab ;
    }
    else
    {
        MainForm->SubjectListView->OnClick = MainForm->OnOpenThreadInActiveTab ;
        MainForm->threadNewTabMI->Caption = "V^uŊJ" ;
        MainForm->threadNewTabMI->OnClick = MainForm->OnOpenThreadInNewTab ;
    }
    MainForm->tabPageControl->MultiLine = m_ini->ReadBool( KODAWARI_INI, KODAWARI_INI_TAB_MULTILINE, false ) ;
    MainForm->tabPageControl->Style = (Comctrls::TTabStyle)m_ini->ReadInteger( KODAWARI_INI, KODAWARI_INI_TAB_STYLE, 0 ) ;
    //MainForm->TabMane.setParent() ;

    g_CacheServerEnable = m_ini->ReadBool(CACHESERVER_INI, CACHESERVER_INI_ENABLE, false);
    g_CacheServerMatch  = m_ini->ReadString(CACHESERVER_INI, CACHESERVER_INI_MATCH, ".2ch.net");
    g_CacheServerHost   = m_ini->ReadString(CACHESERVER_INI, CACHESERVER_INI_HOST, "liveb1.2ch.net");
}
//---------------------------------------------------------------------------
/** ݒ_CAO
 * @param form TSettingForm
 */
void __fastcall AConfig::exportToDialog(long form)
{
    if ( ! m_ini ) return ;
    TSettingForm *SettingForm = (TSettingForm *)form ;

    SettingForm->subjectGzipCheckBox->Checked = g_subjectGzip ;
    SettingForm->debugLogCheckBox->Checked = g_outputDebugLog ;
    SettingForm->newTabCheckBox->Checked = g_openNewTab ;
    SettingForm->tabMultiLineCheckBox->Checked = m_ini->ReadBool( KODAWARI_INI, KODAWARI_INI_TAB_MULTILINE, false ) ;
    SettingForm->tabStyleRadioGroup->ItemIndex = m_ini->ReadInteger( KODAWARI_INI, KODAWARI_INI_TAB_STYLE, 0 ) ;
    SettingForm->browserEdit->Text = g_wwwBrowserPath ;

    int bsize = MainForm->subscribeTreeView->Font->Size ;
    SettingForm->bbsMenuFontButton->Tag = bsize ;
    SettingForm->bbsMenuFontButton->Caption = bsize ;
    int ssize = MainForm->SubjectListView->Font->Size ;
    SettingForm->threadFontButton->Tag = ssize ;
    SettingForm->threadFontButton->Caption = ssize ;

    SettingForm->subscribeLabel->Color = g_colorSubscribeBBS ;
    SettingForm->threadNewLabel->Color = g_colorNewThread ;
    SettingForm->threadUnreadLabel->Color = g_colorUnreadThread ;
    SettingForm->threadLogExistLabel->Color = g_colorLogExistThread ;
    SettingForm->threadNologLabel->Color = g_colorNologThread ;
    SettingForm->thread1000OverLabel->Color = g_color1000OverThread ;
    SettingForm->threadPastLabel->Color = g_colorPastThread ;

    SettingForm->cache1CB->Checked = g_CacheServerEnable ;
    SettingForm->cache1Edit->Text = g_CacheServerMatch ;
    SettingForm->cacheserver1Edit->Text = g_CacheServerHost ;
    SettingForm->cache1Enabled( g_CacheServerEnable ) ;
}
//---------------------------------------------------------------------------
/** ݒ_CAO̓͂ۑ
 * @param form TSettingForm
 * @param flush trueinit@Cɐݒo
 */
void __fastcall AConfig::importFromDialog(long form, bool flush)
{
    if ( ! m_ini ) return ;
    TSettingForm *SettingForm = (TSettingForm *)form ;

    m_ini->WriteBool( KODAWARI_INI, KODAWARI_INI_SUBJECT_GZIP, SettingForm->subjectGzipCheckBox->Checked ) ;
    m_ini->WriteBool( KODAWARI_INI, KODAWARI_INI_DEBUG_LOG, SettingForm->debugLogCheckBox->Checked ) ;
    m_ini->WriteBool( KODAWARI_INI, KODAWARI_INI_NEWTAB_OPEN, SettingForm->newTabCheckBox->Checked ) ;
    m_ini->WriteBool( KODAWARI_INI, KODAWARI_INI_TAB_MULTILINE, SettingForm->tabMultiLineCheckBox->Checked ) ;
    m_ini->WriteInteger( KODAWARI_INI, KODAWARI_INI_TAB_STYLE, SettingForm->tabStyleRadioGroup->ItemIndex ) ;
    m_ini->WriteString( KODAWARI_INI, KODAWARI_INI_WWW_BROWSER, SettingForm->browserEdit->Text ) ;

    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_BOARD_FONTSIZE, SettingForm->bbsMenuFontButton->Tag ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_SUBJECT_FONTSIZE, SettingForm->threadFontButton->Tag ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_SUBJECT_SUBSCRIBE_COLOR, SettingForm->subscribeLabel->Color ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_NEWTHREAD_COLOR, SettingForm->threadNewLabel->Color ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_UNREAD_THREAD_COLOR, SettingForm->threadUnreadLabel->Color ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_LOG_EXIST_THREAD_COLOR, SettingForm->threadLogExistLabel->Color ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_NOLOG_THREAD_COLOR, SettingForm->threadNologLabel->Color ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_1000OVER_THREAD_COLOR, SettingForm->thread1000OverLabel->Color ) ;
    m_ini->WriteInteger( LOOKFEEL_INI, LOOKFEEL_INI_PAST_THREAD_COLOR, SettingForm->threadPastLabel->Color ) ;

    m_ini->WriteBool(CACHESERVER_INI, CACHESERVER_INI_ENABLE, SettingForm->cache1CB->Checked);
    m_ini->WriteString(CACHESERVER_INI, CACHESERVER_INI_MATCH, SettingForm->cache1Edit->Text);
    m_ini->WriteString(CACHESERVER_INI, CACHESERVER_INI_HOST, SettingForm->cacheserver1Edit->Text);

    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** {[hꗗHTMLURLXgǂݏo
 * @param list Xg󂯎TStringList
 */
void __fastcall AConfig::readBBSMenuURL(TStringList *list)
{
    list->Clear() ;
    if ( ! m_ini ) return ;

    AnsiString url ;
    url = m_ini->ReadString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY1, "http://menu.2ch.net/bbsmenu.html" ) ; /* {[hꗗ̃ftHgURL */
    list->Add( url ) ;

    url = m_ini->ReadString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY2, "" ) ;
    if ( ! url.IsEmpty() ) list->Add( url ) ;
    url = m_ini->ReadString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY3, "" ) ;
    if ( ! url.IsEmpty() ) list->Add( url ) ;
    url = m_ini->ReadString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY4, "" ) ;
    if ( ! url.IsEmpty() ) list->Add( url ) ;
    url = m_ini->ReadString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY5, "" ) ;
    if ( ! url.IsEmpty() ) list->Add( url ) ;
}
//---------------------------------------------------------------------------
/** {[hꗗHTMLURLXgۑ
 * @param list URLXg
 * @param flush trueinit@Cɐݒo
 */
void __fastcall AConfig::writeBBSMenuURL(TStringList *list, bool flush)
{
    if ( ! m_ini ) return ;

    int count = list->Count ;
    if ( count < 1 ) return ;
    m_ini->WriteString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY1, list->Strings[0] ) ;
    if ( count < 2 ) return ;
    m_ini->WriteString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY2, list->Strings[1] ) ;
    if ( count < 3 ) return ;
    m_ini->WriteString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY3, list->Strings[2] ) ;
    if ( count < 4 ) return ;
    m_ini->WriteString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY4, list->Strings[3] ) ;
    if ( count < 5 ) return ;
    m_ini->WriteString( BBSMENU_URL_INI, BBSMENU_URL_INI_HISTORY5, list->Strings[4] ) ;

    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** {[hꗗHTML̃^CX^v擾
 * @return ^CX^v
 */
AnsiString __fastcall AConfig::getMenuTimestamp(void)
{
    AnsiString result = "" ;
    if ( ! m_ini ) return result ;

    result = m_ini->ReadString( BBSMENU_URL_INI, BBSMENU_URL_INI_TIMESTAMP, "" ) ;
    return result ;
}
//---------------------------------------------------------------------------
/** {[hꗗHTML̃^CX^vۑ
 * @@param ^CX^v
 * @param flush trueinit@Cɐݒo
 */
void __fastcall AConfig::setMenuTimestamp(const AnsiString &time, bool flush)
{
    if ( ! m_ini ) return ;

    m_ini->WriteString( BBSMENU_URL_INI, BBSMENU_URL_INI_TIMESTAMP, time ) ;

    if ( flush ) m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------

