//---------------------------------------------------------------------------
/** {^Ǘ
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <ComCtrls.hpp>
#pragma hdrstop

#include "brdbtn.h"

/* O[o */
ABoardButton g_boardButton ;
//---------------------------------------------------------------------------
/** 
 */
void __fastcall ABoardButton::init(TToolBar *ToolBar, const AnsiString &listPath)
{
    if ( m_list ) return ;

    m_ToolBar = ToolBar ;
    m_listPath = listPath ;
    OnClick = ToolBar->Buttons[0]->OnClick ;
    OnMouseUp = ToolBar->Buttons[0]->OnMouseUp ;

    m_list = new TStringList() ;
    try
    {
        m_list->LoadFromFile( listPath ) ;
    } catch (...) {}

    TToolButton *pButton ;
    int c = m_list->Count ;
    for (int i=0; i < c; i++)
    {
        pButton = new TToolButton(ToolBar) ;
        pButton->Parent = ToolBar ;
    }
    rebuildButton() ;
}
//---------------------------------------------------------------------------
/** {^̃LvVւ
 */
void __fastcall ABoardButton::rebuildButton(void)
{
    TToolButton *pButton = m_ToolBar->Buttons[0] ;
    pButton->Caption = "Cɓ" ;
    pButton->OnClick = OnClick ;
    pButton->OnMouseUp = NULL ;

    int c = m_list->Count ;
    for (int i=0; i < c; i++)
    {
        pButton = m_ToolBar->Buttons[i +1] ;
        pButton->Caption = m_list->Strings[i] ;
        pButton->OnClick = OnClick ;
        pButton->OnMouseUp = OnMouseUp ;
        pButton->AutoSize = true ;
        pButton->Grouped = true ;
        pButton->Style = tbsCheck ;
    }
}
//---------------------------------------------------------------------------
/** {^ǉ
 */
void __fastcall ABoardButton::addBoard(const AnsiString &boardName)
{
    if ( m_list->IndexOf( boardName ) != -1 ) return ; // d

    m_list->Add( boardName ) ;
    TToolButton *pButton = new TToolButton( m_ToolBar ) ;
    pButton->Parent = m_ToolBar ;
    rebuildButton() ;
    m_list->SaveToFile( m_listPath ) ;
}
//---------------------------------------------------------------------------
/** {^폜
 */
void __fastcall ABoardButton::deleteBoard(const AnsiString &boardName)
{
    int index = m_list->Count ;
    TToolButton *pButton = m_ToolBar->Buttons[index] ;
    pButton->Parent = NULL ;
    delete pButton ;
    m_list->Delete( m_list->IndexOf( boardName ) ) ;
    rebuildButton() ;
    m_list->SaveToFile( m_listPath ) ;
}
//---------------------------------------------------------------------------

