//---------------------------------------------------------------------------
/** {[hꗗc[
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <FileCtrl.hpp>
#include <inifiles.hpp>
#pragma hdrstop

#include "bbsmenu.h"
#include "misc.h"
#include "MainUnit.h"

/* O[o */
ABBSMenu g_allBoard ;   // {[hꗗ
ABBSMenu g_subscribeBoard ;  // Cɓ
//---------------------------------------------------------------------------
/** 
 * @param boardTree ΉTreeView
 * @param iniPath {[hinit@CpX
 */
void __fastcall ABBSMenu::init(TTreeView *boardTree, const AnsiString &iniPath)
{
    if ( m_ini ) return ;
    m_ini = new TMemIniFile( iniPath ) ;
    m_TreeView = boardTree ;
}
//---------------------------------------------------------------------------
/** {[hinit@C݂邩
 * @return
 */
bool __fastcall ABBSMenu::isExist(void)
{
    return FileExists( m_ini->FileName ) ;
}
//---------------------------------------------------------------------------
/** j[HTMLf[^{[hINIɕϊ
 * init@C㏑ۑB
 * MenuDatHTMLf[^NULLI[
 * Ȃ茈ߕt
 */
bool __fastcall ABBSMenu::html2ini(char *MenuDat)
{
    if ( ! m_ini ) return false ;

    TStringList *list = new TStringList() ;
    char *p = MenuDat ;
    for (;;)
    {
        char *tag = strchr( p, '<' ) ;
        if ( tag == NULL ) break ;
        tag ++ ;
        if ( *(WORD*)tag == 0x3e42 /*"B>"*/ )
        {
            // <B>JeS</B>
            char *cate = tag +2 ;
            char *catelast = strchr( cate, '<' ) ;
            if ( catelast == NULL ) break ;
            p = catelast ;
            *p = '\0' ;
            list->Add( (AnsiString)"[" + cate + "]" ) ;
        }
        else if ( *(WORD*)tag == 0x2041 /*"A "*/ )
        {
            // <A HREF=URL></A>
            char *url = tag +7 ; // "A REF="
            char *ita = strchr( url, '>' ) ;
            if ( ita == NULL ) break ;
            *ita = '\0' ;
            ita ++ ;
            char *italast = strchr( ita, '<' ) ;
            if ( italast == NULL ) break ;
            p = italast ;
            *p = '\0' ;
            /* URL".2ch.net/"܂܂ĂčŌオ"/".(,www.2ch.net/,TARGET=blank)
             * ܂,URL".bbspink.com/"܂܂ĂčŌオ"/".
             */
            if ( *(ita -2) == '/' )
            {
                if (
                      ( (strstr( url, ".2ch.net/" ) != NULL) && (*(url +7/*"http://"*/) != 'w') )
                   || (strstr( url, ".bbspink.com/" ) != NULL)
                    )
                {
                    list->Add( (AnsiString)ita + "=" + url ) ;
                }
            }
        }
        p ++ ;
    }
    m_ini->SetStrings( list ) ;
    m_ini->UpdateFile() ;
    delete list ;
    return true ;
}
//---------------------------------------------------------------------------
/** {[hf[^TTreeViewɓo^
 * L[ȂZNVA폜init@C㏑ۑB
 */
void __fastcall ABBSMenu::makeTree(void)
{
    if ( ! m_ini ) return ;

    TStringList *sect = new TStringList() ;
    TStringList *key = new TStringList() ;

    m_TreeView->Items->Clear() ;
    m_ini->ReadSections( sect ) ;
    TTreeNode *root = m_TreeView->Items->Add( NULL, "2ch" ) ;

    bool iniupdate = false ;
    int sc = sect->Count ;
    for (int i=0; i < sc; i++)
    {
        m_ini->ReadSection( sect->Strings[i], key ) ;

        int kc = key->Count ;
        if ( kc == 0 )
        {
            m_ini->EraseSection( sect->Strings[i] ) ;
            iniupdate = true ;
            continue ;
        }
        // JeS
        TTreeNode *n = m_TreeView->Items->AddChild( root, sect->Strings[i] ) ;
        for (int j=0; j < kc; j++)
        {
            m_TreeView->Items->AddChild( n, key->Strings[j] ) ;
        }
    }

    if ( iniupdate ) m_ini->UpdateFile() ;
    delete sect ;
    delete key ;
}
//---------------------------------------------------------------------------
/** URL擾
 * Category:JeS
 * BoardName:
 * G[""Ԃ
 */
AnsiString __fastcall ABBSMenu::getUrl(const AnsiString &Category, const AnsiString &BoardName)
{
    if ( ! m_ini ) return "" ;
    return m_ini->ReadString( Category, BoardName, "" ) ;
}
//---------------------------------------------------------------------------
/** ̃[JLbVtH_΃pX擾
 * Category:JeS
 * BoardName:
 * G[""Ԃ
 */
AnsiString __fastcall ABBSMenu::getLocalUrl(const AnsiString &Category, const AnsiString &BoardName)
{
    if ( ! m_ini ) return "" ;

    AnsiString url = getUrl( Category, BoardName ) ;
    if ( url.IsEmpty() ) return url ;
    return url2local( url ) ;
}
//---------------------------------------------------------------------------
/** URLJeSA擾
 * url:url
 * Category:JeS
 * BoardName:
 * G[""Ԃ
 */
void __fastcall ABBSMenu::getBoardName(const AnsiString &Url, AnsiString &Category, AnsiString &BoardName)
{
    Category = "" ;
    BoardName = "" ;
    if ( ! m_ini ) return ;

    TStringList *sect = new TStringList() ;
    TStringList *key = new TStringList() ;

    m_ini->ReadSections( sect ) ;
    int sc = sect->Count ;
    for (int i=0; i < sc; i++)
    {
        m_ini->ReadSection( sect->Strings[i], key ) ;

        // JeS
        int kc = key->Count ;
        for (int j=0; j < kc; j++)
        {
            if ( m_ini->ReadString( sect->Strings[i], key->Strings[j], "" ) == Url )
            {
                Category = sect->Strings[i] ;
                BoardName = key->Strings[j] ;
                delete sect ;
                delete key ;
                return ;
            }
        }
    }
    
    delete sect ;
    delete key ;
}
//---------------------------------------------------------------------------
/** ǉiniۑ
 * Category:JeS
 * BoardName:
 */
void __fastcall ABBSMenu::subscribe(const AnsiString &Category, const AnsiString &BoardName, const AnsiString &Url)
{
    if ( ! m_ini ) return ;

    TTreeNode *rootnode = m_TreeView->Items->Item[0] ;
    int c = rootnode->Count ;
    TTreeNode *catnode = NULL ;
    for (int i=0; i < c; i++)
    {
        TTreeNode *node = rootnode->Item[i] ;
        if ( node->Text == Category )
        {
            catnode = node ;
        }
    }
    if ( catnode == NULL ) catnode = m_TreeView->Items->AddChild( rootnode, Category ) ;
    m_TreeView->Items->AddChild( catnode, BoardName ) ;
    m_ini->WriteString( Category, BoardName, Url ) ;
    m_ini->UpdateFile() ;
}
//---------------------------------------------------------------------------
/** 폜iniۑ
 * Category:JeS
 * BoardName:
 */
void __fastcall ABBSMenu::unsubscribe(const AnsiString &Category, const AnsiString &BoardName)
{
    if ( ! m_ini ) return ;

    if ( m_ini->ValueExists( Category, BoardName ) )
    {
        m_ini->DeleteKey( Category, BoardName ) ;
        m_ini->UpdateFile() ;

        TTreeNode *rootnode = m_TreeView->Items->Item[0] ;
        int c = rootnode->Count ;
        for (int i=0; i < c; i++)
        {
            TTreeNode *catnode = rootnode->Item[i] ;
            if ( catnode->Text == Category )
            {
                int cc = catnode->Count ;
                for (int j=0; j < cc; j++)
                {
                    TTreeNode *itanode = catnode->Item[j] ;
                    if ( itanode->Text == BoardName )
                    {
                        itanode->Delete() ;
                        if ( catnode->Count == 0 ) catnode->Delete() ;
                        return ;
                    }
                }
            }
        } // for
    }
}
//---------------------------------------------------------------------------
/** ݂邩
 * Category:JeS
 * BoardName:
 */
bool __fastcall ABBSMenu::isExist(const AnsiString &Category, const AnsiString &BoardName)
{
    if ( ! m_ini ) return false ;

    return m_ini->ValueExists( Category, BoardName ) ;
}
//---------------------------------------------------------------------------
/** URL̃XgԂ
 */
void __fastcall ABBSMenu::getUrlList(TStringList *list)
{
    if ( ! m_ini ) return ;

    TStringList *sect = new TStringList() ;
    TStringList *key = new TStringList() ;

    list->Clear() ;
    m_ini->ReadSections( sect ) ;
    // ׂĂURL擾
    AnsiString url ;
    int sc = sect->Count ;
    for (int i=0; i < sc; i++)
    {
        m_ini->ReadSection( sect->Strings[i], key ) ;
        int kc = key->Count ;
        for (int j=0; j < kc; j++)
        {
            url = m_ini->ReadString( sect->Strings[i], key->Strings[j], "" ) ;
            list->Add( url ) ;
        }
    }

    delete key ;
    delete sect ;
}
//---------------------------------------------------------------------------
/** ړ]URLXV
 * this͍wǔ̂͂
 * board:{[hꗗ
 * list:wǔ̈ړ]URL
 */
void __fastcall ABBSMenu::itaIten(ABBSMenu *board, TStringList *list)
{
    if ( ! m_ini ) return ;

    TStringList *sect = new TStringList() ;
    TStringList *key = new TStringList() ;

    AnsiString htmlStr = g_htmlHeader ;
    htmlStr += "ړ]<br><br>" ;

    m_ini->ReadSections( sect ) ;
    int sc = sect->Count ;
    // ׂĂURL`FbN邵
    AnsiString url, newurl, local, newlocal ;
    for (int i=0; i < sc; i++)
    {
        m_ini->ReadSection( sect->Strings[i], key ) ;
        int kc = key->Count ;
        for (int j=0; j < kc; j++)
        {
            url = m_ini->ReadString( sect->Strings[i], key->Strings[j], "" ) ;
            int index = list->IndexOf( url ) ;
            if ( index >= 0 )
            {
                newurl = board->getUrl( sect->Strings[i], key->Strings[j] ) ;
                htmlStr += sect->Strings[i] + "F" + key->Strings[j] + "<br>" ;
                htmlStr += url + "<br>" ;
                if ( ! newurl.IsEmpty() )
                {
                    local = getLocalUrl( sect->Strings[i], key->Strings[j] ) ;
                    newlocal = board->getLocalUrl( sect->Strings[i], key->Strings[j] ) ;
                    if ( ! local.IsEmpty() && ! newlocal.IsEmpty() )
                    {
                        local = ExtractFileDir( g_global.getLogDir() + local ) ;
                        newlocal = ExtractFileDir( g_global.getLogDir() + newlocal ) ;
                        ForceDirectories( ExtractFileDir( newlocal ) ) ;
                        MoveFileEx( local.c_str(), newlocal.c_str(), MOVEFILE_REPLACE_EXISTING ) ;
                        m_ini->WriteString( sect->Strings[i], key->Strings[j], newurl ) ;
                        htmlStr += (AnsiString)"" + newurl + "<br>" ;
                    }
                    else
                    {
                        htmlStr += "ړ]sH<br>" ;
                    }
                    htmlStr += "<br>" ;
                }
            }
        }
    }

    m_ini->UpdateFile() ;
    delete key ;
    delete sect ;


    htmlStr += "</body></html>" ;
    showHTML( htmlStr, "XVڍ" ) ;
}
//---------------------------------------------------------------------------
/** host̒lƂʒuɑ}TListItemԂ
 */
TListItem* __fastcall ABBSMenu::getInsertItem(TListItems *items, const AnsiString &host)
{
    int count = items->Count ;
    if ( count == 0 ) return items->Add() ;
    int low = 0 ;
    int high = count -1 ;
    int index ;
    for (;;)
    {
        if ( low == high )
        {
            index = low ;
            if ( items->Item[index]->SubItems->Strings[2].AnsiCompare(host) <= 0 )
            {
                index ++ ;
            }
            break ;
        }
        index = low + (high -low) / 2 ;
        if ( items->Item[index]->SubItems->Strings[2].AnsiCompare( host ) <= 0 )
        {
            low = index +1 ;
        }
        else
        {
            high = index ;
        }
    }
    return items->Insert( index ) ;
}
//---------------------------------------------------------------------------
/** {^̃hbv_Ej[쐬
 */
void __fastcall ABBSMenu::createItaMenuAll(TPopupMenu *PopupMenu, TNotifyEvent OnClick)
{
    if ( ! m_ini ) return ;

    TStringList *sect = new TStringList() ;
    m_ini->ReadSections( sect ) ;
    int sc = sect->Count ;
    for (int i=0; i<sc; i++) {
        // JeS
        TMenuItem *catItem = new TMenuItem( PopupMenu ) ;
        catItem->Caption = sect->Strings[i] ;
        PopupMenu->Items->Add( catItem ) ;
        createItaMenu( catItem, OnClick, sect->Strings[i] ) ;
    }
    delete sect ;
}
//---------------------------------------------------------------------------
/** {^̃hbv_Ej[쐬
 */
void __fastcall ABBSMenu::createItaMenu(TMenuItem *MenuItem, TNotifyEvent OnClick, const AnsiString &Category)
{
    if ( ! m_ini ) return ;

    TStringList *key = new TStringList() ;
    TStringList *val = new TStringList() ;

    m_ini->ReadSection( Category, key ) ;
    m_ini->ReadSection( Category, val ) ;

    int c = key->Count ;
    for (int j=0; j < c; j++)
    {
        // 
        TMenuItem *NewItem = new TMenuItem( MenuItem ) ;
        NewItem->Caption = key->Strings[j] ;
        NewItem->OnClick = OnClick ;
        MenuItem->Add( NewItem ) ;
    }
    delete key ;
    delete val ;
}
//---------------------------------------------------------------------------

