//---------------------------------------------------------------------------
/** Gg|Cg
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#include <ole2.h> // for OleInitialize(), OleUninitialize()
#pragma hdrstop

#include "bbsmenu.h"
#include "config.h"
#include "misc.h"
USEFORM("UpdateUnit.cpp", UpdateMenuForm);
USEFORM("MainUnit.cpp", MainForm);
USEFORM("OptionUnit.cpp", SettingForm);
USEFORM("SearchUnit.cpp", SearchForm);
//---------------------------------------------------------------------------
void __fastcall applicationInit(void)
{
    gp_config = new AConfig() ; // MainFormɎȂĂ͍
}
//---------------------------------------------------------------------------
/** dN`FbN
 * @return dNĂ邩
 */
bool __fastcall isAlreadyRunning()
{
    TReplaceFlags f ;
    f << rfReplaceAll ; // ׂĒu
    AnsiString objectName = StringReplace( Application->ExeName, "\\", "/", f) ;

    HANDLE hMutex = CreateMutex( NULL, FALSE, objectName.c_str() ) ;
    if ( hMutex == NULL )
    {
        showLastError() ;
        return true ;
    }
    if ( GetLastError() == ERROR_ALREADY_EXISTS )
    {
        //TODO ÑvZXANeBuɂ
        //ShowWindow( hwnd, SW_RESTORE ) ;
        //SetForegroundWindow( GetLastActivePopup( hwnd ) ) ;
        return true ;
    }

    return false ;
}
//---------------------------------------------------------------------------
/** R}hC
 * -b, /b : {[hꗗ̎XVmF
 * {[hꗗ݂Ȃꍇ͎ɂ
 */
void __fastcall comandline(void)
{
    TSysCharSet SwitchChars ;
    SwitchChars << '-' << '/' ;
    bool board = FindCmdLineSwitch( "b", SwitchChars, true ) ;
    if ( board )
    {
        bbsMenuUpdate( true ) ;
    }
    else if ( ! g_allBoard.isExist() )
    {
        // {[hꗗȂ̂Ŏɂ
        bbsMenuUpdate( false, true ) ;
    }
}
//---------------------------------------------------------------------------

/** TCppWebBrowser̂߂COM
 */
class AComInitialize
{
public:
    AComInitialize()
    {
        ::OleInitialize( NULL ) ;
    }
    ~AComInitialize()
    {
        ::OleUninitialize() ;
    }
} ;

/** Gg|Cg
 */
WINAPI WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
{
    if ( isAlreadyRunning() ) return 0 ;

    AComInitialize comInit ;

    try
    {
		applicationInit() ;
		Application->Initialize();
		Application->CreateForm(__classid(TMainForm), &MainForm);
		Application->CreateForm(__classid(TSearchForm), &SearchForm);
		comandline() ;

         Application->Run();
    }
    catch (Exception &exception)
    {
         Application->ShowException(&exception);
    }
    catch (...)
    {
         try
         {
             throw Exception("");
         }
         catch (Exception &exception)
         {
             Application->ShowException(&exception);
         }
    }

    return 0;
}
//---------------------------------------------------------------------------

