//---------------------------------------------------------------------------
/** {[hꗗXV_CAO
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "UpdateUnit.h"
#include "config.h"
#include "bbsmenu.h"
#include "httpsock.h"
#include "misc.h"
#include "MainUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//TUpdateMenuForm *UpdateMenuForm;

#define FILEPATH_DUMPBBSMENU "\\board.html"
//---------------------------------------------------------------------------
/** R[obN
 * 0Ԃ璆f
 */
static int __stdcall boardCallback(const char *str, long lData, int nNum, int nDenom)
{
    ACriticalSection cs ;

    TUpdateMenuForm *form = (TUpdateMenuForm *)lData ;
    if (form == NULL) return 0 ;

    if ( str != NULL )
    {
        form->StatusBar->SimpleText = str ;
    }
    else
    {
        form->ProgressBar->Max = nDenom ;
        form->ProgressBar->Position = nNum ;
    }

    Application->ProcessMessages() ;
    if ( form->isAbort() ) return 1 ;
    
    return 0 ;
}
//---------------------------------------------------------------------------
/** RXgN^
 */
__fastcall TUpdateMenuForm::TUpdateMenuForm(TComponent* Owner)
    : TForm(Owner)
{
    // {[hꗗURLXg
    TStringList *list = new TStringList() ;
    gp_config->readBBSMenuURL( list ) ;
    if ( list->Count > 0 )
    {
         bbsMenuComboBox->Items->AddStrings( list ) ;
         bbsMenuComboBox->ItemIndex = 0 ;
    }
    delete list ;

    // ^CX^v
    m_timestamp = gp_config->getMenuTimestamp() ;
}
//---------------------------------------------------------------------------
/** f{^
 */
void __fastcall TUpdateMenuForm::abortButtonClick(TObject *Sender)
{
    abortButton->Enabled = false ;
    abort() ;
}
//---------------------------------------------------------------------------
/** {^
 */
void __fastcall TUpdateMenuForm::closeButtonClick(TObject *Sender)
{
    Close() ;
}
//---------------------------------------------------------------------------
/** 擾HTMLXV
 * @param ms HTMLǂݍTmemoryStream
 */
void __fastcall TUpdateMenuForm::updateIni(TMemoryStream *ms)
{
    ms->Position = 0 ;

    // {[hꗗXV
    ms->Position = ms->Size ;
    ms->Write( "\0", 1 ) ;
    g_allBoard.html2ini( (char*)ms->Memory ) ;
    g_allBoard.makeTree() ;


    // wǔ̈ړ]`FbN
    TStringList *allList = new TStringList() ;
    TStringList *subList = new TStringList() ;
    g_allBoard.getUrlList( allList ) ;
    g_subscribeBoard.getUrlList( subList ) ;

    // ݂̂
    int c = subList->Count ;
    for (int i = c -1; i >= 0; i--)
    {
        int index = allList->IndexOf( subList->Strings[i] ) ;
        if ( index >= 0 ) subList->Delete( i ) ;
    }
    delete allList ;

    // ĉ͈ړ]
    if ( subList->Count > 0 )
    {
        // ړ]̐ݒXV
        g_subscribeBoard.itaIten( &g_allBoard, subList ) ;
    }
    delete subList ;
}
//---------------------------------------------------------------------------
/** {[hꗗXV
 * @param silent bZ[WoȂ
 */
void __fastcall TUpdateMenuForm::update(bool silent)
{
    m_state = updateStateUpdating ;

    AnsiString targetURL = bbsMenuComboBox->Text ;
    AnsiString timestamp = "" ;

    if ( (rebuildCheckBox->Checked) || (! g_allBoard.isExist()) )
    {
        ; // XV̗Lɂ炸ꗗ擾čXV
    }
    else
    {
        if ( bbsMenuComboBox->Items->Strings[0] == targetURL )
        {
            // ^CX^vLȂ̂͑OXV̂̂
            timestamp = m_timestamp ;
        }
    }

    TMemoryStream *ms = new TMemoryStream() ;
    int ret ;
    {   /* <- http ̎ǗXR[v */
        AHttpSock http ;
        http.setCallback( (long)this, boardCallback ) ;
        ret = http.download( targetURL.c_str(), ms, timestamp ) ;
    }

    if ( ret == 0 )
    {
        // 擾
        ms->Position = 0 ;
        ms->SaveToFile( g_global.getLogDir() + FILEPATH_DUMPBBSMENU ) ;
        updateIni( ms ) ;
    }
    else if ( ! silent ) // silent  true ̏ꍇ̓bZ[WoȂ
    {
        if ( ret == 1 )
        {
            MessageBox( Handle, "XVĂ܂B", Caption.c_str(), MB_OK | MB_ICONINFORMATION ) ;
        }
        else
        {
            MessageBox( Handle, "{[hꗗ̎擾ɎsB", Caption.c_str(), MB_OK | MB_ICONEXCLAMATION ) ;
        }
    }
    delete ms ;


    // ݒۑ

    // Ǘ
    TStringList *list = new TStringList() ;
    gp_config->readBBSMenuURL( list ) ;
    int index = list->IndexOf( targetURL ) ;
    if ( index >= 0 )
    {
        list->Delete( index ) ;
        // ɗL폜Ăǉ
    }
    list->Insert( 0, targetURL ) ;
    gp_config->writeBBSMenuURL( list ) ;
    delete list ;

    // ^CX^v
    gp_config->setMenuTimestamp( timestamp ) ;
}
//---------------------------------------------------------------------------
void __fastcall TUpdateMenuForm::updateButtonClick(TObject *Sender)
{
    bbsMenuComboBox->Enabled = false ;
    rebuildCheckBox->Enabled = false ;

    updateButton->Enabled = false ;
    localButton->Enabled = false ;
    abortButton->Enabled = true ;

    update() ;
    Close() ;
}
//---------------------------------------------------------------------------
void __fastcall TUpdateMenuForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
    abort() ;
}
//---------------------------------------------------------------------------
/** {[hꗗURLR{{bNXύX
 */
void __fastcall TUpdateMenuForm::bbsMenuComboBoxChange(TObject *Sender)
{
    bool b;
    if ( bbsMenuComboBox->Items->Strings[0] != bbsMenuComboBox->Text )
    {
        b = true ; // OURLȊO͈ꉞč\zɐݒ
    }
    else
    {
        b = false ;
    }

    rebuildCheckBox->Checked = b ;
}
//---------------------------------------------------------------------------
/** [Jt@CXV
 */
void __fastcall TUpdateMenuForm::localButtonClick(TObject *Sender)
{
    TOpenDialog *OpenDialog = new TOpenDialog( this ) ;
    OpenDialog->Options << ofHideReadOnly << ofEnableSizing ;
    OpenDialog->Filter = "HTML files|*.HTM;*.HTML|All files(*.*)|*.*" ;
    OpenDialog->Title = "{[hꗗHTML" ;

    bool close = false ;
    if ( OpenDialog->Execute() )
    {
        TMemoryStream *ms = new TMemoryStream() ;
        updateIni( ms ) ;
        delete ms ;
        close = true ;
    }

    delete OpenDialog ;

    if ( close ) Close() ;
}
//---------------------------------------------------------------------------

