//---------------------------------------------------------------------------
/** Xbh/O_CAO
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef SearchUnitH
#define SearchUnitH
//---------------------------------------------------------------------------
#include "regexp.h"

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
/**  */
typedef enum
{
    searchStateSearching,
    searchStateAbort,
} SearchState ;

class TSearchForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TLabel *keyLabel;
    TEdit *keyEdit;
    TRadioGroup *searchTypeRadioGroup;
    TButton *startButton;
    TButton *cancelButton;
    TProgressBar *ProgressBar;
    TLabel *copyrightLabel;
    TButton *dialogButton;
    TCheckBox *nocaseCheckBox;
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall cancelButtonClick(TObject *Sender);
    void __fastcall startButtonClick(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
    void __fastcall keyEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
    void __fastcall dialogButtonClick(TObject *Sender);
    void __fastcall FormShow(TObject *Sender);
private:	// [U[錾
    void __fastcall setEnabled(bool enabled) ;
    ARegExp *m_regexp ;
    SearchState m_state ;
public:		// [U[錾
    __fastcall TSearchForm(TComponent* Owner);
    void __fastcall init(void) ;
    /** 𒆎~
     */
    void __fastcall abort(void)
    {
        m_state = searchStateAbort ;
    }
    /** LZmF
     * @return trueȂLZ
     */
    bool __fastcall isAbort(void)
    {
        return (m_state != searchStateSearching) ;
    }
};
//---------------------------------------------------------------------------
extern PACKAGE TSearchForm *SearchForm;
//---------------------------------------------------------------------------
#endif
