//---------------------------------------------------------------------------
/** Xbh/O_CAO
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "SearchUnit.h"
#include "MainUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TSearchForm *SearchForm;

//---------------------------------------------------------------------------
/** R[obN
 * 0Ԃ璆f
 */
static int __stdcall searchcallback(const char *str, long lData, int nNum, int nDenom)
{
    ACriticalSection cs ;

    if ( str == NULL )
    {
        SearchForm->ProgressBar->Max = nDenom ;
        SearchForm->ProgressBar->Position = nNum ;
    }

    Application->ProcessMessages() ;
    if ( SearchForm->isAbort() ) return 1 ;

    return 0 ;
}
//---------------------------------------------------------------------------
/** RXgN^
 */
__fastcall TSearchForm::TSearchForm(TComponent* Owner)
    : TForm(Owner)
{
    m_regexp = NULL ;
}
//---------------------------------------------------------------------------
/** tH[
 */
void __fastcall TSearchForm::FormClose(TObject *Sender,
      TCloseAction &Action)
{
    abort() ;
}
//---------------------------------------------------------------------------
/** LZ{^NbN
 */
void __fastcall TSearchForm::cancelButtonClick(TObject *Sender)
{
    abort() ;
    Close() ;
}
//---------------------------------------------------------------------------
/** Jn{^NbN
 */
void __fastcall TSearchForm::startButtonClick(TObject *Sender)
{
    setEnabled( false ) ;

    AnsiString key = keyEdit->Text ;
    if ( ! m_regexp->open( key.c_str(), ! nocaseCheckBox->Checked ) )
    {
        init() ;
        return ;
    }
    
    switch ( searchTypeRadioGroup->ItemIndex )
    {
        case 0: MainForm->threadSearch0( m_regexp, searchcallback, (long)this ) ;
            break ;
        case 1: MainForm->threadSearch1( m_regexp, searchcallback, (long)this ) ;
            break ;
        case 2: MainForm->threadSearch2( m_regexp, searchcallback, (long)this ) ;
            break ;
        case 3: MainForm->threadSearch3( m_regexp, searchcallback, (long)this ) ;
            break ;
    }

    m_regexp->close() ;
    Close() ;
}
//---------------------------------------------------------------------------
/** Enabled܂Ƃ߂ăZbg
 * @param enabled
 */
void __fastcall TSearchForm::setEnabled(bool enabled)
{
    startButton->Enabled = enabled ;
    keyEdit->Enabled = enabled ;
    nocaseCheckBox->Enabled = enabled ;
    dialogButton->Enabled = enabled ;
    searchTypeRadioGroup->Enabled = enabled ;
}
//---------------------------------------------------------------------------
/** tH[̏
 * JтɌĂяo
 * [h͏Ȃ
 */
void __fastcall TSearchForm::init(void)
{
    m_state = searchStateSearching ;
    SearchForm->ProgressBar->Position = 0 ;

    setEnabled( true ) ;

    if ( m_regexp == NULL )
    {
        m_regexp = new ARegExp ;
        copyrightLabel->Caption = m_regexp->getVerString() ;
    }
}
//---------------------------------------------------------------------------
/** tH[jꂽ
 */
void __fastcall TSearchForm::FormDestroy(TObject *Sender)
{
    if ( m_regexp ) delete m_regexp ;
}
//---------------------------------------------------------------------------
/** [hENTERŌJn
 */
void __fastcall TSearchForm::keyEditKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift)
{
    if ( Key == VK_RETURN )
    {
        startButtonClick( NULL ) ;
    }
}
//---------------------------------------------------------------------------
/** ܂̐ݒ_CAO\
 */
void __fastcall TSearchForm::dialogButtonClick(TObject *Sender)
{
    m_regexp->showOptionDialog( SearchForm->Handle ) ;
}
//---------------------------------------------------------------------------
void __fastcall TSearchForm::FormShow(TObject *Sender)
{
    keyEdit->SetFocus() ;
}
//---------------------------------------------------------------------------

