//---------------------------------------------------------------------------
/** CtH[
 */
/*
 * Copyright (c) 2004, 2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#ifndef MainUnitH
#define MainUnitH
//---------------------------------------------------------------------------
#include "regexp.h"
#include "subject.h"
#include "tabman.h"

#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>
#include <ToolWin.hpp>
#include <OleCtrls.hpp>
#include <Menus.hpp>
#include <Buttons.hpp>
#include "SHDocVw_OCX.h"
//---------------------------------------------------------------------------
class TMainForm : public TForm
{
__published:	// IDE Ǘ̃R|[lg
    TPanel *favoritePanel;
    TPanel *SidebarPanel;
    TPanel *MainPanel;
    TSplitter *YSplitter;
    TPanel *SubjectPanel;
    TPanel *BrowserPanel;
    TSplitter *XSplitter;
    TPageControl *sidebarPageControl;
    TTabSheet *BBSTabSheet;
    TTabSheet *subscribeTabSheet;
    TListView *SubjectListView;
    TTreeView *BBSTreeView;
    TTreeView *subscribeTreeView;
    TPopupMenu *bbsAllPM;
    TMenuItem *bbsAllSubscribeMI;
    TMenuItem *bbsAllN1MI;
    TMenuItem *bbsAllURLCopyMI;
    TMenuItem *bbsAllUnsubscribeMI;
    TPopupMenu *subscribePM;
    TMenuItem *subscribeUnsubscribeMI;
    TMenuItem *subscribeN2MI;
    TMenuItem *subscribeN1MI;
    TMenuItem *subscribeURLCopyMI;
    TMenuItem *subscribeOpenBrowserMI;
    TPopupMenu *threadPM;
    TPopupMenu *optionPM;
    TMenuItem *optionOptionMI;
    TMenuItem *optionN2MI;
    TMenuItem *optionBBSMenuUpdateMI;
    TMenuItem *threadN1MI;
    TMenuItem *threadDeleteLogMI;
    TMenuItem *threadOpenBrowserMI;
    TMenuItem *threadTitleCopyMI;
    TMenuItem *threadURLCopyMI;
    TMenuItem *bbsAllOpenBrowserMI;
    TPopupMenu *iePM;
    TMenuItem *ieBookmarkMI;
    TPanel *subjectToolPanel;
    TLabel *BBSNameLabel;
    TToolBar *FavoriteToolBar;
    TPopupMenu *bbsButtonDeletePM;
    TToolButton *favoriteToolButton;
    TMenuItem *bbsButtonDeleteMI;
    TMenuItem *subscribeAddFavoriteButtonMI;
    TComboBox *subjectShowTypeCB;
    TPopupMenu *tabPM;
    TMenuItem *tabCloseMI;
    TMenuItem *tabURLCopyMI;
    TMenuItem *tabOpenBrowserMI;
    TMenuItem *tabCloseOtherMI;
    TMenuItem *threadNewTabMI;
    TMenuItem *tabN2MI;
    TMenuItem *tabHistoryMI;
    TMenuItem *tabHistory1MI;
    TMenuItem *tabHistory2MI;
    TMenuItem *tabHistory3MI;
    TMenuItem *tabHistory4MI;
    TMenuItem *tabHistory5MI;
    TMenuItem *tabTitleCopyMI;
    TMenuItem *tabControlMI;
    TMenuItem *tabDeleteLogMI;
    TToolBar *subjectToolBar;
    TToolButton *subjectReloadToolButton;
    TToolButton *subjectS1ToolButton;
    TToolButton *subjectFindToolButton;
    TToolButton *subjectS2ToolButton;
    TToolButton *subjectOptionToolButton;
    TStatusBar *StatusBar;
    TMenuItem *optionN1MI;
    TMenuItem *optionSidebarShowMI;
    TCppWebBrowser *CppWebBrowser;
    TPageControl *tabPageControl;
    TMenuItem *tabN1MI;
    TMenuItem *tabN3MI;
    TPanel *expandPanel;
    TSpeedButton *expandSpeedButton;
    TMenuItem *optionN3MI;
    TMenuItem *optionAboutMI;
    TMenuItem *optionSweepMI;
    TMenuItem *optionLogSweeperMI;
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall bbsAllSubscribeMIClick(TObject *Sender);
    void __fastcall bbsAllUnsubscribeMIClick(TObject *Sender);
    void __fastcall bbsAllURLCopyMIClick(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
    void __fastcall subscribeTreeViewChange(TObject *Sender,
          TTreeNode *Node);
    void __fastcall YSplitterMoved(TObject *Sender);
    void __fastcall XSplitterMoved(TObject *Sender);
    void __fastcall optionBBSMenuUpdateMIClick(TObject *Sender);
    void __fastcall threadPMPopup(TObject *Sender);
    void __fastcall threadDeleteLogMIClick(TObject *Sender);
    void __fastcall threadURLCopyMIClick(TObject *Sender);
    void __fastcall threadTitleCopyMIClick(TObject *Sender);
    void __fastcall threadOpenBrowserMIClick(TObject *Sender);
    void __fastcall bbsAllOpenBrowserMIClick(TObject *Sender);
    void __fastcall ieBookmarkMIClick(TObject *Sender);
    void __fastcall delPop(TObject *Sender);
    void __fastcall favoriteToolButtonClick(TObject *Sender);
    void __fastcall favoriteToolButtonMouseUp(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
    void __fastcall bbsButtonDeleteMIClick(TObject *Sender);
    void __fastcall subscribeAddFavoriteButtonMIClick(TObject *Sender);
    void __fastcall BBSNameLabelMouseUp(TObject *Sender,
          TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall FavoriteToolBarResize(TObject *Sender);
    void __fastcall bbsAllPMPopup(TObject *Sender);
    void __fastcall subscribeTreeViewContextPopup(TObject *Sender,
          TPoint &MousePos, bool &Handled);
    void __fastcall subjectShowTypeCBChange(TObject *Sender);
    void __fastcall SubjectListViewData(TObject *Sender, TListItem *Item);
    void __fastcall SubjectListViewColumnClick(TObject *Sender,
          TListColumn *Column);
    void __fastcall tabPageControlChange(TObject *Sender);
    void __fastcall tabCloseMIClick(TObject *Sender);
    void __fastcall tabPageControlMouseDown(TObject *Sender, TMouseButton Button,
          TShiftState Shift, int X, int Y);
    void __fastcall tabCloseOtherMIClick(TObject *Sender);
    void __fastcall tabURLCopyMIClick(TObject *Sender);
    void __fastcall tabOpenBrowserMIClick(TObject *Sender);
    void __fastcall tabPageControlEnter(TObject *Sender);
    void __fastcall optionOptionMIClick(TObject *Sender);
    void __fastcall tabPMPopup(TObject *Sender);
    void __fastcall tabHistory1MIClick(TObject *Sender);
        void __fastcall tabTitleCopyMIClick(TObject *Sender);
    void __fastcall SubjectListViewCustomDrawItem(TCustomListView *Sender,
          TListItem *Item, TCustomDrawState State, bool &DefaultDraw);
    void __fastcall FormActivate(TObject *Sender);
    void __fastcall tabDeleteLogMIClick(TObject *Sender);
    void __fastcall subjectReloadToolButtonClick(TObject *Sender);
    void __fastcall subjectFindToolButtonClick(TObject *Sender);
    void __fastcall optionSidebarShowMIClick(TObject *Sender);
    void __fastcall BBSTreeViewCustomDrawItem(TCustomTreeView *Sender,
          TTreeNode *Node, TCustomDrawState State, bool &DefaultDraw);
    void __fastcall expandSpeedButtonClick(TObject *Sender);
    void __fastcall optionAboutMIClick(TObject *Sender);
    void __fastcall optionLogSweeperMIClick(TObject *Sender);
private:	// [U[錾
    AnsiString __fastcall getThreadURL(void) ;
    void __fastcall bbsChange(const AnsiString &category, const AnsiString &ita) ;
    void __fastcall bbsMenuClick(TObject *Sender) ;
    void __fastcall resPopup(const AnsiString &str) ;
    void __fastcall openThread(OpenThreads flag) ;
    bool __fastcall reloadSubject(void) ;
    TTreeNode *m_selectedNode ; // {[hc[̉ENbNIm[h
    TTreeNode *m_bbsNode ; // Jgm[h
    int m_sidebarWidth ; // yCFTCho[̕ێ
    int m_subjectHeight ; // yCFuEUJƂ̃Xbhꗗ̍ێ
    TPopupMenu *m_bbsDownPM ; // {^̃v_Ej[
    TToolButton *m_bbsButton ; // Iꂽ{^
    int m_lockSubject ;
public:		// [U[錾
    __fastcall TMainForm(TComponent* Owner);
	void __fastcall openThreadInNewTab(const AnsiString &local, const AnsiString &datname, const AnsiString &title, int midoku, const AnsiString &anc) ;
	void __fastcall threadSearch0(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData) ;
	void __fastcall threadSearch1(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData) ;
	void __fastcall threadSearch2(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData) ;
	void __fastcall threadSearch3(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData) ;
    ASubject subject ; // Xꗗ
    void __fastcall SidebarShowToggle(void) ;
    void __fastcall SidebarShow(bool show) ;
    void __fastcall SubjectExpandToggle(void) ;
    void __fastcall SubjectExpand(bool expand) ;
    void __fastcall OnOpenThreadInActiveTab(TObject *Sender) ;
    void __fastcall OnOpenThreadInNewTab(TObject *Sender) ;
};
//---------------------------------------------------------------------------
extern PACKAGE TMainForm *MainForm;
//---------------------------------------------------------------------------
#endif
