//---------------------------------------------------------------------------
/** CtH[
 */
/*
 * Copyright (c) 2002-2005 shimitei
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "MainUnit.h"
#include "about.h"
#include "bbsmenu.h"
#include "brdbtn.h"
#include "config.h"
#include "logsweep.h"
#include "misc.h"
#include "skin.h"
#include "UpdateUnit.h"
#include "SearchUnit.h"
#include "OptionUnit.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "SHDocVw_OCX"
#pragma resource "*.dfm"
TMainForm *MainForm;

/** Xbhi */
ThreadState threadTypeTbl[] =
{
    threadSmart,    // Xbh
    threadAll,      // ׂẴXbh
    threadLogExist, // ÔXbh
    threadNoLog,    // ÔȂXbh
    threadUnread,   // ǃXbh
    threadNew,      // VKXbh
} ;

//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
/** tH[̏
 */
void __fastcall TMainForm::FormCreate(TObject *Sender)
{
    // uEU^ȕ
    g_tabMan.init( tabPageControl ) ;

    // Ŝ̐ݒ
    AnsiString ininame ;
    ininame = g_global.getExeDir() + FILEPATH_CONFIG_INI ;
    gp_config->init( ininame ) ;
    gp_config->loadGlobal() ;
    g_useragent = getUserAgent() ;


    // tH[֌W
    //TODO ֐ɂ܂Ƃ߂
    gp_config->loadListViewColumn() ;
    FORM_INI form_ini;
    gp_config->loadFormInfo( &form_ini ) ;

    Top = form_ini.top ;
    Left = form_ini.left ;
    Width = form_ini.width ;
    Height = form_ini.height ;

    //TODO ViewStyle 
    m_sidebarWidth = form_ini.sidebarWidth ;
    SidebarPanel->Width = m_sidebarWidth ;
    m_subjectHeight = form_ini.subjectHeight ;
    SubjectPanel->Height = m_subjectHeight ;
    SidebarShow( form_ini.sidebarVisible ) ;
    SubjectExpand( true ) ;

    
    // {[hꗗ
    ininame = g_global.getExeDir() + FILEPATH_BOARD_INI ;
    g_allBoard.init( BBSTreeView, ininame ) ;
    g_allBoard.makeTree() ;

    // Cɓ
    ininame = g_global.getExeDir() + FILEPATH_SUBSCRIBE_INI ;
    g_subscribeBoard.init( subscribeTreeView, ininame ) ;
    g_subscribeBoard.makeTree() ;
    // ΂Cɓc[ANeBu
    if ( subscribeTreeView->Items->Count > 1 )
    {
        sidebarPageControl->ActivePage = subscribeTabSheet ;
    }

    // {^
    g_boardButton.init( FavoriteToolBar, g_global.getExeDir() + FILEPATH_BOARDBUTTON_INI ) ;
    if ( FavoriteToolBar->ButtonCount == 1 ) favoritePanel->Height = 0 ;

    // HTMLXLǂݍ
    g_skin.load() ;

    /* AvANeBuɂƃXgr[ɃtH[JXĂ܂H */
    // AvANeBuɂȂAIER|ANeBuɂ
    Application->OnActivate = MainForm->OnActivate ;

    // ANeBułȂȂ|bvAbv
    Application->OnDeactivate = delPop ;

    // |bvAbv
    g_popHint = new THintWindow( this ) ;
    g_popHint->Canvas->Font->Color = clInfoText ;
    g_popHint->Canvas->Font->Name = "lr oSVbN" ;
    g_popHint->Canvas->Font->Size = 9 ;
    g_popHint->Color = clInfoBk ;
    // |bvAbv̑傫EvZ
    TRect r1, r2 ;
    AnsiString mes = "Ă悵I\nI}Gi[" ;
    r2 = g_popHint->CalcHintRect( Screen->Width, mes, NULL ) ;
    mes = "i ÉEj";
    r1 = g_popHint->CalcHintRect( Screen->Width, mes, NULL ) ;
    int strh = (r2.bottom - r2.top) - (r1.bottom - r1.top) ;
    int pad = r1.bottom - r1.top - strh ;
    g_hintMaxRow = (Screen->Height -pad) / strh ;

    // ŏ̈ڂ͊ĴɎԂ̂ŁA炩ߊJĂ
    CppWebBrowser->Navigate( WideString( "about:blank" ).c_bstr() ) ;
}
//---------------------------------------------------------------------------
/** wǂI
 */
void __fastcall TMainForm::bbsAllSubscribeMIClick(TObject *Sender)
{
    TTreeNode *node = m_selectedNode ;
    AnsiString cat = node->Parent->Text ;
    AnsiString ita = node->Text ;
    g_subscribeBoard.subscribe( cat, ita, g_allBoard.getUrl( cat, ita ) ) ;
}
//---------------------------------------------------------------------------
/** wǂ̎I
 */
void __fastcall TMainForm::bbsAllUnsubscribeMIClick(TObject *Sender)
{
    TTreeNode *node = m_selectedNode ;
    AnsiString cat = node->Parent->Text ;
    AnsiString ita = node->Text ;
    g_subscribeBoard.unsubscribe( cat, ita ) ;
}
//---------------------------------------------------------------------------
/** URLRs[
 */
void __fastcall TMainForm::bbsAllURLCopyMIClick(TObject *Sender)
{
    TTreeNode *node = m_selectedNode ;
    AnsiString cat = node->Parent->Text ;
    AnsiString ita = node->Text ;
    AnsiString url = g_allBoard.getUrl( cat, ita ) ;

    AClipboard cb ;
    cb.SetTextBuf( url.c_str() ) ;
}
//---------------------------------------------------------------------------
/** I
 */
void __fastcall TMainForm::FormDestroy(TObject *Sender)
{
    // tH[̕ۑ
    FORM_INI form_ini ;
    form_ini.top = Top ;
    form_ini.left = Left ;
    form_ini.width = Width ;
    form_ini.height = Height ;

    //TODO ViewStyle ̎

    form_ini.sidebarVisible = SidebarPanel->Visible ;
    form_ini.sidebarWidth = m_sidebarWidth ;
    form_ini.subjectHeight = m_subjectHeight ;

    gp_config->saveFormInfo( &form_ini, false ) ;
    gp_config->saveListViewColumn() ;
}
//---------------------------------------------------------------------------
/** TCho[̕\/\ؑ
 */
void __fastcall TMainForm::SidebarShowToggle(void)
{
    SidebarPanel->Visible = ! SidebarPanel->Visible ;
}
//---------------------------------------------------------------------------
/** TCho[̕\/\ݒ
 * @param show \/Ȃ
 */
void __fastcall TMainForm::SidebarShow(bool show)
{
    SidebarPanel->Visible = show ;
}
//---------------------------------------------------------------------------
/** Xbhꗗ̊g
 */
void __fastcall TMainForm::SubjectExpandToggle(void)
{
    SubjectExpand( SubjectPanel->Align == alTop ) ;
}
//---------------------------------------------------------------------------
/** Xbhꗗ̊g
 * @param expand g傷/Ȃ
 */
void __fastcall TMainForm::SubjectExpand(bool expand)
{
    if ( expand )
    {
        // Xbhꗗg
        if ( SubjectPanel->Align == alClient ) return ;
        BrowserPanel->Align = alBottom ;
        BrowserPanel->Height = 1 ;
        XSplitter->Align = alBottom ;
        XSplitter->Top = BrowserPanel->Top -1 ;
        SubjectPanel->Align = alClient ;
    }
    else
    {
        // ɖ߂
        SubjectPanel->Align = alTop ;
        XSplitter->Align = alTop ;
        XSplitter->Top = SubjectPanel->Top + SubjectPanel->Height +1 ;
        SubjectPanel->Height = m_subjectHeight ;
        BrowserPanel->Align = alClient ;
    }
}
//---------------------------------------------------------------------------
/** \ύX
 */
void __fastcall TMainForm::bbsChange(const AnsiString &category, const AnsiString &itaname)
{
    if ( m_lockSubject != 0 ) return ;
    ATemporarilyCursor hourGlass ;

    subjectShowTypeCB->ItemIndex = 0 ;

    AnsiString local = g_global.getLogDir() + "\\" ;
    local += g_subscribeBoard.getLocalUrl( category, itaname ) ;
    BBSNameLabel->Caption = category +"F"+ itaname ;
    BBSNameLabel->Update() ;
    SubjectExpand( true ) ;

    // g_logDir + "\\pc.2ch.net\\tech\\subject.ini"
    subject.target( local + FILENAME_SUBJECT_INI ) ;
    if ( ! reloadSubject() )
    {
        subject.viewThreadList( SubjectListView, threadTypeTbl[subjectShowTypeCB->ItemIndex] ) ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::subscribeTreeViewChange(TObject *Sender,
      TTreeNode *Node)
{
//wǃc[̑Im[hύX
    if (Node == NULL/*IĂȂ*/ || Node->Level != 2/*[ł͂Ȃ*/)
        return ;

    m_bbsNode = Node ;
    bbsChange( Node->Parent->Text, Node->Text ) ;
}
//---------------------------------------------------------------------------
/** YXvb^hbO
 */
void __fastcall TMainForm::YSplitterMoved(TObject *Sender)
{
    // J߂ƏÎ߂ɕۑ
    m_sidebarWidth = SidebarPanel->Width ;
}
//---------------------------------------------------------------------------
/** XXvb^hbO
 */
void __fastcall TMainForm::XSplitterMoved(TObject *Sender)
{
    // J߂ƏÎ߂ɕۑ
    m_subjectHeight = SubjectPanel->Height ;
}
//---------------------------------------------------------------------------
/** {[hꗗXVI
 */
void __fastcall TMainForm::optionBBSMenuUpdateMIClick(TObject *Sender)
{
    bbsMenuUpdate() ;
}
//---------------------------------------------------------------------------
/** Xbhꗗ̃|bvAbvj[̊ej[̗Lݒ
 */
void __fastcall TMainForm::threadPMPopup(TObject *Sender)
{
    bool b = false ; // IĂXbh
    bool c = false ; // IĂXbh͂ЂƂ
    TListItem *item = SubjectListView->Selected ;
    if ( item != NULL )
    {
        /* IĂ */
        b = true ;
        c = (SubjectListView->SelCount == 1) ;
    }
    threadNewTabMI->Enabled = c ;
    threadURLCopyMI->Enabled = c ;
    threadTitleCopyMI->Enabled = c ;
    threadOpenBrowserMI->Enabled = c ;
    threadDeleteLogMI->Enabled = b ;
}
//---------------------------------------------------------------------------
/** O폜
 */
void __fastcall TMainForm::threadDeleteLogMIClick(TObject *Sender)
{
    ATemporarilyCursor hourGlass ;

    TItemStates selected = TItemStates() << isSelected ;
    TListItem *item = SubjectListView->Selected ;
    while ( item )
    {
        subject.deleteLogList( item->Index, item->SubItems->Strings[indexDatname], false ) ;
        SubjectListView->UpdateItems( item->Index, item->Index ) ;
        //SubjectListView->Invalidate() ;
        item = SubjectListView->GetNextItem( item, sdAll, selected ) ;
    }
    subject.flushIni() ;
}
//---------------------------------------------------------------------------
AnsiString __fastcall TMainForm::getThreadURL(void)
{
//  http://pc.2ch.net/win/
// Xbh http://pc.2ch.net/test/read.cgi/win/1009107036/
    TListItem *item = SubjectListView->Selected ;
    if (item == NULL) return "" ;
    AnsiString host, path, datname ;
    parseLocalUrl(subject.getLogDir(), host, path) ;
// Host: "pc.2ch.net"
// Path: "/win/"
    datname = SubjectListView->Selected->SubItems->Strings[indexDatname] ;
    datname = ChangeFileExt( datname, "" ) ;
    return (AnsiString)"http://" + host + "/test/read.cgi" + path + datname + "/" ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::threadURLCopyMIClick(TObject *Sender)
{
//XbhURLRs[
    AnsiString url = getThreadURL() ;

    AClipboard cb ;
    cb.SetTextBuf( url.c_str() ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::threadTitleCopyMIClick(TObject *Sender)
{
//Xbh̃^CgRs[
    AClipboard cb ;
    cb.SetTextBuf( SubjectListView->Selected->SubItems->Strings[indexTitle].c_str() ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::threadOpenBrowserMIClick(TObject *Sender)
{
//XbhuEUŊJ
    AnsiString url = getThreadURL() ;
	ShellExecute( Handle, "open", url.c_str(), NULL, NULL, SW_SHOW ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OnOpenThreadInActiveTab(TObject *Sender)
{
//ANeBu^uŊJ
    if ( SubjectListView->SelCount != 1 ) return ;

    openThread( inActiveTab ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::OnOpenThreadInNewTab(TObject *Sender)
{
//V^uŊJ
    if ( SubjectListView->SelCount != 1 ) return ;

    openThread( inNewTab ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::openThread(OpenThreads flag)
{
//XbhJ
    ATemporarilyCursor hourGlass ;

    TListItem *item = SubjectListView->Selected ;
    AnsiString datname = item->SubItems->Strings[ indexDatname ] ;
    AnsiString title = item->SubItems->Strings[ indexTitle ] ;

    bool update = subject.ifUnreadDoReload( datname ) ;
    if ( update )
    {
        subject.updateThreadListViewData( item ) ;
    }

    //TODO ViewStyleΉ
    SubjectExpand( false ) ;

    int unread = subject.getUnreadPoint( datname ) ;
    subject.setUnreadPointList( item->Index, datname, -1 ) ;
    SubjectListView->UpdateItems( item->Index, item->Index ) ;
    //SubjectListView->Invalidate() ;

    g_tabMan.open( subject.getLogDir(), datname, title, flag, unread, "midoku" ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::openThreadInNewTab(const AnsiString &local, const AnsiString &datname, const AnsiString &title, int midoku, const AnsiString &anc)
{
//V^uŊJ
    g_tabMan.open( local, datname, title, inNewTab, midoku, anc ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::bbsAllOpenBrowserMIClick(TObject *Sender)
{
//WuEUŊJ
    TTreeNode *node = m_selectedNode ;
    AnsiString cat = node->Parent->Text ;
    AnsiString ita = node->Text ;
    AnsiString url = g_allBoard.getUrl( cat, ita ) ;
	ShellExecute( Handle, "open", url.c_str(), NULL, NULL, SW_SHOW ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::ieBookmarkMIClick(TObject *Sender)
{
//܂œǂ
    g_tabMan.bookmark() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::delPop(TObject *Sender)
{
//|bvAbv
	if ( g_popHint != NULL )
    {
		g_popHint->ReleaseHandle() ;
	}
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::favoriteToolButtonClick(TObject *Sender)
{
// {^NbN
// hbv_EKvł΍쐬ĕ\

    TToolButton *pButton = (TToolButton *)Sender ;
    m_bbsButton = pButton ;
    AnsiString n = pButton->Caption ;
    AnsiString f = n.SubString( 1, 2 ) ;

    // c[
    if ( f == "" )
    {
        // ŏ
    }
    else if ( f == "" )
    {
        // JeS
    }
    else
    {
        pButton->Down = true ;
        bbsMenuClick( NULL ) ;
        return ;
    }

    // hbv_E
    if ( m_bbsDownPM ) delete m_bbsDownPM ;
    m_bbsDownPM = new TPopupMenu( this ) ;
    m_bbsDownPM->AutoHotkeys = maManual ;
    if ( f == "" )
    {
        // ŏ
        g_subscribeBoard.createItaMenuAll( m_bbsDownPM, bbsMenuClick ) ;
    }
    else if ( f == "" )
    {
        // JeS
        g_subscribeBoard.createItaMenu( m_bbsDownPM->Items, bbsMenuClick, n.c_str() +2 ) ;
    }

    pButton->DropdownMenu = m_bbsDownPM ;
    pButton->CheckMenuDropdown() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::favoriteToolButtonMouseUp(TObject *Sender, TMouseButton Button,
      TShiftState Shift, int X, int Y)
{
//{^̉ENbNj[\
    if ( Button == mbRight )
    {
        POINT p ;
        GetCursorPos( &p ) ;
        m_bbsButton = (TToolButton *)Sender ;
        bbsButtonDeletePM->Popup( p.x, p.y ) ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::bbsButtonDeleteMIClick(TObject *Sender)
{
//{^̍폜I
    g_boardButton.deleteBoard( m_bbsButton->Caption ) ;

    if ( FavoriteToolBar->ButtonCount == 1 ) favoritePanel->Height = 20 ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::bbsMenuClick(TObject *Sender)
{
//{^̔NbN

    AnsiString n = m_bbsButton->Caption ;
    if ( Sender == NULL )
    {
        // 
        TTreeNode *topnode = subscribeTreeView->Items->Item[0] ;
        int c = topnode->Count ;
        for (int i=0; i < c; i++)
        {
            TTreeNode *catnode = topnode->Item[i] ;
            int cc = catnode->Count ;
            for (int j=0; j < cc; j++)
            {
                TTreeNode *itanode = catnode->Item[j] ;
                if ( itanode->Text == n )
                {
                    subscribeTreeView->Selected = itanode ;
                    return ;
                }
            }
        }
        return ;
    }

    AnsiString f = n.SubString( 1, 2 ) ;
    TMenuItem *item = (TMenuItem *)Sender ;
    AnsiString Category, BoardName ;
    if ( f == "" )
    {
        // ŏ
        Category = item->Parent->Caption ;
        BoardName = item->Caption ;
    }
    else if ( f == "" )
    {
        // JeS
        Category = n.c_str() +2 ;
        BoardName = item->Caption ;
    }
    TTreeNode *topnode = subscribeTreeView->Items->Item[0] ;
    int c = topnode->Count ;
    for (int i=0; i < c; i++)
    {
        TTreeNode *catnode = topnode->Item[i] ;
        if ( catnode->Text == Category )
        {
            int cc = catnode->Count ;
            for (int j=0; j < cc; j++)
            {
                TTreeNode *itanode = catnode->Item[j] ;
                if ( itanode->Text == BoardName )
                {
                    subscribeTreeView->Selected = itanode ;
                    return ;
                }
            }
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::subscribeAddFavoriteButtonMIClick(TObject *Sender)
{
//{^ɓo^
    if ( m_selectedNode == NULL ) return ;

    AnsiString itaname = "" ;
    if ( m_selectedNode->Level == 1 )
    {
        itaname += "" ;
    }
    itaname += m_selectedNode->Text ;

    g_boardButton.addBoard( itaname ) ;
    FavoriteToolBarResize( NULL ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::BBSNameLabelMouseUp(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if ( Button != mbRight ) return ;
    if ( BBSNameLabel->Caption == "" ) return ;

    bool b = true ;
    subscribeAddFavoriteButtonMI->Enabled = false ;
    if ( m_bbsNode == NULL )
    {
        ;
    }
    else
    {
        m_selectedNode = m_bbsNode ;
    }
    subscribeURLCopyMI->Enabled     = b ;
    subscribeOpenBrowserMI->Enabled = b ;
    subscribeUnsubscribeMI->Enabled  = b ;
    POINT p ;
    GetCursorPos( &p ) ;
    subscribePM->Popup( p.x, p.y ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FavoriteToolBarResize(TObject *Sender)
{
// {^TCYꂽ
    if ( FavoriteToolBar->ButtonCount == 1 )
    {
        favoritePanel->Height = 0 ;
        return ;
    }
    favoritePanel->Height = 20 ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::bbsAllPMPopup(TObject *Sender)
{
// {[hc[|bvAbvj[ڂ̗L
    TTreeNode *node = BBSTreeView->Selected ;
    if ( node == NULL/*IĂȂ*/ || node->Level != 2/*[ł͂Ȃ*/ )
    {
        bbsAllSubscribeMI->Enabled  = false ;
        bbsAllUnsubscribeMI->Enabled  = false ;
        bbsAllURLCopyMI->Enabled     = false ;
        bbsAllOpenBrowserMI->Enabled = false ;
    }
    else
    {
        AnsiString cat = node->Parent->Text ;
        AnsiString ita = node->Text ;
        bool e = g_subscribeBoard.isExist( cat, ita ) ;
        bbsAllSubscribeMI->Enabled  = ! e ;
        bbsAllUnsubscribeMI->Enabled  = e ;
        bbsAllURLCopyMI->Enabled     = true ;
        bbsAllOpenBrowserMI->Enabled = true ;
        m_selectedNode = node ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::subscribeTreeViewContextPopup(TObject *Sender,
      TPoint &MousePos, bool &Handled)
{
    Handled = true ;
    TTreeNode *node = subscribeTreeView->Selected ;
    bool b = true ;
    if ( node != NULL )
    {
        subscribeAddFavoriteButtonMI->Enabled = (node->Level != 0) ;
    }
    m_selectedNode = node ;
    if ( node == NULL/*IĂȂ*/ || node->Level != 2/*[ł͂Ȃ*/ )
    {
        b  = false ;
    }
    subscribeURLCopyMI->Enabled     = b ;
    subscribeOpenBrowserMI->Enabled = b ;
    subscribeUnsubscribeMI->Enabled  = b ;
    POINT p ;
    GetCursorPos( &p ) ;
    subscribePM->Popup( p.x, p.y ) ;
}
//---------------------------------------------------------------------------
/** \Xbh̍i
 */
void __fastcall TMainForm::subjectShowTypeCBChange(TObject *Sender)
{
    ATemporarilyCursor hourGlass ;

    subject.viewThreadList( SubjectListView, threadTypeTbl[subjectShowTypeCB->ItemIndex] ) ;
}
//---------------------------------------------------------------------------
/** Xꗗ̃Xgڂݒ
 */
void __fastcall TMainForm::SubjectListViewData(TObject *Sender,
      TListItem *Item)
{
    subject.getThreadListViewData( Item ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::SubjectListViewColumnClick(TObject *Sender,
      TListColumn *Column)
{
// XꗗXgr[̗wb_[NbN
    subject.threadListsort( Column->Index ) ;
    SubjectListView->Repaint() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabPageControlChange(TObject *Sender)
{
// ^u؂ւ
    g_tabMan.setFocusIE() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabCloseMIClick(TObject *Sender)
{
// ̃^u
    g_tabMan.close( tabPageControl->ActivePage ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabPageControlMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
// ^uNbNꂽ
    TTabSheet *tab = tabPageControl->Pages[ tabPageControl->IndexOfTabAt( X, Y ) ] ;
    // }EX̒{^̓^uN[Y
    if ( Button == mbMiddle )
    {
        g_tabMan.close( tab ) ;
        return ;
    }
    // NbN^uANeBu(ENbNƂł)
    tabPageControl->ActivePage = tab ;
    tabPageControlChange( Sender ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabCloseOtherMIClick(TObject *Sender)
{
// ȊÕ^u
    g_tabMan.closeOther( tabPageControl->ActivePage ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabURLCopyMIClick(TObject *Sender)
{
// ^uURLRs[
    AnsiString url = g_tabMan.getUrl( tabPageControl->ActivePage ) ;

    AClipboard cb ;
    cb.SetTextBuf( url.c_str() ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabOpenBrowserMIClick(TObject *Sender)
{
// ^uuEUŊJ
    AnsiString url = g_tabMan.getUrl( tabPageControl->ActivePage ) ;
	ShellExecute( Handle, "open", url.c_str(), NULL, NULL, SW_SHOW ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabPageControlEnter(TObject *Sender)
{
// ^uANeBuɂȂ
    g_tabMan.setFocusIE() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::threadSearch0(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData)
{
// Xbh
// \̃Xbh^Cg
    subject.search( regexp, SubjectListView ) ;
}
//---------------------------------------------------------------------------
/** Xbh
 * \̔̊O
 */
void __fastcall TMainForm::threadSearch1(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData)
{
    AnsiString ita = ExtractFileDir( subject.getLogDir() ) ;
    AnsiString host = ExtractFileDir( ita ) ;
    if ( ita.IsEmpty() || host.IsEmpty() ) return ;
    host = ExtractFileName( host ) ;
    ita = ExtractFileName( ita ) ;
    AnsiString sureurl = "http://" ;
    sureurl += host ;
    sureurl += "/test/read.cgi/" ;
    sureurl += ita ;
    sureurl += "/" ;
    AnsiString itaurl = "http://" ;
    itaurl += host ;
    itaurl += "/" ;
    itaurl += ita ;
    itaurl += "/" ;

    AnsiString catename, itaname ;
    g_subscribeBoard.getBoardName( itaurl, catename, itaname ) ;
    if ( catename.IsEmpty() || itaname.IsEmpty() ) return ;

    AnsiString htmlstr = g_htmlHeader ;
    htmlstr += "\"" + regexp->getKeyString() + "\" ܂ރO<br>" ;
    htmlstr += subject.searchLog( regexp, sureurl, itaname, lpCallBack, lData ) ;
    htmlstr += "</body></html>" ;
    showHTML( htmlstr, "" ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::threadSearch2(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData)
{
// Xbh
// wǔ̃Xbh^Cg
    AnsiString htmlstr = g_htmlHeader ;
    htmlstr += "\"" + regexp->getKeyString() + "\" ܂ރ^Cg<br>" ;
    TMemIniFile *board = new TMemIniFile( g_global.getExeDir() + FILEPATH_SUBSCRIBE_INI ) ;

    TStringList *cate = new TStringList() ;
    TStringList *itaname = new TStringList() ;
    TStringList *datlist = new TStringList() ;

    board->ReadSections( cate ) ;
    AnsiString itaurl, itadir ;
    AnsiString title ;
    AnsiString hit ;
    AnsiString host, path, url ;
    int c = cate->Count ;
    for (int i=0; i < c; i++)
    {
        board->ReadSection( cate->Strings[i], itaname ) ;
        int cc = itaname->Count ;
        for (int j=0; j < cc; j++)
        {
            hit = "" ;
            itaurl = board->ReadString( cate->Strings[i], itaname->Strings[j], "" ) ;
            itadir = url2local( itaurl ) ;
            TMemIniFile *subjectini = new TMemIniFile( g_global.getLogDir() + itadir + FILENAME_SUBJECT_INI ) ;

            subjectini->ReadSections( datlist ) ;
            int dc = datlist->Count ;
            for (int k=0; k < dc; k++)
            {
                title = subjectini->ReadString( datlist->Strings[k], THREAD_INI_TITLE, "" ) ;
                if ( regexp->match( title.c_str() ) )
                {
                    parseUrl( itaurl.c_str(), host, path ) ;
                    url = (AnsiString)"http://" + host + "/test/read.cgi" + path ;
                    hit += "<dd><a href=\"" ;
                    hit += url ;
                    hit += ChangeFileExt( datlist->Strings[k], "" ) ;
                    hit += "/\">" ;
                    hit += title ;
                    hit += "</a><br>" ;
                }
            }

            delete subjectini ;
            if ( ! hit.IsEmpty() )
            {
                htmlstr += "<dl><dt><strong>" + itaname->Strings[j] + "</strong>" + hit + "</dl>" ;
            }
            if ( lpCallBack( NULL, lData, i, c ) != 0 ) goto loopout2 ;
        }
    }
loopout2:
    delete cate ;
    delete itaname ;
    delete datlist ;

    delete board ;
    htmlstr += "</body></html>" ;
    showHTML( htmlstr, "" ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::threadSearch3(ARegExp *regexp, PROGRESS_CALLBACK lpCallBack, long lData)
{
// Xbh
// wǔ̊O
    AnsiString htmlstr = g_htmlHeader ;
    htmlstr += "\"" + regexp->getKeyString() + "\" ܂ރO<br>" ;
    TMemIniFile *board = new TMemIniFile( g_global.getExeDir() + FILEPATH_SUBSCRIBE_INI ) ;

    TStringList *cate = new TStringList() ;
    TStringList *itaname = new TStringList() ;
    TStringList *datlist = new TStringList() ;
    TStringList *log = new TStringList() ;

    board->ReadSections( cate ) ;
    AnsiString itaurl, itadir ;
    AnsiString hit ;
    AnsiString host, path, url ;
    AnsiString logdir, fname ;
    int c = cate->Count ;
    for (int i=0; i < c; i++)
    {
        board->ReadSection( cate->Strings[i], itaname ) ;
        int cc = itaname->Count ;
        for (int j=0; j < cc; j++)
        {
            hit = "" ;
            itaurl = board->ReadString( cate->Strings[i], itaname->Strings[j], "" ) ;
            itadir = url2local( itaurl ) ;
            logdir = g_global.getLogDir() + itadir ;
            TMemIniFile *subjectini = new TMemIniFile( logdir + FILENAME_SUBJECT_INI ) ;

            subjectini->ReadSections( datlist ) ;
            int dc = datlist->Count ;
            for (int k=0; k < dc; k++)
            {
                fname = logdir + datlist->Strings[k] ;
                if ( ! FileExists( fname ) ) continue ;
                try
                {
                    log->LoadFromFile( fname ) ;
                    int lc = log->Count ;
                    for (int l=0; l < lc; l++)
                    {
                        if ( regexp->match( log->Strings[l].c_str() ) )
                        {
                            parseUrl( itaurl.c_str(), host, path ) ;
                            url = (AnsiString)"http://" + host + "/test/read.cgi" + path ;
                            hit += "<dd><a href=\"" ;
                            hit += url ;
                            hit += ChangeFileExt( datlist->Strings[k], "" ) ;
                            hit += "/" ;
                            hit += AnsiString( l +1 ) ;
                            hit += "\">" ;
                            hit += subjectini->ReadString( datlist->Strings[k], THREAD_INI_TITLE, "" ) ;
                            hit += "</a><br>" ;
                            break ;
                        }
                    }
                } catch (...) {}
                if ( lpCallBack( NULL, lData, i*10 + j*10/cc, c*10 ) != 0 ) break ;
            }

            delete subjectini ;
            if ( ! hit.IsEmpty() )
            {
                htmlstr += "<dl><dt><strong>" + itaname->Strings[j] + "</strong>" + hit + "</dl>" ;
            }
            if ( lpCallBack( NULL, lData, i*10 + j*10/cc, c*10 ) != 0 ) break ;
        }
    }
loopout3:
    delete cate ;
    delete itaname ;
    delete datlist ;
    delete log ;

    delete board ;
    htmlstr += "</body></html>" ;
    showHTML( htmlstr, "" ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::optionOptionMIClick(TObject *Sender)
{
// IvVݒ
    TSettingForm *SettingForm = new TSettingForm( this ) ;
    try
    {
        SettingForm->ShowModal() ;
    } catch(...){}
    delete SettingForm ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabPMPopup(TObject *Sender)
{
// ^u|bvAbvj[܂ɊJ悤ƂĂ܂I
    TStringList *history = g_tabMan.getHistory( tabPageControl->ActivePage ) ;
    int count = history->Count ;
    tabHistoryMI->Enabled = false ;
    tabHistory1MI->Visible = true ; //
    tabHistory2MI->Visible = false ;
    tabHistory3MI->Visible = false ;
    tabHistory4MI->Visible = false ;
    tabHistory5MI->Visible = false ;
    if ( count < 1 ) return ;
    tabHistoryMI->Enabled = true ; //
    tabHistory1MI->Caption = history->Strings[0] ;
    if ( count < 2 ) return ;
    tabHistory2MI->Visible = true ;
    tabHistory2MI->Caption = history->Strings[1] ;
    if ( count < 3 ) return ;
    tabHistory3MI->Visible = true ;
    tabHistory3MI->Caption = history->Strings[2] ;
    if ( count < 4 ) return ;
    tabHistory4MI->Visible = true ;
    tabHistory4MI->Caption = history->Strings[3] ;
    if ( count < 5 ) return ;
    tabHistory5MI->Visible = true ;
    tabHistory5MI->Caption = history->Strings[4] ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabHistory1MIClick(TObject *Sender)
{
// ^uI
    int index = ((TMenuItem*)Sender)->Tag ;
    g_tabMan.openHistory( tabPageControl->ActivePage, index ) ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabTitleCopyMIClick(TObject *Sender)
{
// ^ũ^CgRs[
    AnsiString str = tabPageControl->ActivePage->Caption ;

    AClipboard cb ;
    cb.SetTextBuf( str.c_str() ) ;
}
//---------------------------------------------------------------------------
/** Xbhꗗ̔wiFύX
 */
void __fastcall TMainForm::SubjectListViewCustomDrawItem(
      TCustomListView *Sender, TListItem *Item, TCustomDrawState State,
      bool &DefaultDraw)
{    if ( Item->Selected ) return ;

    ThreadState state = subject.getThreadState( Item->Index ) ;

    //  > dat > OL > V > 1000X > O
    if ( state & threadUnread )
    {
        Sender->Canvas->Brush->Color = g_colorUnreadThread ;
    }
    else if ( state & threadPast )
    {
        Sender->Canvas->Brush->Color = g_colorPastThread ;
    }
    else if ( state & threadLogExist )
    {
        Sender->Canvas->Brush->Color = g_colorLogExistThread ;
    }
    else if ( state & threadNew )
    {
        Sender->Canvas->Brush->Color = g_colorNewThread ;
    }
    else if ( state & threadStop )
    {
        Sender->Canvas->Brush->Color = g_color1000OverThread ;
    }
    else // if ( state & threadNoLog )
    {
        Sender->Canvas->Brush->Color = g_colorNologThread ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::FormActivate(TObject *Sender)
{
    // IER|ANeBuɂ
    if ( MainForm->Active )
    {
        g_tabMan.setFocusIE() ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::tabDeleteLogMIClick(TObject *Sender)
{
    // O폜
    g_tabMan.deleteLog() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::subjectReloadToolButtonClick(TObject *Sender)
{
    reloadSubject() ;
}
//---------------------------------------------------------------------------
bool __fastcall TMainForm::reloadSubject(void)
{
    // XbhꗗXV
    m_lockSubject ++ ;
    bool result = subject.reload() ;
    if ( result )
    {
        subject.viewThreadList( SubjectListView, threadTypeTbl[subjectShowTypeCB->ItemIndex] ) ;
    }
    m_lockSubject -- ;
    return result ;
}
//---------------------------------------------------------------------------
/** Xbh
 */
void __fastcall TMainForm::subjectFindToolButtonClick(TObject *Sender)
{
    SearchForm->init() ;
    try
    {
        SearchForm->ShowModal() ;
    }
    catch (...)
    {
        ;
    }

    g_tabMan.setFocusIE() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::optionSidebarShowMIClick(TObject *Sender)
{
    SidebarShowToggle() ;
}
//---------------------------------------------------------------------------
/** {[hꗗ̐F
 */
void __fastcall TMainForm::BBSTreeViewCustomDrawItem(
      TCustomTreeView *Sender, TTreeNode *Node, TCustomDrawState State,
      bool &DefaultDraw)
{
    bool subsc = false ;
    if ( (! Node->Selected) && (Node->Parent != NULL) )
    {
        AnsiString cate = Node->Parent->Text ;
        AnsiString ita = Node->Text ;
        subsc = g_subscribeBoard.isExist(cate, ita) ;
    }

    if ( subsc )
    {
        Sender->Canvas->Brush->Color = g_colorSubscribeBBS ;
    }
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::expandSpeedButtonClick(TObject *Sender)
{
    SubjectExpandToggle() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::optionAboutMIClick(TObject *Sender)
{
    about() ;
}
//---------------------------------------------------------------------------
void __fastcall TMainForm::optionLogSweeperMIClick(TObject *Sender)
{
    // e肻Ȃ̂ŕ
    subscribeTreeView->Selected = NULL ;
    subject.close() ;
    SubjectListView->Items->Clear() ;
    g_tabMan.clear() ;

    // Os
    logSweeper() ;
}
//---------------------------------------------------------------------------

