﻿'***************************************************************************************************
'   配属一覧サンプル④(一覧表示)                             frmGetMdbDataTest05(Form)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
' 17/01/22(1.0.1.0)更新登録画面追加に伴う修正
' 17/01/29(1.0.2.0)ダブルクリック抑制処置の共通クラス化対応
' 17/02/05(1.0.3.0)新規登録時は追加された行へスクロール位置を調整する対応
' 17/02/26(1.0.4.0)配属一覧サンプル③からの転用でExcel出力機能を追加する対応
' 17/04/02(1.0.5.0)部署メニューコンボ、Excelのインスタンス(新規・既存)指定機能を追加
' 17/04/06(1.0.5.0)※本フォームではタイトルと呼び出しフォーム名の変更のみ
' 18/05/07(1.0.6.0)DataGridViewのスクロールバー表示不正の対応、初期処理をNewに移動させる対応
'***************************************************************************************************
Imports System.IO
Public Class frmGetMdbDataTest05
    '===============================================================================================
    Private Const g_cnsTitle As String = "配属一覧サンプル⑤"
    Private Const g_cnsDGVColumnMAX As Integer = 5          ' DataGridView最大カラム(表示)
    '-----------------------------------------------------------------------------------------------
    ' 背景色
    Private ReadOnly g_colorRetire As Color = Color.FromArgb(220, 220, 220) ' 退職色(薄灰)
    '-----------------------------------------------------------------------------------------------
    ' 共通クラス
    Private g_objAboutMDB As clsAboutMDB3                   ' データベースI/Oクラス(MDB用)
    Private g_objAboutWindow As clsAboutWindow1             ' ウィンドウ制御関連クラス
    Private g_objAboutDGV As clsAboutDataGridView3          ' DataGridView制御関連クラス
    Private g_objOmitDoubleClick As clsOmitDoubleClick2     ' ダブルクリック抑制クラス
    ' 詳細登録フォーム
    Private g_objSYOUSAI_Form As dlgGetMdbDataTest03 = Nothing ' 詳細登録フォーム
    '-----------------------------------------------------------------------------------------------
    ' 一覧表示用抽出SQL文共通部
    Private g_strSQL_Base As String = ""                    ' 抽出SQL文共通部
    ' 現在一覧表示中の抽出SQL文退避
    Private g_strSQL_Save As String = ""                    ' 抽出SQL文退避
    '-----------------------------------------------------------------------------------------------
    ' デフォルトのカラム幅
    Private g_tblDefaultColumnWidth() As Integer            ' カラム幅テーブル
    '-----------------------------------------------------------------------------------------------
    ' 部署メニューコンボに対する部署コードテーブル
    Private g_tblBusyoCd() As String                        ' 部署コードテーブル

    '***********************************************************************************************
    ' ■■■ 初期化 ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2018年05月07日
    '* 作成者　：井上　治
    '* 更新日　：2018年05月07日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Public Sub New()
        '-------------------------------------------------------------------------------------------
        ' ※Windowsフォームデザイナ初期化(必須)
        Call InitializeComponent()
        ' フォームデザイナモード時は以下をスキップする
        If Me.DesignMode Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' データベースI/Oクラスの初期化
        g_objAboutMDB = New clsAboutMDB3(Me, g_cnsMdbFileame, g_cnsMdbSubFolder)
        ' ウィンドウ制御関連クラスの初期化
        g_objAboutWindow = New clsAboutWindow1(Me)
        ' ダブルクリック抑制クラスの初期化
        g_objOmitDoubleClick = New clsOmitDoubleClick2(Me)
        ' DataGridView制御関連クラスの初期化
        g_objAboutDGV = New clsAboutDataGridView3
        '-------------------------------------------------------------------------------------------
        ' DataGridView(登録一覧)のカラム設定
        Dim tblColInfo() As g_typDGVColInfo = Nothing
        With g_objAboutDGV
            Call .SetColumnInfo(tblColInfo, "社員CD", 50, g_cnsDG_MC)   ' (00)社員コード
            Call .SetColumnInfo(tblColInfo, "氏名", 100, , _
                                g_cnsSM_Programmatic)                   ' (01)氏名
            Call .SetColumnInfo(tblColInfo, "部署名", 150, , _
                                g_cnsSM_Programmatic)                   ' (02)部署名
            Call .SetColumnInfo(tblColInfo, "役職名", 100, , _
                                g_cnsSM_Programmatic)                   ' (03)役職名
            Call .SetColumnInfo(tblColInfo, "入社日", 90, g_cnsDG_MC)   ' (04)入社日
            Call .SetColumnInfo(tblColInfo, "退職日", 90, g_cnsDG_MC)   ' (05)退職日
            Call .SetColumnInfo(tblColInfo, "部署CD", 60, g_cnsDG_MC)   ' (06)部署コード(非表示)
            Call .SetColumnInfo(tblColInfo, "役職CD", 50, g_cnsDG_MC)   ' (07)役職コード(非表示)
            Call .SetColumnInfo(tblColInfo, "カナ氏名", 150)            ' (08)カナ氏名(非表示)
            Call .SetColumnInfo(tblColInfo, "開始日", 90, g_cnsDG_MC)   ' (09)配属開始日
            ' 初期カラム幅設定を退避
            g_tblDefaultColumnWidth = .GetDefaultColumnWidth(tblColInfo)
            ' 列幅を設定退避値で置き換える
            Call .AdjustColumnWidth(tblColInfo, My.Settings.ICHIRAN_COL_Width)
            '---------------------------------------------------------------------------------------
            ' DataGridViewの初期設定(一般一覧用)
            Call .InitDataGridView1(DGV_ICHIRAN, tblColInfo, 1)
            '---------------------------------------------------------------------------------------
            ' 半角英数列のフォントをMSゴシック10Pに変更
            Dim objFont10 As Font = New Font(g_cnsStdFontName, g_cnsFontSize975) ' 英数項目用
            ' DataGridViewのその他調整
            With DGV_ICHIRAN
                ' プログラムSORT列指定
                .Columns(1).Tag = 8                 ' 氏名⇒カナ氏名
                .Columns(2).Tag = 6                 ' 部署名⇒部署コード
                .Columns(3).Tag = 7                 ' 役職名⇒役職コード
                ' コード、日付列は当幅フォントに変更
                .Columns(0).DefaultCellStyle.Font = objFont10
                .Columns(4).DefaultCellStyle.Font = objFont10
                .Columns(5).DefaultCellStyle.Font = objFont10
                .Columns(6).DefaultCellStyle.Font = objFont10
                .Columns(7).DefaultCellStyle.Font = objFont10
                .Columns(9).DefaultCellStyle.Font = objFont10
                ' 部署コード以降は非表示
                .Columns(6).Visible = False
                .Columns(7).Visible = False
                .Columns(8).Visible = False
                .Columns(9).Visible = False
            End With
            '---------------------------------------------------------------------------------------
            ' 列配置を設定退避値で置き換える
            Call .AdjustDGVColumnDisplayIndex(DGV_ICHIRAN, My.Settings.ICHIRAN_DisplayIndex)
        End With
        '-------------------------------------------------------------------------------------------
        ' 一覧表示用抽出SQL文共通部の編集(WHERE句の前まで)
        g_strSQL_Base = "SELECT H.[SCD]"                                ' (00)社員コード
        g_strSQL_Base &= ",S.[KANJI_SEI]+S.[KANJI_MEI]"                 ' (01)氏名(漢字)
        g_strSQL_Base &= ",B.[BUSYO_NM]"                                ' (02)部署名
        g_strSQL_Base &= ",Y.[YAKU_NM]"                                 ' (03)役職名
        g_strSQL_Base &= ",S.[NYUSYA_YMD]"                              ' (04)入社日
        g_strSQL_Base &= ",S.[TAISYOKU_YMD]"                            ' (05)退職日
        g_strSQL_Base &= ",H.[BUSYO_CD]"                                ' (06)部署コード
        g_strSQL_Base &= ",H.[YAKU_CD]"                                 ' (07)役職コード
        g_strSQL_Base &= ",S.[KANA_SEI]+S.[KANA_MEI]"                   ' (08)氏名(カナ)
        g_strSQL_Base &= ",H.[KAISHI_YMD]"                              ' (09)配属開始日
        g_strSQL_Base &= " FROM (((" & g_cnsMST_HAIZOKU & " AS H"
        g_strSQL_Base &= g_cnsIN_JOIN & g_cnsMST_SYAIN & " AS S ON H.[SCD]=S.[SCD])"
        g_strSQL_Base &= g_cnsOUT_JOIN & g_cnsMST_BUSYO & " AS B ON H.[BUSYO_CD]=B.[BUSYO_CD])"
        g_strSQL_Base &= g_cnsOUT_JOIN & g_cnsMST_YAKU & " AS Y ON H.[YAKU_CD]=Y.[YAKU_CD])"
    End Sub

    '***********************************************************************************************
    ' ■■■ フォームイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Form_FormClosed
    '* 機能　　：フォーム消失(FormClosed)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_FormClosed(ByVal sender As Object, _
                                ByVal e As FormClosedEventArgs) Handles Me.FormClosed
        '-------------------------------------------------------------------------------------------
        ' DataGridViewの列幅、列配置等を退避
        With My.Settings
            .ICHIRAN_COL_Width = g_objAboutDGV.GetDGVColumnWidth(DGV_ICHIRAN)
            .ICHIRAN_DisplayIndex = g_objAboutDGV.GetDGVColumnDisplayIndex(DGV_ICHIRAN)
            Call g_objAboutWindow.FormSaveSettings1(.ICHIRAN_FormLocation, _
                                                    .ICHIRAN_FormSize, _
                                                    .ICHIRAN_WindowState)
            ' 設定を保存
            .Save()
        End With
        '-------------------------------------------------------------------------------------------
        ' DataGridViewのColumnHeaderMouseClickイベントハンドラ解放(共通記述)
        RemoveHandler DGV_ICHIRAN.ColumnHeaderMouseClick, _
            AddressOf g_objAboutDGV.DGV_ColumnHeaderMouseClick
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_Load
    '* 機能　　：フォーム初期化(Load)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2018年05月07日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '-------------------------------------------------------------------------------------------
        ' 一旦、メニューを消去
        MNU_NEW.Visible = False
        MNU_EXCEL.Visible = False
        '-------------------------------------------------------------------------------------------
        ' フォーム位置・サイズ制御
        With My.Settings
            Call g_objAboutWindow.FormAdjustLocationSize1(.ICHIRAN_FormLocation, _
                                                          .ICHIRAN_FormSize, Me.Size)
            Me.WindowState = .ICHIRAN_WindowState
        End With
        '-------------------------------------------------------------------------------------------
        ' DataGridViewのColumnHeaderMouseClickイベントハンドラ追加(共通記述)
        AddHandler DGV_ICHIRAN.ColumnHeaderMouseClick, _
            AddressOf g_objAboutDGV.DGV_ColumnHeaderMouseClick
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_Shown
    '* 機能　　：フォーム初期表示(Shown)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Shown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shown
        '-------------------------------------------------------------------------------------------
        ' 初回起動か
        If g_objOmitDoubleClick.FirstShown Then
            ' メニューコンボ等の初期セット
            If Not FP_SetFormList() Then
                Me.Close()
                Exit Sub
            End If
            g_objOmitDoubleClick.FirstShown = False
        End If
        ' 一覧再更新表示
        If Not FP_ListUpdate() Then
            Me.Close()
            Exit Sub
        End If
        '-------------------------------------------------------------------------------------------
        MNU_NEW.Visible = True
        ' 初期表示動作完了
        g_objOmitDoubleClick.Shown = True
    End Sub

    '***********************************************************************************************
    ' ■■■ コントロールイベント ■■■
    '***********************************************************************************************
    '* 処理名　：DGV_ICHIRAN_KeyUp
    '* 機能　　：グリッド表示のキーイベント(KeyUp)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub DGV_ICHIRAN_KeyUp(ByVal sender As Object, _
                                  ByVal e As System.Windows.Forms.KeyEventArgs) _
                                  Handles DGV_ICHIRAN.KeyUp
        '-------------------------------------------------------------------------------------------
        ' Ctrl+Cでコピーができないようにする。
        If (e.Control AndAlso (e.KeyCode = Keys.C)) Then
            ' クリップボードをクリア
            Clipboard.Clear()
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：DGV_ICHIRAN_CellClick
    '* 機能　　：グリッド表示のイベント(CellClick)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub DGV_ICHIRAN_CellClick(ByVal sender As Object, _
                                      ByVal e As DataGridViewCellEventArgs) _
                                      Handles DGV_ICHIRAN.CellClick
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick() Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' DataGridViewのセル選択
        Dim intRow As Integer = e.RowIndex                              ' 行INDEX
        ' 選択行0件時はスキップ
        If ((intRow < 0) OrElse (DGV_ICHIRAN.SelectedRows.Count = 0)) Then Exit Sub
        ' 処理中判定スイッチ対応
        g_objOmitDoubleClick.OmitDoubleClick = True
        '-------------------------------------------------------------------------------------------
        ' 詳細表示フォームを起動
        Call GP_ShowEntryForm(intRow)
    End Sub

    '***********************************************************************************************
    '* 処理名　：DGV_ICHIRAN_KeyDown
    '* 機能　　：グリッド表示のイベント(KeyDown)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub DGV_ICHIRAN_KeyDown(ByVal sender As Object, _
                                    ByVal e As System.Windows.Forms.KeyEventArgs) _
                                    Handles DGV_ICHIRAN.KeyDown
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick() Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' Enterキーでなければ処理なし
        If ((e.KeyCode <> Keys.Enter) OrElse e.Shift) Then Exit Sub
        ' 表示0件時はスキップ
        If DGV_ICHIRAN.SelectedCells.Count = 0 Then Exit Sub
        e.Handled = True                                ' Enterキーで下行に移動させない
        Dim intRow As Integer = DGV_ICHIRAN.SelectedCells.Item(0).RowIndex ' 行INDEX
        ' 行未選択でなければ処理なし
        If intRow < 0 Then Exit Sub
        ' 処理中判定スイッチ対応
        g_objOmitDoubleClick.OmitDoubleClick = True
        '-------------------------------------------------------------------------------------------
        ' 詳細表示フォームを起動
        Call GP_ShowEntryForm(intRow)
    End Sub

    '***********************************************************************************************
    '* 処理名　：DGV_ICHIRAN_Leave
    '* 機能　　：グリッド表示のフォーカスアウトイベント(Leave)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub DGV_ICHIRAN_Leave(ByVal sender As Object, _
                                  ByVal e As System.EventArgs) Handles DGV_ICHIRAN.Leave
        '-------------------------------------------------------------------------------------------
        DGV_ICHIRAN.CurrentCell = Nothing
    End Sub

    '***********************************************************************************************
    '* 処理名　：MNU_CBO_BUSYO_SelectedIndexChanged
    '* 機能　　：グリッド表示のフォーカスアウトイベント(Leave)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年04月02日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub MNU_CBO_BUSYO_SelectedIndexChanged(ByVal sender As Object, _
                                                   ByVal e As System.EventArgs) _
                                                   Handles MNU_CBO_BUSYO.SelectedIndexChanged
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick() Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' 一覧再更新表示
        If Not FP_ListUpdate() Then
            Me.Close()
            Exit Sub
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：MNU_EXCEL_Click
    '* 機能　　：｢Excel出力｣メニューイベント(Click)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月26日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub MNU_EXCEL_Click(ByVal sender As Object, _
                                ByVal e As System.EventArgs) Handles MNU_EXCEL.Click
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick() Then Exit Sub
        ' 抽出SQL文が退避されていない場合は終了
        If g_strSQL_Save.Length = 0 Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' 出力確認メッセージ
        Dim strMSG As String = _
            "現在の範囲指定の配属一覧をExcelに出力します。" & _
            ControlChars.CrLf & ControlChars.CrLf & "よろしいですね？"
        ' 拡張メッセージボックス(Excel出力用)を表示
        Dim intMessageResult As DialogResult = _
            MessageBox2.DialogShowEx(Me, _
                                     strMSG, _
                                     g_cnsExcelMessageGuide, _
                                     g_tblExcelButtonText, _
                                     g_cnsTitle, _
                                     MessageBoxButtons.YesNoCancel, _
                                     MessageBoxIcon.Information)
        ' Yes(新規INSTANCE)、No(既存INSTANCE)以外は終了
        If ((intMessageResult <> Windows.Forms.DialogResult.Yes) AndAlso _
            (intMessageResult <> Windows.Forms.DialogResult.No)) Then Exit Sub
        ' 処理中判定スイッチ対応
        g_objOmitDoubleClick.OmitDoubleClick = True
        '-------------------------------------------------------------------------------------------
        ' Excel出力フォームを表示
        Using objExcelForm As dlgOutputExcel2 = New dlgOutputExcel2
            With objExcelForm
                .prpSQL = g_strSQL_Save                         ' 抽出SQL文
                ' 新規インスタンスかどうかの指定
                .prpNewInstance = intMessageResult = Windows.Forms.DialogResult.Yes
                ' 処理中フォーム表示
                .ShowDialog(Me)
            End With
        End Using
    End Sub

    '***********************************************************************************************
    '* 処理名　：MNU_NEW_Click
    '* 機能　　：｢新規登録｣メニューイベント(Click)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub MNU_NEW_Click(ByVal sender As Object, _
                              ByVal e As System.EventArgs) Handles MNU_NEW.Click
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick() Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' 詳細表示フォームを起動
        Call GP_ShowEntryForm(-1)
    End Sub

    '***********************************************************************************************
    '   ■■■ サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：FP_ListUpdate
    '* 機能　　：一覧再更新表示
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2018年05月07日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_ListUpdate() As Boolean
        '-------------------------------------------------------------------------------------------
        With DGV_ICHIRAN
            ' 一旦一覧を消去
            If .Rows.Count <> 0 Then .Rows.Clear()
        End With
        ' Excel出力メニューの非表示
        MNU_EXCEL.Visible = False
        g_strSQL_Save = String.Empty
        '-------------------------------------------------------------------------------------------
        ' 配属情報の抽出
        Dim dbTbl As DataTable = Nothing                            ' DataTable
        Dim strToday As String = FP_SQLDateSUB2(Today)              ' 本日日付(編集)
        Dim strSQL As String = g_strSQL_Base                        ' SQL文
        strSQL &= " WHERE S.[NYUSYA_YMD]<=" & strToday
        strSQL &= " AND (S.[TAISYOKU_YMD] IS NULL OR S.[TAISYOKU_YMD]>=" & strToday & g_cnsKO
        ' 部署メニューコンボの条件
        If MNU_CBO_BUSYO.SelectedIndex >= 1 Then
            strSQL &= " AND H.[BUSYO_CD]='" & g_tblBusyoCd(MNU_CBO_BUSYO.SelectedIndex) & g_cnsSC
        End If
        strSQL &= " ORDER BY H.[BUSYO_CD],H.[YAKU_CD],H.[SCD];"
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, strSQL, g_cnsMST_HAIZOKU) Then Return False
        g_strSQL_Save = strSQL
        '-------------------------------------------------------------------------------------------
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        With DGV_ICHIRAN
            ' スクロールバーを一旦、非表示にする
            .ScrollBars = ScrollBars.None
            ' DataGridViewを一旦、非表示にする
            .Visible = False
            ' SORTマークを部署の昇順に設定
            .Columns(2).HeaderCell.SortGlyphDirection = g_cnsSO_Ascending
            ' 他のプログラムソート列のSortマーク解除
            .Columns(1).HeaderCell.SortGlyphDirection = g_cnsSO_None
            .Columns(3).HeaderCell.SortGlyphDirection = g_cnsSO_None
            ' 前回の一覧をクリア
            If .Rows.Count <> 0 Then .Rows.Clear()
            ' DataTableの全件を繰り返す
            Do While intIx < dbTbl.Rows.Count
                ' 行を追加
                .Rows.Add()
                ' 一覧再更新表示サブ(１行単位)
                Call GP_ListUpdateSub(intIx, dbTbl.Rows(intIx).ItemArray.Clone)
                ' 次へ
                intIx += 1
            Loop
            ' DataGridViewを再表示にする
            .Visible = True
            ' スクロールバーを再表示する
            .ScrollBars = ScrollBars.Both
            ' Excel出力メニューの表示
            MNU_EXCEL.Visible = .Rows.Count > 0
        End With
        ' データテーブルをクリア
        dbTbl.Clear()
        dbTbl.Reset()
        Return True
    End Function

    '***********************************************************************************************
    '* 処理名　：GP_ShowEntryForm
    '* 機能　　：入力(参照)用フォーム表示
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = DataGridViewの行Index(Integer)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：更新登録フォームを表示させる
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_ShowEntryForm(ByVal intRow As Integer)
        '-------------------------------------------------------------------------------------------
        Dim intUpdateMode As Integer = 1                        ' 登録モード 
        Dim strScd As String = String.Empty                     ' 社員コード
        ' 行選択時は更新モードで動作
        If intRow >= 0 Then
            intUpdateMode = 2
            strScd = DGV_ICHIRAN.Rows(intRow).Cells(0).Value
        End If
        '-------------------------------------------------------------------------------------------
        ' 詳細登録フォームを起動
        If g_objSYOUSAI_Form Is Nothing Then
            g_objSYOUSAI_Form = New dlgGetMdbDataTest03(g_objAboutMDB)
        End If
        With g_objSYOUSAI_Form
            .prpUpdateMode = intUpdateMode
            .prpScd = strScd
            ' 詳細画面を起動(モーダル)
            .ShowDialog(Me)
            ' 処理中判定スイッチ対応
            g_objOmitDoubleClick.OmitDoubleClick = True
            ' 更新が成功した場合、一覧再表示
            If .prpUpdateResult <> 0 Then
                Call GP_ListUpdate2(intRow, .prpScd, .prpNyusyaYmd)
            End If
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_ListUpdate2
    '* 機能　　：一覧再更新表示(1行単位)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 更新行Index(Integer)         ※新規登録時は-1
    '* 　　　　　Arg2 = 社員コード(String)
    '* 　　　　　Arg3 = 配属開始日(Date)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_ListUpdate2(ByVal intRow As Integer, _
                               ByVal strScd As String, _
                               ByVal dteKaishiYmd As Date)
        '-------------------------------------------------------------------------------------------
        ' 配属の読み込み
        Dim dbTbl As DataTable = Nothing                            ' DataTable
        Dim strSQL As String = g_strSQL_Base                        ' SQL文
        strSQL &= " WHERE H.[SCD]='" & strScd & g_cnsSC
        strSQL &= " AND H.[KAISHI_YMD]=" & FP_SQLDateSUB2(dteKaishiYmd) & g_cnsCOL
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, strSQL, g_cnsMST_HAIZOKU) Then
            Me.Close()
            Exit Sub
        End If
        '-------------------------------------------------------------------------------------------
        Dim blnNewRow As Boolean = False                            ' 新規登録判定
        ' 追加モード時はDataGridViewに行を追加
        If intRow < 0 Then
            blnNewRow = True
            With DGV_ICHIRAN
                intRow = .Rows.Count
                .Rows.Add()
            End With
        End If
        '-------------------------------------------------------------------------------------------
        ' 一覧再更新表示サブ(１行単位)
        Call GP_ListUpdateSub(intRow, dbTbl.Rows(0).ItemArray.Clone)
        ' 新規登録時はスクロール位置を調整
        If blnNewRow Then
            Call g_objAboutDGV.ScrollToAddedRow(DGV_ICHIRAN, intRow)
        End If
        ' データテーブルをクリア
        dbTbl.Clear()
        dbTbl.Reset()
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_ListUpdateSub
    '* 機能　　：一覧再更新表示サブ(１行単位)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 行INDEX(Integer)
    '* 　　　　　Arg2 = dbTbl.Rows(IX).ItemArray(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：FP_ListUpdateとGP_ListUpdate2から呼び出される
    '***********************************************************************************************
    Private Sub GP_ListUpdateSub(ByRef intRow As Integer, _
                                 ByRef objItemArray As Object())
        '-------------------------------------------------------------------------------------------
        With DGV_ICHIRAN.Rows(intRow)
            .Cells(0).Value = objItemArray(0)                   ' (00)社員コード
            .Cells(1).Value = objItemArray(1)                   ' (01)氏名(漢字)
            ' 氏名(漢字)のToolTipに氏名(カナ)を設定
            .Cells(1).ToolTipText = objItemArray(8)
            .Cells(2).Value = objItemArray(2)                   ' (02)部署名
            .Cells(3).Value = objItemArray(3)                   ' (03)役職名
            .Cells(4).Value = FP_EditDate(objItemArray(4))      ' (04)入社日
            .Cells(5).Value = FP_EditDate(objItemArray(5))      ' (05)退職日
            .Cells(6).Value = objItemArray(6)                   ' (06)部署コード
            .Cells(7).Value = objItemArray(7)                   ' (07)役職コード
            .Cells(8).Value = objItemArray(8)                   ' (08)氏名(カナ)
            .Cells(9).Value = FP_EditDate(objItemArray(9))      ' (09)配属開始日
            ' 退職者か(退職日有り)
            If .Cells(5).Value.ToString.Length <> 0 Then
                ' 退職者はグレーで塗りつぶし
                For intCol As Integer = 0 To g_cnsDGVColumnMAX
                    .Cells(intCol).Style.BackColor = g_colorRetire
                Next intCol
            End If
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：FP_SetFormList
    '* 機能　　：メニューコンボ等の初期セット
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年04月02日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_SetFormList() As Boolean
        '-------------------------------------------------------------------------------------------
        ' 配属の読み込み
        Dim dbTbl As DataTable = Nothing                            ' DataTable
        Dim strSQL As String = "SELECT [BUSYO_CD]"                  ' (00)部署コード
        strSQL &= ",[BUSYO_NM]"                                     ' (01)部署名
        strSQL &= g_cnsFROM & g_cnsMST_BUSYO
        strSQL &= " ORDER BY [BUSYO_CD];"
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, strSQL, g_cnsMST_BUSYO) Then
            Return False
        End If
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        Dim intIx2 As Integer = 0                                   ' テーブルINDEX
        Dim intIxMax As Integer = dbTbl.Rows.Count                  ' テーブルINDEX上限
        Dim tblName() As String                                     ' メニューコンボ表示名
        ReDim tblName(intIxMax), g_tblBusyoCd(intIxMax)
        ' 先頭は「すべて」
        tblName(0) = "(すべて)"
        g_tblBusyoCd(0) = String.Empty
        ' 部署マスタ内容を巡回
        Do While intIx < intIxMax
            intIx2 += 1
            g_tblBusyoCd(intIx2) = dbTbl.Rows(intIx)(0)
            tblName(intIx2) = dbTbl.Rows(intIx)(1)
            ' 次へ
            intIx += 1
        Loop
        ' メニューコンボへの登録
        With MNU_CBO_BUSYO
            With .Items
                If .Count <> 0 Then .Clear()
                .AddRange(tblName)
            End With
            .SelectedIndex = 0
        End With
        Return True
    End Function

    '----------------------------------------<< End of Source >>------------------------------------
End Class
