﻿'***************************************************************************************************
'   配属一覧サンプル(Excel出力②：実行時バインド版)             dlgOutputExcel2(Form)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/02/26(1.0.4.0)新規作成
' 17/03/01(1.0.4.0)作成途中⇒処理例外等を1箇所で処置するように対応中
' 17/04/02(1.0.5.0)Excelのインスタンス(新規・既存)指定機能を追加、拡張メッセージボックスの対応
' 17/04/06(1.0.5.0)実行時バインド版として再作成
'***************************************************************************************************
Imports System.IO
Friend Class dlgOutputExcel2
    '===============================================================================================
    Private Const g_cnsTitle As String = "配属一覧サンプル(Excel出力②)"
    Private Const g_cnsTemplate As String = "ExcelSample1.xltx"
    Private Const g_cnsTempPath As String = "..\..\ExcelTemplate"
    Private Const g_cnsColMax As Integer = 5
    '-----------------------------------------------------------------------------------------------
    ' 共通クラス
    Private g_objAboutMDB As clsAboutMDB3                           ' データベースI/Oクラス(MDB用)
    '-----------------------------------------------------------------------------------------------
    ' フォーム間受け渡し変数
    Private g_strSQL As String = String.Empty                       ' 抽出SQL文
    Private g_blnNewInstance As Boolean = False                     ' 新規インスタンス指定

    '***********************************************************************************************
    ' ■■■ フォームイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Form_Load
    '* 機能　　：フォーム初期化(Load)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月26日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月26日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '-------------------------------------------------------------------------------------------
        ' データベースI/Oクラスの初期化
        g_objAboutMDB = New clsAboutMDB3(Me, g_cnsMdbFileame, g_cnsMdbSubFolder)
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_Shown
    '* 機能　　：フォーム表示完了(Shown)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月26日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月06日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Shown(ByVal sender As Object, _
                           ByVal e As System.EventArgs) Handles Me.Shown
        '-------------------------------------------------------------------------------------------
        Application.DoEvents()
        '-------------------------------------------------------------------------------------------
        Dim objWbk As Object = Nothing                          ' Excel.Workbook
        ' Excel出力クラスの初期化(Escキーのイベントはクラス側に実装済)
        Using clsExcel = New clsAboutExcel2(Me, True)
            '---------------------------------------------------------------------------------------
            Dim strMSGHeader As String = String.Empty               ' メッセージヘッダ
            Try
                '-------------------------------------------
                ' Excel出力(処理本体)
                Call GP_MakeExcelSheet(clsExcel, objWbk, strMSGHeader)

            Catch ex As Exception
                '-------------------------------------------
                ' 処理中例外メッセージの表示
                Call clsExcel.ShowFatalMessage(g_cnsTitle, strMSGHeader, ex.Message)
                ' 例外時後始末(但しExcel応答無しなどではここでの対応は働かない！)
                Call clsExcel.SuspendExcelProc(objWbk)
            End Try
            '---------------------------------------------------------------------------------------
        End Using
        '-------------------------------------------------------------------------------------------
        ' 閉じる
        Me.Close()
    End Sub

    '***********************************************************************************************
    ' ■■■ サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：GP_MakeExcelSheet
    '* 機能　　：Excel出力(処理本体)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Excel出力クラス(Object)
    '* 　　　　　Arg2 = Excel.Workbook(Object)
    '* 　　　　　Arg3 = 例外時メッセージヘッダ(String)          ※Ref参照
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月26日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月06日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：本処理中の例外は上位でトラップされる(この処理内ではトラップしない)
    '***********************************************************************************************
    Private Sub GP_MakeExcelSheet(ByRef clsExcel As clsAboutExcel2, _
                                  ByRef objWbk As Object, _
                                  ByRef strMSGHeader As String)
        '-------------------------------------------------------------------------------------------
        strMSGHeader = "データ抽出中"
        ' 配属情報の抽出
        Dim dbTbl As DataTable = Nothing                            ' DataTable
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, g_strSQL, g_cnsMST_HAIZOKU) Then Exit Sub
        '-------------------------------------------------------------------------------------------
        Dim intCntRec As Integer = 0                                ' レコードカウンタ
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        Dim intIxMax As Integer = dbTbl.Rows.Count - 1              ' テーブルINDEX上限
        Dim tblRec(intIxMax, g_cnsColMax) As Object                 ' 2次元配列テーブル
        PRB_SYORICHU.Maximum = intIxMax + 1
        ' 全レコードを巡回
        Do While intIx <= intIxMax
            intCntRec += 1
            ' プログレスバーの処置
            Call GP_SetProgressBarValue(PRB_SYORICHU, intCntRec)
            ' 2次元配列テーブルに配置
            For intIx2 As Integer = 0 To g_cnsColMax
                tblRec(intIx, intIx2) = dbTbl.Rows(intIx)(intIx2)
            Next intIx2
            ' 次へ
            intIx += 1
        Loop
        ' データテーブルをクリア
        dbTbl.Clear()
        dbTbl.Reset()
        '-------------------------------------------------------------------------------------------
        strMSGHeader = "Excel起動中"
        Dim strFilename As String                                   ' ファイル名
        ' フルパステンプレート名(実行EXEの2階層上のExcelTemplateフォルダになっています)
        Dim objUri1 As New Uri(My.Application.Info.DirectoryPath)
        Dim objUri2 As New Uri(objUri1, g_cnsTempPath)
        strFilename = Path.Combine(objUri2.LocalPath, g_cnsTemplate)
        ' テンプレートOPEN
        If Not clsExcel.GetWorkbook(strFilename, _
                                    objWbk, _
                                    strMSGHeader, _
                                    g_blnNewInstance) Then Exit Sub
        '-------------------------------------------------------------------------------------------
        strMSGHeader = "Excel出力中"
        ' ワークシートに貼り付け(矩形貼り付け)
        With objWbk.Worksheets(1)
            Dim intRow As Integer = intIxMax + 2                    ' 行INDEX
            Dim intCol As Integer = g_cnsColMax + 1                 ' カラムINDEX
            .Range(.Cells(2, 1), .Cells(intRow, intCol)).Value = tblRec
        End With
        '-------------------------------------------------------------------------------------------
        strMSGHeader = "終了処理"
        ' 終了(Excelを表示)
        Call clsExcel.SuspendExcelProc(objWbk, True)
    End Sub

    '***********************************************************************************************
    ' ■■■ 受け渡しプロパティ ■■■
    '***********************************************************************************************
    ' 抽出SQL文(String)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpSQL() As String
        Set(ByVal value As String)
            g_strSQL = value
        End Set
    End Property

    '===============================================================================================
    ' 新規インスタンス指定(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpNewInstance() As Boolean
        Set(ByVal value As Boolean)
            g_blnNewInstance = value
        End Set
    End Property

    '----------------------------------------<< End of Source >>------------------------------------
End Class