﻿'***************************************************************************************************
'   配属一覧サンプル③(更新登録画面)                           dlgGetMdbDataTest03(Form)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/02/05(1.0.3.0)新規作成
' 17/04/02(1.0.4.0)拡張メッセージボックス対応を追加
'***************************************************************************************************
Friend Class dlgGetMdbDataTest03
    '===============================================================================================
    Private Const g_cnsTitle As String = "配属一覧サンプル③"
    '-----------------------------------------------------------------------------------------------
    ' 登録モードなどの定数
    Private Const g_cnsMODE_ADD As String = "(新規登録モード)"
    Private Const g_cnsMODE_UPD As String = "(変更登録モード)"
    'Private Const g_cnsMODE_DSP As String = "(参照モード)"
    Private Const g_cnsGUIDE_ADD As String = "「登録」ボタンで登録されます。"
    Private Const g_cnsGUIDE_UPD As String = "「登録」ボタンで内容が更新されます。"
    '-----------------------------------------------------------------------------------------------
    Private g_objAboutMDB As clsAboutMDB3                   ' データベースI/Oクラス(MDB用)
    Private g_objCheckNotUpdate As clsCheckNotUpdate2       ' 未更新終了チェック関連クラス
    Private g_objOmitDoubleClick As clsOmitDoubleClick2     ' ダブルクリック抑制クラス
    '-----------------------------------------------------------------------------------------------
    ' 一覧フォームとの受け渡し項目
    Private g_intUpdateMode As Integer = 0                  ' 処理モード(1=新規,2=変更)
    Private g_strScd As String                              ' 社員コード
    Private g_dteNyusyaYmd As Date                          ' 入社日
    Private g_intUpdateResult As Integer = 0                ' 更新結果(0=無,1=追加,2=更新,9=削除)
    '-----------------------------------------------------------------------------------------------
    ' コンボボックスに対応したコードテーブル
    Private g_tblBusyoCd() As String                        ' 部署コードテーブル
    Private g_tblYakuCd() As String                         ' 役職コードテーブル

    '***********************************************************************************************
    ' ■■■ 初期化 ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = データベースI/Oクラス(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub New(ByRef objAboutMDB As clsAboutMDB3)
        '-------------------------------------------------------------------------------------------
        ' ※Windowsフォームデザイナ初期化(必須)
        Call InitializeComponent()
        ' フォームデザイナモード時は以下をスキップする
        If Me.DesignMode Then Exit Sub
        '-------------------------------------------------------------------------------------------
        g_objAboutMDB = objAboutMDB                         ' データベースI/Oクラス(MDB用)
        '-------------------------------------------------------------------------------------------
        ' 未更新終了チェック関連クラスの初期化
        g_objCheckNotUpdate = New clsCheckNotUpdate2(Me)
    End Sub

    '***********************************************************************************************
    ' ■■■ フォームイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Form_Load
    '* 機能　　：フォームイベント(Load)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '-------------------------------------------------------------------------------------------
        ' 一旦、登録ボタン等を消去
        BTN_OK.Enabled = False
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック抑制クラスの初期化
        g_objOmitDoubleClick = New clsOmitDoubleClick2(Me)
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_Shown
    '* 機能　　：フォーム初期表示(Shown)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Shown(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Shown
        '-------------------------------------------------------------------------------------------
        g_intUpdateResult = 0
        '-------------------------------------------------------------------------------------------
        ' フォーム位置の保持
        If Me.StartPosition <> FormStartPosition.Manual Then
            Me.StartPosition = FormStartPosition.Manual
        End If
        '-------------------------------------------------------------------------------------------
        ' IME状態の初期化
        TXT_KANJI_SEI.ImeMode = Windows.Forms.ImeMode.Hiragana
        TXT_KANJI_MEI.ImeMode = Windows.Forms.ImeMode.Hiragana
        TXT_KANA_SEI.ImeMode = Windows.Forms.ImeMode.Katakana
        TXT_KANA_MEI.ImeMode = Windows.Forms.ImeMode.Katakana
        '-------------------------------------------------------------------------------------------
        ' 初回起動時は初期セットアップを行なう
        If g_objOmitDoubleClick.FirstShown Then
            ' コンボリスト等の初期セットアップ
            If Not FP_SetFormList() Then
                g_objCheckNotUpdate.FatalError = True
                Me.Close()
                Exit Sub
            End If
            g_objOmitDoubleClick.FirstShown = False
        End If
        '-------------------------------------------------------------------------------------------
        ' 新規登録モード
        If g_intUpdateMode = 1 Then
            ' 内容表示クリア
            Call GP_ClearForm()
        Else
            ' 指定社員情報の表示
            If Not FP_ShowSyainInfo() Then
                g_objCheckNotUpdate.FatalError = True
                Me.Close()
                Exit Sub
            End If
        End If
        ' 入力コントロール表示制御
        Call GP_SetFormCondition()
        '-------------------------------------------------------------------------------------------
        ' 未登録終了警告スイッチをクリア
        g_objCheckNotUpdate.NotUpdate = False
        g_objOmitDoubleClick.Shown = True
    End Sub

    '***********************************************************************************************
    ' ■■■ コントロールイベント ■■■
    '***********************************************************************************************
    '* 処理名　：BTN_CANCEL_Click
    '* 機能　　：「キャンセル」ボタンイベント(Click)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub BTN_CANCEL_Click(ByVal sender As Object, _
                                 ByVal e As System.EventArgs) Handles BTN_CANCEL.Click
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick(True) Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' フォームを閉じる
        Me.Close()
    End Sub

    '***********************************************************************************************
    '* 処理名　：BTN_OK_Click
    '* 機能　　：「登録」ボタンイベント(Click)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub BTN_OK_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles BTN_OK.Click
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック等の多重操作を抑制
        If g_objOmitDoubleClick.CheckDoubleClick() Then Exit Sub
        '-------------------------------------------------------------------------------------------
        Me.Activate()
        BTN_OK.Focus()
        ' ｢登録｣ボタン処理
        Call GP_OK_Click()
    End Sub

    '***********************************************************************************************
    ' ■■■ サブ処理(登録更新系) ■■■
    '***********************************************************************************************
    '* 処理名　：GP_OK_Click
    '* 機能　　：｢登録｣ボタン処理
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_OK_Click()
        '-------------------------------------------------------------------------------------------
        If Not g_objCheckNotUpdate.NotUpdate Then
            MessageBox2.DialogShow(Me, _
                                   "何も変更されていません。", _
                                   g_cnsTitle, _
                                   MessageBoxButtons.OK, _
                                   MessageBoxIcon.Information)
            Exit Sub
        ElseIf Not FP_CheckForm() Then          ' 登録チェック
            Exit Sub
        End If
        '-------------------------------------------------------------------------------------------
        ' 新規登録時は社員コードをプロパティ項目にセット
        If g_intUpdateMode = 1 Then
            g_strScd = TXT_SCD.Text.ToString.Trim
        End If
        g_dteNyusyaYmd = DTP_NYUSYA_YMD.Value
        '-------------------------------------------------------------------------------------------
        ' 登録確認メッセージ
        If MessageBox2.DialogShow( _
            Me, _
            "表示されている内容を登録します。" & _
            ControlChars.CrLf & ControlChars.CrLf & "よろしいですね？", _
            g_cnsTitle, _
            MessageBoxButtons.YesNo, _
            MessageBoxIcon.Information) <> DialogResult.Yes Then Exit Sub
        ' 処理中判定スイッチ対応
        g_objOmitDoubleClick.OmitDoubleClick = True
        '-------------------------------------------------------------------------------------------
        ' 登録(更新)処理
        If FP_UpdateTables() Then
            ' 処理結果を返す
            g_intUpdateResult = g_intUpdateMode
            ' 未登録終了警告スイッチをクリア
            g_objCheckNotUpdate.NotUpdate = False
            Me.Close()
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：FP_CheckForm
    '* 機能　　：登録チェック
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：チェック成否(Boolean)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_CheckForm() As Boolean
        '-------------------------------------------------------------------------------------------
        Dim strMSG As String = String.Empty                     ' エラーメッセージ
        '-------------------------------------------------------------------------------------------
        ' 必須チェック
        ' 新規登録時は社員コードチェックを行なう
        If g_intUpdateMode = 1 Then
            ' 社員コードブランク
            If TXT_SCD.Text.ToString.Trim.Length = 0 Then
                Call GP_AppendMessage(strMSG, "「社員№」が入力されていません。")
            ElseIf Not Integer.TryParse(TXT_SCD.Text.ToString.Trim, 0I) Then
                Call GP_AppendMessage(strMSG, "「社員№」が数字ではありません。")
            End If
        End If
        ' 漢字姓
        If TXT_KANJI_SEI.Text.ToString.Trim.Length = 0 Then
            Call GP_AppendMessage(strMSG, "「漢字氏名(姓)」が入力されていません。")
        End If
        ' 漢字名
        If TXT_KANJI_MEI.Text.ToString.Trim.Length = 0 Then
            Call GP_AppendMessage(strMSG, "「漢字氏名(名)」が入力されていません。")
        End If
        ' カナ姓
        If TXT_KANA_SEI.Text.ToString.Trim.Length = 0 Then
            Call GP_AppendMessage(strMSG, "「カナ氏名(姓)」が入力されていません。")
        End If
        ' カナ名
        If TXT_KANA_MEI.Text.ToString.Trim.Length = 0 Then
            Call GP_AppendMessage(strMSG, "「カナ氏名(名)」が入力されていません。")
        End If
        ' 性別未選択
        If CBO_SEX.SelectedIndex < 0 Then
            Call GP_AppendMessage(strMSG, "「性別」が選択されていません。")
        End If
        ' 部署未選択
        If CBO_BUSYO.SelectedIndex < 0 Then
            Call GP_AppendMessage(strMSG, "「部署」が選択されていません。")
        End If
        ' 役職未選択
        If CBO_YAKU.SelectedIndex < 0 Then
            Call GP_AppendMessage(strMSG, "「役職」が選択されていません。")
        End If
        '-------------------------------------------------------------------------------------------
        ' 日付チェック
        Dim dteSeinenYmd As Date = DTP_SEINEN_YMD.Value             ' 生年月日
        Dim dteNyusyaYmd As Date = DTP_NYUSYA_YMD.Value             ' 入社日
        Dim dteTaisyokuYmd As Date = g_cnsMaximumDate               ' 退職日
        ' 退職日入力有り
        If DTP_TAISYOKU_YMD.Checked Then
            dteTaisyokuYmd = DTP_TAISYOKU_YMD.Value
            If dteTaisyokuYmd = g_cnsMaximumDate Then
                Call GP_AppendMessage(strMSG, "「退職日」が正しくありません。")
            End If
        End If
        ' 入社日異常
        If dteNyusyaYmd <= dteSeinenYmd Then
            Call GP_AppendMessage(strMSG, "「入社日」が「生年月日」以前です。")
        ElseIf dteTaisyokuYmd <= dteNyusyaYmd Then
            Call GP_AppendMessage(strMSG, "「退職日」が「入社日」以前です。")
        End If
        '-------------------------------------------------------------------------------------------
        ' チェック結果
        If strMSG.Length <> 0 Then
            MessageBox2.DialogShow(Me, _
                                   strMSG, _
                                   g_cnsTitle, _
                                   MessageBoxButtons.OK, _
                                   MessageBoxIcon.Exclamation)
            Return False
        Else
            Return True
        End If
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_UpdateTables
    '* 機能　　：登録(更新)処理
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_UpdateTables() As Boolean
        '-------------------------------------------------------------------------------------------
        Dim blnResult As Boolean = False                            ' 処理結果
        Dim blnSuccess As Boolean = False                           ' 登録成否
        Dim strMsgHeader As String = String.Empty                   ' メッセージヘッダ
        Dim strMSG As String = String.Empty                         ' メッセージ
        Dim strSQL As String = String.Empty                         ' SQL文
        Dim strTable As String = String.Empty                       ' テーブル名
        ' MDB接続
        Using dbCon As OleDb.OleDbConnection = g_objAboutMDB.GetConnection(blnResult)
            ' 接続失敗
            If Not blnResult Then Return False
            '---------------------------------------------------------------------------------------
            ' データベースに接続
            dbCon.Open()
            ' トランザクション処理開始
            Using dbTran As OleDb.OleDbTransaction = dbCon.BeginTransaction(), _
                  dbCommand As OleDb.OleDbCommand = dbCon.CreateCommand()
                ' コマンドにトランザクションを割り当てる
                dbCommand.Transaction = dbTran
                '-----------------------------------------------------------------------------------
                Try
                    ' データベーステーブル更新
                    blnSuccess = FP_UpdateTablesSUB(dbTran, _
                                                    dbCommand, _
                                                    strMsgHeader, _
                                                    strSQL, _
                                                    strTable, _
                                                    strMSG)
                Catch ex As Exception
                    ' 更新SQLエラー処理(致命エラー扱い)
                    Call g_objAboutMDB.ExecuteSQLError(ex.Message, _
                                                       strMsgHeader, _
                                                       strTable, _
                                                       strSQL)
                End Try
                '-----------------------------------------------------------------------------------
            End Using
            ' データベースを切断
            dbCon.Close()
            '---------------------------------------------------------------------------------------
        End Using
        '-------------------------------------------------------------------------------------------
        ' エラーがあるか
        If strMSG.Length <> 0 Then
            ' ここでのエラーには致命エラーは含まれない
            MessageBox2.DialogShow(Me, _
                                   strMSG, _
                                   g_cnsTitle, _
                                   MessageBoxButtons.OK, _
                                   MessageBoxIcon.Exclamation)
        End If
        Return blnSuccess
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_UpdateTablesSUB
    '* 機能　　：データベーステーブル更新(サブ処理⇒更新本体)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：Arg1 = OleDbTransaction(Object)
    '* 　　　　　Arg2 = OleDbCommand(Object)
    '* 　　　　　Arg3 = メッセージヘッダ(String)    ※Ref参照
    '* 　　　　　Arg4 = SQL文(String)               ※Ref参照
    '* 　　　　　Arg5 = 更新テーブルID(String)      ※Ref参照
    '* 　　　　　Arg6 = エラーメッセージ(String)    ※Ref参照(例外は含まれない)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：例外発生時のSQL文を確保するためstrSQLはRef参照引数としている
    '***********************************************************************************************
    Private Function FP_UpdateTablesSUB(ByRef dbTran As OleDb.OleDbTransaction, _
                                        ByRef dbCommand As OleDb.OleDbCommand, _
                                        ByRef strMsgHeader As String, _
                                        ByRef strSQL As String, _
                                        ByRef strTable As String, _
                                        ByRef strMSG As String) As Boolean
        '===========================================================================================
        FP_UpdateTablesSUB = False
        strMSG = String.Empty
        ' 実際の内部登録モード(削除復活で置き換わることがある：このサンプルではないが)
        Dim swUpdMode As Integer = g_intUpdateMode                  ' 実際の登録モード
        strMsgHeader = g_cnsMDBMSG003                               ' 参照失敗
        Dim blnUpdate As Boolean = False                            ' 更新有りフラグ
        Dim tblFldO() As Object = Nothing                           ' レコードフィールド
        Dim tblSQL() As g_typUpdSql                                 ' SQL文テーブル
        ReDim tblSQL(-1)
        '-------------------------------------------------------------------------------------------
        ' 現状レコードの読み出し
        strTable = g_cnsMST_SYAIN
        Dim strWhere As String = " WHERE [SCD]='" & g_strScd & g_cnsSC ' WHERE句
        strSQL = g_cnsSELECT_AST & g_cnsMST_SYAIN & strWhere & g_cnsCOL
        ' DataTableにレコードを読み込む
        Dim dbTbl As DataTable = FP_GetDataTable(dbCommand, strSQL) ' DataTable
        ' 読込レコードがあるか
        If dbTbl.Rows.Count <> 0 Then
            '---------------------------------------------------------------------------------------
            ' 当該キーのレコード有り
            If g_intUpdateMode <> 1 Then
                ' 更新登録は更新可
                blnUpdate = True
                ' 最終的な変更前レコード内容の取得
                tblFldO = dbTbl.Rows(0).ItemArray.Clone
                ' NULLがあり得る日付項目はNothingに変換
                Call GP_ReplaceDateFields(tblFldO, New Integer() {8})
            Else
                strMSG = "この「社員№」は既に登録されています。"
            End If
        Else
            '---------------------------------------------------------------------------------------
            ' 当該キーのレコード無し
            If g_intUpdateMode = 1 Then
                ' 新規登録は登録可
                blnUpdate = True
            Else
                strMSG = "この「社員№」は登録されていません。"
            End If
        End If
        ' データテーブルをクリア
        dbTbl.Clear()
        dbTbl.Reset()
        ' 更新不可の場合は終了
        If Not blnUpdate Then Return False
        '===========================================================================================
        ' 登録更新処理
        '-------------------------------------------------------------------------------------------
        ' 更新SQL文の編集
        If swUpdMode = 1 Then
            ' 新規登録 ⇒ 追加登録SQL文編集(社員マスタ)
            Call GP_MakeInsertSqlS(tblSQL)
            ' 追加登録SQL文編集(配属マスタ)
            Call GP_MakeInsertSqlH(tblSQL)
        Else
            ' 更新登録 ⇒ 更新登録SQL文編集(社員マスタ)
            Call GP_MakeUpdateSqlS(tblFldO, strWhere, tblSQL)
            ' 配属マスタを参照
            strTable = g_cnsMST_HAIZOKU
            strSQL = g_cnsSELECT_AST & g_cnsMST_HAIZOKU & strWhere & g_cnsCOL
            ' DataTableにレコードを読み込む
            dbTbl = FP_GetDataTable(dbCommand, strSQL) ' DataTable
            ' 読込レコードがあるか
            If dbTbl.Rows.Count <> 0 Then
                ' 最終的な変更前レコード内容の取得
                tblFldO = dbTbl.Rows(0).ItemArray.Clone
                ' NULLがあり得る日付項目はNothingに変換
                Call GP_ReplaceDateFields(tblFldO, New Integer() {2})
                ' 更新登録SQL文編集(配属マスタ)
                Call GP_MakeUpdateSqlH(tblFldO, strWhere, tblSQL)
            Else
                ' 追加登録SQL文編集(配属マスタ)
                Call GP_MakeInsertSqlH(tblSQL)
            End If
        End If
        '-------------------------------------------------------------------------------------------
        ' 更新対象があるか
        If tblSQL.Length <> 0 Then
            strMsgHeader = g_cnsMDBMSG002
            ' 登録・更新SQL文を発行
            For Each objSQL As g_typUpdSql In tblSQL
                strTable = objSQL.TableId
                strSQL = objSQL.SQL
                ' コマンド発行
                dbCommand.CommandText = strSQL
                dbCommand.ExecuteNonQuery()
            Next objSQL
            '---------------------------------------------------------
            ' コミット
            dbTran.Commit()
            Return True
        Else
            ' 更新項目無し
            strMSG = "更新対象項目がありませんでした。"
        End If
    End Function

    '***********************************************************************************************
    '* 処理名　：GP_MakeInsertSqlS
    '* 機能　　：追加登録SQL文編集(社員マスタ)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 更新SQL文テーブル(Array:Structure)  ※Ref参照
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_MakeInsertSqlS(ByRef tblSQL() As g_typUpdSql)
        '-------------------------------------------------------------------------------------------
        ' フォーム上のアイテムから更新用テーブルを作成(社員マスタ)
        Dim tblFldN() As Object = FP_SetTableFromItemsS()           ' 新規登録側テーブル
        '-------------------------------------------------------------------------------------------
        ' INSERT文の編集
        Dim strSQL As String = FP_SqlInsertCommon(g_cnsMST_SYAIN, g_tblFld_MST_SYAIN)
        ' 先頭フィールドをセット
        strSQL &= g_cnsSC & tblFldN(0) & g_cnsSC
        Dim intIx As Integer = 1                                    ' フィールドINDEX
        ' 以降を繰り返す
        Do While intIx <= g_tblFld_MST_SYAIN.GetUpperBound(0)
            ' データタイプによる判断(このサンプルは文字列と日付のみ)
            Select Case g_tblFldTyp_MST_SYAIN(intIx)
                Case 5                                              ' 日付
                    strSQL &= g_cnsCOM & FP_SQLDateSUB2(tblFldN(intIx))
                Case Else                                           ' 文字列
                    strSQL &= g_cnsCOM & FP_SQLStringSUB(tblFldN(intIx))
            End Select
            ' 次のフィールドへ
            intIx += 1
        Loop
        strSQL &= g_cnsKOCOL
        ' 更新SQL文テーブルに追加
        Call GP_AppendSqlTable(strSQL, g_cnsMST_SYAIN, tblSQL)
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_MakeInsertSqlH
    '* 機能　　：追加登録SQL文編集(配属マスタ)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 更新SQL文テーブル(Array:Structure)  ※Ref参照
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_MakeInsertSqlH(ByRef tblSQL() As g_typUpdSql)
        '-------------------------------------------------------------------------------------------
        ' フォーム上のアイテムから更新用テーブルを作成(配属マスタ)
        Dim tblFldN() As Object = FP_SetTableFromItemsH()           ' 新規登録側テーブル
        '-------------------------------------------------------------------------------------------
        ' INSERT文の編集
        Dim strSQL As String = FP_SqlInsertCommon(g_cnsMST_HAIZOKU, g_tblFld_MST_HAIZOKU)
        ' 先頭フィールドをセット
        strSQL &= g_cnsSC & tblFldN(0) & g_cnsSC
        Dim intIx As Integer = 1                                    ' フィールドINDEX
        ' 以降を繰り返す
        Do While intIx <= g_tblFld_MST_HAIZOKU.GetUpperBound(0)
            ' データタイプによる判断(このサンプルは文字列と日付のみ)
            Select Case g_tblFldTyp_MST_HAIZOKU(intIx)
                Case 5                                              ' 日付
                    strSQL &= g_cnsCOM & FP_SQLDateSUB2(tblFldN(intIx))
                Case Else                                           ' 文字列
                    strSQL &= g_cnsCOM & FP_SQLStringSUB(tblFldN(intIx))
            End Select
            ' 次のフィールドへ
            intIx += 1
        Loop
        strSQL &= g_cnsKOCOL
        ' 更新SQL文テーブルに追加
        Call GP_AppendSqlTable(strSQL, g_cnsMST_HAIZOKU, tblSQL)
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_MakeUpdateSqlS
    '* 機能　　：更新登録SQL文編集(社員マスタ)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 現行テーブル内容(Array:Object)
    '*           Arg2 = WHERE句(String)
    '* 　　　　　Arg3 = 更新SQL文テーブル(Array:Structure)  ※Ref参照
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_MakeUpdateSqlS(ByVal tblFldO() As Object, _
                                  ByVal strWhere As String, _
                                  ByRef tblSQL() As g_typUpdSql)
        '-------------------------------------------------------------------------------------------
        ' フォーム上のアイテムから更新用テーブルを作成(社員マスタ)
        Dim tblFldN() As Object = FP_SetTableFromItemsS()           ' 新規登録側テーブル
        '-------------------------------------------------------------------------------------------
        ' UPDATE文を編集
        Dim strSQL As String = g_cnsUPDATE & g_cnsMST_SYAIN & g_cnsSET ' SQL文
        Dim intIx As Integer = 1                                    ' フィールドINDEX
        Dim intCntUpd As Integer = 0                                ' 更新項目件数
        ' キー項目以後を繰り返す
        Do While intIx <= g_tblFld_MST_SYAIN.GetUpperBound(0)
            ' 変更がある項目のみSQLに追加
            If tblFldN(intIx) <> tblFldO(intIx) Then
                ' 更新項目件数を加算
                intCntUpd += 1
                ' 2フィールド目以降はカンマを付加
                If intCntUpd > 1 Then
                    strSQL &= g_cnsCOM
                End If
                ' 値が変更されたフィールドのみ更新
                strSQL &= g_tblFld_MST_SYAIN(intIx) & g_cnsEQ
                ' データタイプ判定
                Select Case g_tblFldTyp_MST_SYAIN(intIx)
                    Case 5                                              ' 日付
                        strSQL &= FP_SQLDateSUB2(tblFldN(intIx))
                    Case Else                                           ' 文字列
                        strSQL &= FP_SQLStringSUB(tblFldN(intIx))
                End Select
            End If
            ' 次のフィールドへ
            intIx += 1
        Loop
        ' 更新項目があったか
        If intCntUpd <> 0 Then
            ' WHERE句を接続
            strSQL &= strWhere
            ' 更新SQL文テーブルに追加
            Call GP_AppendSqlTable(strSQL, g_cnsMST_SYAIN, tblSQL)
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_MakeUpdateSqlH
    '* 機能　　：更新登録SQL文編集(配属マスタ)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 現行テーブル内容(Array:Object)
    '*           Arg2 = WHERE句(String)
    '* 　　　　　Arg3 = 更新SQL文テーブル(Array:Structure)  ※Ref参照
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_MakeUpdateSqlH(ByVal tblFldO() As Object, _
                                  ByVal strWhere As String, _
                                  ByRef tblSQL() As g_typUpdSql)
        '-------------------------------------------------------------------------------------------
        ' フォーム上のアイテムから更新用テーブルを作成(配属マスタ)
        Dim tblFldN() As Object = FP_SetTableFromItemsH()           ' 新規登録側テーブル
        '-------------------------------------------------------------------------------------------
        ' UPDATE文を編集
        Dim strSQL As String = g_cnsUPDATE & g_cnsMST_HAIZOKU & g_cnsSET ' SQL文
        Dim intIx As Integer = 1                                    ' フィールドINDEX
        Dim intCntUpd As Integer = 0                                ' 更新項目件数
        ' キー項目以後を繰り返す(開始日の更新を含みます)
        Do While intIx <= g_tblFld_MST_HAIZOKU.GetUpperBound(0)
            ' 変更がある項目のみSQLに追加
            If tblFldN(intIx) <> tblFldO(intIx) Then
                ' 更新項目件数を加算
                intCntUpd += 1
                ' 2フィールド目以降はカンマを付加
                If intCntUpd > 1 Then
                    strSQL &= g_cnsCOM
                End If
                ' 値が変更されたフィールドのみ更新
                strSQL &= g_tblFld_MST_HAIZOKU(intIx) & g_cnsEQ
                ' データタイプ判定
                Select Case g_tblFldTyp_MST_HAIZOKU(intIx)
                    Case 5                                              ' 日付
                        strSQL &= FP_SQLDateSUB2(tblFldN(intIx))
                    Case Else                                           ' 文字列
                        strSQL &= FP_SQLStringSUB(tblFldN(intIx))
                End Select
            End If
            ' 次のフィールドへ
            intIx += 1
        Loop
        ' 更新項目があったか
        If intCntUpd <> 0 Then
            ' WHERE句を接続
            strSQL &= strWhere
            ' 更新SQL文テーブルに追加
            Call GP_AppendSqlTable(strSQL, g_cnsMST_HAIZOKU, tblSQL)
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：FP_SetTableFromItemsS
    '* 機能　　：フォーム上のアイテムから更新用テーブルを作成(社員マスタ)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：テーブル(Array:Object)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年12月05日
    '* 作成者　：井上　治
    '* 更新日　：2013年12月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_SetTableFromItemsS() As Object()
        '-------------------------------------------------------------------------------------------
        Dim tblFldN() As Object                                         ' 新規登録側テーブル
        ReDim tblFldN(g_tblFld_MST_SYAIN.GetUpperBound(0))
        ' 各フィールドをセット
        tblFldN(0) = g_strScd                                           ' (00)社員コード
        tblFldN(1) = TXT_KANJI_SEI.Text.ToString.Trim                   ' (01)漢字姓
        tblFldN(2) = TXT_KANJI_MEI.Text.ToString.Trim                   ' (02)漢字名
        tblFldN(3) = TXT_KANA_SEI.Text.ToString.Trim                    ' (03)カナ姓
        tblFldN(4) = TXT_KANA_MEI.Text.ToString.Trim                    ' (04)カナ名
        tblFldN(5) = CBO_SEX.Text                                       ' (05)性別
        tblFldN(6) = DTP_SEINEN_YMD.Value                               ' (06)生年月日
        tblFldN(7) = DTP_NYUSYA_YMD.Value                               ' (07)入社日
        ' 退職日
        If DTP_TAISYOKU_YMD.Checked Then
            tblFldN(8) = DTP_TAISYOKU_YMD.Value                         ' (08)退職日
        Else
            tblFldN(8) = g_cnsNullDate
        End If
        Return tblFldN
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_SetTableFromItemsH
    '* 機能　　：フォーム上のアイテムから更新用テーブルを作成(配属マスタ)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：テーブル(Array:Object)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年12月05日
    '* 作成者　：井上　治
    '* 更新日　：2013年12月05日
    '* 更新者　：井上　治
    '* 機能説明：このサンプルは入社日時点の配属を作成・更新するのみ
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_SetTableFromItemsH() As Object()
        Dim tblFldN() As Object                                         ' 新規登録側テーブル
        ReDim tblFldN(g_tblFld_MST_HAIZOKU.GetUpperBound(0))
        ' 各フィールドをセット
        tblFldN(0) = g_strScd                                           ' (00)社員コード
        tblFldN(1) = DTP_NYUSYA_YMD.Value                               ' (01)開始日(入社日)
        ' 終了日
        If DTP_TAISYOKU_YMD.Checked Then
            tblFldN(2) = DTP_TAISYOKU_YMD.Value                         ' (02)終了日(退職日)
        Else
            tblFldN(2) = g_cnsNullDate
        End If
        tblFldN(3) = g_tblBusyoCd(CBO_BUSYO.SelectedIndex)              ' (03)部署コード
        tblFldN(4) = g_tblYakuCd(CBO_YAKU.SelectedIndex)                ' (04)役職コード
        Return tblFldN
    End Function

    '***********************************************************************************************
    ' ■■■ サブ処理(表示系) ■■■
    '***********************************************************************************************
    '* 処理名　：FP_ShowSyainInfo
    '* 機能　　：指定社員情報の表示
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_ShowSyainInfo() As Boolean
        '-------------------------------------------------------------------------------------------
        ' 明細内容表示クリア
        Call GP_ClearForm()
        ' 社員マスタ、配属マスタの現在状態を参照(入社日時点のみ)
        Dim dbTbl As DataTable = Nothing                        ' DataTable
        Dim strSQL As String = "SELECT S.[KANJI_SEI]"           ' (00)漢字姓
        strSQL &= ",S.[KANJI_MEI]"                              ' (01)漢字名
        strSQL &= ",S.[KANA_SEI]"                               ' (02)カナ姓
        strSQL &= ",S.[KANA_MEI]"                               ' (03)カナ名
        strSQL &= ",S.[SEX]"                                    ' (04)性別
        strSQL &= ",S.[SEINEN_YMD]"                             ' (05)生年月日
        strSQL &= ",S.[NYUSYA_YMD]"                             ' (06)入社日
        strSQL &= ",S.[TAISYOKU_YMD]"                           ' (07)退職日
        strSQL &= ",H.[BUSYO_CD]"                               ' (08)部署コード
        strSQL &= ",H.[YAKU_CD]"                                ' (09)役職コード
        strSQL &= " FROM (" & g_cnsMST_SYAIN & " AS S"
        strSQL &= g_cnsOUT_JOIN & g_cnsMST_HAIZOKU & " AS H"
        strSQL &= " ON (H.[SCD]=S.[SCD] AND H.[KAISHI_YMD]=S.[NYUSYA_YMD]))"
        strSQL &= " WHERE S.[SCD]='" & g_strScd & g_cnsSCCOL
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, strSQL, g_cnsMST_SYAIN) Then Return False
        ' 各コントロールに値をセット
        TXT_SCD.Text = g_strScd                                 ' 社員コード
        TXT_KANJI_SEI.Text = dbTbl.Rows(0)(0)                   ' 漢字姓
        TXT_KANJI_MEI.Text = dbTbl.Rows(0)(1)                   ' 漢字名
        TXT_KANA_SEI.Text = dbTbl.Rows(0)(2)                    ' カナ姓
        TXT_KANA_MEI.Text = dbTbl.Rows(0)(3)                    ' カナ名
        CBO_SEX.Text = dbTbl.Rows(0)(4)                         ' 性別
        DTP_SEINEN_YMD.Value = dbTbl.Rows(0)(5)                 ' 生年月日
        DTP_NYUSYA_YMD.Value = dbTbl.Rows(0)(6)                 ' 入社日
        ' 退職判定？
        If Not DBNull.Value.Equals(dbTbl.Rows(0)(7)) Then
            DTP_TAISYOKU_YMD.Checked = True
            DTP_TAISYOKU_YMD.Value = dbTbl.Rows(0)(7)
        End If
        ' コンボボックスの選択をコードテーブルで行なう
        Call GP_SetComboIndexByCode(CBO_BUSYO, dbTbl.Rows(0)(8), g_tblBusyoCd) ' 部署
        Call GP_SetComboIndexByCode(CBO_YAKU, dbTbl.Rows(0)(9), g_tblYakuCd) ' 役職
        Return True
    End Function

    '***********************************************************************************************
    '* 処理名　：GP_SetFormCondition
    '* 機能　　：フォームの状態制御
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：本サンプルでは参照モードの動作はありません
    '***********************************************************************************************
    Private Sub GP_SetFormCondition()
        '-------------------------------------------------------------------------------------------
        ' 更新モードによる分岐
        Select Case g_intUpdateMode
            Case 1                          ' 新規登録モード
                ' 社員コードは入力可
                With TXT_SCD
                    .ReadOnly = False
                    .TabStop = True
                    .ForeColor = Color.Black
                    .BackColor = Color.Empty
                    .Select()
                End With
                STS_MODE.Text = g_cnsMODE_ADD
                STS_GUIDE.Text = g_cnsGUIDE_ADD
                BTN_OK.Enabled = True
                '-----------------------------------------------------------------------------------
            Case Else                       ' 更新登録モード
                ' 社員コードは入力不可
                With TXT_SCD
                    .ReadOnly = True
                    .TabStop = False
                    .ForeColor = Color.Blue
                    .BackColor = Color.LightYellow
                End With
                TXT_KANJI_SEI.Select()
                STS_MODE.Text = g_cnsMODE_UPD
                STS_GUIDE.Text = g_cnsGUIDE_UPD
                BTN_OK.Enabled = True
        End Select
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_ClearForm
    '* 機能　　：明細内容表示クリア
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_ClearForm()
        '-------------------------------------------------------------------------------------------
        TXT_SCD.Text = String.Empty
        TXT_KANJI_SEI.Text = String.Empty
        TXT_KANJI_MEI.Text = String.Empty
        TXT_KANA_SEI.Text = String.Empty
        TXT_KANA_MEI.Text = String.Empty
        CBO_SEX.SelectedIndex = 0
        DTP_SEINEN_YMD.Value = Today
        DTP_NYUSYA_YMD.Value = Today
        ' 退職日は一旦チェックを付けて最大日付をセットしてからチェックを外す
        With DTP_TAISYOKU_YMD
            .Checked = True
            .Value = g_cnsMaximumDate
            .Checked = False
        End With
        CBO_BUSYO.SelectedIndex = -1
        CBO_YAKU.SelectedIndex = -1
    End Sub

    '***********************************************************************************************
    '* 処理名　：FP_SetFormList
    '* 機能　　：コンボリスト等の初期セットアップ
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_SetFormList() As Boolean
        '-------------------------------------------------------------------------------------------
        ' 部署コンボリストの生成
        Dim dbTbl As DataTable = Nothing                        ' DataTable
        Dim strSQL As String = "SELECT [BUSYO_CD]"              ' (00)部署コード
        strSQL &= ",[BUSYO_NM]"                                 ' (01)部署名
        strSQL &= g_cnsFROM & g_cnsMST_BUSYO
        strSQL &= " ORDER BY [BUSYO_CD];"
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, strSQL, g_cnsMST_BUSYO) Then Return False
        ' コンボボックスのリストセット
        Call GP_SetComboBoxList(CBO_BUSYO, dbTbl, g_tblBusyoCd)
        '-------------------------------------------------------------------------------------------
        ' 役職コンボリストの生成
        strSQL = "SELECT [YAKU_CD]"                             ' (00)役職コード
        strSQL &= ",[YAKU_NM]"                                  ' (01)役職名
        strSQL &= g_cnsFROM & g_cnsMST_YAKU
        strSQL &= " ORDER BY [YAKU_CD];"
        ' DataTable取得
        If Not g_objAboutMDB.GetDataTableOle(dbTbl, strSQL, g_cnsMST_YAKU) Then Return False
        ' コンボボックスのリストセット
        Call GP_SetComboBoxList(CBO_YAKU, dbTbl, g_tblYakuCd)
        dbTbl.Clear()
        dbTbl.Reset()
        Return True
    End Function

    '***********************************************************************************************
    '   プロパティ
    '***********************************************************************************************
    ' 処理モード(1=新規,2=変更)(Integer)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpUpdateMode As Integer
        Set(value As Integer)
            g_intUpdateMode = value
        End Set
    End Property

    '===============================================================================================
    ' 社員コード(String)
    '-----------------------------------------------------------------------------------------------
    Friend Property prpScd As String
        Get
            Return g_strScd
        End Get
        Set(value As String)
            g_strScd = value
        End Set
    End Property

    '===============================================================================================
    ' 入社日(Date)
    '-----------------------------------------------------------------------------------------------
    Friend ReadOnly Property prpNyusyaYmd As Date
        Get
            Return g_dteNyusyaYmd
        End Get
    End Property

    '===============================================================================================
    ' 更新結果(0=無,1=追加,2=更新,9=削除)(Integer)
    '-----------------------------------------------------------------------------------------------
    Friend ReadOnly Property prpUpdateResult As Integer
        Get
            Return g_intUpdateResult
        End Get
    End Property

    '----------------------------------------<< End of Source >>------------------------------------
End Class