﻿'***************************************************************************************************
'     汎用メッセージボックス共通部(システム共通)            modMessageBox2(Module)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 13/03/17(1.0.4.0)新規作成
' 15/02/05(1.3.0.0)clsMessageBox2よりファイル分離
'***************************************************************************************************
Friend Module modMessageBox2

    '***********************************************************************************************
    ' ■■■ 共通サブ処理(clsMessageBox2用) ■■■
    '***********************************************************************************************
    '* 処理名　：FP_CanUseOwnerForm
    '* 機能　　：FormStartPosition.CenterParent使用可否判定
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：判定結果(Boolean)
    '* 引数　　：Arg1 = OwnerForm(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年02月24日
    '* 作成者　：井上　治
    '* 更新日　：2013年03月07日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Function FP_CanUseOwnerForm(ByVal objOwner As Object) As Boolean
        '-------------------------------------------------------------------------------------------
        If objOwner Is Nothing Then
            Return False
        End If
        ' 引数のフォームが参照可能かを確認
        Dim objOwner2 As Form = Nothing
        Try
            objOwner2 = objOwner
            If ((objOwner2.Left <> 0) OrElse _
                (objOwner2.Top <> 0) OrElse _
                (objOwner2.Width > 10) OrElse _
                (objOwner2.Height > 10) OrElse _
                (objOwner2.WindowState = FormWindowState.Maximized)) Then
                FP_CanUseOwnerForm = True
            Else
                ' 隠しフォームなどが起点となる場合はCenterScreenとなるようにする
                FP_CanUseOwnerForm = False
            End If
        Catch ex As Exception
            ' 参照失敗
            Return False
        End Try
    End Function

    '***********************************************************************************************
    ' ■■■ 共通サブ処理(dlgMessageBox2,dlgMessageBox2D共用) ■■■
    '***********************************************************************************************
    '* 処理名　：GP_SelectButtons
    '* 機能　　：ボタンの指定
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = MessageBoxフォーム(Object)
    '* 　　　　　Arg2 = ボタン指定(MessageBoxButtons)            ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2013年06月06日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_SelectButtons( _
        ByRef objMessageBoxForm As Object, _
        Optional ByVal intButtons As MessageBoxButtons = MessageBoxButtons.OK)
        '-------------------------------------------------------------------------------------------
        With objMessageBoxForm
            Select Case intButtons
                Case MessageBoxButtons.OKCancel
                    ' OK､キャンセル
                    Call GP_SetButton(.Button1, True, "OK", DialogResult.OK)
                    Call GP_SetButton(.Button2, True, "キャンセル", DialogResult.Cancel)
                    Call GP_SetButton(.Button3, False)
                    .ControlBox = True
                    .CancelButton = .Button2
                Case MessageBoxButtons.YesNo
                    ' はい､いいえ
                    Call GP_SetButton(.Button1, True, "はい(&Y)", DialogResult.Yes)
                    Call GP_SetButton(.Button2, True, "いいえ(&N)", DialogResult.No)
                    Call GP_SetButton(.Button3, False)
                    .ControlBox = False
                    .CancelButton = Nothing
                Case MessageBoxButtons.YesNoCancel
                    ' はい､いいえ､キャンセル
                    Call GP_SetButton(.Button1, True, "はい(&Y)", DialogResult.Yes)
                    Call GP_SetButton(.Button2, True, "いいえ(&N)", DialogResult.No)
                    Call GP_SetButton(.Button3, True, "キャンセル", DialogResult.Cancel)
                    .ControlBox = True
                    .CancelButton = .Button3
                Case MessageBoxButtons.RetryCancel
                    ' 再試行､キャンセル
                    Call GP_SetButton(.Button1, True, "再試行(&R)", DialogResult.Retry)
                    Call GP_SetButton(.Button2, True, "キャンセル", DialogResult.Cancel)
                    Call GP_SetButton(.Button3, False)
                    .ControlBox = True
                    .CancelButton = .Button2
                Case MessageBoxButtons.AbortRetryIgnore
                    ' 中止､再試行､無視
                    Call GP_SetButton(.Button1, True, "中止(&A)", DialogResult.Abort)
                    Call GP_SetButton(.Button2, True, "再試行(&R)", DialogResult.Retry)
                    Call GP_SetButton(.Button3, True, "無視(&I)", DialogResult.Ignore)
                    .ControlBox = False
                    .CancelButton = Nothing
                Case Else
                    ' OKボタンのみ
                    Call GP_SetButton(.Button1, True, "OK", DialogResult.OK)
                    Call GP_SetButton(.Button2, False)
                    Call GP_SetButton(.Button3, False)
                    .ControlBox = True
                    .CancelButton = .Button1
            End Select
            .AcceptButton = .Button1
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_SelectIcon
    '* 機能　　：アイコンの指定
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = MessageBoxフォーム(Object)
    '* 　　　　　Arg2 = アイコン指定(MessageBoxIcon)             ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2013年03月17日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_SelectIcon( _
        ByRef objMessageBoxForm As Object, _
        Optional ByVal intIcon As MessageBoxIcon = MessageBoxIcon.None)
        '-------------------------------------------------------------------------------------------
        With objMessageBoxForm
            Select Case intIcon
                Case MessageBoxIcon.Error, MessageBoxIcon.Stop, MessageBoxIcon.Hand
                    ' Error
                    .IMG_ERROR.Visible = True
                    .IMG_EXCLAMATION.Visible = False
                    .IMG_INFORMATION.Visible = False
                    .IMG_QUESTION.Visible = False
                    .PNL_IMAGE.Visible = True
                    System.Media.SystemSounds.Hand.Play()
                Case MessageBoxIcon.Exclamation, MessageBoxIcon.Warning
                    ' Exclamation
                    .IMG_ERROR.Visible = False
                    .IMG_EXCLAMATION.Visible = True
                    .IMG_INFORMATION.Visible = False
                    .IMG_QUESTION.Visible = False
                    .PNL_IMAGE.Visible = True
                    System.Media.SystemSounds.Exclamation.Play()
                Case MessageBoxIcon.Information, MessageBoxIcon.Asterisk
                    ' Information
                    .IMG_ERROR.Visible = False
                    .IMG_EXCLAMATION.Visible = False
                    .IMG_INFORMATION.Visible = True
                    .IMG_QUESTION.Visible = False
                    .PNL_IMAGE.Visible = True
                    System.Media.SystemSounds.Asterisk.Play()
                Case MessageBoxIcon.Question
                    ' Quention
                    .IMG_ERROR.Visible = False
                    .IMG_EXCLAMATION.Visible = False
                    .IMG_INFORMATION.Visible = False
                    .IMG_QUESTION.Visible = True
                    .PNL_IMAGE.Visible = True
                    System.Media.SystemSounds.Question.Play()
                Case Else
                    ' None
                    .IMG_ERROR.Visible = False
                    .IMG_EXCLAMATION.Visible = False
                    .IMG_INFORMATION.Visible = False
                    .IMG_QUESTION.Visible = False
                    .PNL_IMAGE.Visible = False
            End Select
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_SelectDefault
    '* 機能　　：デフォルトの指定
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = MessageBoxフォーム(Object)
    '* 　　　　　Arg2 = デフォルトボタン指定(MessageBoxDefaultButton)※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2013年03月17日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_SelectDefault( _
        ByRef objMessageBoxForm As Object, _
        Optional ByVal objButton As MessageBoxDefaultButton = Nothing)
        '-------------------------------------------------------------------------------------------
        With objMessageBoxForm
            Select Case objButton
                Case MessageBoxDefaultButton.Button2
                    ' Button2がデフォルト
                    .AcceptButton = .Button2
                    .Button1.TabIndex = 2
                    .Button2.TabIndex = 0
                    .Button3.TabIndex = 1
                Case MessageBoxDefaultButton.Button3
                    ' Button3がデフォルト
                    .AcceptButton = .Button3
                    .Button1.TabIndex = 1
                    .Button2.TabIndex = 2
                    .Button3.TabIndex = 0
                Case Else
                    ' Button1がデフォルト
                    .AcceptButton = .Button1
                    .Button1.TabIndex = 0
                    .Button2.TabIndex = 1
                    .Button3.TabIndex = 2
            End Select
        End With
    End Sub

    '***********************************************************************************************
    ' ■■■ 共通サブ処理(Private) ■■■
    '***********************************************************************************************
    '* 処理名　：GP_SetButton
    '* 機能　　：ボタンの指定(個別)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = ボタン(Button)
    '* 　　　　　Arg2 = 表示有無(Boolean)
    '* 　　　　　Arg3 = 表示テキスト(String)
    '* 　　　　　Arg4 = クリック時の戻り値(DialogResult)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2013年03月17日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub GP_SetButton(ByRef objButton As Button, _
                             ByVal blnVisible As Boolean, _
                             Optional ByVal strText As String = "", _
                             Optional ByVal intReturnValue As DialogResult = DialogResult.OK)
        '-------------------------------------------------------------------------------------------
        With objButton
            .Text = strText
            .Visible = blnVisible
            .Tag = intReturnValue
        End With
    End Sub

    '---------------------------------------<< End of Source >>-------------------------------------
End Module

