﻿'***************************************************************************************************
'     汎用メッセージボックスクラス(システム共通：詳細版)    dlgMessageBox2D(Form)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
'   [必要なリソース：イメージ]
'   ・IconError.gif
'   ・IconQuestion.gif
'   ・IconInformation.gif
'   ・IconExclamation.gif
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 12/12/28(1.0.0.0)新規作成
' 13/01/08(1.0.1.0)警告サウンドを追加
' 13/02/05(1.0.1.1)ダイアログ表示明滅の抑制対応
' 13/02/06(1.0.2.0)詳細メッセージフォームの追加対応
' 13/02/12(1.0.3.0)詳細メッセージフォームの強制利用対応、右クリックメニューを追加
' 13/02/13(1.0.3.2)詳細型フォームとの切替方法を変更の対応
' 13/03/17(1.0.4.0)共通サブ処理をモジュールに統合
' 13/03/17(1.0.4.0)Escキーで閉じてしまう件の対応
' 13/06/04(1.0.5.0)ボタンのダブルクリック動作抑制処置を追加
' 13/10/23(1.0.6.0)Form_Shownイベント(g_swShownスイッチ)の追加
' 14/01/20(1.0.6.1)[全般修正]Form_ActivatedのMe.Refresh、Application.DoEventsを削除
' 14/01/20(1.0.6.1)[全般修正]Application.Idleの関連付けをForm_Loadに移動
' 14/01/20(1.0.6.1)[全般修正]FormClosedの追加(RemoveHandlerでApplication.Idle解放)
'***************************************************************************************************
Friend Class dlgMessageBox2D
    '===============================================================================================
    ' デフォルトのフォント
    Private ReadOnly g_cnsDefaultFont As Font = New Font(SystemInformation.MenuFont.Name, 10.0F)
    '-----------------------------------------------------------------------------------------------
    ' 利用クラスとの受け渡し変数
    Private g_intReturnValue As DialogResult = DialogResult.None        ' 戻り値
    '-----------------------------------------------------------------------------------------------
    Private g_blnClosing As Boolean = True                  ' Escキーで閉じられるのを防ぐ
    Private g_swShown As Boolean = False                    ' 初期動作中の打鍵を防ぐ
    Private g_swOmitDoubleClick As Boolean = False          ' ダブルクリック抑制スイッチ
    '-----------------------------------------------------------------------------------------------
    ' 詳細メッセージフォーム表示関連
    Private g_strMessage As String = ""                     ' 現在メッセージ

    '***********************************************************************************************
    ' ■■■ コントロールイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Button_Click
    '* 機能　　：ボタンクリック(Click)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2012年12月28日
    '* 作成者　：井上　治
    '* 更新日　：2013年10月23日
    '* 更新者　：井上　治
    '* 機能説明：３つの機能ボタンのClickイベント
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Button_Click(ByVal sender As Object, _
                             ByVal e As System.EventArgs) Handles Button1.Click, _
                                                                  Button2.Click, _
                                                                  Button3.Click
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック動作抑制
        If g_swOmitDoubleClick OrElse Not g_swShown Then Exit Sub
        ' ※g_swOmitDoubleClickはTrueのまま放置で良い
        g_swOmitDoubleClick = True
        '-------------------------------------------------------------------------------------------
        g_intReturnValue = CType(sender, Button).Tag
        g_blnClosing = True
        Me.Close()
    End Sub

    '***********************************************************************************************
    '* 処理名　：Button_PreviewKeyDown
    '* 機能　　：ボタンキーイベント(PreviewKeyDown)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2013年03月17日
    '* 更新者　：井上　治
    '* 機能説明：３つの機能ボタンのPreviewKeyDownイベント
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Button_PreviewKeyDown(ByVal sender As Object, _
                                      ByVal e As PreviewKeyDownEventArgs) _
                                      Handles Button1.PreviewKeyDown, _
                                              Button2.PreviewKeyDown, _
                                              Button3.PreviewKeyDown, _
                                              TXT_MSG.PreviewKeyDown
        '-------------------------------------------------------------------------------------------
        ' Escキーで閉じられるのを防ぐ
        If e.KeyCode = Keys.Escape Then
            g_blnClosing = False
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：MNU_COPY_MESSAGE_Click
    '* 機能　　：「メッセージをコピー」右クリックメニュークリック(Click)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年02月12日
    '* 作成者　：井上　治
    '* 更新日　：2013年06月04日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub MNU_COPY_MESSAGE_Click(ByVal sender As Object, _
                                       ByVal e As System.EventArgs) _
                                       Handles MNU_COPY_MESSAGE.Click
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック動作抑制
        If g_swOmitDoubleClick Then Exit Sub
        ' ※g_swOmitDoubleClickはTrueのまま放置で良い
        g_swOmitDoubleClick = True
        '-------------------------------------------------------------------------------------------
        ' メッセージの文字列をクリップボードにコピー
        Dim strText As String = "[" & Me.Text & "]"
        strText &= ControlChars.CrLf & ControlChars.CrLf & g_strMessage
        If Not strText.EndsWith(ControlChars.CrLf) Then
            strText &= ControlChars.CrLf
        End If
        Clipboard.SetText(strText)
    End Sub

    '***********************************************************************************************
    ' ■■■ 初期化 ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2012年12月28日
    '* 作成者　：井上　治
    '* 更新日　：2014年01月20日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub New()
        '-------------------------------------------------------------------------------------------
        ' この呼び出しは、Windows フォーム デザイナで必要です。
        InitializeComponent()
        ' フォームデザイナモード時は以下をスキップする
        If Me.DesignMode Then Exit Sub
        '-------------------------------------------------------------------------------------------
        ' フォームの初期化
        With Me
            .Text = String.Empty
            .TXT_MSG.Text = String.Empty
            .TXT_MSG.Font = g_cnsDefaultFont
            .TXT_MSG.ForeColor = Color.Black
            Call modMessageBox2.GP_SelectButtons(Me)
            Call modMessageBox2.GP_SelectIcon(Me)
            Call modMessageBox2.GP_SelectDefault(Me)
            g_intReturnValue = DialogResult.None
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：Application_Idle
    '* 機能　　：アプリケーションアイドルイベント
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年06月04日
    '* 作成者　：井上　治
    '* 更新日　：2013年06月04日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Application_Idle(ByVal sender As Object, ByVal e As System.EventArgs)
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック抑制スイッチのクリア
        g_swOmitDoubleClick = False
    End Sub

    '***********************************************************************************************
    ' ■■■ フォームイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Form_FormClosed
    '* 機能　　：フォームイベント(FormClosed)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2014年01月20日
    '* 作成者　：井上　治
    '* 更新日　：2014年01月20日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_FormClosed(ByVal sender As Object, _
                                ByVal e As FormClosedEventArgs) Handles Me.FormClosed
        '-------------------------------------------------------------------------------------------
        ' アプリケーションアイドルイベントの関連付け破棄
        RemoveHandler Application.Idle, AddressOf Application_Idle
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_FormClosing
    '* 機能　　：フォーム閉鎖動作(FormClosing)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2013年03月17日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_FormClosing(ByVal sender As Object, _
                                 ByVal e As System.Windows.Forms.FormClosingEventArgs) _
                                 Handles Me.FormClosing
        '-------------------------------------------------------------------------------------------
        ' Escキーで閉じられるのを防ぐ
        If Not g_blnClosing Then
            e.Cancel = True
            g_blnClosing = True
            Exit Sub
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_Load
    '* 機能　　：フォームイベント(Load)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2014年01月20日
    '* 作成者　：井上　治
    '* 更新日　：2014年01月20日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        '-------------------------------------------------------------------------------------------
        ' アプリケーションアイドルイベントの関連付け
        AddHandler Application.Idle, AddressOf Application_Idle
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_Shown
    '* 機能　　：フォーム表示完了(Shown)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年10月23日
    '* 作成者　：井上　治
    '* 更新日　：2013年10月23日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_Shown(ByVal sender As Object, _
                           ByVal e As System.EventArgs) Handles Me.Shown
        '-------------------------------------------------------------------------------------------
        g_swOmitDoubleClick = True
        Me.Refresh()
        Me.Activate()
        g_swShown = True
    End Sub

    '***********************************************************************************************
    ' ■■■ 受け渡しプロパティ ■■■
    '***********************************************************************************************
    ' メッセージ(String)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpMessage() As String
        Set(ByVal value As String)
            g_strMessage = value
            TXT_MSG.Text = value
        End Set
    End Property

    '===============================================================================================
    ' タイトル(String)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpTitle() As String
        Set(ByVal value As String)
            Me.Text = value
        End Set
    End Property

    '===============================================================================================
    ' ボタン指定(MessageBoxButtons)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpButtons() As MessageBoxButtons
        Set(ByVal value As MessageBoxButtons)
            Call modMessageBox2.GP_SelectButtons(Me, value)
        End Set
    End Property

    '===============================================================================================
    ' アイコン指定(MessageBoxIcon)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpIcon() As MessageBoxIcon
        Set(ByVal value As MessageBoxIcon)
            Call modMessageBox2.GP_SelectIcon(Me, value)
        End Set
    End Property

    '===============================================================================================
    ' デフォルト指定(MessageBoxDefaultButton)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property prpDefault() As MessageBoxDefaultButton
        Set(ByVal value As MessageBoxDefaultButton)
            Call modMessageBox2.GP_SelectDefault(Me, value)
        End Set
    End Property

    '===============================================================================================
    ' 戻り値(DialogResult)
    '-----------------------------------------------------------------------------------------------
    Friend ReadOnly Property prpReturnValue() As DialogResult
        Get
            Return g_intReturnValue
        End Get
    End Property

    '---------------------------------------<< End of Source >>-------------------------------------
End Class
