﻿'***************************************************************************************************
'     汎用メッセージボックスクラス(システム共通)            clsMessageBox2Ex(Class)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 12/12/28(1.0.0.0)新規作成
' 13/01/28(1.0.1.0)親フォームが参照できない場合の対応を追加
' 13/02/05(1.0.1.0)ダイアログ表示解除直後に親フォームをRefreshさせる対応
' 13/02/06(1.0.2.0)詳細メッセージフォームの追加対応
' 13/02/12(1.0.3.0)詳細メッセージフォームの強制利用対応
' 13/02/13(1.0.3.1)メッセージ本文より先に限度文字数をセットするように変更
' 13/02/13(1.0.3.2)詳細型フォームとの切替方法を変更
' 13/02/24(1.0.3.3)OwnerFormが全くない､スクリーン外の場合はCenterScreenを適用するように対応
' 13/03/07(1.0.3.3)CenterScreenの判定でのフォームサイズ下限を変更
' 13/03/17(1.0.4.0)MessageBoxフォームの共通サブ処理を本モジュールに統合する対応
' 13/03/17(1.0.4.0)DialogShowEx､DialogShowTmメソッドを追加(拡張機能対応)
' 13/06/06(1.0.5.0)ControlBox=False時はCancelButton=Nothingとする対応を追加
' 13/06/06(1.0.5.0)DialogShowEx(dlgMessageBox2Ex使用)の追加対応
' 14/05/11(1.0.7.0)DialogShowEx2(dlgMessageBox2Ex2使用)の追加対応
' 14/06/03(1.0.7.1)親ウィンドウ取得失敗時の対応を追加(失敗時はシステムのMessageBoxを表示)
' 15/02/05(1.3.0.0)DialogShowEx2を削除(clsMessageBox2Ex2に委譲)
'***************************************************************************************************
Public Class clsMessageBox2Ex
    Private g_objOwnerForm As Form = Nothing
    '-----------------------------------------------------------------------------------------------
    ' 詳細メッセージフォーム表示関連
    Private g_intDetailFormLimitCharCnt As Integer = 300    ' 詳細フォーム利用判定文字数
    Private g_blnUseDetailForm As Boolean = False           ' 詳細フォームの強制利用区分

    '***********************************************************************************************
    ' ■■■ メソッド ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(なし)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2012年12月28日
    '* 作成者　：井上　治
    '* 更新日　：2012年12月28日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Public Sub New()
        '-------------------------------------------------------------------------------------------
        g_objOwnerForm = Nothing
    End Sub

    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化(Ownerフォーム指定)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Ownerフォーム(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2012年12月28日
    '* 作成者　：井上　治
    '* 更新日　：2012年12月28日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Public Sub New(ByRef objOwner As Form)
        '-------------------------------------------------------------------------------------------
        g_objOwnerForm = objOwner
    End Sub

    '***********************************************************************************************
    '* 処理名　：DialogShow
    '* 機能　　：メッセージ表示①(Ownerフォーム指定有)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Ownerフォーム(Object)
    '* 　　　　　Arg2 = メッセージ(String)
    '* 　　　　　Arg3 = タイトル(String)                     ※Option
    '* 　　　　　Arg4 = ボタン指定(Object)                   ※Option
    '* 　　　　　Arg5 = アイコン指定(Object)                 ※Option
    '* 　　　　　Arg6 = デフォルト指定(Object)               ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2012年12月28日
    '* 作成者　：井上　治
    '* 更新日　：2014年06月03日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Public Overloads Function DialogShow( _
        ByRef objOwner As Form, _
        ByVal strMessage As String, _
        Optional ByVal strTitle As String = "", _
        Optional ByVal intButtons As MessageBoxButtons = MessageBoxButtons.OK, _
        Optional ByVal intIcon As MessageBoxIcon = MessageBoxIcon.None, _
        Optional ByVal intDefault As MessageBoxDefaultButton = MessageBoxDefaultButton.Button1 _
        ) As DialogResult
        '-------------------------------------------------------------------------------------------
        Try
            ' 表示メッセージの文字数によりフォームを切り分ける
            If ((strMessage.Length > g_intDetailFormLimitCharCnt) OrElse g_blnUseDetailForm) Then
                '-----------------------------------------------------------------------------------
                ' 文字列限度超過につきスクロールバー付きメッセージボックスを表示
                Using objMsgBox As New dlgMessageBox2D
                    With objMsgBox
                        .prpMessage = strMessage
                        .prpTitle = strTitle
                        .prpButtons = intButtons
                        .prpIcon = intIcon
                        .prpDefault = intDefault
                        ' Ownerのフォームが参照可能かを確認
                        If modMessageBox2.FP_CanUseOwnerForm(objOwner) Then
                            .StartPosition = FormStartPosition.CenterParent
                            .ShowDialog(objOwner)
                            objOwner.Refresh()
                        Else
                            .StartPosition = FormStartPosition.CenterScreen
                            .ShowDialog()
                        End If
                        Application.DoEvents()
                        Return .prpReturnValue
                    End With
                End Using
            Else
                '-----------------------------------------------------------------------------------
                ' 通常のメッセージボックスを表示
                Using objMsgBox As New dlgMessageBox2
                    With objMsgBox
                        .prpMessage = strMessage
                        .prpTitle = strTitle
                        .prpButtons = intButtons
                        .prpIcon = intIcon
                        .prpDefault = intDefault
                        ' Ownerのフォームが参照可能かを確認
                        If modMessageBox2.FP_CanUseOwnerForm(objOwner) Then
                            .StartPosition = FormStartPosition.CenterParent
                            .ShowDialog(objOwner)
                            objOwner.Refresh()
                        Else
                            .StartPosition = FormStartPosition.CenterScreen
                            .ShowDialog()
                        End If
                        Application.DoEvents()
                        Return .prpReturnValue
                    End With
                End Using
            End If
        Catch ex As Exception
            '---------------------------------------------------------------------------------------
            ' 失敗時はシステムメッセージボックスを表示(Owner無し)
            Return MessageBox.Show(strMessage, _
                                   strTitle, _
                                   intButtons, _
                                   intIcon, _
                                   intDefault)
        End Try
    End Function

    '***********************************************************************************************
    '* 処理名　：DialogShow
    '* 機能　　：メッセージ表示②(Ownerフォーム指定無)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = メッセージ(String)
    '* 　　　　　Arg2 = タイトル(String)                     ※Option
    '* 　　　　　Arg3 = ボタン指定(Object)                   ※Option
    '* 　　　　　Arg4 = アイコン指定(Object)                 ※Option
    '* 　　　　　Arg5 = デフォルト指定(Object)               ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2012年12月28日
    '* 作成者　：井上　治
    '* 更新日　：2014年06月03日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：Sub Newでフォームが指定されている場合はそのフォームがOwnerになる
    '***********************************************************************************************
    Public Overloads Function DialogShow( _
        ByVal strMessage As String, _
        Optional ByVal strTitle As String = "", _
        Optional ByVal intButtons As MessageBoxButtons = MessageBoxButtons.OK, _
        Optional ByVal intIcon As MessageBoxIcon = MessageBoxIcon.None, _
        Optional ByVal intDefault As MessageBoxDefaultButton = MessageBoxDefaultButton.Button1 _
        ) As DialogResult
        '-------------------------------------------------------------------------------------------
        Try
            ' 表示メッセージの文字数によりフォームを切り分ける
            If ((strMessage.Length > g_intDetailFormLimitCharCnt) OrElse g_blnUseDetailForm) Then
                '-----------------------------------------------------------------------------------
                ' 文字列限度超過につきスクロールバー付きメッセージボックスを表示
                Using objMsgBox As New dlgMessageBox2D
                    With objMsgBox
                        .prpMessage = strMessage
                        .prpTitle = strTitle
                        .prpButtons = intButtons
                        .prpIcon = intIcon
                        .prpDefault = intDefault
                        ' Ownerのフォームが参照可能かを確認
                        If modMessageBox2.FP_CanUseOwnerForm(g_objOwnerForm) Then
                            .StartPosition = FormStartPosition.CenterParent
                            .ShowDialog(g_objOwnerForm)
                            g_objOwnerForm.Refresh()
                        Else
                            .StartPosition = FormStartPosition.CenterScreen
                            .ShowDialog()
                        End If
                        Application.DoEvents()
                        Return .prpReturnValue
                    End With
                End Using
            Else
                '-----------------------------------------------------------------------------------
                ' 通常のメッセージボックスを表示
                Using objMsgBox As New dlgMessageBox2
                    With objMsgBox
                        .prpMessage = strMessage
                        .prpTitle = strTitle
                        .prpButtons = intButtons
                        .prpIcon = intIcon
                        .prpDefault = intDefault
                        ' Ownerのフォームが参照可能かを確認
                        If modMessageBox2.FP_CanUseOwnerForm(g_objOwnerForm) Then
                            .ShowDialog(g_objOwnerForm)
                            .StartPosition = FormStartPosition.CenterParent
                            g_objOwnerForm.Refresh()
                        Else
                            .StartPosition = FormStartPosition.CenterScreen
                            .ShowDialog()
                        End If
                        Application.DoEvents()
                        Return .prpReturnValue
                    End With
                End Using
            End If
        Catch ex As Exception
            '---------------------------------------------------------------------------------------
            ' 失敗時はシステムメッセージボックスを表示(Owner無し)
            Return MessageBox.Show(strMessage, _
                                   strTitle, _
                                   intButtons, _
                                   intIcon, _
                                   intDefault)
        End Try
    End Function

    '***********************************************************************************************
    '* 処理名　：DialogShowEx
    '* 機能　　：メッセージ表示③(Excel出力確認用などにボタン名表示を変更可能)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Ownerフォーム(Object)
    '* 　　　　　Arg2 = メッセージ(String)
    '* 　　　　　Arg3 = メッセージ追加ガイド(String)
    '* 　　　　　Arg4 = ボタン表示テキスト(Array:String)     ※指定時要素数は3固定
    '* 　　　　　Arg5 = タイトル(String)
    '* 　　　　　Arg6 = ボタン指定(Object)
    '* 　　　　　Arg7 = アイコン指定(Object)                 ※Option
    '* 　　　　　Arg8 = デフォルト指定(Object)               ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年06月06日
    '* 作成者　：井上　治
    '* 更新日　：2014年06月03日
    '* 更新者　：井上　治
    '* 機能説明：｢新規インスタンス｣｢既存インスタンス｣等にボタン表示を変更可
    '* 注意事項：スクロールバー付きメッセージボックスの対応は行なわない
    '***********************************************************************************************
    Public Function DialogShowEx( _
        ByRef objOwner As Form, _
        ByVal strMessage As String, _
        ByVal strAddMessage As String, _
        ByVal tblButtonText As String(), _
        ByVal strTitle As String, _
        ByVal intButtons As MessageBoxButtons, _
        Optional ByVal intIcon As MessageBoxIcon = MessageBoxIcon.None, _
        Optional ByVal intDefault As MessageBoxDefaultButton = MessageBoxDefaultButton.Button1 _
        ) As DialogResult
        '-------------------------------------------------------------------------------------------
        Try
            ' Excel出力専用のメッセージボックスを表示
            Using objMsgBox As New dlgMessageBox2Ex
                With objMsgBox
                    .prpMessage = strMessage
                    .prpTitle = strTitle
                    .prpButtons = intButtons
                    .prpIcon = intIcon
                    .prpDefault = intDefault
                    .prpButtonText = tblButtonText
                    .prpMessage2 = strAddMessage
                    ' Ownerのフォームが参照可能かを確認
                    If FP_CanUseOwnerForm(objOwner) Then
                        .StartPosition = FormStartPosition.CenterParent
                        .ShowDialog(objOwner)
                        objOwner.Refresh()
                    Else
                        .StartPosition = FormStartPosition.CenterScreen
                        .ShowDialog()
                    End If
                    Application.DoEvents()
                    Return .prpReturnValue
                End With
            End Using
        Catch ex As Exception
            '---------------------------------------------------------------------------------------
            ' 失敗時はシステムメッセージボックスを表示(Owner無し)
            Return MessageBox.Show(strMessage, _
                                   strTitle, _
                                   intButtons, _
                                   intIcon, _
                                   intDefault)
        End Try
    End Function

    '***********************************************************************************************
    '* 処理名　：DialogShowTm
    '* 機能　　：メッセージ表示⑤(タイマによる自動消失機能対応)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Ownerフォーム(Object)
    '* 　　　　　Arg2 = メッセージ(String)
    '* 　　　　　Arg3 = 自動消失秒数(Integer)
    '* 　　　　　Arg4 = タイトル(String)
    '* 　　　　　Arg5 = ボタン指定(Object)
    '* 　　　　　Arg6 = アイコン指定(Object)
    '* 　　　　　Arg7 = デフォルト指定(Object)               ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2013年03月17日
    '* 作成者　：井上　治
    '* 更新日　：2014年06月03日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：自動消失秒数=0時はタイマ消失機能が無効になります
    '***********************************************************************************************
    Public Overloads Function DialogShowTm( _
        ByRef objOwner As Form, _
        ByVal strMessage As String, _
        ByVal intInterval As Integer, _
        ByVal strTitle As String, _
        ByVal intButtons As MessageBoxButtons, _
        ByVal intIcon As MessageBoxIcon, _
        Optional ByVal intDefault As MessageBoxDefaultButton = MessageBoxDefaultButton.Button1 _
        ) As DialogResult
        '-------------------------------------------------------------------------------------------
        Try
            ' 通常のメッセージボックスを表示(スクロールバー付き不対応)
            Using objMsgBox As New dlgMessageBox2
                With objMsgBox
                    .prpMessage = strMessage
                    .prpTitle = strTitle
                    .prpButtons = intButtons
                    .prpIcon = intIcon
                    .prpDefault = intDefault
                    .prpInterval = intInterval
                    ' Ownerのフォームが参照可能かを確認
                    If modMessageBox2.FP_CanUseOwnerForm(objOwner) Then
                        .StartPosition = FormStartPosition.CenterParent
                        .ShowDialog(objOwner)
                        objOwner.Refresh()
                    Else
                        .StartPosition = FormStartPosition.CenterScreen
                        .ShowDialog()
                    End If
                    Application.DoEvents()
                    Return .prpReturnValue
                End With
            End Using
        Catch ex As Exception
            '---------------------------------------------------------------------------------------
            ' 失敗時はシステムメッセージボックスを表示(Owner無し)
            Return MessageBox.Show(strMessage, _
                                   strTitle, _
                                   intButtons, _
                                   intIcon, _
                                   intDefault)
        End Try
    End Function

    '***********************************************************************************************
    ' ■■■ 受け渡しプロパティ ■■■
    '***********************************************************************************************
    ' 詳細フォーム利用判定文字数(Integer) ※デフォルトは300文字
    '-----------------------------------------------------------------------------------------------
    Public WriteOnly Property prpDetailFormLimitCharCnt() As Integer
        Set(ByVal value As Integer)
            g_intDetailFormLimitCharCnt = value
        End Set
    End Property

    '===============================================================================================
    ' 詳細フォームの強制利用区分(Boolean) ※デフォルトはFalse
    '-----------------------------------------------------------------------------------------------
    Public WriteOnly Property prpUseDetailForm() As Boolean
        Set(ByVal value As Boolean)
            g_blnUseDetailForm = value
        End Set
    End Property

    '---------------------------------------<< End of Source >>-------------------------------------
End Class

