﻿'***************************************************************************************************
'   サンプル用共通モジュール③                                modCommonModule3(Module)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
' 17/01/22(1.0.1.0)更新登録画面追加に関する対応
' 17/04/02(1.0.5.0)プログレスバー表示(GP_SetProgressBarValue)の追加
'***************************************************************************************************
Module modCommonModule3
    '===============================================================================================
    ' [共通定数]
    ' 日付チェック用定数
    Friend Const g_cnsDefaultDate As Date = #12/31/1899#
    Friend Const g_cnsMinimumDate As Date = #1/1/1900#
    Friend Const g_cnsMaximumDate As Date = #12/31/2079#
    ' 日付NULL時の代替値
    Friend Const g_cnsNullDate As Date = Nothing
    ' 標準フォント名
    Friend Const g_cnsStdFontName As String = "ＭＳ ゴシック"
    Friend Const g_cnsStdFontNameP As String = "ＭＳ Ｐゴシック"
    ' 標準フォントサイズ
    Friend Const g_cnsFontSize900 As Single = 9.0F
    Friend Const g_cnsFontSize975 As Single = 9.75F
    ' 共通利用固定文字
    Friend Const g_cnsFormatDate As String = "yyyy-MM-dd"
    Friend Const g_cnsFormatDate2 As String = "yyyy/MM/dd"

    '***********************************************************************************************
    '   ■■■ 一般共通サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：GP_AppendMessage
    '* 機能　　：エラーメッセージ累積処理
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 表示用累積メッセージ(String)
    '* 　　　　　Arg2 = 今回追加メッセージ(String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：改行を加えながらメッセージを追加する
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_AppendMessage(ByRef strMSG As String, ByRef strADDMSG As String)
        '-------------------------------------------------------------------------------------------
        If strMSG.Length <> 0 Then strMSG &= ControlChars.CrLf
        strMSG &= strADDMSG
    End Sub

    '***********************************************************************************************
    '* 処理名　：FP_EditDate
    '* 機能　　：日付表示用編集処理(一覧表示用：デフォルトはyyyy/MM/dd編集)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：編集後の日付(String)
    '* 引数　　：Arg1 = 日付値(Object:String)
    '* 　　　　　Arg2 = 日付フォーマット(String)     ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：Null日付等はブランクが返る
    '***********************************************************************************************
    Friend Function FP_EditDate(ByVal objInDate As Object, _
                                Optional ByVal strDateFormat As String = g_cnsFormatDate2) As String
        '-------------------------------------------------------------------------------------------
        Dim dteDate As Date                                         ' 日付WORK
        Dim strDate As String = String.Empty                        ' 文字列WORK
        ' NULL値でなければ値(文字列)を取り出す
        If ((Not DBNull.Value.Equals(objInDate)) AndAlso (objInDate IsNot Nothing)) Then
            strDate = objInDate.ToString.Trim
        End If
        ' 有効な日付か判定
        If ((strDate.Length <> 0) AndAlso _
            (Date.TryParse(strDate, dteDate)) AndAlso _
            (dteDate >= g_cnsMinimumDate) AndAlso _
            (dteDate < g_cnsMaximumDate)) Then
            ' 日付をフォーマット編集
            Return dteDate.ToString(strDateFormat)
        Else
            ' NGはブランクを返す
            Return String.Empty
        End If
    End Function

    '***********************************************************************************************
    '* 処理名　：GP_ReplaceDateFields
    '* 機能　　：日付項目のNullデータ置き換え
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = データテーブルレコード(DataTable.ItemArray) ※戻り値利用
    '* 　　　　　Arg2 = 日付項目配置INDEXテーブル(Array:Integer)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：Null値をNothingに置き換え、有効日付は内部データ型に置き換える
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_ReplaceDateFields(ByRef tblFLD As Object(), _
                                    ByVal tblIX As Integer())
        '-------------------------------------------------------------------------------------------
        Dim IX As Integer, dteDate As Date
        For IX2 As Integer = 0 To tblIX.GetUpperBound(0)
            IX = tblIX(IX2)
            If DBNull.Value.Equals(tblFLD(IX)) Then
                ' NULLの場合はNothingに置き換え
                tblFLD(IX) = g_cnsNullDate
            Else
                ' 有効日付(NULL以外)の場合は内部日付型で置き換え
                dteDate = tblFLD(IX)
                tblFLD(IX) = dteDate
            End If
        Next IX2
    End Sub

    '***********************************************************************************************
    ' ■■■ コンボボックス関連共通サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：GP_SetComboBoxList
    '* 機能　　：コンボボックスのリストセット
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = コンボボックス(Object)
    '* 　　　　　Arg2 = DataTable(Object)
    '* 　　　　　Arg3 = コードテーブル(Array:String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：コンボボックスのリスト及びコードテーブルを作成する
    '* 注意事項：コンボはメニューコンボでも利用できるようにObject型としている
    '***********************************************************************************************
    Friend Sub GP_SetComboBoxList(ByRef objComboBox As Object, _
                                  ByRef dbTbl As DataTable, _
                                  ByRef tblCode() As String)
        '-------------------------------------------------------------------------------------------
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        Dim intIxMax As Integer = dbTbl.Rows.Count - 1              ' テーブルINDEX上限
        Dim tblName() As String                                     ' 名称テーブル
        ReDim tblCode(intIxMax), tblName(intIxMax)
        ' レコードを巡回
        Do While intIx <= intIxMax
            tblCode(intIx) = dbTbl.Rows(intIx)(0)                   ' (00)コード
            tblName(intIx) = dbTbl.Rows(intIx)(1)                   ' (01)名称
            ' 次へ
            intIx += 1
        Loop
        '-------------------------------------------------------------------------------------------
        ' コンボボックスのリストセット
        With objComboBox.Items
            ' リストクリア
            If .Count <> 0 Then .Clear()
            .AddRange(tblName)
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_SetComboIndexByCode
    '* 機能　　：コンボボックスの選択をコードテーブルで行なう
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = コンボボックス(Object)
    '* 　　　　　Arg2 = 現在コード(String)
    '* 　　　　　Arg3 = コードテーブル(Array:String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：コードテーブルで発見した位置INDEXをコンボボックスのSelectedIndexにセット
    '* 注意事項：コンボはメニューコンボでも利用できるようにObject型としている
    '***********************************************************************************************
    Friend Sub GP_SetComboIndexByCode(ByRef objComboBox As Object, _
                                      ByVal strCode As String, _
                                      ByRef tblCode() As String)
        '-------------------------------------------------------------------------------------------
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        Dim intIx2 As Integer = -1                                  ' テーブルINDEX
        Dim intIxMax As Integer = tblCode.GetUpperBound(0)          ' テーブルINDEX上限
        ' コードテーブルを巡回
        Do While intIx <= intIxMax
            ' コード発見か
            If tblCode(intIx) = strCode Then
                intIx2 = intIx
                Exit Do
            End If
            ' 次へ
            intIx += 1
        Loop
        '-------------------------------------------------------------------------------------------
        ' 発見位置をコンボボックスにセット
        objComboBox.SelectedIndex = intIx2
    End Sub

    '***********************************************************************************************
    '* 処理名　：GP_SetProgressBarValue
    '* 機能　　：プログレスバー表示
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 対象プログレスバー(Object)
    '* 　　　　　Arg2 = Value値(Integer)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年04月02日
    '* 作成者　：井上　治
    '* 更新日　：2017年04月02日
    '* 更新者　：井上　治
    '* 機能説明：Vista以降でもプログレスバーの進捗表示が遅れないように表示する
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_SetProgressBarValue(ByRef objProgressBar As ProgressBar, _
                                      ByVal intValue As Integer)
        '-------------------------------------------------------------------------------------------
        With objProgressBar
            If intValue > .Value Then
                ' 値が増える時
                If intValue < .Maximum Then
                    ' 目的値+1させてから戻す
                    .Value = intValue + 1
                    .Value = intValue
                ElseIf .Value < .Maximum Then
                    ' 最大値を調整
                    .Maximum += 1
                    .Value = .Maximum
                    .Value -= 1
                    .Maximum -= 1
                End If
            Else
                ' 値が減る時はそのまま
                If intValue < .Minimum Then
                    .Value = .Minimum
                Else
                    .Value = intValue
                End If
            End If
        End With
    End Sub

    '----------------------------------------<< End of Source >>------------------------------------
End Module
