﻿'***************************************************************************************************
'   入力コントロールのダブルクリック抑制クラス                   clsOmitDoubleClick2(Class)
'
'   ※ボタン等でダブルクリックしてしまうとClickイベントが2回走ってしまうことを抑制するクラス
'     ⇒本クラスはフォームのLoadイベントで実装すること
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/29(1.0.1.0)新規作成
'***************************************************************************************************
Friend Class clsOmitDoubleClick2
    '===============================================================================================
    Private g_objOwnerForm As Form = Nothing                ' 現在フォーム
    '-----------------------------------------------------------------------------------------------
    Private g_swShown As Boolean = False                    ' 初期表示完了スイッチ
    Private g_swFirstShown As Boolean = True                ' 初回表示判定スイッチ
    Private g_swOmitDoubleClick As Boolean = False          ' ダブルクリック抑制スイッチ

    '***********************************************************************************************
    ' ■■■ クラス初期化メソッド ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Ownerフォーム(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub New(ByRef objOwner As Form)
        '-------------------------------------------------------------------------------------------
        g_objOwnerForm = objOwner                   ' Ownerフォーム
        '-------------------------------------------------------------------------------------------
        ' アプリケーションアイドルイベントの関連付け
        AddHandler Application.Idle, AddressOf Application_Idle
        ' フォームイベント関連付け
        AddHandler g_objOwnerForm.FormClosed, AddressOf Form_FormClosed
    End Sub

    '***********************************************************************************************
    ' ■■■ アプリケーションイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Application_Idle
    '* 機能　　：アプリケーションアイドルイベント
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Application_Idle(ByVal sender As Object, ByVal e As System.EventArgs)
        '-------------------------------------------------------------------------------------------
        ' ダブルクリック抑制スイッチのクリア
        g_swOmitDoubleClick = False
    End Sub

    '***********************************************************************************************
    ' ■■■ フォームイベント ■■■
    '***********************************************************************************************
    '* 処理名　：Form_FormClosed
    '* 機能　　：フォームイベント(FormClosed)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Sub Form_FormClosed(ByVal sender As Object, ByVal e As FormClosedEventArgs)
        '-------------------------------------------------------------------------------------------
        ' アプリケーションアイドルイベントの関連付け解除
        RemoveHandler Application.Idle, AddressOf Application_Idle
    End Sub

    '***********************************************************************************************
    ' ■■■ フォームからの呼び出し処理 ■■■
    '***********************************************************************************************
    '* 処理名　：CheckDoubleClick
    '* 機能　　：ダブルクリック等の多重操作の判定とスイッチセット
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：判定結果(Boolean)                           ※True=処理中
    '* 引数　　：Arg1 = スイッチセットのオミット(Boolean)    ※True=Omit(Option)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Function CheckDoubleClick(Optional ByVal blnOmitSet As Boolean = False) As Boolean
        '-------------------------------------------------------------------------------------------
        CheckDoubleClick = False
        ' ダブルクリック等の多重操作の判定
        If g_swOmitDoubleClick OrElse Not g_swShown Then Return True
        ' ※g_swOmitDoubleClickはTrueのまま放置で良い
        If Not blnOmitSet Then
            g_swOmitDoubleClick = True
        End If
    End Function

    '***********************************************************************************************
    '   プロパティ
    '***********************************************************************************************
    ' 初期表示完了スイッチ(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend Property Shown As Boolean
        Set(value As Boolean)
            g_swShown = value
        End Set
        Get
            Return g_swShown
        End Get
    End Property

    '===============================================================================================
    ' 初回表示判定スイッチ(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend Property FirstShown As Boolean
        Set(value As Boolean)
            g_swFirstShown = value
        End Set
        Get
            Return g_swFirstShown
        End Get
    End Property

    '===============================================================================================
    ' ダブルクリック抑制スイッチ(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend Property OmitDoubleClick As Boolean
        Set(value As Boolean)
            g_swOmitDoubleClick = value
        End Set
        Get
            Return g_swOmitDoubleClick
        End Get
    End Property

    '----------------------------------------<< End of Source >>------------------------------------
End Class
