﻿'***************************************************************************************************
'   未更新終了チェック関連クラス                              clsCheckNotUpdate2(Class)
'
'   ※登録ボタンをClickせずに終了しようとする時の警告表示対応の変数、共通プロシージャ
'     ⇒本クラスはフォームのNewイベントでInitializeComponentの直後に実装すること
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/29(1.0.1.0)新規作成
'***************************************************************************************************
Friend Class clsCheckNotUpdate2
    '-----------------------------------------------------------------------------------------------
    Private g_objOwnerForm As Form = Nothing                    ' 現在フォーム
    Private g_cnsProgTitle As String = "未更新終了チェック"     ' フォームタイトル 
    Private g_swNotUpdate As Boolean = False                    ' 未登録終了警告スイッチ
    Private g_swFatalError As Boolean = False                   ' 致命例外判定スイッチ
    Private g_swLockItem As Boolean = False                     ' 項目ロックスイッチ
    ' 未更新終了警告メッセージ
    Private g_strNotUpdateMSG As String = "「キャンセル」が選択されました。" & ControlChars.CrLf & _
                "入力途中の内容は更新されませんが終了しますか？" ' メッセージ

    '***********************************************************************************************
    ' ■■■ クラス初期化メソッド ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = Ownerフォーム(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub New(ByRef objOwner As Form)
        '-------------------------------------------------------------------------------------------
        g_objOwnerForm = objOwner                   ' Ownerフォーム
        g_cnsProgTitle = objOwner.Text              ' フォームタイトル
        '-------------------------------------------------------------------------------------------
        ' 未登録終了警告スイッチ対応イベントハンドラ追加
        Call GP_ControlsAddHandler(objOwner)
        ' FormClosingイベントハンドラ追加
        AddHandler CType(objOwner, Form).FormClosing, AddressOf Form_FormClosing
        '-------------------------------------------------------------------------------------------
        g_swNotUpdate = False
        g_swFatalError = False
    End Sub

    '***********************************************************************************************
    ' ■■■ サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：GP_ControlsAddHandler
    '* 機能　　：入力コントロールへのイベントハンドラ追加処理
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 所属するコンテナ(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：コンテナ上の各入力コントロールにイベントハンドラを追加(変異検出用)
    '* 注意事項：本処理は再帰動作
    '***********************************************************************************************
    Private Sub GP_ControlsAddHandler(ByVal objContainer As Object)
        '-------------------------------------------------------------------------------------------
        ' コントロールの種別によって変異検出用のイベントハンドラを追加
        For Each objCont As Control In objContainer.Controls
            If TypeOf objCont Is TextBox Then
                ' テキストボックス
                AddHandler CType(objCont, TextBox).TextChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is ComboBox Then
                ' コンボボックス
                With CType(objCont, ComboBox)
                    AddHandler .SelectedIndexChanged, AddressOf Controls_ValueChanged
                    AddHandler .TextChanged, AddressOf Controls_ValueChanged
                End With
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is CheckBox Then
                ' チェックボックス
                AddHandler CType(objCont, CheckBox).CheckedChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is RadioButton Then
                ' ラジオボタン
                AddHandler CType(objCont, RadioButton).CheckedChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is DataGridView Then
                ' DataGridView
                AddHandler CType(objCont, DataGridView).CellValueChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is MaskedTextBox Then
                ' マスクドテキストボックス(DatePickerJP等)
                AddHandler CType(objCont, MaskedTextBox).TextChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is RichTextBox Then
                ' リッチテキストボックス
                AddHandler CType(objCont, RichTextBox).TextChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is ListBox Then
                ' リストボックス
                AddHandler CType(objCont, ListBox).SelectedIndexChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is NumericUpDown Then
                ' ニューメリックアップダウン
                AddHandler CType(objCont, NumericUpDown).ValueChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf TypeOf objCont Is DateTimePicker Then
                ' DateTimePicker
                AddHandler CType(objCont, DateTimePicker).ValueChanged, AddressOf Controls_ValueChanged
                '-----------------------------------------------------------------------------------
            ElseIf ((TypeOf objCont Is TabControl) OrElse _
                    (TypeOf objCont Is TabPage) OrElse _
                    (TypeOf objCont Is GroupBox) OrElse _
                    (TypeOf objCont Is Panel) OrElse _
                    (TypeOf objCont Is TableLayoutPanel) OrElse _
                    (TypeOf objCont Is FlowLayoutPanel) OrElse _
                    (TypeOf objCont Is SplitContainer) OrElse _
                    (TypeOf objCont Is UserControl)) Then
                ' コンテナ時は再帰呼び出し
                Call GP_ControlsAddHandler(objCont)
                '-----------------------------------------------------------------------------------
            End If
        Next objCont
    End Sub

    '***********************************************************************************************
    '   ■■■ イベント
    '***********************************************************************************************
    '* 処理名　：Controls_ValueChanged
    '* 機能　　：各入力コントロールの値変更イベント処理
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：どれかの入力コントロールで更新入力があったかを判断するイベント
    '* 注意事項：Form_Loadイベントで全入力コントロールのイベントハンドラ追加を行なう前提
    '***********************************************************************************************
    Friend Sub Controls_ValueChanged(ByVal sender As Object, ByVal e As System.EventArgs)
        '-------------------------------------------------------------------------------------------
        ' 未登録終了警告スイッチをセット
        If Not g_swNotUpdate Then
            g_swNotUpdate = True
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：Form_FormClosing
    '* 機能　　：フォーム閉じる動作(FormClosing)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月29日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月29日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub Form_FormClosing(ByVal sender As Object, ByVal e As FormClosingEventArgs)
        '-------------------------------------------------------------------------------------------
        ' 未登録終了警告スイッチの判定
        e.Cancel = False
        If (g_swNotUpdate AndAlso Not g_swLockItem AndAlso Not g_swFatalError) Then
            If MessageBox.Show( _
                g_objOwnerForm, _
                g_strNotUpdateMSG, _
                g_cnsProgTitle, _
                MessageBoxButtons.YesNo, _
                MessageBoxIcon.Information) <> Windows.Forms.DialogResult.Yes Then
                e.Cancel = True
                Exit Sub
            End If
        End If
    End Sub

    '***********************************************************************************************
    '   ■■■ 参照・設定プロパティ
    '***********************************************************************************************
    '   未登録終了警告スイッチ(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend Property NotUpdate() As Boolean
        Get
            Return g_swNotUpdate
        End Get
        Set(ByVal value As Boolean)
            g_swNotUpdate = value
        End Set
    End Property

    '===============================================================================================
    '   致命例外判定スイッチ(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend Property FatalError As Boolean
        Get
            Return g_swFatalError
        End Get
        Set(value As Boolean)
            g_swFatalError = value
        End Set
    End Property

    '===============================================================================================
    '   項目ロックスイッチ(Boolean)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property LockItem() As Boolean
        Set(ByVal value As Boolean)
            g_swLockItem = value
        End Set
    End Property

    '===============================================================================================
    '   未登録終了警告メッセージ(String)
    '-----------------------------------------------------------------------------------------------
    Friend WriteOnly Property NotUpdateMSG() As String
        Set(ByVal value As String)
            g_strNotUpdateMSG = value
        End Set
    End Property

    '---------------------------------------<< End of Source >>-------------------------------------
End Class

