﻿'***************************************************************************************************
'   サンプル用ウィンドウ制御関連クラス                       clsAboutWindow1(Class)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
'***************************************************************************************************
Friend Class clsAboutWindow1
    '===============================================================================================
    Private Const g_cnsArrowPoint As Integer = 15                   ' はみ出し許容ポイント
    '-----------------------------------------------------------------------------------------------
    Private g_objOwnerForm As Form = Nothing                        ' 親フォーム

    '***********************************************************************************************
    '   ■■■ 初期化 ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 親フォーム(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub New(ByVal objOwnerForm As Form)
        '-------------------------------------------------------------------------------------------
        g_objOwnerForm = objOwnerForm
    End Sub

    '***********************************************************************************************
    '   ■■■ ウィンドウ制御関連共通サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：FormAdjustLocationSize1
    '* 機能　　：フォーム位置・サイズ制御
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 設定退避位置(Point)
    '* 　　　　　Arg2 = 設定退避サイズ(Size)
    '* 　　　　　Arg3 = デザイン時サイズ(Size)      ※DPI更新後であること
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：フォーム退避値がスクリーンから外れている時はメインスクリーン中央に戻す機能
    '* 注意事項：以下の条件の場合に使用できる
    '* 　　　　　・Windows上に直接出ることができるフォーム(MDI子フォーム等でない)
    '* 　　　　　・親ウィンドウを持たない(隠しベースフォームを除く)
    '* 　　　　　・Sizableフォーム
    '* 　　　　　・設定に位置・サイズを保持させており、この復旧のLoadプロシージャで行なう
    '***********************************************************************************************
    Friend Sub FormAdjustLocationSize1(ByVal objSettingLocation As Point, _
                                       ByVal objSettingSize As Size, _
                                       ByVal objDesigndSize As Size)
        '-------------------------------------------------------------------------------------------
        ' 退避位置未設定、フォーム起動位置手動以外は除外
        If Not FP_CheckEnableAdjust(objSettingLocation) Then Exit Sub
        '-------------------------------------------------------------------------------------------
        Dim objSize As Size = objSettingSize                        ' 設定サイズ
        ' 退避サイズ未設定の場合はデザインサイズを充当
        If ((objSize.Width = 0) AndAlso (objSize.Height = 0)) Then
            objSize = objDesigndSize
        End If
        Dim objLocation As Point = objSettingLocation               ' 設定位置
        Dim objMainScreen As Screen = Nothing                       ' メインスクリーン
        '-------------------------------------------------------------------------------------------
        ' 各スクリーンを巡回してどれかのスクリーン内に収まっているかを確認
        Dim blnOK As Boolean = FP_CheckFormInScreens(objLocation, objSize, objMainScreen) ' 正常判定
        ' どのスクリーンにも収まっていない場合はメインスクリーン内(中央)に移動
        If Not blnOK AndAlso objMainScreen IsNot Nothing Then
            With objMainScreen.WorkingArea
                objLocation = New Point(.Left + (.Width - g_objOwnerForm.Width) \ 2, _
                                        .Top + (.Height - g_objOwnerForm.Height) \ 2)
            End With
            ' サイズは対象フォームのサイズに戻す(変更しない)
            objSize = g_objOwnerForm.Size
        End If
        ' 位置・サイズを設定(サイズが後であること)
        g_objOwnerForm.Location = objLocation
        g_objOwnerForm.Size = objSize
    End Sub

    '***********************************************************************************************
    '* 処理名　：FormSaveSettings1
    '* 機能　　：フォーム位置・サイズ・ウィンドウ状態の退避
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 設定退避位置(Point)
    '* 　　　　　Arg2 = 設定退避サイズ(Size)
    '* 　　　　　Arg3 = 設定退避ウィンドウ状態(Integer)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：フォーム位置・サイズを設定に退避(最大化を伴う場合に使用)
    '* 注意事項：最大化時は原則として退避せずスクリーンが異なる時のみ代替値を退避させる
    '***********************************************************************************************
    Friend Sub FormSaveSettings1(ByRef objSettingLocation As Point, _
                                 ByRef objSettingSize As Size, _
                                 ByRef intWindowState As Integer)
        '-------------------------------------------------------------------------------------------
        ' WindowStateによる判定
        Select Case g_objOwnerForm.WindowState
            Case FormWindowState.Minimized                          ' 最小化
                ' (何もしない)
            Case FormWindowState.Maximized                          ' 最大化
                ' サイズは退避しない(位置は前回退避値が同スクリーンでなければ代替値)
                objSettingLocation = FP_GetPositionDummy(objSettingLocation, _
                                                         objSettingSize)
                intWindowState = g_objOwnerForm.WindowState
            Case Else                                               ' 通常
                ' 全て退避
                objSettingLocation = g_objOwnerForm.Location
                objSettingSize = g_objOwnerForm.Size
                intWindowState = g_objOwnerForm.WindowState
        End Select
    End Sub


    '***********************************************************************************************
    '   ■■■ 共通サブ処理(Private) ■■■
    '***********************************************************************************************
    '* 処理名　：FP_CheckEnableAdjust
    '* 機能　　：フォーム位置制御可能か判定
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理可能判定(Boolean)
    '* 引数　　：Arg1 = 設定退避位置(Point)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_CheckEnableAdjust(ByVal objSettingLocation As Point) As Boolean
        '-------------------------------------------------------------------------------------------
        ' 退避位置未設定、フォーム起動位置手動以外は除外
        If ((objSettingLocation.X = 0) AndAlso _
            (objSettingLocation.Y = 0) AndAlso _
            (g_objOwnerForm.StartPosition <> FormStartPosition.Manual)) Then
            Return False
        End If
        ' フォーム起動位置手動以外は｢手動｣にする
        If g_objOwnerForm.StartPosition <> FormStartPosition.Manual Then
            g_objOwnerForm.StartPosition = FormStartPosition.Manual
        End If
        Return True
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_CheckFormInScreens
    '* 機能　　：指定位置・サイズがどれかのスクリーンに収まっているかの判定
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：正常判定(Boolean)
    '* 引数　　：Arg1 = 指定位置(Point)
    '* 　　　　　Arg2 = 指定サイズ(Size)
    '* 　　　　　Arg3 = メインスクリーン(Screen)            ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_CheckFormInScreens(ByVal objLocation As Point, _
                                           ByVal objSize As Size, _
                                           Optional ByRef objMainScreen As Screen = Nothing) As Boolean
        '-------------------------------------------------------------------------------------------
        ' 位置未設定は失敗
        If ((objLocation.X = 0) AndAlso (objLocation.Y = 0)) Then Return False
        '-------------------------------------------------------------------------------------------
        Dim objBottomRight As Point = New Point(objLocation.X + objSize.Width, _
                                                objLocation.Y + objSize.Height) ' 右下位置
        Dim blnOK As Boolean = False                                ' 設定スクリーン内判定
        '-------------------------------------------------------------------------------------------
        ' 各スクリーンを巡回してどれかのスクリーン内に収まっているかを確認
        For Each objScreen As Screen In Screen.AllScreens
            ' メインスクリーンは別変数に退避
            If objScreen.Primary Then objMainScreen = objScreen
            With objScreen.WorkingArea
                ' フォームがスクリーン内に収まっているか
                If ((objLocation.X >= .Location.X - g_cnsArrowPoint) AndAlso _
                    (objBottomRight.X <= (.Location.X + .Width + g_cnsArrowPoint)) AndAlso _
                    (objLocation.Y >= .Location.Y - g_cnsArrowPoint) AndAlso _
                    (objBottomRight.Y <= (.Location.Y + .Height + g_cnsArrowPoint))) Then
                    blnOK = True
                End If
            End With
        Next objScreen
        Return blnOK
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_GetPositionDummy
    '* 機能　　：代替フォーム位置の取得(最大化時)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：フォーム位置(Point)
    '* 引数　　：Arg1 = 設定退避位置(Point)
    '* 　　　　　Arg2 = 設定退避サイズ(Size)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：フォームが収容されているスクリーンの中央の位置を返す
    '* 注意事項：元の設定値と同じスクリーンの場合は元の設定値を返す
    '***********************************************************************************************
    Private Function FP_GetPositionDummy(ByVal objSettingLocation As Point, _
                                         ByVal objSettingSize As Size) As Point
        '-------------------------------------------------------------------------------------------
        Dim objLoc1 As Point = g_objOwnerForm.Location              ' 現在位置
        Dim objLoc2 As Point = objSettingLocation                   ' 退避位置
        Dim strScr1 As String = String.Empty                        ' 現在スクリーン名
        Dim strScr2 As String = String.Empty                        ' 退避スクリーン名
        Dim objCurrScreen As Screen = Nothing                       ' 現在スクリーン
        '-------------------------------------------------------------------------------------------
        ' 最大化(8P程度マイナスになる)のため誤認を避けるため100Pシフトさせておく
        objLoc1.X += 100
        objLoc1.Y += 100
        ' 各スクリーンを巡回してどれかのスクリーン内に収まっているかを確認
        For Each objScreen As Screen In Screen.AllScreens
            With objScreen.WorkingArea
                ' 現在位置が所属しているか
                If ((objLoc1.X >= .Location.X) AndAlso _
                    (objLoc1.X < (.Location.X + .Width)) AndAlso _
                    (objLoc1.Y >= .Location.Y) AndAlso _
                    (objLoc1.Y < (.Location.Y + .Height))) Then
                    objCurrScreen = objScreen
                    strScr1 = objScreen.DeviceName
                End If
                ' 退避位置が所属しているか
                If ((objLoc2.X >= .Location.X) AndAlso _
                    (objLoc2.X < (.Location.X + .Width)) AndAlso _
                    (objLoc2.Y >= .Location.Y) AndAlso _
                    (objLoc2.Y < (.Location.Y + .Height))) Then
                    strScr2 = objScreen.DeviceName
                End If
            End With
        Next objScreen
        '-------------------------------------------------------------------------------------------
        ' 現在スクリーンと退避スクリーンが同じなら退避値のままとする
        If strScr1 = strScr2 Then
            Return objLoc2
        End If
        '-------------------------------------------------------------------------------------------
        ' 退避サイズがゼロの場合はデザインサイズで充当
        If ((objSettingSize.Width = 0) OrElse (objSettingSize.Height = 0)) Then
            objSettingSize = g_objOwnerForm.Size
        End If
        ' 現在スクリーン上の中央に退避サイズのウィンドウがあるとしてその位置を算出
        With objCurrScreen.WorkingArea
            objLoc2 = New Point(.Location.X + (.Width - objSettingSize.Width) \ 2, _
                                .Location.Y + (.Height - objSettingSize.Height) \ 2)
        End With
        Return objLoc2
    End Function

    '----------------------------------------<< End of Source >>------------------------------------
End Class
