﻿'***************************************************************************************************
'   サンプル用データベースI/O関連定数(MDB用)                   modAboutMDB3(Module)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
'   ※この下に「データベースI/Oクラス(MDB用)(clsAboutMDB)」があります
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
' 17/01/22(1.0.1.0)FP_GetDataTable、GP_AppendSqlTable等を追加(更新登録機能対応)
' 17/02/05(1.0.1.0)FP_SqlInsertCommonの追加(更新登録機能対応)
'***************************************************************************************************
Imports System.IO
Module modAboutMDB3
    '===============================================================================================
    ' WorkTable名
    Friend Const g_cnsMdbTempTable1 As String = "MdbTempTable1"
    Friend Const g_cnsMdbTempTable2 As String = "MdbTempTable2"
    Friend Const g_cnsMdbTempTable3 As String = "MdbTempTable3"
    ' エラーメッセージ
    Friend Const g_cnsMDBMSG001 As String = "データベースに接続できませんでした。"
    Friend Const g_cnsMDBMSG002 As String = "データベースの更新に失敗しました。"
    Friend Const g_cnsMDBMSG003 As String = "データベースの参照に失敗しました。"
    Friend Const g_cnsMDBMSG011 As String = "このコードのデータは既に登録されています。"
    Friend Const g_cnsMDBMSG012 As String = "このコードのデータは登録されていません。"
    Friend Const g_cnsMDBMSG013 As String = "このコードのデータは既に削除済みです。"
    Friend Const g_cnsMDBMSG021 As String = "出力対象データが存在しません。"
    ' MDB共通利用固定文字
    Friend Const g_cnsKA As String = "("
    Friend Const g_cnsKO As String = ")"
    Friend Const g_cnsKA2 As String = "["
    Friend Const g_cnsKO2 As String = "]"
    Friend Const g_cnsFROM As String = " FROM "
    Friend Const g_cnsWHERE As String = " WHERE "
    Friend Const g_cnsSET As String = " SET "
    Friend Const g_cnsIN_JOIN As String = " INNER JOIN "
    Friend Const g_cnsOUT_JOIN As String = " LEFT OUTER JOIN "
    Friend Const g_cnsAND As String = " AND "
    Friend Const g_cnsOR As String = " OR "
    Friend Const g_cnsSELECT As String = "SELECT "
    Friend Const g_cnsSELECT_AST As String = "SELECT * FROM "
    Friend Const g_cnsINSERT As String = "INSERT INTO "
    Friend Const g_cnsUPDATE As String = "UPDATE "
    Friend Const g_cnsDELETE As String = "DELETE FROM "
    Friend Const g_cnsCOM As String = ","
    Friend Const g_cnsSC As String = "'"
    Friend Const g_cnsCOMSC As String = ",'"
    Friend Const g_cnsSCCOM As String = "',"
    Friend Const g_cnsSCCOMSC As String = "','"
    Friend Const g_cnsNULL As String = "NULL"
    Friend Const g_cnsCOMNULL As String = g_cnsCOM & g_cnsNULL
    Friend Const g_cnsSCCOL As String = "';"
    Friend Const g_cnsCOL As String = ";"
    Friend Const g_cnsKOCOL As String = ");"
    Friend Const g_cnsEQ As String = "="
    Friend Const g_cnsEQSC As String = "='"
    Friend Const g_cnsPERSC As String = "%'"
    Friend Const g_cnsSCPER As String = "'%"
    Friend Const g_cnsSH As String = "#"
    '-----------------------------------------------------------------------------------------------
    ' 更新SQL文収容テーブルユーザー定義
    Friend Structure g_typUpdSql
        Dim TableId As String                               ' 更新テーブルID
        Dim SQL As String                                   ' 更新SQL文
    End Structure

    '***********************************************************************************************
    '   ■■■ MDB更新関連サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：FP_GetDataTable
    '* 機能　　：OleDbCommandからDataTableを取得
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：DataTable(Object)
    '* 引数　　：Arg1 = SqlCommand(Object)
    '* 　　　　　Arg2 = SQLのSELECT文(String)
    '* 　　　　　Arg3 = データテーブル名(String)         ※Option(※)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：本処理内で例外は判定していない
    '***********************************************************************************************
    Friend Function FP_GetDataTable(ByRef dbCommand As OleDb.OleDbCommand, _
                                    ByVal strSQL As String, _
                                    Optional ByVal strWorkTable As String = g_cnsMdbTempTable1) _
                                    As DataTable
        '-------------------------------------------------------------------------------------------
        dbCommand.CommandText = strSQL
        Using dbDAdp As New OleDb.OleDbDataAdapter, dbDSet As New DataSet
            ' DataSetを取得
            dbDAdp.SelectCommand = dbCommand
            dbDAdp.Fill(dbDSet, strWorkTable)
            ' DataTableを返す
            FP_GetDataTable = dbDSet.Tables(strWorkTable)
        End Using
    End Function

    '***********************************************************************************************
    '* 処理名　：GP_AppendSqlTable
    '* 機能　　：更新用SQL文テーブルにSQL文を追加
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 追加するSQL文(String)
    '* 　　　　　Arg2 = 追加するテーブルID(String)
    '* 　　　　　Arg3 = SQL文テーブル(Array:g_typUpdSql)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub GP_AppendSqlTable(ByVal strSQL As String, _
                                 ByVal strTableId As String, _
                                 ByRef tblSQL() As g_typUpdSql)
        '-------------------------------------------------------------------------------------------
        Dim intMax As Integer = tblSQL.Length                       ' テーブル最大要素(追加)
        ReDim Preserve tblSQL(intMax)
        With tblSQL(intMax)
            .TableId = strTableId
            .SQL = strSQL
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：FP_SQLStringSUB
    '* 機能　　：SQL文文字列項目補助処理
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：SQL文用項目文字列(String)
    '* 引数　　：Arg1 = 入力項目文字列(String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：Trim処理及びシングルクォーテーション二重化
    '* 注意事項：前後にシングルクォーテーションが付加されます。
    '***********************************************************************************************
    Friend Function FP_SQLStringSUB(ByVal strInText As String) As String
        '-------------------------------------------------------------------------------------------
        Dim strInText2 As String = String.Empty & strInText
        FP_SQLStringSUB = g_cnsSC & strInText2.Trim.Replace("'", "''") & g_cnsSC
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_SQLDateSUB2
    '* 機能　　：SQL文日付項目補助処理(MDB用)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：SQL文用項目文字列(String)
    '* 引数　　：Arg1 = 入力項目日付(Date)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：Trim処理及び日付書式フォーマット
    '* 注意事項：前後にシングルクォーテーションが付加されます。
    '***********************************************************************************************
    Friend Function FP_SQLDateSUB2(ByVal dteInDate As Date) As String
        '-------------------------------------------------------------------------------------------
        If dteInDate <> g_cnsNullDate Then
            Return g_cnsSH & dteInDate.ToString(g_cnsFormatDate) & g_cnsSH
        Else
            Return g_cnsNULL
        End If
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_SqlInsertCommon
    '* 機能　　：SQL(INSERT)文共通部編集
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：SQL文一部文字列(String)
    '* 引数　　：Arg1 = テーブルID(string)
    '* 　　　　　Arg2 = フィールド名配列(Array:String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明："INSERT INTO"から"VALUES ("までを編集
    '* 注意事項：
    '***********************************************************************************************
    Friend Function FP_SqlInsertCommon(ByVal strTableId As String, _
                                       ByRef tblFieldId() As String) As String
        '-------------------------------------------------------------------------------------------
        ' INSERT文の先頭から編集
        Dim strSQL As String = g_cnsINSERT & strTableId
        strSQL &= " (" & tblFieldId(0)
        Dim intIx As Integer = 1                                ' テーブルINDEX
        ' フィールドIDを
        Do While intIx <= tblFieldId.GetUpperBound(0)
            strSQL &= g_cnsCOM & tblFieldId(intIx)
            intIx += 1
        Loop
        strSQL &= ") VALUES ("
        Return strSQL
    End Function

    '---------------------------------------<< End of Source >>-------------------------------------
End Module

'***************************************************************************************************
'   サンプル用データベースI/Oクラス(MDB用)                     clsAboutMDB3(Class)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
' 17/01/22(1.0.1.0)GetConnection、ExecuteSQLErrorの追加(更新登録機能対応)
' 17/03/11(1.0.1.0)ACCDBでの変更箇所をコメントで追加する対応
'***************************************************************************************************
Friend Class clsAboutMDB3
    '===============================================================================================
    Private Const g_cnsMDB_Connect1 = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source='"
    'Private Const g_cnsMDB_Connect1 = "Provider=Microsoft.ACE.OLEDB.12.0;Data Source='" ' ←ACCDBの場合
    '-----------------------------------------------------------------------------------------------
    Private g_strConnectionString As String = ""                    ' 接続文字列
    Private g_objOwnerForm As Form = Nothing                        ' 親フォーム

    '***********************************************************************************************
    '   ■■■ 初期化 ■■■
    '***********************************************************************************************
    '* 処理名　：New
    '* 機能　　：初期化
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = 親フォーム(Object)
    '* 　　　　　Arg2 = MDBファイル名(String)
    '* 　　　　　Arg3 = MDBサブフォルダ名(String)
    '* 　　　　　Arg4 = MDBの接続ユーザーID(String)     ※Option
    '* 　　　　　Arg5 = MDBの接続パスワード(String)     ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub New(ByVal objOwnerForm As Form, _
                   ByVal strMdbFilename As String, _
                   ByVal strMdbSubFolder As String, _
                   Optional ByVal strMdbUserId As String = "", _
                   Optional ByVal strMdbPassword As String = "")
        '-------------------------------------------------------------------------------------------
        g_objOwnerForm = objOwnerForm
        ' MDB接続文字列の編集
        g_strConnectionString = FP_GetMdbConnectionString(strMdbFilename, _
                                                          strMdbSubFolder, _
                                                          strMdbUserId, _
                                                          strMdbPassword)
    End Sub

    '***********************************************************************************************
    '   ■■■ OleDbアクセス関連共通サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：GetDataTableOle
    '* 機能　　：データテーブルを取得(OLE非接続処理)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：処理成否(Boolean)
    '* 引数　　：Arg1 = DataTable(Object)                ※Ref参照(戻り値)
    '* 　　　　　Arg2 = SQL文(String)
    '* 　　　　　Arg3 = 参照テーブルID(String)           ※カッコ付きテーブル名
    '* 　　　　　Arg4 = エラーメッセージ(String)         ※Option(エラー表示させない時の通知用)
    '* 　　　　　Arg5 = データテーブル名(String)         ※Option
    '* 　　　　　Arg6 = エラー表示スイッチ(Boolean)      ※Option(内部でエラー表示させる)
    '* 　　　　　Arg7 = 無データエラースイッチ(Boolean)  ※Option(0件をエラー扱いにしない)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：データテーブル名は"MdbTempTable1"がデフォルト
    '* 注意事項：
    '***********************************************************************************************
    Friend Function GetDataTableOle(ByRef dbTbl As DataTable, _
                                    ByVal strSQL As String, _
                                    ByVal strTableName As String, _
                                    Optional ByRef strFatalErrMSG As String = "", _
                                    Optional ByVal strWorkTable As String = g_cnsMdbTempTable1, _
                                    Optional ByVal swDispError As Boolean = True, _
                                    Optional ByVal swNoDataError As Boolean = False) As Boolean
        '-------------------------------------------------------------------------------------------
        Dim strMSG As String = g_cnsMDBMSG001                       ' エラーメッセージ
        dbTbl = Nothing
        Using dbCon As New OleDb.OleDbConnection, dbDSet As New DataSet
            Try
                '-----------------------------------------------------------------------------------
                ' MDBコネクションを取得
                dbCon.ConnectionString = g_strConnectionString
                '-----------------------------------------------------------------------------------
                ' 参照SQLの発行(DataAdapter)
                strMSG = g_cnsMDBMSG003
                Using dbDAdp As New OleDb.OleDbDataAdapter(strSQL, dbCon)
                    ' DataSetを取得
                    dbDAdp.Fill(dbDSet, strWorkTable)
                    ' DataTableを返す
                    dbTbl = dbDSet.Tables(strWorkTable)
                    ' 0件確認
                    If (swNoDataError AndAlso (dbTbl.Rows.Count = 0)) Then
                        ' 0件をエラーとする場合の処置
                        strFatalErrMSG = g_cnsMDBMSG021 & FP_ChangeRoundBrackets(strTableName)
                        ' メッセージ表示
                        If swDispError Then
                            MessageBox.Show(g_objOwnerForm, _
                                            strFatalErrMSG, _
                                            g_objOwnerForm.Text, _
                                            MessageBoxButtons.OK, _
                                            MessageBoxIcon.Error)
                        End If
                        Return False
                    End If
                End Using
                Return True

            Catch ex As Exception
                '-----------------------------------------------------------------------------------
                ' 接続・参照不成功(一般例外)
                strFatalErrMSG = strMSG & FP_ChangeRoundBrackets(strTableName) & _
                    ControlChars.CrLf & ex.Message
                ' メッセージ表示
                If swDispError Then
                    MessageBox.Show(g_objOwnerForm, _
                                    strFatalErrMSG, _
                                    g_objOwnerForm.Text, _
                                    MessageBoxButtons.OK, _
                                    MessageBoxIcon.Error)
                End If
                Return False
            End Try
        End Using
    End Function

    '***********************************************************************************************
    '* 処理名　：GetConnection
    '* 機能　　：OleDbConnectionの取得
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：OleDbConnection(Object)
    '* 引数　　：Arg1 = 処理成否(Boolean)                ※Ref参照
    '* 　　　　　Arg2 = エラーメッセージ(String)         ※Option(エラー表示させない時の通知用)
    '* 　　　　　Arg3 = エラー表示スイッチ(Boolean)      ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Function GetConnection(ByRef blnResult As Boolean, _
                                  Optional ByRef strFatalErrMSG As String = "", _
                                  Optional ByVal swDispError As Boolean = True) _
                                  As OleDb.OleDbConnection
        '-------------------------------------------------------------------------------------------
        Try
            blnResult = True
            Return New OleDb.OleDbConnection(g_strConnectionString)
        Catch ex As Exception
            strFatalErrMSG = ex.Message
            ' メッセージ表示
            If swDispError Then
                MessageBox.Show(g_objOwnerForm, _
                                strFatalErrMSG, _
                                g_objOwnerForm.Text, _
                                MessageBoxButtons.OK, _
                                MessageBoxIcon.Error)
            End If
            blnResult = False
            Return Nothing
        End Try
    End Function

    '***********************************************************************************************
    '* 処理名　：ExecuteSQLError
    '* 機能　　：更新SQLエラー処理(致命エラー扱い)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = エラーメッセージ(String)
    '* 　　　　　Arg2 = 処理工程(String)
    '* 　　　　　Arg3 = 更新テーブルID(String)
    '* 　　　　　Arg5 = SQL文(String)                ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月22日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub ExecuteSQLError(ByVal strErrMessage As String, _
                               ByVal strWork As String, _
                               ByVal strTableId As String, _
                               Optional ByVal strSQL As String = "")
        '-------------------------------------------------------------------------------------------
        Dim strMSG As String = String.Empty                     ' エラーメッセージ
        ' エラーメッセージの編集
        If strWork.Length <> 0 Then
            strMSG = strWork & FP_ChangeRoundBrackets(strTableId) & ControlChars.CrLf & _
                     strErrMessage
        Else
            strMSG = strErrMessage
            If strTableId.Length <> 0 Then
                strMSG &= FP_ChangeRoundBrackets(strTableId)
            End If
        End If
        ' SQL文があれば接続
        If strSQL.Length <> 0 Then
            strMSG &= ControlChars.CrLf & strSQL
        End If
        ' エラーメッセージの表示
        MessageBox.Show(g_objOwnerForm, _
                        strMSG, _
                        g_objOwnerForm.Text, _
                        MessageBoxButtons.OK, _
                        MessageBoxIcon.Error)
    End Sub

    '***********************************************************************************************
    '   ■■■ 共通サブ処理(Private) ■■■
    '***********************************************************************************************
    '* 処理名　：FP_GetMdbConnectionString
    '* 機能　　：MDB接続文字列の編集
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：MDB接続文字列(String)
    '* 引数　　：Arg1 = MDBファイル名(String)
    '* 　　　　　Arg2 = マイドキュメント配下のサブフォルダ(String)
    '* 　　　　　Arg3 = ユーザーID(String)
    '* 　　　　　Arg4 = パスワード(String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：マイドキュメント配下のサブフォルダを指定してMDB接続文字列を編集
    '* 注意事項：
    '***********************************************************************************************
    Private Function FP_GetMdbConnectionString(ByVal strMDBName As String, _
                                               ByVal strSubFolder As String, _
                                               ByVal strUserId As String, _
                                               ByVal strPassword As String) As String
        '-------------------------------------------------------------------------------------------
        Dim strPathname As String = My.Computer.FileSystem.SpecialDirectories.MyDocuments ' フォルダ
        ' サブフォルダ指定あり
        If strSubFolder.Length <> 0 Then
            strPathname = Path.Combine(strPathname, strSubFolder)
        End If
        ' MDBファイル名を接続したフルパス名を編集
        Dim strFilename As String = Path.Combine(strPathname, strMDBName) ' ファイル名
        ' MDBの接続文字列を編集
        Dim strConnectionString As String = g_cnsMDB_Connect1       ' 接続文字列
        strConnectionString &= strFilename & g_cnsSCCOL
        ' ユーザーIDが指定されている
        If strUserId.Length <> 0 Then
            strConnectionString &= "User ID='" & strUserId & g_cnsSCCOL
        End If
        ' パスワードが指定されている
        If strPassword.Length <> 0 Then
            strConnectionString &= "Password='" & strPassword & g_cnsSCCOL
        End If
        Return strConnectionString
    End Function

    '***********************************************************************************************
    '* 処理名　：FP_ChangeRoundBrackets
    '* 機能　　：鍵カッコを丸カッコに変換(共通処理)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：変換後文字列(String)
    '* 引数　　：Arg1 = 変換前文字列(String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月22日
    '* 更新者　：井上　治
    '* 機能説明：例："[TableName]"を"(TableName)"に変換する(例外メッセージ表示用)
    '* 注意事項：先頭文字が"["でない場合はそのまま返す
    '***********************************************************************************************
    Private Function FP_ChangeRoundBrackets(ByVal strInTableName As String) As String
        '-------------------------------------------------------------------------------------------
        Const cnsKOKA2 As String = "].["
        Const cnsDOT As String = "."
        If strInTableName.Length = 0 Then Return strInTableName
        ' 先頭文字が"["か
        If strInTableName.StartsWith(g_cnsKA2) Then
            ' 中間の"].["を"."のみに変換
            Dim strText As String = strInTableName.Replace(cnsKOKA2, cnsDOT)
            ' 先頭文字が"["の場合は丸カッコに変換する
            Return g_cnsKA & strText.Substring(1, strText.Length - 2) & g_cnsKO
        ElseIf strInTableName.StartsWith(g_cnsKA) Then
            ' 先頭文字が"("の場合はそのまま返す
            Return strInTableName
        ElseIf strInTableName.EndsWith(g_cnsKO2) Then
            ' 右端のみ"]"が付いている場合の対応
            Dim strText As String = strInTableName.Substring(0, strInTableName.Length - 1)
            Return g_cnsKA & strText & g_cnsKO
        Else
            ' 上記以外の場合は"("～")"で挟む
            Return g_cnsKA & strInTableName & g_cnsKO
        End If
    End Function

    '----------------------------------------<< End of Source >>------------------------------------
End Class
