﻿'***************************************************************************************************
'   サンプル用DataGridView制御関連定数・変数                  modAboutDataGridView1(Module)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
'   ※この下に「DataGridView制御関連クラス(clsAboutDataGridView3)」があります
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
'***************************************************************************************************
Module modAboutDataGridView1
    '===============================================================================================
    ' DataGridViewの位置
    Friend Const g_cnsDG_ML As DataGridViewContentAlignment = DataGridViewContentAlignment.MiddleLeft
    Friend Const g_cnsDG_MC As DataGridViewContentAlignment = DataGridViewContentAlignment.MiddleCenter
    Friend Const g_cnsDG_MR As DataGridViewContentAlignment = DataGridViewContentAlignment.MiddleRight
    ' DataGridViewのSortOrder
    Friend Const g_cnsSO_Ascending As SortOrder = Windows.Forms.SortOrder.Ascending
    Friend Const g_cnsSO_Descending As SortOrder = Windows.Forms.SortOrder.Descending
    Friend Const g_cnsSO_None As SortOrder = Windows.Forms.SortOrder.None
    ' DataGridViewのSortMode
    Friend Const g_cnsSM_Programmatic As DataGridViewColumnSortMode = _
        DataGridViewColumnSortMode.Programmatic
    Friend Const g_cnsSM_NotSortable As DataGridViewColumnSortMode = _
        DataGridViewColumnSortMode.NotSortable
    '-----------------------------------------------------------------------------------------------
    ' DataGridViewのカラム設定用ユーザー定義
    Friend Structure g_typDGVColInfo
        Dim dgvCaption As String                        ' 見出し表示名
        Dim dgvWidth As Integer                         ' カラム表示幅
        Dim dgvAlign As DataGridViewContentAlignment    ' 水平配置
        Dim dgvSortMode As DataGridViewColumnSortMode   ' Sortモード
    End Structure

    '----------------------------------------<< End of Source >>------------------------------------
End Module

'***************************************************************************************************
'   サンプル用DataGridView制御関連クラス                      clsAboutDataGridView3(Class)
'
'   作成者:井上治  URL:https://www.ne.jp/asahi/excel/inoue/ [Excelでお仕事!]
'***************************************************************************************************
' 変更日付 Rev     変更履歴内容-------------------------------------------------------------------->
' 17/01/15(1.0.0.0)新規作成
' 17/02/05(1.0.3.0)｢追加行へのスクロール移動(ScrollToAddedRow)｣の追加
'***************************************************************************************************
Friend Class clsAboutDataGridView3

    '***********************************************************************************************
    '   ■■■ DataGridView関連共通サブ処理 ■■■
    '***********************************************************************************************
    '* 処理名　：SetColumnInfo
    '* 機能　　：DataGridViewのカラム情報テーブル登録
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = カラム情報テーブル(Array:g_typDGVColInfo)
    '*　　　　　 Arg2 = 見出し表示文字列(String)
    '*　　　　　 Arg3 = カラム表示幅(Integer)
    '*　　　　　 Arg4 = 水平配置(DataGridViewContentAlignment)   ※Option
    '*　　　　　 Arg5 = Sortモード(DataGridViewColumnSortMode)   ※Option
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：カラム情報の見出し名､表示幅､配置､Sortモードをカラム順にセット
    '* 注意事項：INDEXは順次加算されるのでテーブルはデフォルトをNothingとする
    '***********************************************************************************************
    Friend Sub SetColumnInfo(ByRef DGVColInfo() As g_typDGVColInfo, _
                             ByVal Caption As String, _
                             ByVal Width As Integer, _
                             Optional ByVal Align As DataGridViewContentAlignment = g_cnsDG_ML, _
                             Optional ByVal SortMode As DataGridViewColumnSortMode = _
                                 DataGridViewColumnSortMode.Automatic)
        '-------------------------------------------------------------------------------------------
        ' テーブル要素を追加
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        ' 既にテーブルが作成済みか
        If DGVColInfo IsNot Nothing Then
            ' [作成済]要素を追加
            intIx = DGVColInfo.Length
            ReDim Preserve DGVColInfo(intIx)
        Else
            ' [未作成]初期化
            ReDim DGVColInfo(intIx)
        End If
        '-------------------------------------------------------------------------------------------
        ' テーブルに追加
        With DGVColInfo(intIx)
            .dgvCaption = Caption           ' 見出し表示名
            .dgvWidth = Width               ' カラム表示幅
            .dgvAlign = Align               ' 水平配置
            .dgvSortMode = SortMode         ' Sortモード
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：GetDefaultColumnWidth
    '* 機能　　：カラム情報テーブルよりカラム幅一次テーブルを作成
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：カラム幅一次テーブル(Array:Integer)
    '* 引数　　：Arg1 = カラム情報テーブル(Array:g_typDGVColInfo)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：｢列リセット｣用カラム幅一次テーブルを作成する
    '* 注意事項：
    '***********************************************************************************************
    Friend Function GetDefaultColumnWidth(ByRef DGVColInfo() As g_typDGVColInfo) As Integer()
        '-------------------------------------------------------------------------------------------
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        Dim intIxMax As Integer = DGVColInfo.GetUpperBound(0)       ' テーブルINDEX上限
        Dim tblDefaultColumnWidth(intIxMax) As Integer              ' カラム情報テーブルWORK
        ' 全件繰り返す
        Do While intIx <= intIxMax
            tblDefaultColumnWidth(intIx) = DGVColInfo(intIx).dgvWidth
            ' 次へ
            intIx += 1
        Loop
        Return tblDefaultColumnWidth.Clone
    End Function

    '***********************************************************************************************
    '* 処理名　：GP_AdjustColumnWidth
    '* 機能　　：カラム情報テーブルのカラム幅再調整
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = カラム情報テーブル(Array:g_typDGVColInfo)
    '*　　　　　 Arg2 = 設定文字列(String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：列幅の配列を設定退避値で置き換える
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub AdjustColumnWidth(ByRef DGVColInfo() As g_typDGVColInfo, _
                                 ByVal strSettingString As String)
        '-------------------------------------------------------------------------------------------
        ' 設定退避値が登録済みか
        If ((strSettingString IsNot Nothing) AndAlso (strSettingString.Length <> 0)) Then
            ' 設定文字列を配列に変換(セパレータはTab)
            Dim tblWidth2() As String = strSettingString.Split(ControlChars.Tab) ' 一時テーブル
            ' 配列要素の一致を確認
            If ((DGVColInfo.Length > 2) AndAlso (tblWidth2.Length > 2)) Then
                Dim intIx As Integer = 0                                ' テーブルINDEX
                Dim intIxMax As Integer = DGVColInfo.GetUpperBound(0)   ' テーブルINDEX上限
                ' 設定値で配列を置き換える
                If tblWidth2.GetUpperBound(0) < intIxMax Then
                    intIxMax = tblWidth2.GetUpperBound(0)
                End If
                ' 全件繰り返す
                Do While intIx <= intIxMax
                    DGVColInfo(intIx).dgvWidth = Integer.Parse(tblWidth2(intIx).Trim)
                    ' 次へ
                    intIx += 1
                Loop
            End If
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：InitDataGridView1
    '* 機能　　：DataGridViewの初期設定(一般一覧用)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = DataGridView(Object)
    '*　　　　　 Arg2 = カラム情報テーブル(Array:g_typDGVColInfo)
    '*　　　　　 Arg3 = 固定見出し列INDEX(Integer)       ※Option(デフォルト:-1)
    '*　　　　　 Arg4 = 見出し高さ(Integer)              ※Option(デフォルト:20)
    '*　　　　　 Arg5 = 選択モード(DGVSelectionMode)     ※Option(デフォルト:FullRow)
    '*　　　　　 Arg6 = 読み取り専用(Boolean)            ※Option(デフォルト:True)
    '*　　　　　 Arg7 = 列幅変更可否(Boolean)            ※Option(デフォルト:True)
    '*　　　　　 Arg8 = 列位置変更可否(Boolean)          ※Option(デフォルト:True)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub InitDataGridView1(ByRef objDGV As DataGridView, _
                                 ByRef DGVColInfo() As g_typDGVColInfo, _
                                 Optional ByVal FrozenColIndex As Integer = -1, _
                                 Optional ByVal ColumnHeadersHeight As Integer = 20, _
                                 Optional ByVal SelectionMode As DataGridViewSelectionMode = _
                                     DataGridViewSelectionMode.FullRowSelect, _
                                 Optional ByVal blnReadOnly As Boolean = True, _
                                 Optional ByVal AllowUserToResizeColumns As Boolean = True, _
                                 Optional ByVal AllowUserToOrderColumns As Boolean = True)
        '-------------------------------------------------------------------------------------------
        Dim intIx As Integer = 0                                    ' テーブルINDEX
        Dim intIxMax As Integer = DGVColInfo.GetUpperBound(0)       ' テーブルINDEX上限
        '-------------------------------------------------------------------------------------------
        ' ForeColor、BackColorの調整
        Dim objBackColor As Color = Color.FromArgb(240, 240, 240)
        Dim objForeColor As Color = Color.Green
        '-------------------------------------------------------------------------------------------
        ' DataGridViewの初期設定
        With objDGV
            .AutoSize = False                                       ' 自動サイズ無し(固定)
            .AllowUserToResizeColumns = AllowUserToResizeColumns    ' 列幅変更可否
            .AllowUserToOrderColumns = AllowUserToOrderColumns      ' 列位置変更可否
            .AllowUserToResizeRows = False                          ' 行高変更不可(固定)
            .EnableHeadersVisualStyles = False                      ' Visualスタイルを使用しない(固定)
            .RowHeadersVisible = False                              ' 行見出し有無
            .ColumnHeadersVisible = True                            ' 列見出し有無
            .ReadOnly = blnReadOnly                                 ' 読み取り専用
            .ColumnHeadersHeightSizeMode = _
                DataGridViewColumnHeadersHeightSizeMode.DisableResizing ' (固定)
            With .ColumnHeadersDefaultCellStyle
                .Alignment = DataGridViewContentAlignment.MiddleCenter  ' (固定)
                .BackColor = objBackColor                           ' 列見出し背景色
                .ForeColor = objForeColor                           ' 列見出し文字色
            End With
            .ColumnHeadersHeight = ColumnHeadersHeight              ' 列見出し高さ
            .SelectionMode = SelectionMode                          ' 選択モード
            .MultiSelect = False                                    ' 複数選択
            .ColumnCount = intIxMax + 1                             ' 列数
            ' 各列の設定
            Do While intIx <= intIxMax
                With .Columns(intIx)
                    .Width = DGVColInfo(intIx).dgvWidth
                    .HeaderText = DGVColInfo(intIx).dgvCaption
                    .AutoSizeMode = DataGridViewAutoSizeColumnMode.None
                    .DefaultCellStyle.Alignment = DGVColInfo(intIx).dgvAlign
                    .SortMode = DGVColInfo(intIx).dgvSortMode
                End With
                ' 次列へ
                intIx += 1
            Loop
            If FrozenColIndex >= 0 Then
                .Columns(FrozenColIndex).Frozen = True              ' 設定列で列固定
            End If
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：AdjustDGVColumnDisplayIndex
    '* 機能　　：DataGridViewのカラム配置再調整
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = DataGridView(Object)
    '*　　　　　 Arg2 = 設定文字列(String)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：列配置を設定退避値で置き換える
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub AdjustDGVColumnDisplayIndex(ByRef objDGV As DataGridView, _
                                           ByVal strSettingString As String)
        '-------------------------------------------------------------------------------------------
        If ((strSettingString IsNot Nothing) AndAlso (strSettingString.Length <> 0)) Then
            ' 設定文字列を配列に変換(セパレータはTab)
            Dim tblDisplayIndexS() As String = strSettingString.Split(ControlChars.Tab) ' WORK
            Dim intIxMax As Integer = tblDisplayIndexS.GetUpperBound(0) ' テーブルINDEX上限
            Dim tblDisplayIndex(intIxMax) As Integer                ' 設定値テーブル
            Dim tblIndex(intIxMax) As Integer                       ' 位置テーブル
            Dim intIx As Integer = 0                                ' テーブルINDEX
            Do While intIx <= intIxMax
                tblDisplayIndex(intIx) = Integer.Parse(tblDisplayIndexS(intIx).Trim)
                tblIndex(intIx) = intIx
                ' 次へ
                intIx += 1
            Loop
            ' 表示順の若い方からセットするために並替え
            Array.Sort(tblDisplayIndex, tblIndex)
            ' DataGridView
            With objDGV
                ' カラム数調整
                If intIxMax >= .Columns.Count Then
                    intIxMax = .Columns.Count - 1
                End If
                intIx = 0
                ' 全列を巡回
                Do While intIx <= intIxMax
                    ' 位置が上限以内
                    If tblIndex(intIx) <= intIxMax Then
                        .Columns(tblIndex(intIx)).DisplayIndex = intIx
                    End If
                    ' 次列へ
                    intIx += 1
                Loop
            End With
        End If
    End Sub

    '***********************************************************************************************
    '* 処理名　：GetDGVColumnWidth
    '* 機能　　：DataGridViewのカラム幅の取得
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：設定退避用に文字列(String)
    '* 引数　　：Arg1 = DataGridView(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：DataGridViewのカラム幅を設定退避用に文字列で取得
    '* 注意事項：
    '***********************************************************************************************
    Friend Function GetDGVColumnWidth(ByRef objDGV As DataGridView) As String
        '-------------------------------------------------------------------------------------------
        Dim strTEXT As String = String.Empty                        ' テキストWORK
        Dim intIx As Integer = 1                                    ' テーブルINDEX
        ' DataGridView
        With objDGV
            strTEXT = .Columns(0).Width.ToString
            ' 全列の幅をTabを挟んで接合
            Do While intIx < .Columns.Count
                strTEXT &= ControlChars.Tab & .Columns(intIx).Width.ToString
                ' 次へ
                intIx += 1
            Loop
        End With
        Return strTEXT
    End Function

    '***********************************************************************************************
    '* 処理名　：GetDGVColumnDisplayIndex
    '* 機能　　：DataGridViewのカラム配置の取得
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：設定退避用に文字列(String)
    '* 引数　　：Arg1 = DataGridView(Object)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：DataGridViewのカラム配置を設定退避用に文字列で取得
    '* 注意事項：
    '***********************************************************************************************
    Friend Function GetDGVColumnDisplayIndex(ByRef objDGV As DataGridView) As String
        '-------------------------------------------------------------------------------------------
        Dim strTEXT As String = String.Empty                        ' テキストWORK
        Dim intIx As Integer = 1                                    ' テーブルINDEX
        ' DataGridView
        With objDGV
            strTEXT = .Columns(0).DisplayIndex.ToString
            ' 全列の表示順INDEXをTabを挟んで接合
            Do While intIx < .Columns.Count
                strTEXT &= ControlChars.Tab & .Columns(intIx).DisplayIndex.ToString
                ' 次へ
                intIx += 1
            Loop
        End With
        Return strTEXT
    End Function

    '***********************************************************************************************
    '* 処理名　：DGV_ColumnHeaderMouseClick
    '* 機能　　：グリッド見出しクリック(ColumnHeaderMouseClick)
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：(デフォルト)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年01月15日
    '* 作成者　：井上　治
    '* 更新日　：2017年01月15日
    '* 更新者　：井上　治
    '* 機能説明：SortMode.Programmatic列を含む一覧の並替えを行なう
    '* 注意事項：Programmatic列は実Sort列IndexをTagにセットしておくこと
    '***********************************************************************************************
    Friend Sub DGV_ColumnHeaderMouseClick(ByVal sender As Object, _
                                          ByVal e As DataGridViewCellMouseEventArgs)
        '-------------------------------------------------------------------------------------------
        With CType(sender, DataGridView)
            Dim intCol As Integer = e.ColumnIndex                   ' カラムINDEX
            If .Columns(intCol).SortMode = g_cnsSM_Programmatic Then
                '-----------------------------------------------------------------------------------
                ' 当該カラムがProgrammaticに場合は指定列でSort
                Dim intCol2 As Integer = .Columns(intCol).Tag       ' カラムINDEX
                If .Columns(intCol).HeaderCell.SortGlyphDirection = g_cnsSO_Ascending Then
                    ' 降順に並替え及びソートマーク切替え
                    .Sort(.Columns(intCol2), System.ComponentModel.ListSortDirection.Descending)
                    .Columns(intCol).HeaderCell.SortGlyphDirection = g_cnsSO_Descending
                Else
                    ' 昇順に並替え及びソートマーク切替え
                    .Sort(.Columns(intCol2), System.ComponentModel.ListSortDirection.Ascending)
                    .Columns(intCol).HeaderCell.SortGlyphDirection = g_cnsSO_Ascending
                End If
                ' 他のProgrammatic列のソートマークを消す
                For Each objCol As DataGridViewColumn In .Columns
                    If ((objCol.SortMode = g_cnsSM_Programmatic) AndAlso _
                        (objCol.Index <> intCol)) Then
                        objCol.HeaderCell.SortGlyphDirection = g_cnsSO_None
                    End If
                Next objCol
            Else
                '-----------------------------------------------------------------------------------
                ' 当該カラムがProgrammaticでない場合は全Programmatic列のソートマークを消す
                For Each objCol As DataGridViewColumn In .Columns
                    If objCol.SortMode = g_cnsSM_Programmatic Then
                        objCol.HeaderCell.SortGlyphDirection = g_cnsSO_None
                    End If
                Next objCol
            End If
        End With
    End Sub

    '***********************************************************************************************
    '* 処理名　：ScrollToAddedRow
    '* 機能　　：追加行へのスクロール移動
    '-----------------------------------------------------------------------------------------------
    '* 返り値　：(なし)
    '* 引数　　：Arg1 = DataGridView(Object)
    '* 　　　　　Arg2 = 追加された行INDEX(Integer)
    '-----------------------------------------------------------------------------------------------
    '* 作成日　：2017年02月05日
    '* 作成者　：井上　治
    '* 更新日　：2017年02月05日
    '* 更新者　：井上　治
    '* 機能説明：
    '* 注意事項：
    '***********************************************************************************************
    Friend Sub ScrollToAddedRow(ByRef objDGV As DataGridView, _
                                ByVal intNewRow As Integer)
        '-------------------------------------------------------------------------------------------
        ' 追加行が画面内の場合は何もしない
        If ((intNewRow < 0) OrElse (objDGV.Rows(intNewRow).Displayed)) Then Exit Sub
        Dim intLastRow As Integer = objDGV.Rows.Count - 1           ' 最終行 
        ' 追加行が最終行でない場合は何もしない
        If intNewRow <> intLastRow Then Exit Sub
        With objDGV
            ' 画面に何行分表示できるかをカウント(可変行高は不対応)
            Dim intCntRow As Integer = 0                            ' 表示可能行数
            Dim intRow As Integer = .FirstDisplayedScrollingRowIndex ' 表示先頭行INDEX
            ' 下へ向かって各行が表示可能かを確認
            Do While intRow <= intLastRow
                ' 現在行が表示されているか
                If .Rows(intRow).Displayed Then
                    intCntRow += 1
                Else
                    Exit Do
                End If
                ' 次の行へ
                intRow += 1
            Loop
            ' 表示可能行数が取得できない場合は何もしない
            If intCntRow = 0 Then Exit Sub
            ' 一部表示でもDisplayedになることの対応と最終行認識のため空行を表示させるため2行調整
            intRow = intNewRow - intCntRow + 2
            ' 先頭判定(念のため！)
            If intRow < 0 Then intRow = 0
            ' その行にスクロールさせる
            .FirstDisplayedScrollingRowIndex = intRow
            ' 追加行を選択状態にする
            .Rows(intNewRow).Selected = True
        End With
    End Sub

    '----------------------------------------<< End of Source >>------------------------------------
End Class
