/*
 * $Id: SCTable.java,v 1.1.1.1 2003/01/24 14:34:00 kenta Exp $
 *
 * Copyright 2001 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.util;

/**
 * Sin Cos table.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class SCTable {
  public static final int TABLE_SIZE = DegUtil.DIV;

  static public int[] sintbl = new int[TABLE_SIZE];
  static public int[] costbl = new int[TABLE_SIZE];

  static {
    for ( int i=TABLE_SIZE-1 ; i>=0 ; i-- ) {
      sintbl[i] = (int)(Math.sin(i*(6.28/TABLE_SIZE))*256);
      costbl[i] = (int)(Math.cos(i*(6.28/TABLE_SIZE))*256);
    }
  }
}
