package jp.gr.java_conf.abagames.bulletnote.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.ui.editors.text.FileDocumentProvider;

public class XMLDocumentProvider extends FileDocumentProvider {

	/**
	 * Constructor for XMLDocumentProvider.
	 */
	public XMLDocumentProvider() {
		super();
	}

	private IDocumentPartitioner partitioner;
	
	/* (non-Javadoc)
	 * Method declared on AbstractDocumentProvider
	 */
	protected IDocument createDocument(Object element) throws CoreException {
		IDocument document = super.createDocument(element);
		if (document != null) {
			partitioner =
				new DefaultPartitioner(
					new XMLPartitionScanner(),
					new String[] { XMLPartitionScanner.XML_TAG, XMLPartitionScanner.XML_COMMENT });
			partitioner.connect(document);
			document.setDocumentPartitioner(partitioner);
		}
		return document;
	}
	
	public IDocumentPartitioner getDocumentPartitioner() {
		return partitioner;
	}
}