/*
 * $Id: BulletMLEditor.java,v 1.2 2003/01/24 14:46:01 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletnote.editors;

import java.util.ResourceBundle;

import jp.gr.java_conf.abagames.bulletnote.Previewer;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.TextOperationAction;

/**
 * BulletML XML editor .
 *
 * @version $Revision: 1.2 $
 */
public class BulletMLEditor extends TextEditor {

	private ColorManager colorManager;

	public BulletMLEditor() {
		super();
		colorManager = new ColorManager();
		setSourceViewerConfiguration(new XMLConfiguration(colorManager, this));
		setDocumentProvider(new XMLDocumentProvider());
	}

	public void dispose() {
		colorManager.dispose();
		super.dispose();
	}

	public void setBulletML() {
		String text = getDocumentProvider().getDocument(getEditorInput()).get();
		IViewPart previewerPart = 
		 getSite().getWorkbenchWindow().getActivePage().findView("jp.gr.javaconf.abagames.bulletnote.Previewer");
		if ( previewerPart == null ) return;
		Previewer previewer = (Previewer)previewerPart.getAdapter(Previewer.class);

		IResource resource = ((IFileEditorInput)getEditorInput()).getFile();
		try {
			resource.deleteMarkers(null, true, IResource.DEPTH_INFINITE);
		} catch ( CoreException e ) {
			e.printStackTrace();
		}

		previewer.setBulletML(text, resource);
	}

	public void doSave(IProgressMonitor monitor) {
		super.doSave(monitor);
		setBulletML();
	}

	protected void createActions() {
		super.createActions();
		IAction action = new TextOperationAction(
			ResourceBundle.getBundle("jp.gr.java_conf.abagames.bulletnote.editors.bulletnote"), 
			"ContentAssistProposal.", this, ISourceViewer.CONTENTASSIST_PROPOSALS);
		action.setActionDefinitionId("jp.gr.javaconf.abagames.bulletnote.content.assist.proposals");
		setAction("ContentAssistProposal", action);
		markAsStateDependentAction("ContentAssistProposal", true);
	}
}
