/*
 * $Id: BulletMLCreationWizard.java,v 1.1.1.1 2003/01/24 14:34:00 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletnote.editors;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.dialogs.NewWizard;

/**
 * BulletML template file creation wizard.
 *
 * @version $Revision: 1.1.1.1 $
 */
public class BulletMLCreationWizard extends NewWizard implements INewWizard {
	private IStructuredSelection selection;
    
	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
		setWindowTitle("New BulletML File");
	}
    
	public void addPages() {
		IWizardPage page = new BulletMLCreationPage("workbench", selection);
		addPage(page);
	}

	public boolean performFinish() {
		BulletMLCreationPage page = (BulletMLCreationPage)getPages()[0];
		page.createFile();
		return page.isPageComplete();
	}
}
