/*
 * $Id: BulletMLContentAssistProcessor.java,v 1.2 2003/01/24 16:01:25 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletnote.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

import jp.gr.java_conf.abagames.bulletnote.BulletnotePlugin;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

/**
 * Simple BulletML content assist.
 *
 * @version $Revision: 1.2 $
 */
public class BulletMLContentAssistProcessor
	implements IContentAssistProcessor {

	private static Image[] iconImage = new Image[3]
;
	static {
		ImageDescriptor image;
		URL url = null;
		URL installURL = BulletnotePlugin.getInstance().getDescriptor().getInstallURL();
		try {
			url = new URL(installURL, "icons/bn_tag.gif");
		} catch (MalformedURLException e) {}
		image = ImageDescriptor.createFromURL(url);
		iconImage[0] = image.createImage();
		try {
			url = new URL(installURL, "icons/bn_atr.gif");
		} catch (MalformedURLException e) {}
		image = ImageDescriptor.createFromURL(url);
		iconImage[1] = image.createImage();
		try {
			url = new URL(installURL, "icons/bn_qut.gif");
		} catch (MalformedURLException e) {}
		image = ImageDescriptor.createFromURL(url);
		iconImage[2] = image.createImage();
	}
	
	private BulletMLEditor editor;
	
	public BulletMLContentAssistProcessor(BulletMLEditor editor) {
		this.editor = editor;
	}

	private String[][] completionWord = {
		{"bullet", "action", "fire", "direction", "speed", "repeat", "times", "wait",
		 "bulletRef", "actionRef", "fireRef", "param",
		 "changeDirection", "changeSpeed", "accel", "vanish", "term", 
		 "horizontal", "vertical"},
		{"type", "label"},
		{"absolute", "relative", "sequence"},
	};
	private String[] completionTagComment = {
		"Defines attributes of a bullet",
		"Defines the action of bullet",
		"Fires a bullet",
		"Specifies a direction",
		"Specifies a speed",
		"Repeats an action",
		"Specifies the number of times",
		"Waits",
		"Refers to the bullet",
		"Refers to the action",
		"Refers to the fire action",
		"Specifies the parameter",
		"Changes the direction of bullet",
		"Changes the speed of bullet",
		"Accelerates a bullet",
		"Vanishes a bullet",
		"Specifies a term",
		"Specifies the acceleration in a horizontal line",
		"Specifies the acceleration in a vertical line",
	};

	private final char COMPLETION_WORD_SEPARATOR_0 = '<';
	private final char COMPLETION_WORD_SEPARATOR_1 = ' ';
	private final char COMPLETION_WORD_SEPARATOR_2 = '"';
	 
	/**
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#computeCompletionProposals(org.eclipse.jface.text.ITextViewer, int)
	 */
	public ICompletionProposal[] computeCompletionProposals(
	 ITextViewer viewer, int documentOffset) {
		IDocumentPartitioner partitioner =
			((XMLDocumentProvider)editor.getDocumentProvider()).getDocumentPartitioner();
		ITypedRegion type = partitioner.getPartition(documentOffset);
		if ( !type.getType().equals(XMLPartitionScanner.XML_TAG) ) return null;

		String document = viewer.getDocument().get();
		String incompleteWord = getIncompleteWord(document, documentOffset);
		if ( incompleteWord == null ) return null;

		char startChar = incompleteWord.charAt(0);
		incompleteWord = incompleteWord.substring(1);
		int completionType = 0;
		switch (startChar) {
			case COMPLETION_WORD_SEPARATOR_0:
				completionType = 0;
				break;
			case COMPLETION_WORD_SEPARATOR_1:
				completionType = 1;
				break;
			case COMPLETION_WORD_SEPARATOR_2:
				completionType = 2;
				break;
		}

		Vector prpVct = new Vector();
 		for ( int i=0 ; i<completionWord[completionType].length ; i++ ) {
			String cmpWord = completionWord[completionType][i];
 			if ( cmpWord.startsWith(incompleteWord) ) {
				int rplPos = documentOffset-incompleteWord.length();
				int crsPos = 0;
				String dispWord = new String();
				switch ( completionType ) {
				case 0:
					// Complete the tag.
					crsPos = cmpWord.length()+1;
					dispWord = cmpWord + " - " + completionTagComment[i];
					cmpWord = cmpWord + "></" + cmpWord + ">";
					break;
				case 1:
					// Complete the attribute.
					dispWord = cmpWord;
					cmpWord += "=\"\"";
					crsPos = cmpWord.length()-1;
					break;
				case 2:
					// Complete the type string.
					dispWord = cmpWord;
					crsPos = cmpWord.length();
					break;
				}
				prpVct.addElement(new CompletionProposal(
					cmpWord, rplPos, incompleteWord.length(), crsPos,
					iconImage[completionType], dispWord, null, null));
 			}
		}
		ICompletionProposal[] proposal = new CompletionProposal[prpVct.size()];
		prpVct.copyInto(proposal);
		return proposal;
	}

	private String getIncompleteWord(String str, int offset) {
		int idx;
		char ch = 0;
		for ( idx = offset-1 ; idx >= 0 ; idx-- ) {
			ch = str.charAt(idx);
			if ( ch == COMPLETION_WORD_SEPARATOR_0 ||
	 			   ch == COMPLETION_WORD_SEPARATOR_1 || 
				   ch == COMPLETION_WORD_SEPARATOR_2 ) break;
		}
		if ( idx < 0 ) return null;
		return str.substring(idx, offset);
	}

	/**
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#computeContextInformation(org.eclipse.jface.text.ITextViewer, int)
	 */
	public IContextInformation[] computeContextInformation(
		ITextViewer viewer,
		int documentOffset) {
		return null;
	}

	/**
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getCompletionProposalAutoActivationCharacters()
	 */
	public char[] getCompletionProposalAutoActivationCharacters() {
		char[] c = new char[1];
		c[0] = COMPLETION_WORD_SEPARATOR_0;
		return c;
	}

	/**
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getContextInformationAutoActivationCharacters()
	 */
	public char[] getContextInformationAutoActivationCharacters() {
		return null;
	}

	/**
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getErrorMessage()
	 */
	public String getErrorMessage() {
		return null;
	}

	/**
	 * @see org.eclipse.jface.text.contentassist.IContentAssistProcessor#getContextInformationValidator()
	 */
	public IContextInformationValidator getContextInformationValidator() {
		return null;
	}

}
