/*
 * $Id: Previewer.java,v 1.3 2003/01/24 14:44:10 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletnote;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.part.ViewPart;

/**
 * BulletML Previewer.
 *
 * @version $Revision: 1.3 $
 */
public class Previewer extends ViewPart implements SelectionListener {
  private PreviewerCanvas canvas;
	private Slider slider;

	/**
	 * @see IWorkbenchPart#createPartControl(Composite)
	 */
	public void createPartControl(Composite parent) {
		GridLayout layout = new GridLayout();
		layout.numColumns = 1;
		parent.setLayout(layout);

    canvas = new PreviewerCanvas(parent, 0);
		GridData cvsGrd = new GridData(GridData.FILL_BOTH);
		canvas.setLayoutData(cvsGrd);

		slider = new Slider(parent, SWT.HORIZONTAL);
		GridData sldGrd = new GridData(GridData.FILL_HORIZONTAL);
		slider.setLayoutData(sldGrd);
		slider.setMinimum(0);
		slider.setMaximum(100);
		slider.setSelection(50);
		canvas.setRank(0.5f);
		slider.addSelectionListener(this);
	}

	public void widgetSelected(SelectionEvent e) {
		canvas.setRank(((float)slider.getSelection())/100.0f);
	}
	
	public void widgetDefaultSelected(SelectionEvent e) {
		widgetSelected(e);
	}
	
	/**
	 * @see IWorkbenchPart#setFocus()
	 */
	public void setFocus() {
    canvas.setFocus();
	}

	public Object getAdapter(Class cls) {
		if ( cls.isInstance(this) ) {
			return this;
		} else {
			return super.getAdapter(cls);
		}
	}
	
	public void setBulletML(String text, IResource resource) {
		try {
			canvas.setBulletML(text, resource);
		} catch ( Exception e ) {
			try {
				IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
				marker.setAttribute(IMarker.SEVERITY, IMarker.SEVERITY_ERROR);
				marker.setAttribute(IMarker.MESSAGE, e.getMessage());
			} catch ( CoreException ex ) {
				ex.printStackTrace();
			}
		}
	}
}
