/*
 * $Id: BulletnotePlugin.java,v 1.2 2003/01/24 16:01:25 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletnote;

import org.eclipse.ui.plugin.*;
import org.eclipse.core.runtime.*;
import org.eclipse.core.resources.*;
import java.util.*;

/**
 * Bulletnote eclipse plugin.
 *
 * @version $Revision: 1.2 $
 */
public class BulletnotePlugin extends AbstractUIPlugin {
	//The shared instance.
	private static BulletnotePlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	public static BulletnotePlugin getInstance() {
		return plugin;
	}

	/**
	 * The constructor.
	 */
	public BulletnotePlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		try {
			resourceBundle= ResourceBundle.getBundle("jp.gr.java_conf.abagames.bulletnote.BulletnotePluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static BulletnotePlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= BulletnotePlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
}
