/*
 * $Id: BulletnotePerspective.java,v 1.2 2003/01/24 14:43:50 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletnote;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;

/**
 * Bulletnote perspective(BulletML editor and previewer ).
 *
 * @version $Revision: 1.2 $
 */
public class BulletnotePerspective implements IPerspectiveFactory {

  public void createInitialLayout(IPageLayout layout) {
    defineActions(layout);
    defineLayout(layout);
  }

  private void defineActions(IPageLayout layout) {
    layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
    layout.addNewWizardShortcut("org.eclipse.ui.wizards.new.file");
    
    layout.addShowViewShortcut(IPageLayout.ID_RES_NAV);
    layout.addShowViewShortcut(IPageLayout.ID_TASK_LIST);
  }
  
  public void defineLayout(IPageLayout layout) {
    String editorArea = layout.getEditorArea();

    IFolderLayout left = layout.createFolder(
      "left", IPageLayout.LEFT, (float)0.26, editorArea);
    left.addView(IPageLayout.ID_RES_NAV);
    layout.addView(
      "jp.gr.javaconf.abagames.bulletnote.Previewer",
      IPageLayout.BOTTOM, (float)0.56, 
      "left");
		layout.addView(
	    "org.eclipse.ui.views.TaskList",
			IPageLayout.BOTTOM, (float)0.75, 
			editorArea);
  }
}
