package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <b>Fire</b> is generated from bulletml.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="fire">
 *   <optional>
 *     <attribute name="label">
 *       <data type="string"/>
 *     </attribute>
 *   </optional>
 *   <group>
 *     <optional>
 *       <ref name="direction"/>
 *     </optional>
 *     <optional>
 *       <ref name="speed"/>
 *     </optional>
 *     <ref name="bulletElm"/>
 *   </group>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="fire"&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="label"&gt;
 *       &lt;data type="string"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;group&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="direction"/&gt;
 *     &lt;/optional&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="speed"/&gt;
 *     &lt;/optional&gt;
 *     &lt;ref name="bulletElm"/&gt;
 *   &lt;/group&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version bulletml.rng
 * @author  Relaxer 0.17 (http://www.relaxer.org)
 */
public class Fire implements java.io.Serializable, IActionChoice, IBulletmlChoice {
    private String label_;
    private Direction direction_;
    private Speed speed_;
    private IBulletElmChoice bulletElm_;

    /**
     * Creates a <code>Fire</code>.
     *
     */
    public Fire() {
    }

    /**
     * Creates a <code>Fire</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Fire(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Fire</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Fire(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Fire</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Fire(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Fire</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Fire(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Fire</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Fire(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Fire</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Fire(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Fire</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Fire(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Fire</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Fire(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Fire</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Fire(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Fire</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Fire</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Fire</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        label_ = URelaxer.getAttributePropertyAsString(element, "label");
        if (Direction.isMatch(stack)) {
            setDirection(new Direction(stack));
        }
        if (Speed.isMatch(stack)) {
            setSpeed(new Speed(stack));
        }
        if (BulletRef.isMatch(stack)) {
            setBulletElm(new BulletRef(stack));
        } else if (Bullet.isMatch(stack)) {
            setBulletElm(new Bullet(stack));
        } else {
            throw (new IllegalArgumentException());
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("fire");
        int size;
        if (this.label_ != null) {
            URelaxer.setAttributePropertyByString(element, "label", this.label_);
        }
        if (this.direction_ != null) {
            this.direction_.makeElement(element);
        }
        if (this.speed_ != null) {
            this.speed_.makeElement(element);
        }
        this.bulletElm_.makeElement(element);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Fire</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Fire</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Fire</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Fire</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Fire</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Fire</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label_);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label_ = label;
    }

    /**
     * Gets the Direction property <b>direction</b>.
     *
     * @return Direction
     */
    public final Direction getDirection() {
        return (direction_);
    }

    /**
     * Sets the Direction property <b>direction</b>.
     *
     * @param direction
     */
    public final void setDirection(Direction direction) {
        this.direction_ = direction;
    }

    /**
     * Gets the Speed property <b>speed</b>.
     *
     * @return Speed
     */
    public final Speed getSpeed() {
        return (speed_);
    }

    /**
     * Sets the Speed property <b>speed</b>.
     *
     * @param speed
     */
    public final void setSpeed(Speed speed) {
        this.speed_ = speed;
    }

    /**
     * Gets the IBulletElmChoice property <b>bulletElm</b>.
     *
     * @return IBulletElmChoice
     */
    public final IBulletElmChoice getBulletElm() {
        return (bulletElm_);
    }

    /**
     * Sets the IBulletElmChoice property <b>bulletElm</b>.
     *
     * @param bulletElm
     */
    public final void setBulletElm(IBulletElmChoice bulletElm) {
        this.bulletElm_ = bulletElm;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<fire");
        if (label_ != null) {
            buffer.append(" label=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getLabel())));
            buffer.append("\"");
        }
        bulletElm_.makeTextAttribute(buffer);
        buffer.append(">");
        if (direction_ != null) {
            direction_.makeTextElement(buffer);
        }
        if (speed_ != null) {
            speed_.makeTextElement(buffer);
        }
        bulletElm_.makeTextElement(buffer);
        buffer.append("</fire>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<fire");
        if (label_ != null) {
            buffer.print(" label=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getLabel())));
            buffer.print("\"");
        }
        bulletElm_.makeTextAttribute(buffer);
        buffer.print(">");
        if (direction_ != null) {
            direction_.makeTextElement(buffer);
        }
        if (speed_ != null) {
            speed_.makeTextElement(buffer);
        }
        bulletElm_.makeTextElement(buffer);
        buffer.print("</fire>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLabelAsString() {
        return (URelaxer.getString(getLabel()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLabelByString(String string) {
        setLabel(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setDirectionByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setDirection(new Direction(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setSpeedByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setSpeed(new Speed(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Fire</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "fire")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (Direction.isMatchHungry(target)) {
        }
        if (Speed.isMatchHungry(target)) {
        }
        if (BulletRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (Bullet.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return (false);
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Fire</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Fire</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
