/*
 * $Id: BulletmlManager.java,v 1.2 2003/01/24 14:46:01 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletml;

import org.xml.sax.ErrorHandler;

/**
 * Handle bulletimpls and actionimpls .
 *
 * @version $Revision: 1.2 $
 */
public class BulletmlManager {
  public int screenWidth, screenHeight;

	private IBulletmlScreen screen;
	
  private final int BULLET_MAX = 512;
  private BulletImpl[] bullet = new BulletImpl[BULLET_MAX];
  private int bltIdx = 0;

  private final int ACTION_MAX = 2048;
  private ActionImpl[] action = new ActionImpl[ACTION_MAX];
  private int actIdx = 0;

  public int shipX, shipY, shipPx, shipPy;

  private String fileName;

  public int cnt;

  public BulletmlUtil bulletmlUtil = new BulletmlUtil();

	public void setErrorHandler(ErrorHandler handler) {
		bulletmlUtil.setErrorHandler(handler);
	}
	
  public void reinit() {
  	bulletmlUtil.clear();
    for ( int i=0 ; i<bullet.length ; i++ ) {
      bullet[i].vanish();
    }
    for ( int i=0 ; i<action.length ; i++ ) {
      action[i].vanish();
    }
    cnt = 0;
  }

  public void init() {
    for ( int i=0 ; i<bullet.length ; i++ ) {
      bullet[i] = new BulletImpl(this);
    }
    for ( int i=0 ; i<action.length ; i++ ) {
      action[i] = new ActionImpl(this);
    }
    reinit();
  }

  public void setScreen(IBulletmlScreen screen) {
  	this.screen = screen;
    screenWidth  = screen.getWidth()<<8;
    screenHeight = screen.getHeight()<<8;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public void setShipPos(int x, int y, int px, int py) {
    shipX = x; shipY = y;
    shipPx = px; shipPy = py;
  }

  public BulletImpl getBulletImplInstance() {
    for ( int i=BULLET_MAX-1 ; i>=0 ; i-- ) {
      bltIdx++; bltIdx &= (BULLET_MAX-1);
      if ( bullet[bltIdx].x == BulletImpl.NOT_EXIST ) {
        return bullet[bltIdx];
      }
    }
    return null;
  }

  public ActionImpl getActionImplInstance() {
    for ( int i=ACTION_MAX-1 ; i>=0 ; i-- ) {
      actIdx++; actIdx &= (ACTION_MAX-1);
      if ( action[actIdx].pc == ActionImpl.NOT_EXIST ) {
        return action[actIdx];
      }
    }
    return null;
  }

  private int bulletNum;
	private final int CLS_WIDTH = 100;
	
  public void moveBullets() {
    long a, b, c, d, e, f, dnm, x, y;
    int a1x, a2x, a1y, a2y;
    int b1x, b2x, b1y, b2y;

    if ( shipX < shipPx ) {
      a1x =  shipX-CLS_WIDTH; a2x = shipPx+CLS_WIDTH;
    } else {
      a1x = shipPx-CLS_WIDTH; a2x =  shipX+CLS_WIDTH;
    }
    if ( shipY < shipPy ) {
      a1y =  shipY-CLS_WIDTH; a2y = shipPy+CLS_WIDTH;
    } else {
      a1y = shipPy-CLS_WIDTH; a2y =  shipY+CLS_WIDTH;
    }

    bulletNum = 0;
    for ( int i=BULLET_MAX-1 ; i>=0 ; i-- ) {
      if ( bullet[i].x != BulletImpl.NOT_EXIST ) {
        BulletImpl bl = bullet[i];
        bl.move();

        // Check if the bullet hits my ship.
        if ( bl.py < bl.y ) {
          b1y = bl.py-CLS_WIDTH; b2y =  bl.y+CLS_WIDTH;
        } else {
          b1y =  bl.y-CLS_WIDTH; b2y = bl.py+CLS_WIDTH;
        }
        if ( a2y>=b1y && b2y>=a1y ) {
          if ( bl.px < bl.x ) {
            b1x = bl.px-CLS_WIDTH; b2x =  bl.x+CLS_WIDTH;
          } else {
            b1x =  bl.x-CLS_WIDTH; b2x = bl.px+CLS_WIDTH;
          }
          if ( a2x>=b1x && b2x>=a1x ) {
            a = shipY - shipPy;
            b = shipPx - shipX;
            c = shipPx*shipY - shipPy*shipX;
            d = bl.py - bl.y;
            e = bl.x - bl.px;
            f = bl.x*bl.py - bl.y*bl.px;
            dnm = b*d - a*e;
            if ( dnm != 0 ) {
              x = (b*f - c*e) / dnm;
              y = (c*d - a*f) / dnm;
              if ( a1x<=x && x<=a2x && a1y<=y && y<=a2y &&
                   b1x<=x && x<=b2x && b1y<=y && y<=b2y ) {
                screen.hitShip();
              }
            }
          }
        }
        bulletNum++;
      }
    }
    cnt++;
  }

  public void drawBullets() {
    for ( int i=BULLET_MAX-1 ; i>=0 ; i-- ) {
      if ( bullet[i].x != BulletImpl.NOT_EXIST ) {
        bullet[i].draw();
      }
    }
  }

  public final void drawBullet(int x, int y, int px, int py, int sx, int sy, int cl, int cnt) {
    screen.drawBullet(x, y, px, py, sx, sy, cl, cnt);
  }

  private IActionElmChoice[] topActions;

  public void setTopActions(IActionElmChoice[] actions) {
    topActions = actions;
  }

	private BulletImpl topBullet;
	
  public BulletImpl addTopBullet(int x, int y, int d) {
		if ( topBullet != null && topBullet.x != BulletImpl.NOT_EXIST ) {
			topBullet.vanishForced();
		}
    topBullet = getBulletImplInstance();
    if ( topBullet != null ) {
      topBullet.set(topActions, x, y, d, 0);
    }
    return topBullet;
  }

  public void setRank(float rank) {
    bulletmlUtil.setRank(rank);
  }

  public boolean isFinished() {
    //return ( cnt > 1 && bulletNum <= 0 );
    return !( topBullet != null && topBullet.x != BulletImpl.NOT_EXIST &&
    	!topBullet.isAllActionFinished() );
  }

  public int getBulletsNum() {
    return bulletNum;
  }
}
