package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <b>Bulletml</b> is generated from bulletml.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="bulletml">
 *   <optional>
 *     <attribute name="xmlns">
 *       <data type="string"/>
 *     </attribute>
 *   </optional>
 *   <optional>
 *     <attribute name="type">
 *       <choice>
 *         <value type="string">none</value>
 *         <value type="string">vertical</value>
 *         <value type="string">horizontal</value>
 *       </choice>
 *     </attribute>
 *   </optional>
 *   <zeroOrMore>
 *     <choice>
 *       <ref name="action"/>
 *       <ref name="bullet"/>
 *       <ref name="fire"/>
 *     </choice>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="bulletml"&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="xmlns"&gt;
 *       &lt;data type="string"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="type"&gt;
 *       &lt;choice&gt;
 *         &lt;value type="string"&gt;none&lt;/value&gt;
 *         &lt;value type="string"&gt;vertical&lt;/value&gt;
 *         &lt;value type="string"&gt;horizontal&lt;/value&gt;
 *       &lt;/choice&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;choice&gt;
 *       &lt;ref name="action"/&gt;
 *       &lt;ref name="bullet"/&gt;
 *       &lt;ref name="fire"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version bulletml.rng
 * @author  Relaxer 0.17 (http://www.relaxer.org)
 */
public class Bulletml implements java.io.Serializable {
    private String xmlns_;
    private String type_;
    // List<IBulletmlChoice>
    private java.util.List content_ = new java.util.ArrayList();

    /**
     * Creates a <code>Bulletml</code>.
     *
     */
    public Bulletml() {
    }

    /**
     * Creates a <code>Bulletml</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Bulletml(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Bulletml</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Bulletml(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Bulletml</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Bulletml(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Bulletml</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Bulletml</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Bulletml</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Bulletml</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Bulletml</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Bulletml</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Bulletml</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Bulletml</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Bulletml</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        xmlns_ = URelaxer.getAttributePropertyAsString(element, "xmlns");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        content_.clear();
        while (true) {
            if (Action.isMatch(stack)) {
                addContent(new Action(stack));
            } else if (Bullet.isMatch(stack)) {
                addContent(new Bullet(stack));
            } else if (Fire.isMatch(stack)) {
                addContent(new Fire(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("bulletml");
        int size;
        if (this.xmlns_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmlns", this.xmlns_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Bulletml</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Bulletml</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bulletml</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bulletml</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bulletml</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Bulletml</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>xmlns</b>.
     *
     * @return String
     */
    public final String getXmlns() {
        return (xmlns_);
    }

    /**
     * Sets the String property <b>xmlns</b>.
     *
     * @param xmlns
     */
    public final void setXmlns(String xmlns) {
        this.xmlns_ = xmlns;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the IBulletmlChoice property <b>content</b>.
     *
     * @return IBulletmlChoice[]
     */
    public final IBulletmlChoice[] getContent() {
        IBulletmlChoice[] array = new IBulletmlChoice[content_.size()];
        return ((IBulletmlChoice[])content_.toArray(array));
    }

    /**
     * Sets the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IBulletmlChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
    }

    /**
     * Sets the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IBulletmlChoice content) {
        this.content_.clear();
        addContent(content);
    }

    /**
     * Adds the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IBulletmlChoice content) {
        this.content_.add(content);
    }

    /**
     * Adds the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IBulletmlChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
    }

    /**
     * Gets number of the IBulletmlChoice property <b>content</b>.
     *
     * @return int
     */
    public final int getContentCount() {
        return (content_.size());
    }

    /**
     * Gets the IBulletmlChoice property <b>content</b> by index.
     *
     * @param index
     * @return IBulletmlChoice
     */
    public final IBulletmlChoice getContent(int index) {
        return ((IBulletmlChoice)content_.get(index));
    }

    /**
     * Sets the IBulletmlChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IBulletmlChoice content) {
        this.content_.set(index, content);
    }

    /**
     * Adds the IBulletmlChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IBulletmlChoice content) {
        this.content_.add(index, content);
    }

    /**
     * Remove the IBulletmlChoice property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IBulletmlChoice property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IBulletmlChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IBulletmlChoice property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<bulletml");
        if (xmlns_ != null) {
            buffer.append(" xmlns=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlns())));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</bulletml>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<bulletml");
        if (xmlns_ != null) {
            buffer.print(" xmlns=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getXmlns())));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getType())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</bulletml>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getXmlnsAsString() {
        return (URelaxer.getString(getXmlns()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTypeAsString() {
        return (URelaxer.getString(getType()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setXmlnsByString(String string) {
        setXmlns(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTypeByString(String string) {
        setType(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Bulletml</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "bulletml")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (Action.isMatchHungry(target)) {
                $match$ = true;
            } else if (Bullet.isMatchHungry(target)) {
                $match$ = true;
            } else if (Fire.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Bulletml</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Bulletml</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
