package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <b>BulletRef</b> is generated from bulletml.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="bulletRef">
 *   <attribute name="label">
 *     <data type="string"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <choice>
 *       <ref name="param"/>
 *     </choice>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="bulletRef"&gt;
 *   &lt;attribute name="label"&gt;
 *     &lt;data type="string"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;choice&gt;
 *       &lt;ref name="param"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version bulletml.rng
 * @author  Relaxer 0.17 (http://www.relaxer.org)
 */
public class BulletRef implements java.io.Serializable, IBulletElmChoice {
    private String label_;
    // List<Param>
    private java.util.List param_ = new java.util.ArrayList();

    /**
     * Creates a <code>BulletRef</code>.
     *
     */
    public BulletRef() {
        label_ = "";
    }

    /**
     * Creates a <code>BulletRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public BulletRef(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>BulletRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public BulletRef(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>BulletRef</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public BulletRef(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>BulletRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public BulletRef(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>BulletRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public BulletRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>BulletRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public BulletRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>BulletRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public BulletRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>BulletRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public BulletRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>BulletRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public BulletRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>BulletRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>BulletRef</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>BulletRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        label_ = URelaxer.getAttributePropertyAsString(element, "label");
        param_.clear();
        while (true) {
            if (Param.isMatch(stack)) {
                addParam(new Param(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("bulletRef");
        int size;
        URelaxer.setAttributePropertyByString(element, "label", this.label_);
        size = this.param_.size();
        for (int i = 0;i < size;i++) {
            Param value = (Param)this.param_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>BulletRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>BulletRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>BulletRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>BulletRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>BulletRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>BulletRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label_);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label_ = label;
    }

    /**
     * Gets the Param property <b>param</b>.
     *
     * @return Param[]
     */
    public final Param[] getParam() {
        Param[] array = new Param[param_.size()];
        return ((Param[])param_.toArray(array));
    }

    /**
     * Sets the Param property <b>param</b>.
     *
     * @param param
     */
    public final void setParam(Param[] param) {
        this.param_.clear();
        for (int i = 0;i < param.length;i++) {
            addParam(param[i]);
        }
    }

    /**
     * Sets the Param property <b>param</b>.
     *
     * @param param
     */
    public final void setParam(Param param) {
        this.param_.clear();
        addParam(param);
    }

    /**
     * Adds the Param property <b>param</b>.
     *
     * @param param
     */
    public final void addParam(Param param) {
        this.param_.add(param);
    }

    /**
     * Adds the Param property <b>param</b>.
     *
     * @param param
     */
    public final void addParam(Param[] param) {
        for (int i = 0;i < param.length;i++) {
            addParam(param[i]);
        }
    }

    /**
     * Gets number of the Param property <b>param</b>.
     *
     * @return int
     */
    public final int getParamCount() {
        return (param_.size());
    }

    /**
     * Gets the Param property <b>param</b> by index.
     *
     * @param index
     * @return Param
     */
    public final Param getParam(int index) {
        return ((Param)param_.get(index));
    }

    /**
     * Sets the Param property <b>param</b> by index.
     *
     * @param index
     * @param param
     */
    public final void setParam(int index, Param param) {
        this.param_.set(index, param);
    }

    /**
     * Adds the Param property <b>param</b> by index.
     *
     * @param index
     * @param param
     */
    public final void addParam(int index, Param param) {
        this.param_.add(index, param);
    }

    /**
     * Remove the Param property <b>param</b> by index.
     *
     * @param index
     */
    public final void removeParam(int index) {
        this.param_.remove(index);
    }

    /**
     * Remove the Param property <b>param</b> by object.
     *
     * @param param
     */
    public final void removeParam(Param param) {
        this.param_.remove(param);
    }

    /**
     * Clear the Param property <b>param</b>.
     *
     */
    public final void clearParam() {
        this.param_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<bulletRef");
        buffer.append(" label=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getLabel())));
        buffer.append("\"");
        buffer.append(">");
        size = this.param_.size();
        for (int i = 0;i < size;i++) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</bulletRef>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<bulletRef");
        buffer.print(" label=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getLabel())));
        buffer.print("\"");
        buffer.print(">");
        size = this.param_.size();
        for (int i = 0;i < size;i++) {
            Param value = (Param)this.param_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</bulletRef>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLabelAsString() {
        return (URelaxer.getString(getLabel()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLabelByString(String string) {
        setLabel(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setParamByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setParam(new Param(string));
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void addParamByString(String string) throws IOException, SAXException, ParserConfigurationException {
        addParam(new Param(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>BulletRef</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "bulletRef")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "label")) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!Param.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>BulletRef</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>BulletRef</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
