/*
 * $Id: BulletImpl.java,v 1.2 2003/01/24 14:46:00 kenta Exp $
 *
 * Copyright 2003 Kenta Cho. All rights reserved.
 */
package jp.gr.java_conf.abagames.bulletml;

import jp.gr.java_conf.abagames.util.DegUtil;
import jp.gr.java_conf.abagames.util.SCTable;

/**
 * Bullet implementation .
 *
 * @version $Revision: 1.2 $
 */
public class BulletImpl {
  public static final int NOT_EXIST = Integer.MIN_VALUE;

  private final int ACTION_MAX = 8;

  private ActionImpl[] action = new ActionImpl[ACTION_MAX];
  private int acIdx;

  public int x, y, px, py;
  public int sx, sy;

  public Direction drcElm;
  public Speed spdElm;
  public float direction, speed;

  public float mx, my;

  public int clr;

  private int cnt;

  private BulletmlManager manager;

  private float[] prms;

  private int tmx, tmy;
  public BulletImpl parent;

  public BulletImpl(BulletmlManager bm) {
    manager = bm;
    x = NOT_EXIST;
  }

  public void changeAction(ActionImpl bfr, ActionImpl aft) {
    for ( int i=0 ; i<acIdx ; i++ ) {
      if ( action[i].equals(bfr) ) {
        action[i] = aft;
        return;
      }
    }
  }

  public void set(IActionElmChoice[] aec,
   int x, int y, int d, int clr) {
    this.x = px = sx = x; this.y = py = sy = y;
    mx = my = 0; tmx = tmy = 0;
    this.clr = clr;
    cnt = 0;
    acIdx = 0;
    for ( int i=0 ; i<aec.length ; i++ ) {
      action[acIdx] = manager.getActionImplInstance();
      if ( action[acIdx] == null ) break;
      action[acIdx].set(manager.bulletmlUtil.getActionElm(aec[i]), this);
      float[] actPrms = manager.bulletmlUtil.getActionParams(aec[i], prms);
      if ( actPrms == null ) {
        action[acIdx].setParams(prms);
      } else {
        action[acIdx].setParams(actPrms);
      }
      acIdx++;
      if ( acIdx >= ACTION_MAX ) break;
    }
    direction = d;
    speed = 0;
    parent = null;
  }

  public void set(Bullet bullet, int x, int y, int ci, BulletImpl bImpl) {
    drcElm = bullet.getDirection();
    spdElm = bullet.getSpeed();
    IActionElmChoice[] aec = bullet.getActionElm();
    set(aec, x, y, 0, ci);
    parent = bImpl;
  }

  public void setParams(float[] prms) {
    this.prms = prms;
  }

  public float getAimDeg() {
    return (float)DegUtil.getDeg(manager.shipX - x, manager.shipY - y)
     * 360 / SCTable.TABLE_SIZE;
  }

  public void vanish() {
    vanishForced();
  }

  public void vanishForced() {
    for ( int i=0 ; i<acIdx ; i++ ) {
      action[i].vanish();
    }
    x = NOT_EXIST;
  }

  public boolean isAllActionFinished() {
    for ( int i=0 ; i<acIdx ; i++ ) {
      if ( action[i].pc != ActionImpl.NOT_EXIST ) {
        return false;
      }
    }
    return true;
  }

	private final int SPEED_MAG = 2;
	private final int ACCEL_MAG = 2;
	
  public final void move() {
    for ( int i=0 ; i<acIdx ; i++ ) {
      action[i].move();
    }

    cnt++;

    int d = (int)(direction*SCTable.TABLE_SIZE/360);
    d &= (SCTable.TABLE_SIZE-1);

    int mvx = ((int)(speed*SCTable.sintbl[d])*SPEED_MAG) + (int)(mx*256*ACCEL_MAG);
    int mvy = ((int)(-speed*SCTable.costbl[d])*SPEED_MAG) + (int)(my*256*ACCEL_MAG);
    int pmvx = mvx, pmvy = mvy;
    x += mvx; tmx = mvx;
    y += mvy; tmy = mvy;
    if ( pmvx == 0 && pmvy == 0 ) {
      pmvx = SCTable.sintbl[d]<<0;
      pmvy = -SCTable.costbl[d]<<0;
    }
    if ( cnt < 4 ) {
      px = x - pmvx;
      py = y - pmvy;
    } else if ( cnt < 8 ) {
      px = x - (pmvx<<1);
      py = y - (pmvy<<1);
    } else {
      px = x - (pmvx<<2);
      py = y - (pmvy<<2);
    }

    if ( px < 0 || px >= manager.screenWidth ||
         py < 0 || py >= manager.screenHeight ) {
      vanish();
    }
  }

  public final void draw() {
    manager.drawBullet(x, y, px, py, sx, sy, clr, cnt);
  }
}
