package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <b>ActionRef</b> is generated from bulletml.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="actionRef">
 *   <attribute name="label">
 *     <data type="string"/>
 *   </attribute>
 *   <zeroOrMore>
 *     <ref name="param"/>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="actionRef"&gt;
 *   &lt;attribute name="label"&gt;
 *     &lt;data type="string"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;ref name="param"/&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version bulletml.rng
 * @author  Relaxer 0.17 (http://www.relaxer.org)
 */
public class ActionRef implements java.io.Serializable, IActionElmChoice, IActionChoice {
    private String label_;
    // List<String>
    private java.util.List param_ = new java.util.ArrayList();

    /**
     * Creates a <code>ActionRef</code>.
     *
     */
    public ActionRef() {
        label_ = "";
    }

    /**
     * Creates a <code>ActionRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ActionRef(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>ActionRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public ActionRef(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>ActionRef</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public ActionRef(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>ActionRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ActionRef(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>ActionRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ActionRef(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>ActionRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ActionRef(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>ActionRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ActionRef(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>ActionRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ActionRef(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>ActionRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ActionRef(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>ActionRef</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>ActionRef</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>ActionRef</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        label_ = URelaxer.getAttributePropertyAsString(element, "label");
        param_ = URelaxer.getElementPropertyAsStringListByStack(stack, "param");
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("actionRef");
        int size;
        URelaxer.setAttributePropertyByString(element, "label", this.label_);
        URelaxer.setElementPropertyByStringList(element, "param", this.param_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>ActionRef</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>ActionRef</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ActionRef</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ActionRef</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ActionRef</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ActionRef</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>label</b>.
     *
     * @return String
     */
    public final String getLabel() {
        return (label_);
    }

    /**
     * Sets the String property <b>label</b>.
     *
     * @param label
     */
    public final void setLabel(String label) {
        this.label_ = label;
    }

    /**
     * Gets the String property <b>param</b>.
     *
     * @return String[]
     */
    public final String[] getParam() {
        String[] array = new String[param_.size()];
        return ((String[])param_.toArray(array));
    }

    /**
     * Sets the String property <b>param</b>.
     *
     * @param param
     */
    public final void setParam(String[] param) {
        this.param_.clear();
        for (int i = 0;i < param.length;i++) {
            addParam(param[i]);
        }
    }

    /**
     * Sets the String property <b>param</b>.
     *
     * @param param
     */
    public final void setParam(String param) {
        this.param_.clear();
        addParam(param);
    }

    /**
     * Adds the String property <b>param</b>.
     *
     * @param param
     */
    public final void addParam(String param) {
        this.param_.add(param);
    }

    /**
     * Adds the String property <b>param</b>.
     *
     * @param param
     */
    public final void addParam(String[] param) {
        for (int i = 0;i < param.length;i++) {
            addParam(param[i]);
        }
    }

    /**
     * Gets number of the String property <b>param</b>.
     *
     * @return int
     */
    public final int getParamCount() {
        return (param_.size());
    }

    /**
     * Gets the String property <b>param</b> by index.
     *
     * @param index
     * @return String
     */
    public final String getParam(int index) {
        return ((String)param_.get(index));
    }

    /**
     * Sets the String property <b>param</b> by index.
     *
     * @param index
     * @param param
     */
    public final void setParam(int index, String param) {
        this.param_.set(index, param);
    }

    /**
     * Adds the String property <b>param</b> by index.
     *
     * @param index
     * @param param
     */
    public final void addParam(int index, String param) {
        this.param_.add(index, param);
    }

    /**
     * Remove the String property <b>param</b> by index.
     *
     * @param index
     */
    public final void removeParam(int index) {
        this.param_.remove(index);
    }

    /**
     * Remove the String property <b>param</b> by object.
     *
     * @param param
     */
    public final void removeParam(String param) {
        this.param_.remove(param);
    }

    /**
     * Clear the String property <b>param</b>.
     *
     */
    public final void clearParam() {
        this.param_.clear();
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<actionRef");
        buffer.append(" label=\"");
        buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getLabel())));
        buffer.append("\"");
        buffer.append(">");
        size = getParamCount();
        for (int i = 0;i < size;i++) {
            buffer.append("<param>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getParam(i))));
            buffer.append("</param>");
        }
        buffer.append("</actionRef>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<actionRef");
        buffer.print(" label=\"");
        buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getLabel())));
        buffer.print("\"");
        buffer.print(">");
        size = getParamCount();
        for (int i = 0;i < size;i++) {
            buffer.print("<param>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getParam(i))));
            buffer.print("</param>");
        }
        buffer.print("</actionRef>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLabelAsString() {
        return (URelaxer.getString(getLabel()));
    }

    /**
     * Gets the property value as String array.
     *
     * @return String[]
     */
    public String[] getParamAsString() {
        int size = getParamCount();
        String[] array = new String[size];
        for (int i = 0;i < size;i++) {
            array[i] = URelaxer.getString(getParam(i));
        }
        return (array);
    }

    /**
     * Gets the property value by index as String.
     *
     * @param index
     * @return String
     */
    public String getParamAsString(int index) {
        return (URelaxer.getString(getParam(index)));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLabelByString(String string) {
        setLabel(string);
    }

    /**
     * Sets the property value by String array.
     *
     * @param strings
     */
    public void setParamByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            setParam(string);
            for (int i = 1;i < strings.length;i++) {
                string = strings[i];
                addParam(string);
            }
        }
    }

    /**
     * Sets the property value by String via index.
     *
     * @param index
     * @param value
     */
    public void setParamByString(int index, String value) {
        setParam(index, value);
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     */
    public void addParamByString(String string) {
        addParam(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>ActionRef</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "actionRef")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "label")) {
            return (false);
        }
        $match$ = true;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "param")) {
                break;
            }
            target.popElement();
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ActionRef</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ActionRef</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
