package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * <b>Accel</b> is generated from bulletml.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="accel">
 *   <group>
 *     <optional>
 *       <ref name="horizontal"/>
 *     </optional>
 *     <optional>
 *       <ref name="vertical"/>
 *     </optional>
 *     <ref name="term"/>
 *   </group>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="accel"&gt;
 *   &lt;group&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="horizontal"/&gt;
 *     &lt;/optional&gt;
 *     &lt;optional&gt;
 *       &lt;ref name="vertical"/&gt;
 *     &lt;/optional&gt;
 *     &lt;ref name="term"/&gt;
 *   &lt;/group&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version bulletml.rng
 * @author  Relaxer 0.17 (http://www.relaxer.org)
 */
public class Accel implements java.io.Serializable, IActionChoice {
    private Horizontal horizontal_;
    private Vertical vertical_;
    private String term_;

    /**
     * Creates a <code>Accel</code>.
     *
     */
    public Accel() {
        term_ = "";
    }

    /**
     * Creates a <code>Accel</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Accel(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Accel</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Accel(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Accel</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Accel(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Accel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Accel(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Accel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Accel(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Accel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Accel(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Accel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Accel(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Accel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Accel(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Accel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Accel(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Accel</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Accel</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Accel</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        if (Horizontal.isMatch(stack)) {
            setHorizontal(new Horizontal(stack));
        }
        if (Vertical.isMatch(stack)) {
            setVertical(new Vertical(stack));
        }
        term_ = URelaxer.getElementPropertyAsString(stack.popElement());
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("accel");
        int size;
        if (this.horizontal_ != null) {
            this.horizontal_.makeElement(element);
        }
        if (this.vertical_ != null) {
            this.vertical_.makeElement(element);
        }
        URelaxer.setElementPropertyByString(element, "term", this.term_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Accel</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Accel</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Accel</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Accel</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Accel</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Accel</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the Horizontal property <b>horizontal</b>.
     *
     * @return Horizontal
     */
    public final Horizontal getHorizontal() {
        return (horizontal_);
    }

    /**
     * Sets the Horizontal property <b>horizontal</b>.
     *
     * @param horizontal
     */
    public final void setHorizontal(Horizontal horizontal) {
        this.horizontal_ = horizontal;
    }

    /**
     * Gets the Vertical property <b>vertical</b>.
     *
     * @return Vertical
     */
    public final Vertical getVertical() {
        return (vertical_);
    }

    /**
     * Sets the Vertical property <b>vertical</b>.
     *
     * @param vertical
     */
    public final void setVertical(Vertical vertical) {
        this.vertical_ = vertical;
    }

    /**
     * Gets the String property <b>term</b>.
     *
     * @return String
     */
    public final String getTerm() {
        return (term_);
    }

    /**
     * Sets the String property <b>term</b>.
     *
     * @param term
     */
    public final void setTerm(String term) {
        this.term_ = term;
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<accel");
        buffer.append(">");
        if (horizontal_ != null) {
            horizontal_.makeTextElement(buffer);
        }
        if (vertical_ != null) {
            vertical_.makeTextElement(buffer);
        }
        buffer.append("<term>");
        buffer.append(URelaxer.escapeCharData(URelaxer.getString(getTerm())));
        buffer.append("</term>");
        buffer.append("</accel>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<accel");
        buffer.print(">");
        if (horizontal_ != null) {
            horizontal_.makeTextElement(buffer);
        }
        if (vertical_ != null) {
            vertical_.makeTextElement(buffer);
        }
        buffer.print("<term>");
        buffer.print(URelaxer.escapeCharData(URelaxer.getString(getTerm())));
        buffer.print("</term>");
        buffer.print("</accel>");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTermAsString() {
        return (URelaxer.getString(getTerm()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setHorizontalByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setHorizontal(new Horizontal(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setVerticalByString(String string) throws IOException, SAXException, ParserConfigurationException {
        setVertical(new Vertical(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTermByString(String string) {
        setTerm(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Accel</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "accel")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (Horizontal.isMatchHungry(target)) {
        }
        if (Vertical.isMatchHungry(target)) {
        }
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "term")) {
            return (false);
        }
        $match$ = true;
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Accel</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Accel</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
