/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletnote.editors;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import jp.gr.java_conf.abagames.bulletnote.BulletnotePlugin;
import jp.gr.java_conf.abagames.bulletnote.editors.BulletMLEditor;
import jp.gr.java_conf.abagames.bulletnote.editors.XMLDocumentProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class BulletMLContentAssistProcessor
implements IContentAssistProcessor {
    private static Image[] iconImage = new Image[3];
    private BulletMLEditor editor;
    private String[][] completionWord = new String[][]{{"bullet", "action", "fire", "direction", "speed", "repeat", "times", "wait", "bulletRef", "actionRef", "fireRef", "param", "changeDirection", "changeSpeed", "accel", "vanish", "term", "horizontal", "vertical"}, {"type", "label"}, {"absolute", "relative", "sequence"}};
    private String[] completionTagComment = new String[]{"Defines attributes of a bullet", "Defines the action of bullet", "Fires a bullet", "Specifies a direction", "Specifies a speed", "Repeats an action", "Specifies the number of times", "Waits", "Refers to the bullet", "Refers to the action", "Refers to the fire action", "Specifies the parameter", "Changes the direction of bullet", "Changes the speed of bullet", "Accelerates a bullet", "Vanishes a bullet", "Specifies a term", "Specifies the acceleration in a horizontal line", "Specifies the acceleration in a vertical line"};
    private final char COMPLETION_WORD_SEPARATOR_0 = (char)60;
    private final char COMPLETION_WORD_SEPARATOR_1 = (char)32;
    private final char COMPLETION_WORD_SEPARATOR_2 = (char)34;

    static {
        URL url = null;
        URL installURL = BulletnotePlugin.getInstance().getDescriptor().getInstallURL();
        try {
            url = new URL(installURL, "icons/bn_tag.gif");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        ImageDescriptor image = ImageDescriptor.createFromURL(url);
        BulletMLContentAssistProcessor.iconImage[0] = image.createImage();
        try {
            url = new URL(installURL, "icons/bn_atr.gif");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        image = ImageDescriptor.createFromURL((URL)url);
        BulletMLContentAssistProcessor.iconImage[1] = image.createImage();
        try {
            url = new URL(installURL, "icons/bn_qut.gif");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        image = ImageDescriptor.createFromURL((URL)url);
        BulletMLContentAssistProcessor.iconImage[2] = image.createImage();
    }

    public BulletMLContentAssistProcessor(BulletMLEditor editor) {
        this.editor = editor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IDocumentPartitioner partitioner = ((XMLDocumentProvider)this.editor.getDocumentProvider()).getDocumentPartitioner();
        ITypedRegion type = partitioner.getPartition(documentOffset);
        if (!type.getType().equals("__xml_tag")) {
            return null;
        }
        String document = viewer.getDocument().get();
        String incompleteWord = this.getIncompleteWord(document, documentOffset);
        if (incompleteWord == null) {
            return null;
        }
        char startChar = incompleteWord.charAt(0);
        incompleteWord = incompleteWord.substring(1);
        int completionType = 0;
        switch (startChar) {
            case '<': {
                completionType = 0;
                break;
            }
            case ' ': {
                completionType = 1;
                break;
            }
            case '\"': {
                completionType = 2;
            }
        }
        Vector<CompletionProposal> prpVct = new Vector<CompletionProposal>();
        int i = 0;
        while (i < this.completionWord[completionType].length) {
            String cmpWord = this.completionWord[completionType][i];
            if (cmpWord.startsWith(incompleteWord)) {
                int rplPos = documentOffset - incompleteWord.length();
                int crsPos = 0;
                String dispWord = new String();
                switch (completionType) {
                    case 0: {
                        crsPos = cmpWord.length() + 1;
                        dispWord = String.valueOf(cmpWord) + " - " + this.completionTagComment[i];
                        cmpWord = String.valueOf(cmpWord) + "></" + cmpWord + ">";
                        break;
                    }
                    case 1: {
                        dispWord = cmpWord;
                        cmpWord = String.valueOf(cmpWord) + "=\"\"";
                        crsPos = cmpWord.length() - 1;
                        break;
                    }
                    case 2: {
                        dispWord = cmpWord;
                        crsPos = cmpWord.length();
                    }
                }
                prpVct.addElement(new CompletionProposal(cmpWord, rplPos, incompleteWord.length(), crsPos, iconImage[completionType], dispWord, null, null));
            }
            ++i;
        }
        Object[] proposal = new CompletionProposal[prpVct.size()];
        prpVct.copyInto(proposal);
        return proposal;
    }

    private String getIncompleteWord(String str, int offset) {
        char ch = '\u0000';
        int idx = offset - 1;
        while (idx >= 0) {
            ch = str.charAt(idx);
            if (ch == '<' || ch == ' ' || ch == '\"') break;
            --idx;
        }
        if (idx < 0) {
            return null;
        }
        return str.substring(idx, offset);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        char[] c = new char[]{'<'};
        return c;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

