/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletnote;

import java.io.IOException;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.abagames.bulletml.Action;
import jp.gr.java_conf.abagames.bulletml.Bullet;
import jp.gr.java_conf.abagames.bulletml.Bulletml;
import jp.gr.java_conf.abagames.bulletml.BulletmlEntityResolver;
import jp.gr.java_conf.abagames.bulletml.BulletmlManager;
import jp.gr.java_conf.abagames.bulletml.Fire;
import jp.gr.java_conf.abagames.bulletml.IActionElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletmlChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletmlScreen;
import jp.gr.java_conf.abagames.bulletml.UJAXP;
import jp.gr.java_conf.abagames.util.ITime;
import jp.gr.java_conf.abagames.util.Timer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PreviewerCanvas
extends Canvas
implements IBulletmlScreen,
ITime {
    private BulletmlManager manager;
    private Display display;
    private GC gc;
    private Color background;
    private final int BULLET_COLOR_NUM = 3;
    private Color[] bulletColor = new Color[3];
    private Point size;
    private final String TOP_PREFIX = "top";
    private ErrorHandler errorHandler;
    private boolean horizontal;
    private Timer timer;
    private int interval = 33;
    private final int DEFAULT_DEGREE = 180;
    private long prvTickCount = 0L;
    private int restartCount;

    public PreviewerCanvas(Composite parent, int style) {
        super(parent, style);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                PreviewerCanvas.this.resized();
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PreviewerCanvas.this.stop();
            }
        });
        this.display = this.getDisplay();
        this.gc = new GC((Drawable)this);
        this.bulletColor[0] = new Color((Device)this.display, 255, 200, 200);
        this.bulletColor[1] = new Color((Device)this.display, 200, 255, 200);
        this.bulletColor[2] = new Color((Device)this.display, 200, 200, 255);
        this.background = new Color((Device)this.display, 0, 0, 0);
        this.gc.setBackground(this.background);
        this.manager = new BulletmlManager();
        this.manager.init();
    }

    private void resized() {
        int sy;
        int sx;
        this.size = this.getSize();
        this.manager.setScreen(this);
        if (!this.horizontal) {
            sx = this.size.x << 7;
            sy = (this.size.y << 6) * 3;
        } else {
            sx = this.size.x << 6;
            sy = this.size.y << 7;
        }
        this.manager.setShipPos(sx, sy, sx, sy + 1);
    }

    public void stop() {
        this.deactive();
        int i = 0;
        while (i < 3) {
            this.bulletColor[i].dispose();
            ++i;
        }
        this.background.dispose();
        this.gc.dispose();
    }

    public void setRank(float rank) {
        this.manager.setRank(rank);
    }

    public void setBulletML(String document, final IResource resource) throws SAXException, ParserConfigurationException, IOException {
        this.errorHandler = new ErrorHandler(){

            public void error(SAXParseException e) {
                try {
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("message", (Object)e.getMessage());
                    marker.setAttribute("lineNumber", e.getLineNumber());
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }

            public void fatalError(SAXParseException e) {
                try {
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("message", (Object)e.getMessage());
                    marker.setAttribute("lineNumber", e.getLineNumber());
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }

            public void warning(SAXParseException e) {
                try {
                    IMarker marker = resource.createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("severity", 0);
                    marker.setAttribute("message", (Object)e.getMessage());
                    marker.setAttribute("lineNumber", e.getLineNumber());
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
        };
        this.clearScreen();
        this.deactive();
        this.manager.reinit();
        this.manager.setErrorHandler(this.errorHandler);
        Document doc = UJAXP.getDocument(new StringReader(document), 1, this.errorHandler, (EntityResolver)new BulletmlEntityResolver());
        Bulletml bulletml = new Bulletml(doc);
        this.horizontal = bulletml.getType().equals("horizontal");
        Vector<Action> actionsVct = new Vector<Action>();
        IBulletmlChoice[] choices = bulletml.getContent();
        int i = 0;
        while (i < choices.length) {
            if (choices[i] instanceof Action) {
                Action action = (Action)choices[i];
                String label = action.getLabel();
                if (label != null && label.startsWith("top")) {
                    actionsVct.addElement(action);
                } else {
                    this.manager.bulletmlUtil.addAction(action);
                }
            } else if (choices[i] instanceof Bullet) {
                this.manager.bulletmlUtil.addBullet((Bullet)choices[i]);
            } else if (choices[i] instanceof Fire) {
                this.manager.bulletmlUtil.addFire((Fire)choices[i]);
            }
            ++i;
        }
        Object[] actions = new IActionElmChoice[actionsVct.size()];
        actionsVct.copyInto(actions);
        this.manager.setTopActions((IActionElmChoice[])actions);
        this.resized();
        this.restartCount = 0;
        this.start();
    }

    public int getWidth() {
        return this.size.x;
    }

    public int getHeight() {
        return this.size.y;
    }

    public void hitShip() {
    }

    public void drawBullet(int x, int y, int px, int py, int sx, int sy, int cl, int cnt) {
        this.gc.setForeground(this.bulletColor[cl % 3]);
        this.gc.drawLine(x >> 8, y >> 8, px >> 8, py >> 8);
    }

    public void start() {
        this.deactive();
        this.timer = new Timer(this);
        this.timer.activate(this.interval, false);
    }

    public void setInterval(int itv) {
        this.interval = itv;
        this.timer.setDuration(itv);
    }

    public void deactive() {
        if (this.timer != null) {
            this.timer.deactivate();
        }
    }

    public void terminate() {
        this.timer.terminate();
    }

    private synchronized void waitFrame() {
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final synchronized void notifyFrame() {
        this.notifyAll();
    }

    public final void wakeUp() {
        try {
            this.loop();
        }
        catch (Exception e) {
            try {
                this.errorHandler.fatalError(new SAXParseException("runtime error: " + e.toString(), null));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            this.deactive();
        }
        this.waitFrame();
    }

    private void clearScreen() {
        if (this.gc == null || this.size == null) {
            return;
        }
        this.gc.fillRectangle(0, 0, this.size.x, this.size.y);
    }

    private void loop() {
        long nowTick = System.currentTimeMillis();
        int frame = (int)(nowTick - this.prvTickCount) / this.interval;
        if (frame <= 0) {
            frame = 1;
            this.prvTickCount = nowTick;
        } else if (frame > 5) {
            frame = 5;
            this.prvTickCount = nowTick;
        } else {
            this.prvTickCount += (long)(frame * this.interval);
        }
        int i = 0;
        while (i < frame) {
            this.manager.moveBullets();
            ++i;
        }
        if (this.manager.isFinished()) {
            --this.restartCount;
            if (this.restartCount < 0) {
                this.restartCount = 60;
                if (!this.horizontal) {
                    this.manager.addTopBullet(this.size.x << 7, this.size.y << 6, 180);
                } else {
                    this.manager.addTopBullet((this.size.x << 6) * 3, this.size.y << 7, 180);
                }
            }
        }
        this.clearScreen();
        this.manager.drawBullets();
    }
}

