/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.gr.java_conf.abagames.bulletml.Bullet;
import jp.gr.java_conf.abagames.bulletml.BulletRef;
import jp.gr.java_conf.abagames.bulletml.Direction;
import jp.gr.java_conf.abagames.bulletml.IActionChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletElmChoice;
import jp.gr.java_conf.abagames.bulletml.IBulletmlChoice;
import jp.gr.java_conf.abagames.bulletml.RStack;
import jp.gr.java_conf.abagames.bulletml.Speed;
import jp.gr.java_conf.abagames.bulletml.UJAXP;
import jp.gr.java_conf.abagames.bulletml.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Fire
implements Serializable,
IActionChoice,
IBulletmlChoice {
    private String label_;
    private Direction direction_;
    private Speed speed_;
    private IBulletElmChoice bulletElm_;

    public Fire() {
    }

    public Fire(RStack stack) {
        this.setup(stack);
    }

    public Fire(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Fire(Element element) {
        this.setup(element);
    }

    public Fire(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Fire(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Fire(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Fire(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Fire(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Fire(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.label_ = URelaxer.getAttributePropertyAsString(element, "label");
        if (Direction.isMatch(stack)) {
            this.setDirection(new Direction(stack));
        }
        if (Speed.isMatch(stack)) {
            this.setSpeed(new Speed(stack));
        }
        if (BulletRef.isMatch(stack)) {
            this.setBulletElm(new BulletRef(stack));
        } else if (Bullet.isMatch(stack)) {
            this.setBulletElm(new Bullet(stack));
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("fire");
        if (this.label_ != null) {
            URelaxer.setAttributePropertyByString(element, "label", this.label_);
        }
        if (this.direction_ != null) {
            this.direction_.makeElement(element);
        }
        if (this.speed_ != null) {
            this.speed_.makeElement(element);
        }
        this.bulletElm_.makeElement(element);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getLabel() {
        return this.label_;
    }

    public final void setLabel(String label) {
        this.label_ = label;
    }

    public final Direction getDirection() {
        return this.direction_;
    }

    public final void setDirection(Direction direction) {
        this.direction_ = direction;
    }

    public final Speed getSpeed() {
        return this.speed_;
    }

    public final void setSpeed(Speed speed) {
        this.speed_ = speed;
    }

    public final IBulletElmChoice getBulletElm() {
        return this.bulletElm_;
    }

    public final void setBulletElm(IBulletElmChoice bulletElm) {
        this.bulletElm_ = bulletElm;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<fire");
        if (this.label_ != null) {
            buffer.append(" label=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLabel())));
            buffer.append("\"");
        }
        this.bulletElm_.makeTextAttribute(buffer);
        buffer.append(">");
        if (this.direction_ != null) {
            this.direction_.makeTextElement(buffer);
        }
        if (this.speed_ != null) {
            this.speed_.makeTextElement(buffer);
        }
        this.bulletElm_.makeTextElement(buffer);
        buffer.append("</fire>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<fire");
        if (this.label_ != null) {
            buffer.print(" label=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getLabel())));
            buffer.print("\"");
        }
        this.bulletElm_.makeTextAttribute(buffer);
        buffer.print(">");
        if (this.direction_ != null) {
            this.direction_.makeTextElement(buffer);
        }
        if (this.speed_ != null) {
            this.speed_.makeTextElement(buffer);
        }
        this.bulletElm_.makeTextElement(buffer);
        buffer.print("</fire>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getLabelAsString() {
        return URelaxer.getString(this.getLabel());
    }

    public void setLabelByString(String string) {
        this.setLabel(string);
    }

    public void setDirectionByString(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setDirection(new Direction(string));
    }

    public void setSpeedByString(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setSpeed(new Speed(string));
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "fire")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Direction.isMatchHungry(target);
        Speed.isMatchHungry(target);
        if (BulletRef.isMatchHungry(target)) {
            $match$ = true;
        } else if (Bullet.isMatchHungry(target)) {
            $match$ = true;
        } else {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Fire.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Fire.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

