/*
 * Decompiled with CFR 0.152.
 */
package jp.gr.java_conf.abagames.bulletml;

import java.util.Random;
import jp.gr.java_conf.abagames.bulletml.BulletmlUtil;

public class Expression {
    private static Random rnd = new Random();
    private static final int MAX_LENGTH = 128;
    public static final int STACK_VARIABLE = 11;
    public static final int STACK_RANK = -2;
    public static final int STACK_RAND = -1;
    public static final int STACK_NUM = 0;
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    public static final int MULTIPLE = 3;
    public static final int DIVISION = 4;
    public static final int MODULO = 5;
    private float[] num = new float[128];
    private int[] opr = new int[128];
    private int idx;
    private float[] stack = new float[128];
    private BulletmlUtil bulletmlUtil;

    public Expression(BulletmlUtil bulletmlUtil) {
        this.bulletmlUtil = bulletmlUtil;
        this.idx = 0;
    }

    private float calcOp(int op, float n1, float n2) {
        switch (op) {
            case 1: {
                return n1 + n2;
            }
            case 2: {
                return n1 - n2;
            }
            case 3: {
                return n1 * n2;
            }
            case 4: {
                return n1 / n2;
            }
            case 5: {
                return n1 % n2;
            }
        }
        return 0.0f;
    }

    public void setOperator(int op) {
        if (this.idx >= 128) {
            return;
        }
        if (this.opr[this.idx - 1] == 0 && this.opr[this.idx - 2] == 0) {
            this.num[this.idx - 2] = this.calcOp(op, this.num[this.idx - 2], this.num[this.idx - 1]);
            --this.idx;
        } else {
            this.opr[this.idx] = op;
            ++this.idx;
        }
    }

    public void push(float nm, int vr) {
        if (this.idx >= 128) {
            return;
        }
        this.num[this.idx] = nm;
        this.opr[this.idx] = vr;
        ++this.idx;
    }

    public final float calc(float[] prms) {
        int stkIdx = 0;
        int i = 0;
        while (i < this.idx) {
            switch (this.opr[i]) {
                case 0: {
                    this.stack[stkIdx] = this.num[i];
                    ++stkIdx;
                    break;
                }
                case -1: {
                    this.stack[stkIdx] = rnd.nextFloat();
                    ++stkIdx;
                    break;
                }
                case -2: {
                    this.stack[stkIdx] = this.bulletmlUtil.getRank();
                    ++stkIdx;
                    break;
                }
                default: {
                    if (this.opr[i] >= 11) {
                        this.stack[stkIdx] = prms[this.opr[i] - 11];
                        ++stkIdx;
                        break;
                    }
                    this.stack[stkIdx - 2] = this.calcOp(this.opr[i], this.stack[stkIdx - 2], this.stack[stkIdx - 1]);
                    --stkIdx;
                }
            }
            ++i;
        }
        return this.stack[0];
    }
}

